/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.ideafactory;

import java.util.ArrayList;
import java.util.List;
import org.xmind.core.IExtensionElement;
import org.xmind.core.ITopic;
import org.xmind.core.ITopicExtension;
import org.xmind.core.ITopicExtensionElement;
import org.xmind.core.event.ICoreEventSource;
import org.xmind.gef.command.SourceCommand;
import org.xmind.ui.internal.ideafactory.AddIdeaGroupCommand;
import org.xmind.ui.internal.ideafactory.IdeaFactoryMessages;
import org.xmind.ui.internal.ideafactory.IdeaUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddIdeaCommand
extends SourceCommand {
    private ITopic rootTopic;
    private ITopicExtensionElement groupElement;
    private String groupName;
    private String ideaContent;
    private int insertInGroupIndex = -1;
    private AddIdeaGroupCommand addGroupCommand;
    private ITopicExtensionElement parent;
    private ITopicExtensionElement addedIdea;
    private int realInsertIndex;
    private int fireIndex;

    public AddIdeaCommand(ITopicExtensionElement groupElement, String idea) {
        this(groupElement, idea, -1);
    }

    public AddIdeaCommand(ITopicExtensionElement groupElement, String idea, int insertIndex) {
        super((Object)groupElement.getTopic());
        this.rootTopic = groupElement.getTopic();
        this.groupElement = groupElement;
        this.ideaContent = idea;
        this.insertInGroupIndex = insertIndex;
        this.setLabel(IdeaFactoryMessages.AddIdeaCommand_LabelText);
    }

    public AddIdeaCommand(ITopic rootTopic, String groupName, String idea) {
        super((Object)rootTopic);
        this.rootTopic = rootTopic;
        this.groupName = groupName;
        this.ideaContent = idea;
        this.setLabel(IdeaFactoryMessages.AddIdeaCommand_LabelText);
    }

    public void redo() {
        if (!this.canRedo()) {
            return;
        }
        this.ensureGroup();
        ITopicExtension ext = this.rootTopic.createExtension("org.xmind.ui.ideafactory");
        ITopicExtensionElement content = ext.getContent();
        this.parent = (ITopicExtensionElement)content.getCreatedChild("ideas");
        if (this.addedIdea == null) {
            this.addedIdea = (ITopicExtensionElement)this.parent.createChild("idea");
            this.realInsertIndex = this.getRealInsertIndex();
            this.parent.addChild((IExtensionElement)this.addedIdea, this.realInsertIndex);
            this.addedIdea.setAttribute("group_id", this.groupElement.getAttribute("id"));
            this.addedIdea.setTextContent(this.ideaContent);
            List<ITopicExtensionElement> groupIdeas = IdeaUtils.getGroupIdeas(this.groupElement);
            this.fireIndex = this.insertInGroupIndex != -1 ? this.insertInGroupIndex : groupIdeas.size() - 1;
            this.fireCoreEvent(this.rootTopic, "ideaAdded", this.fireIndex);
        } else {
            this.parent.addChild((IExtensionElement)this.addedIdea, this.realInsertIndex);
            this.fireCoreEvent(this.rootTopic, "ideaAdded", this.fireIndex);
        }
        super.redo();
    }

    private int getRealInsertIndex() {
        List<ITopicExtensionElement> ideas = this.getIdeas(this.rootTopic);
        List<ITopicExtensionElement> groupIdeas = IdeaUtils.getGroupIdeas(this.groupElement);
        if (ideas.size() == 0) {
            return 0;
        }
        if (groupIdeas.size() == 0) {
            return ideas.size();
        }
        if (this.insertInGroupIndex < 0 || this.insertInGroupIndex > groupIdeas.size()) {
            return ideas.size();
        }
        if (this.insertInGroupIndex == groupIdeas.size()) {
            return ideas.size();
        }
        ITopicExtensionElement idea = groupIdeas.get(this.insertInGroupIndex);
        return ideas.indexOf(idea);
    }

    public void undo() {
        if (!this.canUndo()) {
            return;
        }
        this.removeCreatedGroup();
        this.parent.deleteChild((IExtensionElement)this.addedIdea);
        this.fireCoreEvent(this.rootTopic, "ideaDeleted", this.fireIndex);
        super.undo();
    }

    private void ensureGroup() {
        if (this.groupElement == null) {
            if (this.addGroupCommand == null) {
                this.addGroupCommand = new AddIdeaGroupCommand(this.rootTopic, this.groupName);
            }
            this.addGroupCommand.execute();
            this.groupElement = this.addGroupCommand.getCreatedGroupElement();
        }
    }

    private void removeCreatedGroup() {
        if (this.addGroupCommand != null) {
            this.addGroupCommand.undo();
            this.groupElement = null;
        }
    }

    private void fireCoreEvent(ITopic topic, String eventType, int index) {
        if (topic instanceof ICoreEventSource) {
            ((ICoreEventSource)topic).getCoreEventSupport().dispatchIndexedTargetChange((ICoreEventSource)topic, eventType, (Object)this.addedIdea, index);
        }
    }

    private List<ITopicExtensionElement> getIdeas(ITopic topic) {
        ITopicExtensionElement content;
        ITopicExtensionElement ideaParentElement;
        ArrayList<ITopicExtensionElement> ideas = new ArrayList<ITopicExtensionElement>();
        if (topic == null) {
            return ideas;
        }
        ITopicExtension ext = topic.getExtension("org.xmind.ui.ideafactory");
        if (ext != null && (ideaParentElement = (ITopicExtensionElement)(content = ext.getContent()).getFirstChild("ideas")) != null) {
            return ideaParentElement.getChildren("idea");
        }
        return ideas;
    }
}

