/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.animation;

import java.util.Collections;
import java.util.List;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Widget;
import org.xmind.ui.animation.IAnimationContentProvider;

public class AnimationViewer
extends StructuredViewer {
    private static final int DEFAULT_DURATION = 125;
    private Canvas canvas;
    private Frame startFrame;
    private Frame staticFrame;
    private Frame currentFrame;
    private Thread animationThread;

    public AnimationViewer(Composite parent, int style) {
        this.canvas = new AnimationCanvas(parent, style);
        this.hookControl((Control)this.canvas);
    }

    protected void hookControl(Control control) {
        super.hookControl(control);
        control.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                AnimationViewer.this.paintCanvas(e);
            }
        });
    }

    protected void inputChanged(Object input, Object oldInput) {
        this.startFrame = null;
        this.staticFrame = null;
        this.buildFrames(input);
        if (this.canvas != null && !this.canvas.isDisposed()) {
            this.setCurrent(this.getStaticFrame());
            this.canvas.getParent().layout();
        }
    }

    private void buildFrames(Object input) {
        Object staticElement;
        IStructuredContentProvider provider = (IStructuredContentProvider)this.getContentProvider();
        Object[] elements = provider.getElements(input);
        if (this.getContentProvider() instanceof IAnimationContentProvider) {
            staticElement = ((IAnimationContentProvider)this.getContentProvider()).getStaticElement(input, elements);
            this.staticFrame = this.createFrame(staticElement);
        } else {
            staticElement = null;
        }
        Frame last = null;
        int i = 0;
        while (i < elements.length) {
            Frame frame;
            Object element = elements[i];
            if (!(staticElement != null && staticElement.equals(element) || (frame = this.createFrame(element)) == null)) {
                if (this.startFrame == null) {
                    this.startFrame = frame;
                }
                if (last != null) {
                    last.next = frame;
                }
                last = frame;
            }
            ++i;
        }
        if (last != null) {
            last.next = this.startFrame;
        }
    }

    private Frame createFrame(Object element) {
        Image image;
        if (this.getLabelProvider() instanceof ILabelProvider && (image = ((ILabelProvider)this.getLabelProvider()).getImage(element)) != null) {
            long duration;
            if (this.getContentProvider() instanceof IAnimationContentProvider) {
                duration = ((IAnimationContentProvider)this.getContentProvider()).getDuration(element);
                if (duration < 0L) {
                    duration = 125L;
                } else if (duration == 0L) {
                    duration = 1L;
                }
            } else {
                duration = 125L;
            }
            return new Frame(element, image, duration);
        }
        return null;
    }

    protected void paintCanvas(PaintEvent e) {
        Frame frame = this.currentFrame;
        if (frame == null) {
            return;
        }
        Rectangle area = this.canvas.getClientArea();
        if (area.width == 0 || area.height == 0) {
            return;
        }
        GC gc = e.gc;
        Rectangle r = frame.image.getBounds();
        int x = area.x + (area.width - r.width) / 2;
        int y = area.y + (area.height - r.height) / 2;
        gc.drawImage(frame.image, x, y);
    }

    protected void handleDispose(DisposeEvent event) {
        super.handleDispose(event);
        this.startFrame = null;
        this.staticFrame = null;
        this.currentFrame = null;
        this.animationThread = null;
    }

    public void start() {
        if (this.animationThread == null) {
            this.createAnimationThread();
        }
    }

    public void stop() {
        if (this.animationThread != null) {
            this.animationThread = null;
        }
    }

    private synchronized void createAnimationThread() {
        if (this.animationThread != null || !this.hasAnimatableFrames()) {
            return;
        }
        this.setCurrent(this.getStartFrame());
        this.animationThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    AnimationViewer.this.loop();
                }
                catch (Throwable throwable) {}
                if (AnimationViewer.this.animationThread == null && !AnimationViewer.this.canvas.isDisposed()) {
                    AnimationViewer.this.canvas.getDisplay().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            AnimationViewer.this.setCurrent(AnimationViewer.this.getStaticFrame());
                        }
                    });
                }
            }
        });
        this.animationThread.setPriority(7);
        this.animationThread.setDaemon(true);
        this.animationThread.start();
    }

    private void loop() {
        while (this.animationThread != null && !this.canvas.isDisposed() && this.hasAnimatableFrames()) {
            Display display = this.canvas.getDisplay();
            if (display.isDisposed()) {
                return;
            }
            display.syncExec(new Runnable(){

                @Override
                public void run() {
                    if (AnimationViewer.this.animationThread != null && AnimationViewer.this.hasAnimatableFrames()) {
                        Frame next = AnimationViewer.this.currentFrame == null ? AnimationViewer.this.getStartFrame() : ((AnimationViewer)AnimationViewer.this).currentFrame.next;
                        AnimationViewer.this.setCurrent(next);
                    }
                }
            });
            if (this.currentFrame == null) {
                return;
            }
            try {
                Thread.sleep(this.currentFrame.duration);
            }
            catch (Exception exception) {}
        }
    }

    protected boolean hasAnimatableFrames() {
        return this.startFrame != null;
    }

    protected boolean hasFrames() {
        return this.staticFrame != null || this.startFrame != null;
    }

    protected Frame getStartFrame() {
        return this.startFrame;
    }

    protected Frame getStaticFrame() {
        return this.staticFrame;
    }

    protected Frame getCurrentFrame() {
        return this.currentFrame;
    }

    public Image getCurrentImage() {
        return this.currentFrame == null ? null : this.currentFrame.image;
    }

    public Object getCurrentElement() {
        return this.currentFrame == null ? null : this.currentFrame.element;
    }

    private void setCurrent(Frame frame) {
        if (this.currentFrame != frame && !this.canvas.isDisposed()) {
            this.currentFrame = frame;
            this.canvas.redraw();
            this.setSelection((ISelection)new StructuredSelection(frame.element));
        }
    }

    public boolean isAnimating() {
        return this.animationThread != null;
    }

    protected Widget doFindInputItem(Object element) {
        return this.canvas;
    }

    protected Widget doFindItem(Object element) {
        return this.canvas;
    }

    protected void doUpdateItem(Widget item, Object element, boolean fullMap) {
    }

    protected List getSelectionFromWidget() {
        return Collections.EMPTY_LIST;
    }

    protected void internalRefresh(Object element) {
    }

    public void reveal(Object element) {
    }

    protected void setSelectionToWidget(List l, boolean reveal) {
    }

    public Control getControl() {
        return this.canvas;
    }

    private class AnimationCanvas
    extends Canvas {
        public AnimationCanvas(Composite parent, int style) {
            super(parent, style);
        }

        public Point computeSize(int wHint, int hHint, boolean changed) {
            Rectangle imgBounds;
            Frame frame;
            int h;
            int w = wHint >= 0 ? wHint : 0;
            int n = h = hHint >= 0 ? hHint : 0;
            if (AnimationViewer.this.hasAnimatableFrames()) {
                frame = AnimationViewer.this.startFrame;
                do {
                    imgBounds = frame.image.getBounds();
                    if (wHint < 0) {
                        w = Math.max(w, imgBounds.width);
                    }
                    if (hHint >= 0) continue;
                    h = Math.max(h, imgBounds.height);
                } while ((frame = frame.next) != AnimationViewer.this.startFrame && frame != null);
            }
            if (AnimationViewer.this.getStaticFrame() != null) {
                frame = AnimationViewer.this.getStaticFrame();
                imgBounds = frame.image.getBounds();
                if (wHint < 0) {
                    w = Math.max(w, imgBounds.width);
                }
                if (hHint < 0) {
                    h = Math.max(h, imgBounds.height);
                }
            }
            return new Point(w, h);
        }
    }

    protected static class Frame {
        Object element;
        Image image;
        long duration;
        Frame next;

        public Frame(Object element, Image image, long duration) {
            this.element = element;
            this.image = image;
            this.duration = duration;
        }
    }
}

