/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.evernote;

import com.evernote.edam.error.EDAMErrorCode;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.xmind.gef.ui.editor.IGraphicalEditor;
import org.xmind.ui.dialogs.Notification;
import org.xmind.ui.evernote.signin.Evernote;
import org.xmind.ui.evernote.signin.IEvernoteAccount;
import org.xmind.ui.internal.evernote.ErrorStatusDialog;
import org.xmind.ui.internal.evernote.EvernoteMessages;
import org.xmind.ui.internal.evernote.export.EvernoteExportJob;
import org.xmind.ui.mindmap.IMindMapViewer;

public class EvernoteExporter {
    private EvernoteExportJob job = null;

    public void export(IMindMapViewer sourceViewer) {
        if (this.check(sourceViewer)) {
            IEvernoteAccount accountInfo = Evernote.signIn();
            this.export(sourceViewer, accountInfo);
        }
    }

    private boolean check(IMindMapViewer sourceViewer) {
        if (sourceViewer == null) {
            return false;
        }
        Control control = sourceViewer.getControl();
        return control != null && !control.isDisposed();
    }

    private void export(IMindMapViewer viewer, IEvernoteAccount accountInfo) {
        if (viewer == null || accountInfo == null) {
            return;
        }
        Control control = viewer.getControl();
        if (control == null || control.isDisposed()) {
            return;
        }
        final Display display = control.getDisplay();
        final Shell shell = control.getShell();
        this.job = new EvernoteExportJob(viewer, accountInfo);
        this.job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                final IStatus result = event.getResult();
                if (result.getSeverity() == 2) {
                    display.syncExec(new Runnable(){

                        @Override
                        public void run() {
                            ErrorStatusDialog errorDialog = new ErrorStatusDialog(shell, result.getMessage());
                            errorDialog.open();
                        }
                    });
                    if (EvernoteExporter.this.isAuthFailed(result.getCode())) {
                        Evernote.signOut();
                        Evernote.signIn();
                    }
                } else if (result.getSeverity() == 0) {
                    display.syncExec(new Runnable(){

                        @Override
                        public void run() {
                            EvernoteExporter.this.showNotification();
                        }
                    });
                }
                if (EvernoteExporter.this.job == event.getJob()) {
                    EvernoteExporter.this.job = null;
                }
            }
        });
        this.job.setUser(false);
        this.job.setSystem(false);
        this.job.schedule();
        this.block(display);
    }

    private void block(Display display) {
        while (this.job != null) {
            if (display == null) {
                try {
                    Thread.sleep(20L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    break;
                }
            }
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    private boolean isAuthFailed(int code) {
        return code == EDAMErrorCode.AUTH_EXPIRED.getValue() || code == EDAMErrorCode.INVALID_AUTH.getValue();
    }

    private void showNotification() {
        Control control;
        Action okAction = new Action(){};
        okAction.setText(EvernoteMessages.EvernoteExportHandler_okActionLabel);
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        Shell parentShell = window == null ? Display.getCurrent().getActiveShell() : window.getShell();
        Rectangle bounds = null;
        IEditorPart activeEditor = window.getActivePage().getActiveEditor();
        if (activeEditor instanceof IGraphicalEditor && (control = ((IGraphicalEditor)activeEditor).getActivePageInstance().getControl()) != null && !control.isDisposed()) {
            Rectangle bounds2 = control.getBounds();
            Point toDisplay = control.getParent().toDisplay(bounds2.x, bounds2.y);
            bounds = new Rectangle(toDisplay.x, toDisplay.y, bounds2.width, bounds2.height);
        }
        Notification popup = new Notification(parentShell, EvernoteMessages.EvernoteExportHandler_successfullySaveText, (IAction)okAction, bounds, true, false, false, null, true);
        popup.setDuration(5000);
        popup.open();
    }
}

