/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.editpolicies;

import java.util.ArrayList;
import java.util.List;
import org.xmind.core.ITopic;
import org.xmind.core.IWorkbook;
import org.xmind.core.marker.IMarker;
import org.xmind.core.marker.IMarkerGroup;
import org.xmind.core.marker.IMarkerRef;
import org.xmind.core.marker.IMarkerSheet;
import org.xmind.gef.Request;
import org.xmind.gef.command.Command;
import org.xmind.gef.command.CompoundCommand;
import org.xmind.gef.part.IPart;
import org.xmind.ui.commands.AddMarkerCommand;
import org.xmind.ui.commands.CommandMessages;
import org.xmind.ui.commands.DeleteMarkerCommand;
import org.xmind.ui.internal.editpolicies.MindMapPolicyBase;
import org.xmind.ui.mindmap.IMarkerPart;
import org.xmind.ui.mindmap.ITopicPart;

public class MarkerMovablePolicy
extends MindMapPolicyBase {
    public boolean understands(String requestType) {
        return super.understands(requestType) || "move to".equals(requestType) || "copy to".equals(requestType);
    }

    public void handle(Request request) {
        String type = request.getType();
        if ("move to".equals(type)) {
            this.moveMarker(request);
        } else if ("copy to".equals(type)) {
            this.copyMarker(request);
        }
    }

    private void moveMarker(Request request) {
        this.copyMarker(request, true);
    }

    private void copyMarker(Request request) {
        this.copyMarker(request, false);
    }

    private void copyMarker(Request request, boolean deleteSource) {
        IPart primaryTarget = request.getPrimaryTarget();
        if (!(primaryTarget instanceof IMarkerPart)) {
            return;
        }
        IMarkerPart marker = (IMarkerPart)primaryTarget;
        Object param = request.getParameter("parent");
        if (param == null || !(param instanceof ITopicPart)) {
            return;
        }
        ITopicPart targetParent = (ITopicPart)param;
        ITopic targetTopic = targetParent.getTopic();
        IMarkerRef sourceMarker = marker.getMarkerRef();
        if (sourceMarker.getParent() == targetTopic) {
            return;
        }
        ArrayList<Command> cmds = new ArrayList<Command>();
        this.createAddMarkerCommand(targetTopic, sourceMarker.getMarkerId(), cmds);
        if (cmds.isEmpty()) {
            return;
        }
        if (deleteSource) {
            DeleteMarkerCommand delete = new DeleteMarkerCommand(sourceMarker.getParent(), sourceMarker.getMarkerId());
            delete.setSourceCollectable(false);
            cmds.add((Command)delete);
        }
        CompoundCommand cmd = new CompoundCommand(cmds);
        cmd.setLabel(deleteSource ? CommandMessages.Command_MoveMarker : CommandMessages.Command_CopyMarker);
        this.saveAndRun((Command)cmd, request.getTargetDomain());
        this.select(cmd.getSources(), request.getTargetViewer());
    }

    private void createAddMarkerCommand(ITopic topic, String newMarkerId, List<Command> cmds) {
        if (topic.hasMarker(newMarkerId)) {
            return;
        }
        IMarker marker = this.findMarker(topic, newMarkerId);
        if (marker != null) {
            IMarkerGroup group = marker.getParent();
            if (group != null && group.isSingleton()) {
                this.removeSingletonMarkers(topic, newMarkerId, group, cmds);
            }
            cmds.add((Command)new AddMarkerCommand(topic, newMarkerId));
        }
    }

    private IMarker findMarker(ITopic topic, String markerId) {
        IMarkerSheet markerSheet;
        IWorkbook workbook = topic.getOwnedWorkbook();
        if (workbook != null && (markerSheet = workbook.getMarkerSheet()) != null) {
            return markerSheet.findMarker(markerId);
        }
        return null;
    }

    private void removeSingletonMarkers(ITopic topic, String newMarkerId, IMarkerGroup group, List<Command> cmds) {
        for (IMarker m : group.getMarkers()) {
            String markerId = m.getId();
            if (newMarkerId.equals(markerId) || !topic.hasMarker(markerId)) continue;
            DeleteMarkerCommand cmd = new DeleteMarkerCommand(topic, markerId);
            cmd.setSourceCollectable(false);
            cmds.add((Command)cmd);
        }
    }
}

