/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.handlers;

import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;
import org.xmind.core.IIdentifiable;
import org.xmind.core.internal.ElementRegistry;
import org.xmind.core.style.IStyle;
import org.xmind.core.style.IStyleSheet;
import org.xmind.ui.internal.MindMapMessages;
import org.xmind.ui.internal.handlers.MindMapHandlerUtil;
import org.xmind.ui.mindmap.MindMapUI;

public class DeleteStyleHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.deleteSelectedStyles(event);
        return null;
    }

    private void deleteSelectedStyles(ExecutionEvent event) {
        List<IStyle> deletableStyles = MindMapHandlerUtil.findStyles(event, 2);
        if (deletableStyles.isEmpty()) {
            return;
        }
        IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event);
        if (window != null && !this.confirmDeletingStyles(window.getShell(), deletableStyles)) {
            return;
        }
        this.deleteStyles(deletableStyles);
    }

    protected void deleteStyles(List<IStyle> styles) {
        boolean isTheme = false;
        for (IStyle style : styles) {
            if ("theme".equals(style.getType())) {
                isTheme = true;
            }
            IStyleSheet sheet = style.getOwnedStyleSheet();
            ElementRegistry elementRegistry = (ElementRegistry)sheet.getAdapter(ElementRegistry.class);
            elementRegistry.unregister((IIdentifiable)style);
            sheet.removeStyle(style);
        }
        if (isTheme) {
            MindMapUI.getResourceManager().saveUserThemeSheet();
        } else {
            MindMapUI.getResourceManager().saveUserStyleSheet();
        }
    }

    private boolean confirmDeletingStyles(Shell parentShell, List<IStyle> styles) {
        StringBuilder sb = new StringBuilder(styles.size() * 10);
        boolean isTheme = false;
        for (IStyle style : styles) {
            if ("theme".equals(style.getType())) {
                isTheme = true;
            }
            if (sb.length() > 0) {
                sb.append(',');
                sb.append(' ');
            }
            sb.append('\'');
            sb.append(style.getName());
            sb.append('\'');
        }
        String styleNames = sb.toString();
        return MessageDialog.openConfirm((Shell)parentShell, (String)NLS.bind((String)MindMapMessages.DeleteStyles_MessageDialog_title, (Object)(isTheme ? MindMapMessages.DeleteStyle_MessageDialog_themes : MindMapMessages.DeleteStyle_MessageDialog_styles)), (String)NLS.bind((String)MindMapMessages.DeleteStyle_MessageDialog_description, (Object)styleNames));
    }
}

