/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.handlers;

import java.util.ArrayList;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.handlers.HandlerUtil;
import org.xmind.core.IAdaptable;
import org.xmind.core.IRevision;
import org.xmind.core.IRevisionManager;
import org.xmind.core.ISheet;
import org.xmind.core.IWorkbook;
import org.xmind.gef.command.Command;
import org.xmind.gef.command.CompoundCommand;
import org.xmind.gef.command.ICommandStack;
import org.xmind.gef.command.SourceCommand;
import org.xmind.ui.commands.AddSheetCommand;
import org.xmind.ui.commands.DeleteSheetCommand;
import org.xmind.ui.internal.MindMapMessages;
import org.xmind.ui.internal.MindMapUIPlugin;

public class RevertToRevisionHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        RevertToRevisionHandler.revertToRevision(HandlerUtil.getCurrentSelection((ExecutionEvent)event), HandlerUtil.getActiveEditor((ExecutionEvent)event));
        return null;
    }

    private static void revertToRevision(ISelection selection, IEditorPart editor) {
        if (selection == null || selection.isEmpty() || !(selection instanceof IStructuredSelection)) {
            return;
        }
        Object obj = ((IStructuredSelection)selection).getFirstElement();
        if (!(obj instanceof IRevision)) {
            return;
        }
        IRevision revision = (IRevision)obj;
        if (!"application/vnd.xmind.sheet".equals(revision.getContentType())) {
            return;
        }
        IWorkbook workbook = revision.getOwnedWorkbook();
        final ISheet sourceSheet = (ISheet)workbook.findElement(revision.getResourceId(), null);
        ISheet targetSheet = (ISheet)workbook.importElement(revision.getContent());
        if (targetSheet == null) {
            return;
        }
        String title = targetSheet.getTitleText();
        targetSheet.setTitleText("#" + title);
        targetSheet.setTitleText(title);
        int sheetIndex = sourceSheet.getIndex();
        ArrayList<SourceCommand> commands = new ArrayList<SourceCommand>();
        ISheet placeholderSheet = workbook.createSheet();
        commands.add(new AddSheetCommand(placeholderSheet, workbook));
        commands.add(new DeleteSheetCommand(sourceSheet));
        commands.add(new AddSheetCommand(targetSheet, workbook, sheetIndex));
        commands.add(new DeleteSheetCommand(placeholderSheet, workbook));
        CompoundCommand command = new CompoundCommand(MindMapMessages.RevertToRevisionCommand_label, commands);
        final ICommandStack commandStack = editor == null ? null : MindMapUIPlugin.getAdapter(editor, ICommandStack.class);
        final IRevisionManager manager = revision.getOwnedManager();
        final IRevision latestRevision = manager.getLatestRevision();
        SafeRunner.run((ISafeRunnable)new SafeRunnable((Command)command){
            private final /* synthetic */ Command val$command;
            {
                this.val$command = command;
            }

            public void run() throws Exception {
                if (latestRevision == null || sourceSheet.getModifiedTime() > latestRevision.getTimestamp()) {
                    manager.addRevision((IAdaptable)sourceSheet);
                }
                if (commandStack != null) {
                    commandStack.execute(this.val$command);
                } else {
                    this.val$command.execute();
                }
            }
        });
    }
}

