/* $Id: imx23_powerreg.h,v 1.2 2013/10/07 17:36:40 matt Exp $ */

/*
 * Copyright (c) 2012 The NetBSD Foundation, Inc.
 * All rights reserved.
 *
 * This code is derived from software contributed to The NetBSD Foundation
 * by Petri Laakso.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _ARM_IMX_IMX23_POWERREG_H_
#define _ARM_IMX_IMX23_POWERREG_H_

#include <sys/cdefs.h>

#define HW_POWER_BASE 0x80044000
#define HW_POWER_SIZE 0x2000

/*
 * Power Control Register.
 */
#define HW_POWER_CTRL		0x000
#define HW_POWER_CTRL_SET	0x004
#define HW_POWER_CTRL_CLR	0x008
#define HW_POWER_CTRL_TOG	0x00c

#define HW_POWER_CTRL_RSRVD3			__BIT(31)
#define HW_POWER_CTRL_CLKGATE			__BIT(30)
#define HW_POWER_CTRL_RSRVD2			__BITS(29, 28)
#define HW_POWER_CTRL_PSWITCH_MID_TRAN		__BIT(27)
#define HW_POWER_CTRL_RSRVD1			__BITS(26, 25)
#define HW_POWER_CTRL_DCDC4P2_BO_IRQ		__BIT(24)
#define HW_POWER_CTRL_ENIRQ_DCDC4P2_BO		__BIT(23)
#define HW_POWER_CTRL_VDD5V_DROOP_IRQ		__BIT(22)
#define HW_POWER_CTRL_ENIRQ_VDD5V_DROOP		__BIT(21)
#define HW_POWER_CTRL_PSWITCH_IRQ		__BIT(20)
#define HW_POWER_CTRL_PSWITCH_IRQ_SRC		__BIT(19)
#define HW_POWER_CTRL_POLARITY_PSWITCH		__BIT(18)
#define HW_POWER_CTRL_ENIRQ_PSWITCH		__BIT(17)
#define HW_POWER_CTRL_POLARITY_DC_OK		__BIT(16)
#define HW_POWER_CTRL_DC_OK_IRQ			__BIT(15)
#define HW_POWER_CTRL_ENIRQ_DC_OK		__BIT(14)
#define HW_POWER_CTRL_BATT_BO_IRQ		__BIT(13)
#define HW_POWER_CTRL_ENIRQBATT_BO		__BIT(12)
#define HW_POWER_CTRL_VDDIO_BO_IRQ		__BIT(11)
#define HW_POWER_CTRL_ENIRQ_VDDIO_BO		__BIT(10)
#define HW_POWER_CTRL_VDDA_BO_IRQ		__BIT(9)
#define HW_POWER_CTRL_ENIRQ_VDDA_BO		__BIT(8)
#define HW_POWER_CTRL_VDDD_BO_IRQ		__BIT(7)
#define HW_POWER_CTRL_ENIRQ_VDDD_BO		__BIT(6)
#define HW_POWER_CTRL_POLARITY_VBUSVALID	__BIT(5)
#define HW_POWER_CTRL_VBUSVALID_IRQ		__BIT(4)
#define HW_POWER_CTRL_ENIRQ_VBUS_VALID		__BIT(3)
#define HW_POWER_CTRL_POLARITY_VDD5V_GT_VDDIO	__BIT(2)
#define HW_POWER_CTRL_VDD5V_GT_VDDIO_IRQ	__BIT(1)
#define HW_POWER_CTRL_ENIRQ_VDD5V_GT_VDDIO	__BIT(0)

/*
 * DC-DC 5V Control Register.
 */
#define HW_POWER_5VCTRL		0x010
#define HW_POWER_5VCTRL_SET	0x014
#define HW_POWER_5VCTRL_CLR	0x018
#define HW_POWER_5VCTRL_TOG	0x01C

#define HW_POWER_5VCTRL_RSRVD6			__BITS(31, 30)
#define HW_POWER_5VCTRL_VBUSDROOP_TRSH		__BITS(29, 28)
#define HW_POWER_5VCTRL_RSRVD5			__BIT(27)
#define HW_POWER_5VCTRL_HEADROOM_ADJ		__BITS(26, 24)
#define HW_POWER_5VCTRL_RSRVD4			__BITS(23, 21)
#define HW_POWER_5VCTRL_PWD_CHARGE_4P2		__BIT(20)
#define HW_POWER_5VCTRL_RSRVD3			__BITS(19, 18)
#define HW_POWER_5VCTRL_CHARGE_4P2_ILIMIT	__BITS(17, 12)
#define HW_POWER_5VCTRL_RSRVD2			__BIT(11)
#define HW_POWER_5VCTRL_VBUSVALID_TRSH		__BITS(10, 8)
#define HW_POWER_5VCTRL_PWDN_5VBRNOUT		__BIT(7)
#define HW_POWER_5VCTRL_ENABLE_LINREG_ILIMIT	__BIT(6)
#define HW_POWER_5VCTRL_DCDC_XFER		__BIT(5)
#define HW_POWER_5VCTRL_VBUSVALID_5VDETECT	__BIT(4)
#define HW_POWER_5VCTRL_VBUSVALID_TO_B		__BIT(3)
#define HW_POWER_5VCTRL_ILIMIT_EQ_ZERO		__BIT(2)
#define HW_POWER_5VCTRL_PWRUP_VBUS_CMPS		__BIT(1)
#define HW_POWER_5VCTRL_ENABLE_DCDC		__BIT(0)

/*
 * DC-DC Minimum Power and Miscellaneous Control Register.
 */
#define HW_POWER_MINPWR		0x020
#define HW_POWER_MINPWR_SET	0x024
#define HW_POWER_MINPWR_CLR	0x028
#define HW_POWER_MINPWR_TOG	0x02C

#define HW_POWER_MINPWR_RSRVD1		__BITS(31, 15)
#define HW_POWER_MINPWR_LOWPWR_4P2	__BIT(14)
#define HW_POWER_MINPWR_VDAC_DUMP_CTRL	__BIT(13)
#define HW_POWER_MINPWR_PWD_BO		__BIT(12)
#define HW_POWER_MINPWR_USE_VDDXTAL_VBG	__BIT(11)
#define HW_POWER_MINPWR_PWD_ANA_CMPS	__BIT(10)
#define HW_POWER_MINPWR_ENABLE_OSC	__BIT(9)
#define HW_POWER_MINPWR_SELECT_OSC	__BIT(8)
#define HW_POWER_MINPWR_VBG_OFF		__BIT(7)
#define HW_POWER_MINPWR_DOUBLE_FETS	__BIT(6)
#define HW_POWER_MINPWR_HALF_FETS	__BIT(5)
#define HW_POWER_MINPWR_LESSANA_I	__BIT(4)
#define HW_POWER_MINPWR_PWD_XTAL24	__BIT(3)
#define HW_POWER_MINPWR_DC_STOPCLK	__BIT(2)
#define HW_POWER_MINPWR_EN_DC_PFM	__BIT(1)
#define HW_POWER_MINPWR_DC_HALFCLK	__BIT(0)

/*
 * Battery Charge Control Register.
 */
#define HW_POWER_CHARGE		0x030
#define HW_POWER_CHARGE_SET	0x034
#define HW_POWER_CHARGE_CLR	0x038
#define HW_POWER_CHARGE_TOG	0x03C

#define HW_POWER_CHARGE_RSVD5				__BITS(31, 27)
#define HW_POWER_CHARGE_ADJ_VOLT			__BITS(26, 24)
#define HW_POWER_CHARGE_RSRVD3				__BIT(23)
#define HW_POWER_CHARGE_ENABLE_LOAD			__BIT(22)
#define HW_POWER_CHARGE_ENABLE_CHARGER_RESISTORS	__BIT(21)
#define HW_POWER_CHARGE_ENABLE_FAULT_DETECT		__BIT(20)
#define HW_POWER_CHARGE_CHRG_STS_OFF			__BIT(19)
#define HW_POWER_CHARGE_RSVD4				__BIT(18)
#define HW_POWER_CHARGE_RSVD3				__BIT(17)
#define HW_POWER_CHARGE_PWD_BATTCHRG			__BIT(16)
#define HW_POWER_CHARGE_RSVD2				__BITS(15, 12)
#define HW_POWER_CHARGE_STOP_ILIMIT			__BITS(11, 8)
#define HW_POWER_CHARGE_RSVD1				__BITS(7, 6)
#define HW_POWER_CHARGE_BATTCHRG_I			__BITS(5, 0)

/*
 * VDDD Supply Targets and Brownouts Control Register.
 */
#define HW_POWER_VDDDCTRL	0x040

#define HW_POWER_VDDDCTRL_ADJTN			__BITS(31, 28)
#define HW_POWER_VDDDCTRL_RSRVD4		__BITS(27, 24)
#define HW_POWER_VDDDCTRL_PWDN_BRNOUT		__BIT(23)
#define HW_POWER_VDDDCTRL_DISABLE_STEPPING	__BIT(22)
#define HW_POWER_VDDDCTRL_ENABLE_LINREG		__BIT(21)
#define HW_POWER_VDDDCTRL_DISABLE_FET		__BIT(20)
#define HW_POWER_VDDDCTRL_RSRVD3		__BITS(19, 18)
#define HW_POWER_VDDDCTRL_LINREG_OFFSET		__BITS(17, 16)
#define HW_POWER_VDDDCTRL_RSRVD2		__BITS(15, 11)
#define HW_POWER_VDDDCTRL_BO_OFFSET		__BITS(10, 8)
#define HW_POWER_VDDDCTRL_RSRVD1		__BITS(7, 5)
#define HW_POWER_VDDDCTRL_TRG			__BITS(4, 0)

/*
 * VDDA Supply Targets and Brownouts Control Register.
 */

#define HW_POWER_VDDACTRL	0x050

#define HW_POWER_VDDACTRL_RSRVD4		__BITS(31, 20)
#define HW_POWER_VDDACTRL_PWDN_BRNOUT		__BIT(19)
#define HW_POWER_VDDACTRL_DISABLE_STEPPING	__BIT(18)
#define HW_POWER_VDDACTRL_ENABLE_LINREG		__BIT(17)
#define HW_POWER_VDDACTRL_DISABLE_FET		__BIT(16)
#define HW_POWER_VDDACTRL_RSRVD3		__BITS(15, 14)
#define HW_POWER_VDDACTRL_LINREG_OFFSET		__BITS(13, 12)
#define HW_POWER_VDDACTRL_RSRVD2		__BIT(11)
#define HW_POWER_VDDACTRL_BO_OFFSET		__BITS(10, 8)
#define HW_POWER_VDDACTRL_RSRVD1		__BITS(7, 5)
#define HW_POWER_VDDACTRL_TRG			__BITS(4, 0)

/*
 * VDDIO Supply Targets and Brownouts Control Register.
 */
#define HW_POWER_VDDIOCTRL	0x060

#define HW_POWER_VDDIOCTRL_RSRVD5		__BITS(31, 24)
#define HW_POWER_VDDIOCTRL_ADJTN		__BITS(23, 20)
#define HW_POWER_VDDIOCTRL_RSRVD4		__BIT(19)
#define HW_POWER_VDDIOCTRL_PWDN_BRNOUT		__BIT(18)
#define HW_POWER_VDDIOCTRL_DISABLE_STEPPING	__BIT(17)
#define HW_POWER_VDDIOCTRL_DISABLE_FET		__BIT(16)
#define HW_POWER_VDDIOCTRL_RSRVD3		__BITS(15, 14)
#define HW_POWER_VDDIOCTRL_LINREG_OFFSET	__BITS(13, 12)
#define HW_POWER_VDDIOCTRL_RSRVD2		__BIT(11)
#define HW_POWER_VDDIOCTRL_BO_OFFSET		__BITS(10, 8)
#define HW_POWER_VDDIOCTRL_RSRVD1		__BITS(7, 5)
#define HW_POWER_VDDIOCTRL_TRG			__BITS(4, 0)

/*
 * VDDMEM Supply Targets Control Register.
 */
#define HW_POWER_VDDMEMCTRL 0x070

#define HW_POWER_VDDMEMCTRL_RSRVD2		__BITS(31, 11)
#define HW_POWER_VDDMEMCTRL_PULLDOWN_ACTIVE	__BIT(10)
#define HW_POWER_VDDMEMCTRL_ENABLE_ILIMIT	__BIT(9)
#define HW_POWER_VDDMEMCTRL_ENABLE_LINREG	__BIT(8)
#define HW_POWER_VDDMEMCTRL_RSRVD1		__BITS(7, 5)
#define HW_POWER_VDDMEMCTRL_TRG			__BITS(4, 0)

/*
 * DC-DC Converter 4.2V Control Register.
 */
#define HW_POWER_DCDC4P2	0x080

#define HW_POWER_DCDC4P2_DROPOUT_CTRL	__BITS(31, 28)
#define HW_POWER_DCDC4P2_RSRVD5		__BITS(27, 26)
#define HW_POWER_DCDC4P2_ISTEAL_THRESH	__BITS(25, 24)
#define HW_POWER_DCDC4P2_ENABLE_4P2	__BIT(23)
#define HW_POWER_DCDC4P2_ENABLE_DCDC	__BIT(22)
#define HW_POWER_DCDC4P2_HYST_DIR	__BIT(21)
#define HW_POWER_DCDC4P2_HYST_THRESH	__BIT(20)
#define HW_POWER_DCDC4P2_RSRVD3		__BIT(19)
#define HW_POWER_DCDC4P2_TRG		__BITS(18, 16)
#define HW_POWER_DCDC4P2_RSRVD2		__BITS(15, 13)
#define HW_POWER_DCDC4P2_BO		__BITS(12, 8)
#define HW_POWER_DCDC4P2_RSRVD1		__BITS(7, 5)
#define HW_POWER_DCDC4P2_CMPTRIP	__BITS(4, 0)

/*
 * DC-DC Miscellaneous Register.
 */
#define HW_POWER_MISC	0x090

#define HW_POWER_MISC_RSRVD2		__BITS(31, 7)
#define HW_POWER_MISC_FREQSEL		__BITS(6, 4)
#define HW_POWER_MISC_RSRVD1		__BIT(3)
#define HW_POWER_MISC_DELAY_TIMING	__BIT(2)
#define HW_POWER_MISC_TEST		__BIT(1)
#define HW_POWER_MISC_SEL_PLLCLK	__BIT(0)

/*
 * DC-DC Duty Cycle Limits Control Register.
 */
#define HW_POWER_DCLIMITS 0x0A0

#define HW_POWER_DCLIMITS_RSRVD3	__BITS(31, 16)
#define HW_POWER_DCLIMITS_RSRVD2	__BIT(15)
#define HW_POWER_DCLIMITS_POSLIMIT_BUCK	__BITS(14, 8)
#define HW_POWER_DCLIMITS_RSRVD1	__BIT(7)
#define HW_POWER_DCLIMITS_NEGLIMIT	__BITS(6, 0)

/*
 * Converter Loop Behavior Control Register.
 */
#define HW_POWER_LOOPCTRL 0x0B0
#define HW_POWER_LOOPCTRL_SET 0x0B4
#define HW_POWER_LOOPCTRL_CLR 0x0B8
#define HW_POWER_LOOPCTRL_TOG 0x0BC

#define HW_POWER_LOOPCTRL_RSRVD3		__BITS(31, 21)
#define HW_POWER_LOOPCTRL_TOGGLE_DIF		__BIT(20)
#define HW_POWER_LOOPCTRL_HYST_SIGN		__BIT(19)
#define HW_POWER_LOOPCTRL_EN_CM_HYST		__BIT(18)
#define HW_POWER_LOOPCTRL_EN_DF_HYST		__BIT(17)
#define HW_POWER_LOOPCTRL_CM_HYST_THRESH	__BIT(16)
#define HW_POWER_LOOPCTRL_DF_HYST_THRESH	__BIT(15)
#define HW_POWER_LOOPCTRL_RCSCALE_THRESH	__BIT(14)
#define HW_POWER_LOOPCTRL_EN_RCSCALE		__BITS(13, 12)
#define HW_POWER_LOOPCTRL_RSRVD2		__BIT(11)
#define HW_POWER_LOOPCTRL_DC_FF			__BITS(10, 8)
#define HW_POWER_LOOPCTRL_DC_R			__BITS(7, 4)
#define HW_POWER_LOOPCTRL_RSRVD1		__BITS(3, 2)
#define HW_POWER_LOOPCTRL_DC_C			__BITS(1, 0)

/*
 * Power Subsystem Status Register.
 */
#define HW_POWER_STS	0x0C0

#define HW_POWER_STS_RSVD4		__BITS(31, 30)
#define HW_POWER_STS_PWRUP_SOURCE	__BITS(29, 24)
#define HW_POWER_STS_RSVD3		__BITS(23, 22)
#define HW_POWER_STS_PSWITCH		__BITS(21, 20)
#define HW_POWER_STS_RSVD2		__BITS(19, 18)
#define HW_POWER_STS_AVALID_STATUS	__BIT(17)
#define HW_POWER_STS_BVALID_STATUS	__BIT(16)
#define HW_POWER_STS_VBUSVALID_STATUS	__BIT(15)
#define HW_POWER_STS_SESSEND_STATUS	__BIT(14)
#define HW_POWER_STS_BATT_BO		__BIT(13)
#define HW_POWER_STS_VDD5V_FAULT	__BIT(12)
#define HW_POWER_STS_CHRGSTS		__BIT(11)
#define HW_POWER_STS_DCDC_4P2_BO	__BIT(10)
#define HW_POWER_STS_RSVD1		__BIT(9)
#define HW_POWER_STS_VDDIO_BO		__BIT(8)
#define HW_POWER_STS_VDDA_BO		__BIT(7)
#define HW_POWER_STS_VDDD_BO		__BIT(6)
#define HW_POWER_STS_VDD5V_GT_VDDIO	__BIT(5)
#define HW_POWER_STS_VDD5V_DROOP	__BIT(4)
#define HW_POWER_STS_AVALID		__BIT(3)
#define HW_POWER_STS_BVALID		__BIT(2)
#define HW_POWER_STS_VBUSVALID		__BIT(1)
#define HW_POWER_STS_SESSEND		__BIT(0)

/*
 * Transistor Speed Control and Status Register.
 */
#define HW_POWER_SPEED		0x0D0
#define HW_POWER_SPEED_SET	0x0D4
#define HW_POWER_SPEED_CLR	0x0D8
#define HW_POWER_SPEED_TOG	0x0DC

#define HW_POWER_SPEED_RSRVD1	__BITS(31, 24)
#define HW_POWER_SPEED_STATUS	__BITS(23, 16)
#define HW_POWER_SPEED_RSRVD0	__BITS(15, 2)
#define HW_POWER_SPEED_CTRL	__BITS(1, 0)

/*
 * Battery Level Monitor Register.
 */
#define HW_POWER_BATTMONITOR	0x0E0

#define HW_POWER_BATTMONITOR_RSRVD3		__BITS(31, 26)
#define HW_POWER_BATTMONITOR_BATT_VAL		__BITS(25, 16)
#define HW_POWER_BATTMONITOR_RSRVD2		__BITS(15, 11)
#define HW_POWER_BATTMONITOR_EN_BATADJ		__BIT(10)
#define HW_POWER_BATTMONITOR_PWDN_BATTBRNOUT	__BIT(9)
#define HW_POWER_BATTMONITOR_BRWNOUT_PWD	__BIT(8)
#define HW_POWER_BATTMONITOR_RSRVD1		__BITS(7, 5)
#define HW_POWER_BATTMONITOR_BRWNOUT_LVL	__BITS(4, 0)

/*
 * Power Module Reset Register.
 */
#define HW_POWER_RESET		0x100
#define HW_POWER_RESET_SET	0x104
#define HW_POWER_RESET_CLR	0x108
#define HW_POWER_RESET_TOG	0x10C

#define HW_POWER_RESET_UNLOCK	__BITS(31, 16)
#define HW_POWER_RESET_RSRVD1	__BITS(15, 2)
#define HW_POWER_RESET_PWD_OFF	__BIT(1)
#define HW_POWER_RESET_PWD	__BIT(0)

/*
 * Power Module Debug Register.
 */
#define HW_POWER_DEBUG		0x110
#define HW_POWER_DEBUG_SET	0x114
#define HW_POWER_DEBUG_CLR	0x118
#define HW_POWER_DEBUG_TOG	0x11C

#define HW_POWER_DEBUG_RSRVD0		__BITS(31, 4)
#define HW_POWER_DEBUG_VBUSVALIDPIOLOCK	__BIT(3)
#define HW_POWER_DEBUG_AVALIDPIOLOCK	__BIT(2)
#define HW_POWER_DEBUG_BVALIDPIOLOCK	__BIT(1)
#define HW_POWER_DEBUG_SESSENDPIOLOCK	__BIT(0)

/*
 * Power Module Special Register.
 */
#define HW_POWER_SPECIAL	0x120
#define HW_POWER_SPECIAL_SET	0x124
#define HW_POWER_SPECIAL_CLR	0x128
#define HW_POWER_SPECIAL_TOG	0x12C

#define HW_POWER_SPECIAL_TEST	__BITS(31, 0)

/*
 * Power Module Version Register.
 */
#define HW_POWER_VERSION	0x130

#define HW_POWER_VERSION_MAJOR	__BITS(31, 24)
#define HW_POWER_VERSION_MINOR	__BITS(23, 16)
#define HW_POWER_VERSION_STEP	__BITS(15, 0)

#endif /* !_ARM_IMX_IMX23_POWERREG_H_ */
