/* $NetBSD: linux32_syscalls.c,v 1.3 2021/12/02 04:39:45 ryo Exp $ */

/*
 * System call names.
 *
 * DO NOT EDIT-- this file is automatically generated.
 * created from	NetBSD: syscalls.master,v 1.2 2021/11/27 21:15:07 ryo Exp
 */

#include <sys/cdefs.h>
__KERNEL_RCSID(0, "$NetBSD: linux32_syscalls.c,v 1.3 2021/12/02 04:39:45 ryo Exp $");

#if defined(_KERNEL_OPT)
#include <sys/param.h>
#include <sys/syscallargs.h>
#include <machine/netbsd32_machdep.h>
#include <compat/netbsd32/netbsd32.h>
#include <compat/netbsd32/netbsd32_syscallargs.h>
#include <compat/linux/common/linux_types.h>
#include <compat/linux/common/linux_mmap.h>
#include <compat/linux/common/linux_signal.h>
#include <compat/linux/common/linux_siginfo.h>
#include <compat/linux/common/linux_machdep.h>
#include <compat/linux/common/linux_ipc.h>
#include <compat/linux/common/linux_sem.h>
#include <compat/linux/linux_syscallargs.h>
#include <compat/linux32/common/linux32_types.h>
#include <compat/linux32/common/linux32_signal.h>
#include <compat/linux32/common/linux32_socketcall.h>
#include <compat/linux32/arch/aarch64/linux32_missing.h>
#include <compat/linux32/linux32_syscallargs.h>
#else /* _KERNEL_OPT */
#include <sys/null.h>
#endif /* _KERNEL_OPT */

const char *const linux32_syscallnames[] = {
	/*   0 */	"syscall",
	/*   1 */	"exit",
	/*   2 */	"fork",
	/*   3 */	"netbsd32_read",
	/*   4 */	"netbsd32_write",
	/*   5 */	"open",
	/*   6 */	"netbsd32_close",
	/*   7 */	"waitpid",
	/*   8 */	"creat",
	/*   9 */	"netbsd32_link",
	/*  10 */	"unlink",
	/*  11 */	"netbsd32_execve",
	/*  12 */	"netbsd32_chdir",
	/*  13 */	"time",
	/*  14 */	"mknod",
	/*  15 */	"netbsd32_chmod",
	/*  16 */	"lchown16",
	/*  17 */	"#17 (obsolete break)",
	/*  18 */	"#18 (obsolete ostat)",
	/*  19 */	"compat_43_netbsd32_olseek",
	/*  20 */	"getpid",
	/*  21 */	"#21 (unimplemented mount)",
	/*  22 */	"#22 (unimplemented umount)",
	/*  23 */	"linux_setuid16",
	/*  24 */	"linux_getuid16",
	/*  25 */	"stime",
	/*  26 */	"ptrace",
	/*  27 */	"alarm",
	/*  28 */	"#28 (obsolete ofstat)",
	/*  29 */	"pause",
	/*  30 */	"utime",
	/*  31 */	"#31 (obsolete stty)",
	/*  32 */	"#32 (obsolete gtty)",
	/*  33 */	"netbsd32_access",
	/*  34 */	"nice",
	/*  35 */	"#35 (obsolete ftime)",
	/*  36 */	"sync",
	/*  37 */	"kill",
	/*  38 */	"netbsd32___posix_rename",
	/*  39 */	"netbsd32_mkdir",
	/*  40 */	"netbsd32_rmdir",
	/*  41 */	"netbsd32_dup",
	/*  42 */	"pipe",
	/*  43 */	"times",
	/*  44 */	"#44 (obsolete prof)",
	/*  45 */	"brk",
	/*  46 */	"linux_setgid16",
	/*  47 */	"linux_getgid16",
	/*  48 */	"signal",
	/*  49 */	"linux_geteuid16",
	/*  50 */	"linux_getegid16",
	/*  51 */	"netbsd32_acct",
	/*  52 */	"#52 (obsolete phys)",
	/*  53 */	"#53 (obsolete lock)",
	/*  54 */	"ioctl",
	/*  55 */	"fcntl",
	/*  56 */	"#56 (obsolete mpx)",
	/*  57 */	"netbsd32_setpgid",
	/*  58 */	"#58 (obsolete ulimit)",
	/*  59 */	"oldolduname",
	/*  60 */	"netbsd32_umask",
	/*  61 */	"netbsd32_chroot",
	/*  62 */	"#62 (unimplemented ustat)",
	/*  63 */	"netbsd32_dup2",
	/*  64 */	"getppid",
	/*  65 */	"getpgrp",
	/*  66 */	"setsid",
	/*  67 */	"#67 (unimplemented sigaction)",
	/*  68 */	"siggetmask",
	/*  69 */	"sigsetmask",
	/*  70 */	"setreuid16",
	/*  71 */	"setregid16",
	/*  72 */	"#72 (unimplemented sigsuspend)",
	/*  73 */	"#73 (unimplemented sigpending)",
	/*  74 */	"compat_43_netbsd32_osethostname",
	/*  75 */	"setrlimit",
	/*  76 */	"getrlimit",
	/*  77 */	"compat_50_netbsd32_getrusage",
	/*  78 */	"gettimeofday",
	/*  79 */	"settimeofday",
	/*  80 */	"getgroups16",
	/*  81 */	"setgroups16",
	/*  82 */	"oldselect",
	/*  83 */	"netbsd32_symlink",
	/*  84 */	"compat_43_netbsd32_lstat43",
	/*  85 */	"netbsd32_readlink",
	/*  86 */	"#86 (unimplemented uselib)",
	/*  87 */	"swapon",
	/*  88 */	"reboot",
	/*  89 */	"readdir",
	/*  90 */	"old_mmap",
	/*  91 */	"netbsd32_munmap",
	/*  92 */	"compat_43_netbsd32_otruncate",
	/*  93 */	"compat_43_netbsd32_oftruncate",
	/*  94 */	"netbsd32_fchmod",
	/*  95 */	"fchown16",
	/*  96 */	"getpriority",
	/*  97 */	"netbsd32_setpriority",
	/*  98 */	"netbsd32_profil",
	/*  99 */	"statfs",
	/* 100 */	"fstatfs",
	/* 101 */	"#101 (unimplemented ioperm)",
	/* 102 */	"socketcall",
	/* 103 */	"#103 (unimplemented syslog)",
	/* 104 */	"compat_50_netbsd32_setitimer",
	/* 105 */	"compat_50_netbsd32_getitimer",
	/* 106 */	"stat",
	/* 107 */	"lstat",
	/* 108 */	"fstat",
	/* 109 */	"olduname",
	/* 110 */	"#110 (unimplemented iopl)",
	/* 111 */	"#111 (unimplemented vhangup)",
	/* 112 */	"#112 (unimplemented idle)",
	/* 113 */	"#113 (unimplemented syscall)",
	/* 114 */	"wait4",
	/* 115 */	"swapoff",
	/* 116 */	"sysinfo",
	/* 117 */	"ipc",
	/* 118 */	"netbsd32_fsync",
	/* 119 */	"sigreturn",
	/* 120 */	"clone",
	/* 121 */	"setdomainname",
	/* 122 */	"uname",
	/* 123 */	"#123 (unimplemented modify_ldt)",
	/* 124 */	"#124 (unimplemented adjtimex)",
	/* 125 */	"mprotect",
	/* 126 */	"#126 (unimplemented sigprocmask)",
	/* 127 */	"#127 (unimplemented create_module)",
	/* 128 */	"#128 (unimplemented init_module)",
	/* 129 */	"#129 (unimplemented delete_module)",
	/* 130 */	"#130 (unimplemented get_kernel_syms)",
	/* 131 */	"#131 (unimplemented quotactl)",
	/* 132 */	"netbsd32_getpgid",
	/* 133 */	"netbsd32_fchdir",
	/* 134 */	"#134 (unimplemented bdflush)",
	/* 135 */	"#135 (unimplemented sysfs)",
	/* 136 */	"personality",
	/* 137 */	"#137 (unimplemented afs_syscall)",
	/* 138 */	"setfsuid16",
	/* 139 */	"setfsgid16",
	/* 140 */	"llseek",
	/* 141 */	"getdents",
	/* 142 */	"select",
	/* 143 */	"netbsd32_flock",
	/* 144 */	"netbsd32___msync13",
	/* 145 */	"netbsd32_readv",
	/* 146 */	"netbsd32_writev",
	/* 147 */	"netbsd32_getsid",
	/* 148 */	"fdatasync",
	/* 149 */	"__sysctl",
	/* 150 */	"netbsd32_mlock",
	/* 151 */	"netbsd32_munlock",
	/* 152 */	"netbsd32_mlockall",
	/* 153 */	"munlockall",
	/* 154 */	"sched_setparam",
	/* 155 */	"sched_getparam",
	/* 156 */	"sched_setscheduler",
	/* 157 */	"sched_getscheduler",
	/* 158 */	"sched_yield",
	/* 159 */	"sched_get_priority_max",
	/* 160 */	"sched_get_priority_min",
	/* 161 */	"#161 (unimplemented sched_rr_get_interval)",
	/* 162 */	"nanosleep",
	/* 163 */	"mremap",
	/* 164 */	"setresuid16",
	/* 165 */	"getresuid16",
	/* 166 */	"#166 (unimplemented vm86)",
	/* 167 */	"#167 (unimplemented query_module)",
	/* 168 */	"netbsd32_poll",
	/* 169 */	"#169 (unimplemented nfsservctl)",
	/* 170 */	"setresgid16",
	/* 171 */	"getresgid16",
	/* 172 */	"#172 (unimplemented prctl)",
	/* 173 */	"rt_sigreturn",
	/* 174 */	"rt_sigaction",
	/* 175 */	"rt_sigprocmask",
	/* 176 */	"rt_sigpending",
	/* 177 */	"rt_sigtimedwait",
	/* 178 */	"rt_queueinfo",
	/* 179 */	"rt_sigsuspend",
	/* 180 */	"pread",
	/* 181 */	"pwrite",
	/* 182 */	"chown16",
	/* 183 */	"netbsd32___getcwd",
	/* 184 */	"#184 (unimplemented capget)",
	/* 185 */	"#185 (unimplemented capset)",
	/* 186 */	"#186 (unimplemented sigaltstack)",
	/* 187 */	"#187 (unimplemented sendfile)",
	/* 188 */	"#188 (unimplemented getpmsg)",
	/* 189 */	"#189 (unimplemented putpmsg)",
	/* 190 */	"__vfork14",
	/* 191 */	"ugetrlimit",
	/* 192 */	"mmap2",
	/* 193 */	"truncate64",
	/* 194 */	"ftruncate64",
	/* 195 */	"stat64",
	/* 196 */	"lstat64",
	/* 197 */	"fstat64",
	/* 198 */	"netbsd32___posix_lchown",
	/* 199 */	"getuid",
	/* 200 */	"getgid",
	/* 201 */	"geteuid",
	/* 202 */	"getegid",
	/* 203 */	"netbsd32_setreuid",
	/* 204 */	"netbsd32_setregid",
	/* 205 */	"netbsd32_getgroups",
	/* 206 */	"netbsd32_setgroups",
	/* 207 */	"netbsd32___posix_fchown",
	/* 208 */	"setresuid",
	/* 209 */	"getresuid",
	/* 210 */	"setresgid",
	/* 211 */	"getresgid",
	/* 212 */	"netbsd32___posix_chown",
	/* 213 */	"netbsd32_setuid",
	/* 214 */	"netbsd32_setgid",
	/* 215 */	"setfsuid",
	/* 216 */	"setfsgid",
	/* 217 */	"getdents64",
	/* 218 */	"#218 (unimplemented pivot_root)",
	/* 219 */	"netbsd32_mincore",
	/* 220 */	"netbsd32_madvise",
#define linux32_sys_fcntl64 linux32_sys_fcntl
#define linux32_sys_fcntl64_args linux32_sys_fcntl_args
	/* 221 */	"fcntl64",
	/* 222 */	"#222 (unimplemented / * unused * /)",
	/* 223 */	"#223 (unimplemented / * unused * /)",
	/* 224 */	"gettid",
	/* 225 */	"#225 (unimplemented readahead)",
	/* 226 */	"netbsd32_setxattr",
	/* 227 */	"netbsd32_lsetxattr",
	/* 228 */	"netbsd32_fsetxattr",
	/* 229 */	"netbsd32_getxattr",
	/* 230 */	"netbsd32_lgetxattr",
	/* 231 */	"netbsd32_fgetxattr",
	/* 232 */	"netbsd32_listxattr",
	/* 233 */	"netbsd32_llistxattr",
	/* 234 */	"netbsd32_flistxattr",
	/* 235 */	"netbsd32_removexattr",
	/* 236 */	"netbsd32_lremovexattr",
	/* 237 */	"netbsd32_fremovexattr",
	/* 238 */	"tkill",
	/* 239 */	"#239 (unimplemented sendfile64)",
	/* 240 */	"futex",
	/* 241 */	"sched_setaffinity",
	/* 242 */	"sched_getaffinity",
	/* 243 */	"#243 (unimplemented io_setup)",
	/* 244 */	"#244 (unimplemented io_destroy)",
	/* 245 */	"#245 (unimplemented io_getevents)",
	/* 246 */	"#246 (unimplemented io_submit)",
	/* 247 */	"#247 (unimplemented io_cancel)",
	/* 248 */	"exit_group",
	/* 249 */	"#249 (unimplemented lookup_dcookie)",
	/* 250 */	"#250 (unimplemented epoll_create)",
	/* 251 */	"#251 (unimplemented epoll_ctl)",
	/* 252 */	"#252 (unimplemented epoll_wait)",
	/* 253 */	"#253 (unimplemented remap_file_pages)",
	/* 254 */	"#254 (unimplemented set_thread_area)",
	/* 255 */	"#255 (unimplemented get_thread_area)",
	/* 256 */	"set_tid_address",
	/* 257 */	"timer_create",
	/* 258 */	"timer_settime",
	/* 259 */	"timer_gettime",
	/* 260 */	"timer_getoverrun",
	/* 261 */	"timer_delete",
	/* 262 */	"clock_settime",
	/* 263 */	"clock_gettime",
	/* 264 */	"clock_getres",
	/* 265 */	"clock_nanosleep",
	/* 266 */	"statfs64",
	/* 267 */	"fstatfs64",
	/* 268 */	"tgkill",
	/* 269 */	"compat_50_netbsd32_utimes",
	/* 270 */	"fadvise64_64",
	/* 271 */	"#271 (unimplemented pciconfig_iobase)",
	/* 272 */	"#272 (unimplemented pciconfig_read)",
	/* 273 */	"#273 (unimplemented pciconfig_write)",
	/* 274 */	"#274 (unimplemented mq_open)",
	/* 275 */	"#275 (unimplemented mq_unlink)",
	/* 276 */	"#276 (unimplemented mq_timedsend)",
	/* 277 */	"#277 (unimplemented mq_timedreceive)",
	/* 278 */	"#278 (unimplemented mq_notify)",
	/* 279 */	"#279 (unimplemented mq_getsetattr)",
	/* 280 */	"#280 (unimplemented waitid)",
	/* 281 */	"socket",
	/* 282 */	"bind",
	/* 283 */	"connect",
	/* 284 */	"#284 (unimplemented listen)",
	/* 285 */	"accept",
	/* 286 */	"getsockname",
	/* 287 */	"getpeername",
	/* 288 */	"socketpair",
	/* 289 */	"send",
	/* 290 */	"sendto",
	/* 291 */	"recv",
	/* 292 */	"recvfrom",
	/* 293 */	"#293 (unimplemented shutdown)",
	/* 294 */	"setsockopt",
	/* 295 */	"getsockopt",
	/* 296 */	"#296 (unimplemented sendmsg)",
	/* 297 */	"#297 (unimplemented recvmsg)",
	/* 298 */	"#298 (unimplemented semop)",
	/* 299 */	"#299 (unimplemented semget)",
	/* 300 */	"#300 (unimplemented semctl)",
	/* 301 */	"#301 (unimplemented msgsnd)",
	/* 302 */	"#302 (unimplemented msgrcv)",
	/* 303 */	"#303 (unimplemented msgget)",
	/* 304 */	"#304 (unimplemented msgctl)",
	/* 305 */	"#305 (unimplemented shmat)",
	/* 306 */	"#306 (unimplemented shmdt)",
	/* 307 */	"#307 (unimplemented shmget)",
	/* 308 */	"#308 (unimplemented shmctl)",
	/* 309 */	"#309 (unimplemented add_key)",
	/* 310 */	"#310 (unimplemented request_key)",
	/* 311 */	"#311 (unimplemented keyctl)",
	/* 312 */	"#312 (unimplemented semtimedop)",
	/* 313 */	"#313 (unimplemented vserver)",
	/* 314 */	"#314 (unimplemented ioptio_set)",
	/* 315 */	"#315 (unimplemented ioptio_get)",
	/* 316 */	"#316 (unimplemented inotify_init)",
	/* 317 */	"#317 (unimplemented inotify_add_watch)",
	/* 318 */	"#318 (unimplemented inotify_rm_watch)",
	/* 319 */	"#319 (unimplemented mbind)",
	/* 320 */	"#320 (unimplemented get_mempolicy)",
	/* 321 */	"#321 (unimplemented set_mempolicy)",
	/* 322 */	"openat",
	/* 323 */	"netbsd32_mkdirat",
	/* 324 */	"mknodat",
	/* 325 */	"fchownat",
	/* 326 */	"#326 (unimplemented futimesat)",
	/* 327 */	"fstatat64",
	/* 328 */	"unlinkat",
	/* 329 */	"netbsd32_renameat",
	/* 330 */	"linkat",
	/* 331 */	"netbsd32_symlinkat",
	/* 332 */	"netbsd32_readlinkat",
	/* 333 */	"fchmodat",
	/* 334 */	"faccessat",
	/* 335 */	"pselect6",
	/* 336 */	"ppoll",
	/* 337 */	"#337 (unimplemented unshare)",
	/* 338 */	"netbsd32___futex_set_robust_list",
	/* 339 */	"netbsd32___futex_get_robust_list",
	/* 340 */	"#340 (unimplemented splice)",
	/* 341 */	"#341 (unimplemented sync_file_range)",
	/* 342 */	"#342 (unimplemented tee)",
	/* 343 */	"#343 (unimplemented vmsplice)",
	/* 344 */	"#344 (unimplemented move_pages)",
	/* 345 */	"#345 (unimplemented getcpu)",
	/* 346 */	"#346 (unimplemented epoll_wait)",
	/* 347 */	"#347 (unimplemented kexec_load)",
	/* 348 */	"utimensat",
	/* 349 */	"#349 (unimplemented signalfd)",
	/* 350 */	"timerfd_create",
	/* 351 */	"eventfd",
	/* 352 */	"fallocate",
	/* 353 */	"timerfd_settime",
	/* 354 */	"timerfd_gettime",
	/* 355 */	"#355 (unimplemented signalfd4)",
	/* 356 */	"eventfd2",
	/* 357 */	"#357 (unimplemented epoll_create1)",
	/* 358 */	"dup3",
	/* 359 */	"pipe2",
	/* 360 */	"#360 (unimplemented inotify_init1)",
	/* 361 */	"preadv",
	/* 362 */	"pwritev",
	/* 363 */	"#363 (unimplemented rt_tgsigqueueinfo)",
	/* 364 */	"#364 (unimplemented perf_counter_open)",
	/* 365 */	"#365 (unimplemented recvmmsg)",
	/* 366 */	"#366 (unimplemented accept4)",
	/* 367 */	"#367 (unimplemented fanotify_init)",
	/* 368 */	"#368 (unimplemented fanotify_mark)",
	/* 369 */	"prlimit64",
	/* 370 */	"#370 (unimplemented name_to_handle_at)",
	/* 371 */	"#371 (unimplemented open_by_handle_at)",
	/* 372 */	"#372 (unimplemented clock_adjtime)",
	/* 373 */	"#373 (unimplemented syncfs)",
	/* 374 */	"#374 (unimplemented sendmmsg)",
	/* 375 */	"#375 (unimplemented setns)",
	/* 376 */	"#376 (unimplemented process_vm_readv)",
	/* 377 */	"#377 (unimplemented process_vm_writev)",
	/* 378 */	"#378 (unimplemented kcmp)",
	/* 379 */	"#379 (unimplemented finit_module)",
	/* 380 */	"#380 (unimplemented sched_setattr)",
	/* 381 */	"#381 (unimplemented sched_getattr)",
	/* 382 */	"#382 (unimplemented renameat2)",
	/* 383 */	"#383 (unimplemented seccomp)",
	/* 384 */	"netbsd32_getrandom",
	/* 385 */	"#385 (unimplemented memfd_create)",
	/* 386 */	"#386 (unimplemented bpf)",
	/* 387 */	"#387 (unimplemented execveat)",
	/* 388 */	"#388 (unimplemented userfaultfd)",
	/* 389 */	"#389 (unimplemented membarrier)",
	/* 390 */	"#390 (unimplemented mlock2)",
	/* 391 */	"#391 (unimplemented copy_file_range)",
	/* 392 */	"#392 (unimplemented preadv2)",
	/* 393 */	"#393 (unimplemented pwritev2)",
	/* 394 */	"#394 (unimplemented pkey_mprotect)",
	/* 395 */	"#395 (unimplemented pkey_alloc)",
	/* 396 */	"#396 (unimplemented pkey_free)",
	/* 397 */	"statx",
	/* 398 */	"#398 (unimplemented rseq)",
	/* 399 */	"#399 (unimplemented io_pgetevents)",
	/* 400 */	"#400 (unimplemented migrate_pages)",
	/* 401 */	"#401 (unimplemented kexec_file_load)",
	/* 402 */	"#402 (unimplemented / * unused * /)",
	/* 403 */	"#403 (unimplemented clock_gettime64)",
	/* 404 */	"#404 (unimplemented clock_settime64)",
	/* 405 */	"#405 (unimplemented clock_adjtime64)",
	/* 406 */	"#406 (unimplemented clock_getres_time64)",
	/* 407 */	"#407 (unimplemented clock_nanosleep_time64)",
	/* 408 */	"#408 (unimplemented timer_gettime64)",
	/* 409 */	"#409 (unimplemented timer_settime64)",
	/* 410 */	"#410 (unimplemented timerfd_gettime64)",
	/* 411 */	"#411 (unimplemented timerfd_settime64)",
	/* 412 */	"#412 (unimplemented utimensat_time64)",
	/* 413 */	"#413 (unimplemented pselect6_time64)",
	/* 414 */	"#414 (unimplemented ppoll_time64)",
	/* 415 */	"#415 (unimplemented / * unused? * /)",
	/* 416 */	"#416 (unimplemented io_pgetevents_time64)",
	/* 417 */	"#417 (unimplemented recvmmsg_time64)",
	/* 418 */	"#418 (unimplemented mq_timedsend_time64)",
	/* 419 */	"#419 (unimplemented mq_timedreceive_time64)",
	/* 420 */	"#420 (unimplemented semtimedop_time64)",
	/* 421 */	"#421 (unimplemented rt_sigtimedwait_time64)",
	/* 422 */	"#422 (unimplemented futex_time64)",
	/* 423 */	"#423 (unimplemented sched_rr_get_interval_time64)",
	/* 424 */	"#424 (unimplemented pidfd_send_signal)",
	/* 425 */	"#425 (unimplemented io_uring_setup)",
	/* 426 */	"#426 (unimplemented io_uring_enter)",
	/* 427 */	"#427 (unimplemented io_uring_register)",
	/* 428 */	"#428 (unimplemented open_tree)",
	/* 429 */	"#429 (unimplemented move_mount)",
	/* 430 */	"#430 (unimplemented fsopen)",
	/* 431 */	"#431 (unimplemented fsconfig)",
	/* 432 */	"#432 (unimplemented fsmount)",
	/* 433 */	"#433 (unimplemented fspick)",
	/* 434 */	"#434 (unimplemented pidfd_open)",
	/* 435 */	"#435 (unimplemented clone3)",
	/* 436 */	"#436 (unimplemented close_range)",
	/* 437 */	"#437 (unimplemented openat2)",
	/* 438 */	"#438 (unimplemented pidfd_getfd)",
	/* 439 */	"#439 (unimplemented faccessat2)",
	/* 440 */	"#440 (unimplemented process_madvise)",
	/* 441 */	"#441 (unimplemented epoll_pwait2)",
	/* 442 */	"#442 (unimplemented mount_setattr)",
	/* 443 */	"#443 (unimplemented quotactl_fd)",
	/* 444 */	"#444 (unimplemented landlock_create_ruleset)",
	/* 445 */	"#445 (unimplemented landlock_add_rule)",
	/* 446 */	"#446 (unimplemented landlock_restrict_self)",
	/* 447 */	"#447 (unimplemented)",
	/* 448 */	"#448 (unimplemented)",
	/* 449 */	"#449 (unimplemented)",
	/* 450 */	"#450 (unimplemented)",
	/* 451 */	"#451 (unimplemented)",
	/* 452 */	"#452 (unimplemented)",
	/* 453 */	"#453 (unimplemented)",
	/* 454 */	"#454 (unimplemented)",
	/* 455 */	"#455 (unimplemented)",
	/* 456 */	"#456 (unimplemented)",
	/* 457 */	"#457 (unimplemented)",
	/* 458 */	"#458 (unimplemented)",
	/* 459 */	"#459 (unimplemented)",
	/* 460 */	"#460 (unimplemented)",
	/* 461 */	"#461 (unimplemented)",
	/* 462 */	"#462 (unimplemented)",
	/* 463 */	"#463 (unimplemented)",
	/* 464 */	"#464 (unimplemented)",
	/* 465 */	"#465 (unimplemented)",
	/* 466 */	"#466 (unimplemented)",
	/* 467 */	"#467 (unimplemented)",
	/* 468 */	"#468 (unimplemented)",
	/* 469 */	"#469 (unimplemented)",
	/* 470 */	"#470 (unimplemented)",
	/* 471 */	"#471 (unimplemented)",
	/* 472 */	"#472 (unimplemented)",
	/* 473 */	"#473 (unimplemented)",
	/* 474 */	"#474 (unimplemented)",
	/* 475 */	"#475 (unimplemented)",
	/* 476 */	"#476 (unimplemented)",
	/* 477 */	"#477 (unimplemented)",
	/* 478 */	"#478 (unimplemented)",
	/* 479 */	"#479 (unimplemented)",
	/* 480 */	"#480 (unimplemented / * base. actually 0x0f0000 * /)",
	/* 481 */	"#481 (unimplemented breakpoint)",
	/* 482 */	"#482 (unimplemented cacheflush)",
	/* 483 */	"#483 (unimplemented usr26)",
	/* 484 */	"#484 (unimplemented usr32)",
	/* 485 */	"set_tls",
	/* 486 */	"get_tls",
	/* 487 */	"# filler",
	/* 488 */	"# filler",
	/* 489 */	"# filler",
	/* 490 */	"# filler",
	/* 491 */	"# filler",
	/* 492 */	"# filler",
	/* 493 */	"# filler",
	/* 494 */	"# filler",
	/* 495 */	"# filler",
	/* 496 */	"# filler",
	/* 497 */	"# filler",
	/* 498 */	"# filler",
	/* 499 */	"# filler",
	/* 500 */	"# filler",
	/* 501 */	"# filler",
	/* 502 */	"# filler",
	/* 503 */	"# filler",
	/* 504 */	"# filler",
	/* 505 */	"# filler",
	/* 506 */	"# filler",
	/* 507 */	"# filler",
	/* 508 */	"# filler",
	/* 509 */	"# filler",
	/* 510 */	"# filler",
	/* 511 */	"# filler",
};


/* libc style syscall names */
const char *const altlinux32_syscallnames[] = {
	/*   0 */	"nosys",
	/*   1 */	NULL, /* exit */
	/*   2 */	NULL, /* fork */
	/*   3 */	"read",
	/*   4 */	"write",
	/*   5 */	NULL, /* open */
	/*   6 */	"close",
	/*   7 */	NULL, /* waitpid */
	/*   8 */	NULL, /* creat */
	/*   9 */	"link",
	/*  10 */	NULL, /* unlink */
	/*  11 */	"execve",
	/*  12 */	"chdir",
	/*  13 */	NULL, /* time */
	/*  14 */	NULL, /* mknod */
	/*  15 */	"chmod",
	/*  16 */	NULL, /* lchown16 */
	/*  17 */	NULL, /* obsolete break */
	/*  18 */	NULL, /* obsolete ostat */
	/*  19 */	"olseek",
	/*  20 */	NULL, /* getpid */
	/*  21 */	NULL, /* unimplemented mount */
	/*  22 */	NULL, /* unimplemented umount */
	/*  23 */	"setuid",
	/*  24 */	"getuid",
	/*  25 */	NULL, /* stime */
	/*  26 */	NULL, /* ptrace */
	/*  27 */	NULL, /* alarm */
	/*  28 */	NULL, /* obsolete ofstat */
	/*  29 */	NULL, /* pause */
	/*  30 */	NULL, /* utime */
	/*  31 */	NULL, /* obsolete stty */
	/*  32 */	NULL, /* obsolete gtty */
	/*  33 */	"access",
	/*  34 */	NULL, /* nice */
	/*  35 */	NULL, /* obsolete ftime */
	/*  36 */	NULL, /* sync */
	/*  37 */	NULL, /* kill */
	/*  38 */	"__posix_rename",
	/*  39 */	"mkdir",
	/*  40 */	"rmdir",
	/*  41 */	"dup",
	/*  42 */	NULL, /* pipe */
	/*  43 */	NULL, /* times */
	/*  44 */	NULL, /* obsolete prof */
	/*  45 */	NULL, /* brk */
	/*  46 */	"setgid",
	/*  47 */	"getgid",
	/*  48 */	NULL, /* signal */
	/*  49 */	"geteuid",
	/*  50 */	"getegid",
	/*  51 */	"acct",
	/*  52 */	NULL, /* obsolete phys */
	/*  53 */	NULL, /* obsolete lock */
	/*  54 */	NULL, /* ioctl */
	/*  55 */	NULL, /* fcntl */
	/*  56 */	NULL, /* obsolete mpx */
	/*  57 */	"setpgid",
	/*  58 */	NULL, /* obsolete ulimit */
	/*  59 */	NULL, /* oldolduname */
	/*  60 */	"umask",
	/*  61 */	"chroot",
	/*  62 */	NULL, /* unimplemented ustat */
	/*  63 */	"dup2",
	/*  64 */	NULL, /* getppid */
	/*  65 */	NULL, /* getpgrp */
	/*  66 */	NULL, /* setsid */
	/*  67 */	NULL, /* unimplemented sigaction */
	/*  68 */	NULL, /* siggetmask */
	/*  69 */	NULL, /* sigsetmask */
	/*  70 */	NULL, /* setreuid16 */
	/*  71 */	NULL, /* setregid16 */
	/*  72 */	NULL, /* unimplemented sigsuspend */
	/*  73 */	NULL, /* unimplemented sigpending */
	/*  74 */	"osethostname",
	/*  75 */	NULL, /* setrlimit */
	/*  76 */	NULL, /* getrlimit */
	/*  77 */	"getrusage",
	/*  78 */	NULL, /* gettimeofday */
	/*  79 */	NULL, /* settimeofday */
	/*  80 */	NULL, /* getgroups16 */
	/*  81 */	NULL, /* setgroups16 */
	/*  82 */	NULL, /* oldselect */
	/*  83 */	"symlink",
	/*  84 */	"lstat43",
	/*  85 */	"readlink",
	/*  86 */	NULL, /* unimplemented uselib */
	/*  87 */	NULL, /* swapon */
	/*  88 */	NULL, /* reboot */
	/*  89 */	NULL, /* readdir */
	/*  90 */	NULL, /* old_mmap */
	/*  91 */	"munmap",
	/*  92 */	"otruncate",
	/*  93 */	"oftruncate",
	/*  94 */	"fchmod",
	/*  95 */	NULL, /* fchown16 */
	/*  96 */	NULL, /* getpriority */
	/*  97 */	"setpriority",
	/*  98 */	"profil",
	/*  99 */	NULL, /* statfs */
	/* 100 */	NULL, /* fstatfs */
	/* 101 */	NULL, /* unimplemented ioperm */
	/* 102 */	NULL, /* socketcall */
	/* 103 */	NULL, /* unimplemented syslog */
	/* 104 */	"setitimer",
	/* 105 */	"getitimer",
	/* 106 */	NULL, /* stat */
	/* 107 */	NULL, /* lstat */
	/* 108 */	NULL, /* fstat */
	/* 109 */	NULL, /* olduname */
	/* 110 */	NULL, /* unimplemented iopl */
	/* 111 */	NULL, /* unimplemented vhangup */
	/* 112 */	NULL, /* unimplemented idle */
	/* 113 */	NULL, /* unimplemented syscall */
	/* 114 */	NULL, /* wait4 */
	/* 115 */	NULL, /* swapoff */
	/* 116 */	NULL, /* sysinfo */
	/* 117 */	NULL, /* ipc */
	/* 118 */	"fsync",
	/* 119 */	NULL, /* sigreturn */
	/* 120 */	NULL, /* clone */
	/* 121 */	NULL, /* setdomainname */
	/* 122 */	NULL, /* uname */
	/* 123 */	NULL, /* unimplemented modify_ldt */
	/* 124 */	NULL, /* unimplemented adjtimex */
	/* 125 */	NULL, /* mprotect */
	/* 126 */	NULL, /* unimplemented sigprocmask */
	/* 127 */	NULL, /* unimplemented create_module */
	/* 128 */	NULL, /* unimplemented init_module */
	/* 129 */	NULL, /* unimplemented delete_module */
	/* 130 */	NULL, /* unimplemented get_kernel_syms */
	/* 131 */	NULL, /* unimplemented quotactl */
	/* 132 */	"getpgid",
	/* 133 */	"fchdir",
	/* 134 */	NULL, /* unimplemented bdflush */
	/* 135 */	NULL, /* unimplemented sysfs */
	/* 136 */	NULL, /* personality */
	/* 137 */	NULL, /* unimplemented afs_syscall */
	/* 138 */	"setfsuid",
	/* 139 */	"setfsgid",
	/* 140 */	NULL, /* llseek */
	/* 141 */	NULL, /* getdents */
	/* 142 */	NULL, /* select */
	/* 143 */	"flock",
	/* 144 */	"msync",
	/* 145 */	"readv",
	/* 146 */	"writev",
	/* 147 */	"getsid",
	/* 148 */	NULL, /* fdatasync */
	/* 149 */	NULL, /* __sysctl */
	/* 150 */	"mlock",
	/* 151 */	"munlock",
	/* 152 */	"mlockall",
	/* 153 */	NULL, /* munlockall */
	/* 154 */	NULL, /* sched_setparam */
	/* 155 */	NULL, /* sched_getparam */
	/* 156 */	NULL, /* sched_setscheduler */
	/* 157 */	NULL, /* sched_getscheduler */
	/* 158 */	NULL, /* sched_yield */
	/* 159 */	NULL, /* sched_get_priority_max */
	/* 160 */	NULL, /* sched_get_priority_min */
	/* 161 */	NULL, /* unimplemented sched_rr_get_interval */
	/* 162 */	NULL, /* nanosleep */
	/* 163 */	NULL, /* mremap */
	/* 164 */	NULL, /* setresuid16 */
	/* 165 */	NULL, /* getresuid16 */
	/* 166 */	NULL, /* unimplemented vm86 */
	/* 167 */	NULL, /* unimplemented query_module */
	/* 168 */	"poll",
	/* 169 */	NULL, /* unimplemented nfsservctl */
	/* 170 */	NULL, /* setresgid16 */
	/* 171 */	NULL, /* getresgid16 */
	/* 172 */	NULL, /* unimplemented prctl */
	/* 173 */	NULL, /* rt_sigreturn */
	/* 174 */	NULL, /* rt_sigaction */
	/* 175 */	NULL, /* rt_sigprocmask */
	/* 176 */	NULL, /* rt_sigpending */
	/* 177 */	NULL, /* rt_sigtimedwait */
	/* 178 */	NULL, /* rt_queueinfo */
	/* 179 */	NULL, /* rt_sigsuspend */
	/* 180 */	NULL, /* pread */
	/* 181 */	NULL, /* pwrite */
	/* 182 */	NULL, /* chown16 */
	/* 183 */	"__getcwd",
	/* 184 */	NULL, /* unimplemented capget */
	/* 185 */	NULL, /* unimplemented capset */
	/* 186 */	NULL, /* unimplemented sigaltstack */
	/* 187 */	NULL, /* unimplemented sendfile */
	/* 188 */	NULL, /* unimplemented getpmsg */
	/* 189 */	NULL, /* unimplemented putpmsg */
	/* 190 */	"vfork",
	/* 191 */	NULL, /* ugetrlimit */
	/* 192 */	NULL, /* mmap2 */
	/* 193 */	NULL, /* truncate64 */
	/* 194 */	NULL, /* ftruncate64 */
	/* 195 */	NULL, /* stat64 */
	/* 196 */	NULL, /* lstat64 */
	/* 197 */	NULL, /* fstat64 */
	/* 198 */	"__posix_lchown",
	/* 199 */	NULL, /* getuid */
	/* 200 */	NULL, /* getgid */
	/* 201 */	NULL, /* geteuid */
	/* 202 */	NULL, /* getegid */
	/* 203 */	"setreuid",
	/* 204 */	"setregid",
	/* 205 */	"getgroups",
	/* 206 */	"setgroups",
	/* 207 */	"__posix_fchown",
	/* 208 */	NULL, /* setresuid */
	/* 209 */	NULL, /* getresuid */
	/* 210 */	NULL, /* setresgid */
	/* 211 */	NULL, /* getresgid */
	/* 212 */	"__posix_chown",
	/* 213 */	"setuid",
	/* 214 */	"setgid",
	/* 215 */	NULL, /* setfsuid */
	/* 216 */	NULL, /* setfsgid */
	/* 217 */	NULL, /* getdents64 */
	/* 218 */	NULL, /* unimplemented pivot_root */
	/* 219 */	"mincore",
	/* 220 */	"madvise",
#define linux32_sys_fcntl64 linux32_sys_fcntl
#define linux32_sys_fcntl64_args linux32_sys_fcntl_args
	/* 221 */	NULL, /* fcntl64 */
	/* 222 */	NULL, /* unimplemented / * unused * / */
	/* 223 */	NULL, /* unimplemented / * unused * / */
	/* 224 */	NULL, /* gettid */
	/* 225 */	NULL, /* unimplemented readahead */
	/* 226 */	"setxattr",
	/* 227 */	"lsetxattr",
	/* 228 */	"fsetxattr",
	/* 229 */	"getxattr",
	/* 230 */	"lgetxattr",
	/* 231 */	"fgetxattr",
	/* 232 */	"listxattr",
	/* 233 */	"llistxattr",
	/* 234 */	"flistxattr",
	/* 235 */	"removexattr",
	/* 236 */	"lremovexattr",
	/* 237 */	"fremovexattr",
	/* 238 */	NULL, /* tkill */
	/* 239 */	NULL, /* unimplemented sendfile64 */
	/* 240 */	NULL, /* futex */
	/* 241 */	NULL, /* sched_setaffinity */
	/* 242 */	NULL, /* sched_getaffinity */
	/* 243 */	NULL, /* unimplemented io_setup */
	/* 244 */	NULL, /* unimplemented io_destroy */
	/* 245 */	NULL, /* unimplemented io_getevents */
	/* 246 */	NULL, /* unimplemented io_submit */
	/* 247 */	NULL, /* unimplemented io_cancel */
	/* 248 */	NULL, /* exit_group */
	/* 249 */	NULL, /* unimplemented lookup_dcookie */
	/* 250 */	NULL, /* unimplemented epoll_create */
	/* 251 */	NULL, /* unimplemented epoll_ctl */
	/* 252 */	NULL, /* unimplemented epoll_wait */
	/* 253 */	NULL, /* unimplemented remap_file_pages */
	/* 254 */	NULL, /* unimplemented set_thread_area */
	/* 255 */	NULL, /* unimplemented get_thread_area */
	/* 256 */	NULL, /* set_tid_address */
	/* 257 */	NULL, /* timer_create */
	/* 258 */	NULL, /* timer_settime */
	/* 259 */	NULL, /* timer_gettime */
	/* 260 */	NULL, /* timer_getoverrun */
	/* 261 */	NULL, /* timer_delete */
	/* 262 */	NULL, /* clock_settime */
	/* 263 */	NULL, /* clock_gettime */
	/* 264 */	NULL, /* clock_getres */
	/* 265 */	NULL, /* clock_nanosleep */
	/* 266 */	NULL, /* statfs64 */
	/* 267 */	NULL, /* fstatfs64 */
	/* 268 */	NULL, /* tgkill */
	/* 269 */	"utimes",
	/* 270 */	NULL, /* fadvise64_64 */
	/* 271 */	NULL, /* unimplemented pciconfig_iobase */
	/* 272 */	NULL, /* unimplemented pciconfig_read */
	/* 273 */	NULL, /* unimplemented pciconfig_write */
	/* 274 */	NULL, /* unimplemented mq_open */
	/* 275 */	NULL, /* unimplemented mq_unlink */
	/* 276 */	NULL, /* unimplemented mq_timedsend */
	/* 277 */	NULL, /* unimplemented mq_timedreceive */
	/* 278 */	NULL, /* unimplemented mq_notify */
	/* 279 */	NULL, /* unimplemented mq_getsetattr */
	/* 280 */	NULL, /* unimplemented waitid */
	/* 281 */	NULL, /* socket */
	/* 282 */	NULL, /* bind */
	/* 283 */	NULL, /* connect */
	/* 284 */	NULL, /* unimplemented listen */
	/* 285 */	NULL, /* accept */
	/* 286 */	NULL, /* getsockname */
	/* 287 */	NULL, /* getpeername */
	/* 288 */	NULL, /* socketpair */
	/* 289 */	NULL, /* send */
	/* 290 */	NULL, /* sendto */
	/* 291 */	NULL, /* recv */
	/* 292 */	NULL, /* recvfrom */
	/* 293 */	NULL, /* unimplemented shutdown */
	/* 294 */	NULL, /* setsockopt */
	/* 295 */	NULL, /* getsockopt */
	/* 296 */	NULL, /* unimplemented sendmsg */
	/* 297 */	NULL, /* unimplemented recvmsg */
	/* 298 */	NULL, /* unimplemented semop */
	/* 299 */	NULL, /* unimplemented semget */
	/* 300 */	NULL, /* unimplemented semctl */
	/* 301 */	NULL, /* unimplemented msgsnd */
	/* 302 */	NULL, /* unimplemented msgrcv */
	/* 303 */	NULL, /* unimplemented msgget */
	/* 304 */	NULL, /* unimplemented msgctl */
	/* 305 */	NULL, /* unimplemented shmat */
	/* 306 */	NULL, /* unimplemented shmdt */
	/* 307 */	NULL, /* unimplemented shmget */
	/* 308 */	NULL, /* unimplemented shmctl */
	/* 309 */	NULL, /* unimplemented add_key */
	/* 310 */	NULL, /* unimplemented request_key */
	/* 311 */	NULL, /* unimplemented keyctl */
	/* 312 */	NULL, /* unimplemented semtimedop */
	/* 313 */	NULL, /* unimplemented vserver */
	/* 314 */	NULL, /* unimplemented ioptio_set */
	/* 315 */	NULL, /* unimplemented ioptio_get */
	/* 316 */	NULL, /* unimplemented inotify_init */
	/* 317 */	NULL, /* unimplemented inotify_add_watch */
	/* 318 */	NULL, /* unimplemented inotify_rm_watch */
	/* 319 */	NULL, /* unimplemented mbind */
	/* 320 */	NULL, /* unimplemented get_mempolicy */
	/* 321 */	NULL, /* unimplemented set_mempolicy */
	/* 322 */	NULL, /* openat */
	/* 323 */	"mkdirat",
	/* 324 */	NULL, /* mknodat */
	/* 325 */	NULL, /* fchownat */
	/* 326 */	NULL, /* unimplemented futimesat */
	/* 327 */	NULL, /* fstatat64 */
	/* 328 */	NULL, /* unlinkat */
	/* 329 */	"renameat",
	/* 330 */	NULL, /* linkat */
	/* 331 */	"symlinkat",
	/* 332 */	"readlinkat",
	/* 333 */	NULL, /* fchmodat */
	/* 334 */	NULL, /* faccessat */
	/* 335 */	NULL, /* pselect6 */
	/* 336 */	NULL, /* ppoll */
	/* 337 */	NULL, /* unimplemented unshare */
	/* 338 */	"__futex_set_robust_list",
	/* 339 */	"__futex_get_robust_list",
	/* 340 */	NULL, /* unimplemented splice */
	/* 341 */	NULL, /* unimplemented sync_file_range */
	/* 342 */	NULL, /* unimplemented tee */
	/* 343 */	NULL, /* unimplemented vmsplice */
	/* 344 */	NULL, /* unimplemented move_pages */
	/* 345 */	NULL, /* unimplemented getcpu */
	/* 346 */	NULL, /* unimplemented epoll_wait */
	/* 347 */	NULL, /* unimplemented kexec_load */
	/* 348 */	NULL, /* utimensat */
	/* 349 */	NULL, /* unimplemented signalfd */
	/* 350 */	NULL, /* timerfd_create */
	/* 351 */	NULL, /* eventfd */
	/* 352 */	NULL, /* fallocate */
	/* 353 */	NULL, /* timerfd_settime */
	/* 354 */	NULL, /* timerfd_gettime */
	/* 355 */	NULL, /* unimplemented signalfd4 */
	/* 356 */	NULL, /* eventfd2 */
	/* 357 */	NULL, /* unimplemented epoll_create1 */
	/* 358 */	NULL, /* dup3 */
	/* 359 */	NULL, /* pipe2 */
	/* 360 */	NULL, /* unimplemented inotify_init1 */
	/* 361 */	NULL, /* preadv */
	/* 362 */	NULL, /* pwritev */
	/* 363 */	NULL, /* unimplemented rt_tgsigqueueinfo */
	/* 364 */	NULL, /* unimplemented perf_counter_open */
	/* 365 */	NULL, /* unimplemented recvmmsg */
	/* 366 */	NULL, /* unimplemented accept4 */
	/* 367 */	NULL, /* unimplemented fanotify_init */
	/* 368 */	NULL, /* unimplemented fanotify_mark */
	/* 369 */	NULL, /* prlimit64 */
	/* 370 */	NULL, /* unimplemented name_to_handle_at */
	/* 371 */	NULL, /* unimplemented open_by_handle_at */
	/* 372 */	NULL, /* unimplemented clock_adjtime */
	/* 373 */	NULL, /* unimplemented syncfs */
	/* 374 */	NULL, /* unimplemented sendmmsg */
	/* 375 */	NULL, /* unimplemented setns */
	/* 376 */	NULL, /* unimplemented process_vm_readv */
	/* 377 */	NULL, /* unimplemented process_vm_writev */
	/* 378 */	NULL, /* unimplemented kcmp */
	/* 379 */	NULL, /* unimplemented finit_module */
	/* 380 */	NULL, /* unimplemented sched_setattr */
	/* 381 */	NULL, /* unimplemented sched_getattr */
	/* 382 */	NULL, /* unimplemented renameat2 */
	/* 383 */	NULL, /* unimplemented seccomp */
	/* 384 */	"getrandom",
	/* 385 */	NULL, /* unimplemented memfd_create */
	/* 386 */	NULL, /* unimplemented bpf */
	/* 387 */	NULL, /* unimplemented execveat */
	/* 388 */	NULL, /* unimplemented userfaultfd */
	/* 389 */	NULL, /* unimplemented membarrier */
	/* 390 */	NULL, /* unimplemented mlock2 */
	/* 391 */	NULL, /* unimplemented copy_file_range */
	/* 392 */	NULL, /* unimplemented preadv2 */
	/* 393 */	NULL, /* unimplemented pwritev2 */
	/* 394 */	NULL, /* unimplemented pkey_mprotect */
	/* 395 */	NULL, /* unimplemented pkey_alloc */
	/* 396 */	NULL, /* unimplemented pkey_free */
	/* 397 */	NULL, /* statx */
	/* 398 */	NULL, /* unimplemented rseq */
	/* 399 */	NULL, /* unimplemented io_pgetevents */
	/* 400 */	NULL, /* unimplemented migrate_pages */
	/* 401 */	NULL, /* unimplemented kexec_file_load */
	/* 402 */	NULL, /* unimplemented / * unused * / */
	/* 403 */	NULL, /* unimplemented clock_gettime64 */
	/* 404 */	NULL, /* unimplemented clock_settime64 */
	/* 405 */	NULL, /* unimplemented clock_adjtime64 */
	/* 406 */	NULL, /* unimplemented clock_getres_time64 */
	/* 407 */	NULL, /* unimplemented clock_nanosleep_time64 */
	/* 408 */	NULL, /* unimplemented timer_gettime64 */
	/* 409 */	NULL, /* unimplemented timer_settime64 */
	/* 410 */	NULL, /* unimplemented timerfd_gettime64 */
	/* 411 */	NULL, /* unimplemented timerfd_settime64 */
	/* 412 */	NULL, /* unimplemented utimensat_time64 */
	/* 413 */	NULL, /* unimplemented pselect6_time64 */
	/* 414 */	NULL, /* unimplemented ppoll_time64 */
	/* 415 */	NULL, /* unimplemented / * unused? * / */
	/* 416 */	NULL, /* unimplemented io_pgetevents_time64 */
	/* 417 */	NULL, /* unimplemented recvmmsg_time64 */
	/* 418 */	NULL, /* unimplemented mq_timedsend_time64 */
	/* 419 */	NULL, /* unimplemented mq_timedreceive_time64 */
	/* 420 */	NULL, /* unimplemented semtimedop_time64 */
	/* 421 */	NULL, /* unimplemented rt_sigtimedwait_time64 */
	/* 422 */	NULL, /* unimplemented futex_time64 */
	/* 423 */	NULL, /* unimplemented sched_rr_get_interval_time64 */
	/* 424 */	NULL, /* unimplemented pidfd_send_signal */
	/* 425 */	NULL, /* unimplemented io_uring_setup */
	/* 426 */	NULL, /* unimplemented io_uring_enter */
	/* 427 */	NULL, /* unimplemented io_uring_register */
	/* 428 */	NULL, /* unimplemented open_tree */
	/* 429 */	NULL, /* unimplemented move_mount */
	/* 430 */	NULL, /* unimplemented fsopen */
	/* 431 */	NULL, /* unimplemented fsconfig */
	/* 432 */	NULL, /* unimplemented fsmount */
	/* 433 */	NULL, /* unimplemented fspick */
	/* 434 */	NULL, /* unimplemented pidfd_open */
	/* 435 */	NULL, /* unimplemented clone3 */
	/* 436 */	NULL, /* unimplemented close_range */
	/* 437 */	NULL, /* unimplemented openat2 */
	/* 438 */	NULL, /* unimplemented pidfd_getfd */
	/* 439 */	NULL, /* unimplemented faccessat2 */
	/* 440 */	NULL, /* unimplemented process_madvise */
	/* 441 */	NULL, /* unimplemented epoll_pwait2 */
	/* 442 */	NULL, /* unimplemented mount_setattr */
	/* 443 */	NULL, /* unimplemented quotactl_fd */
	/* 444 */	NULL, /* unimplemented landlock_create_ruleset */
	/* 445 */	NULL, /* unimplemented landlock_add_rule */
	/* 446 */	NULL, /* unimplemented landlock_restrict_self */
	/* 447 */	NULL, /* unimplemented */
	/* 448 */	NULL, /* unimplemented */
	/* 449 */	NULL, /* unimplemented */
	/* 450 */	NULL, /* unimplemented */
	/* 451 */	NULL, /* unimplemented */
	/* 452 */	NULL, /* unimplemented */
	/* 453 */	NULL, /* unimplemented */
	/* 454 */	NULL, /* unimplemented */
	/* 455 */	NULL, /* unimplemented */
	/* 456 */	NULL, /* unimplemented */
	/* 457 */	NULL, /* unimplemented */
	/* 458 */	NULL, /* unimplemented */
	/* 459 */	NULL, /* unimplemented */
	/* 460 */	NULL, /* unimplemented */
	/* 461 */	NULL, /* unimplemented */
	/* 462 */	NULL, /* unimplemented */
	/* 463 */	NULL, /* unimplemented */
	/* 464 */	NULL, /* unimplemented */
	/* 465 */	NULL, /* unimplemented */
	/* 466 */	NULL, /* unimplemented */
	/* 467 */	NULL, /* unimplemented */
	/* 468 */	NULL, /* unimplemented */
	/* 469 */	NULL, /* unimplemented */
	/* 470 */	NULL, /* unimplemented */
	/* 471 */	NULL, /* unimplemented */
	/* 472 */	NULL, /* unimplemented */
	/* 473 */	NULL, /* unimplemented */
	/* 474 */	NULL, /* unimplemented */
	/* 475 */	NULL, /* unimplemented */
	/* 476 */	NULL, /* unimplemented */
	/* 477 */	NULL, /* unimplemented */
	/* 478 */	NULL, /* unimplemented */
	/* 479 */	NULL, /* unimplemented */
	/* 480 */	NULL, /* unimplemented / * base. actually 0x0f0000 * / */
	/* 481 */	NULL, /* unimplemented breakpoint */
	/* 482 */	NULL, /* unimplemented cacheflush */
	/* 483 */	NULL, /* unimplemented usr26 */
	/* 484 */	NULL, /* unimplemented usr32 */
	/* 485 */	NULL, /* set_tls */
	/* 486 */	NULL, /* get_tls */
	/* 487 */	NULL, /* filler */
	/* 488 */	NULL, /* filler */
	/* 489 */	NULL, /* filler */
	/* 490 */	NULL, /* filler */
	/* 491 */	NULL, /* filler */
	/* 492 */	NULL, /* filler */
	/* 493 */	NULL, /* filler */
	/* 494 */	NULL, /* filler */
	/* 495 */	NULL, /* filler */
	/* 496 */	NULL, /* filler */
	/* 497 */	NULL, /* filler */
	/* 498 */	NULL, /* filler */
	/* 499 */	NULL, /* filler */
	/* 500 */	NULL, /* filler */
	/* 501 */	NULL, /* filler */
	/* 502 */	NULL, /* filler */
	/* 503 */	NULL, /* filler */
	/* 504 */	NULL, /* filler */
	/* 505 */	NULL, /* filler */
	/* 506 */	NULL, /* filler */
	/* 507 */	NULL, /* filler */
	/* 508 */	NULL, /* filler */
	/* 509 */	NULL, /* filler */
	/* 510 */	NULL, /* filler */
	/* 511 */	NULL, /* filler */
};
