/*	$NetBSD: pci_calls.h,v 1.1 2021/09/15 17:33:08 thorpej Exp $	*/

/*
 * THIS FILE IS AUTOMATICALLY GENERATED.  DO NOT EDIT.
 *
 * generated from:
 *	NetBSD: pci_calls,v 1.1 2021/09/15 17:26:07 thorpej Exp
 */

/*-
 * Copyright (c) 2021 The NetBSD Foundation, Inc.
 * All rights reserved.
 *
 * This code is derived from software contributed to The NetBSD Foundation
 * by Jason R. Thorpe.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

/*
 * Device calls used by the PCI subsystem.
 */

#ifndef _PCI_CALLS_H_
#define _PCI_CALLS_H_

#include <sys/device.h>

#include <dev/pci/pcivar.h>

/*
 * pci-bus-get-child-devhandle
 *
 * Retrieve the devhandle for the PCI device represented by 'tag'
 * in the PCI segment represented by 'pc'.  The PCI bus's device_t
 * is the one that's passed in the call, and the device whose handle
 * is being requested must be a direct child of that bus, otherwise
 * behavior is undefined.
 *
 * Call returns 0 if successful, or an error code upon failure:
 *
 * ENOTSUP	The device handle implementation for the
 *		PCI bus does not support this device call.
 *
 * ENODEV	The PCI device represented by the pcitag_t
 *		was not found in a bus-scoped search of the
 *		platform device tree.
 */
struct pci_bus_get_child_devhandle_args {
	pci_chipset_tag_t pc;		/* IN */
	pcitag_t tag;			/* IN */
	devhandle_t devhandle;		/* OUT */
};

union pci_bus_get_child_devhandle_binding {
	struct device_call_generic generic;
	struct {
		const char *name;
		struct pci_bus_get_child_devhandle_args *args;
	} binding;
};

#define PCI_BUS_GET_CHILD_DEVHANDLE_STR "pci-bus-get-child-devhandle"

#define PCI_BUS_GET_CHILD_DEVHANDLE(_args_) \
	&((const union pci_bus_get_child_devhandle_binding){ \
		.binding.name = "pci-bus-get-child-devhandle", \
		.binding.args = (_args_), \
	})

#endif /* _PCI_CALLS_H_ */
