/*	$NetBSD: t_syslog.c,v 1.3 2020/07/03 03:13:10 jruoho Exp $ */

/*-
 * Copyright (c) 2010, 2020 The NetBSD Foundation, Inc.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE
 * COPYRIGHT HOLDERS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
 * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#include <sys/types.h>

#include <atf-c.h>
#include <syslog.h>

ATF_TC(syslog_pthread);
ATF_TC_HEAD(syslog_pthread, tc)
{
	atf_tc_set_md_var(tc, "descr", "Test that syslog(3) "
	    "works when linked to pthread(3) (PR lib/44248)");
	atf_tc_set_md_var(tc, "timeout", "2");
}

ATF_TC_BODY(syslog_pthread, tc)
{
	syslog(LOG_DEBUG, "from tests/lib/libc/gen/t_syslog");
}

ATF_TC(syslog_invalid_priority);
ATF_TC_HEAD(syslog_invalid_priority, tc)
{
	atf_tc_set_md_var(tc, "descr", "Test that syslog(3) does "
	    "not segfault from an invalid priority (PR lib/55041)");
}

ATF_TC_BODY(syslog_invalid_priority, tc)
{
	syslog(-1, "from tests/lib/libc/gen/t_syslog");
}

ATF_TP_ADD_TCS(tp)
{

	ATF_TP_ADD_TC(tp, syslog_pthread);
	ATF_TP_ADD_TC(tp, syslog_invalid_priority);

	return atf_no_error();
}
