/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.database;

import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.BaseDatabaseMeta;
import org.pentaho.di.core.database.DatabaseInterface;
import org.pentaho.di.core.row.ValueMetaInterface;

public class MonetDBDatabaseMeta
extends BaseDatabaseMeta
implements DatabaseInterface {
    public MonetDBDatabaseMeta(String name, String access, String host, String db, String port, String user, String pass) {
        super(name, access, host, db, port, user, pass);
    }

    public MonetDBDatabaseMeta() {
    }

    public String getDatabaseTypeDesc() {
        return "MONETDB";
    }

    public String getDatabaseTypeDescLong() {
        return "MonetDB";
    }

    public int getDatabaseType() {
        return 32;
    }

    public int[] getAccessTypeList() {
        return new int[]{0, 1, 4};
    }

    public int getNotFoundTK(boolean use_autoinc) {
        if (this.supportsAutoInc() && use_autoinc) {
            return 1;
        }
        return super.getNotFoundTK(use_autoinc);
    }

    public String getDriverClass() {
        if (this.getAccessType() == 0) {
            return "nl.cwi.monetdb.jdbc.MonetDriver";
        }
        return "sun.jdbc.odbc.JdbcOdbcDriver";
    }

    public String getURL(String hostname, String port, String databaseName) {
        if (this.getAccessType() == 0) {
            if (!Const.isEmpty((String)port)) {
                return "jdbc:monetdb://" + hostname + "/" + databaseName;
            }
            return "jdbc:monetdb://" + hostname + ":" + port + "/" + databaseName;
        }
        return "jdbc:odbc:" + databaseName;
    }

    public boolean isFetchSizeSupported() {
        return false;
    }

    public boolean supportsBitmapIndex() {
        return true;
    }

    public boolean supportsAutoInc() {
        return true;
    }

    public boolean supportsBatchUpdates() {
        return true;
    }

    public boolean supportsBooleanDataType() {
        return true;
    }

    public boolean supportsSetMaxRows() {
        return true;
    }

    public boolean supportsRepository() {
        return false;
    }

    public String getTruncateTableStatement(String tableName) {
        return "DELETE FROM " + tableName;
    }

    public String getAddColumnStatement(String tablename, ValueMetaInterface v, String tk, boolean use_autoinc, String pk, boolean semicolon) {
        return "ALTER TABLE " + tablename + " ADD " + this.getFieldDefinition(v, tk, pk, use_autoinc, true, false);
    }

    public String getModifyColumnStatement(String tablename, ValueMetaInterface v, String tk, boolean use_autoinc, String pk, boolean semicolon) {
        return "ALTER TABLE " + tablename + " MODIFY " + this.getFieldDefinition(v, tk, pk, use_autoinc, true, false);
    }

    public String getFieldDefinition(ValueMetaInterface v, String tk, String pk, boolean use_autoinc, boolean add_fieldname, boolean add_cr) {
        String retval = "";
        String fieldname = v.getName();
        int length = v.getLength();
        int precision = v.getPrecision();
        if (add_fieldname) {
            retval = retval + fieldname + " ";
        }
        int type = v.getType();
        switch (type) {
            case 3: {
                retval = retval + "TIMESTAMP";
                break;
            }
            case 4: {
                if (this.supportsBooleanDataType()) {
                    retval = retval + "BOOLEAN";
                    break;
                }
                retval = retval + "CHAR(1)";
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                if (fieldname.equalsIgnoreCase(tk) || fieldname.equalsIgnoreCase(pk)) {
                    if (use_autoinc) {
                        retval = retval + "SERIAL";
                        break;
                    }
                    retval = retval + "BIGINT";
                    break;
                }
                if (precision == 0) {
                    if (length > 9) {
                        if (length < 19) {
                            retval = retval + "BIGINT";
                            break;
                        }
                        retval = retval + "DECIMAL(" + length + ")";
                        break;
                    }
                    retval = retval + "INT";
                    break;
                }
                if (length > 15) {
                    retval = retval + "DECIMAL(" + length;
                    if (precision > 0) {
                        retval = retval + ", " + precision;
                    }
                    retval = retval + ")";
                    break;
                }
                retval = retval + "DOUBLE";
                break;
            }
            case 2: {
                if (length >= 9999999) {
                    retval = retval + "CLOB";
                    break;
                }
                retval = retval + "VARCHAR";
                retval = length > 0 ? retval + "(" + length : retval + "(";
                retval = retval + ")";
                break;
            }
            default: {
                retval = retval + " UNKNOWN";
            }
        }
        if (add_cr) {
            retval = retval + Const.CR;
        }
        return retval;
    }

    public String[] getUsedLibraries() {
        return new String[]{"monetdb-1.7-jdbc.jar"};
    }
}

