/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.common.util;

import java.lang.reflect.Modifier;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openjdk.jmc.common.IMCOldObject;
import org.openjdk.jmc.common.IMCOldObjectArray;
import org.openjdk.jmc.common.IMCOldObjectField;
import org.openjdk.jmc.common.IMCType;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.QuantityConversionException;
import org.openjdk.jmc.common.unit.UnitLookup;

public class MCOldObject
implements IMCOldObject {
    private final IQuantity address;
    private final MCOldObjectArray array;
    private final MCOldObjectField field;
    private final String objectDescription;
    private final IMCOldObject referrer;
    private final IMCType type;

    public MCOldObject(IQuantity address, IMCType type, String objectDescription, IMCOldObject referrer, String field, IQuantity fieldModifier, IQuantity arraySize, IQuantity arrayIndex) {
        this.address = address;
        this.type = type;
        this.objectDescription = objectDescription;
        this.referrer = referrer;
        this.field = fieldModifier != null ? new MCOldObjectField(field, (int)fieldModifier.longValue()) : null;
        this.array = arraySize != null && arraySize.longValue() >= 0L ? new MCOldObjectArray(arrayIndex, arraySize) : null;
    }

    @Override
    public IQuantity getAddress() {
        return this.address;
    }

    @Override
    public IMCOldObjectArray getReferrerArray() {
        return this.array;
    }

    @Override
    public IMCOldObjectField getReferrerField() {
        return this.field;
    }

    @Override
    public String getDescription() {
        return this.objectDescription;
    }

    @Override
    public IMCOldObject getReferrer() {
        return this.referrer;
    }

    @Override
    public IMCType getType() {
        return this.type;
    }

    public boolean equals(Object obj) {
        if (obj instanceof IMCOldObject) {
            return Objects.equals(((IMCOldObject)obj).getAddress(), this.address);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.address);
    }

    public String toString() {
        Integer modifier;
        String s = this.getType().getFullName();
        if (this.getReferrerArray() != null) {
            s = s.substring(0, s.length() - 1) + this.getReferrerArray().getIndex() + "]";
        }
        if (this.getReferrerField() != null && (modifier = this.getReferrerField().getModifier()) != null) {
            s = modifier == 0 ? s + "." + this.getReferrerField().getName() : Modifier.toString(modifier) + " " + s + "." + this.getReferrerField().getName();
        }
        s = s + " @ " + this.getAddress().displayUsing("auto");
        return s;
    }

    @Override
    public int getReferrerSkip() {
        return 0;
    }

    private static class MCOldObjectField
    implements IMCOldObjectField {
        String fieldName;
        Integer fieldModifier;

        public MCOldObjectField(String fieldName, Integer fieldModifier) {
            this.fieldName = fieldName;
            this.fieldModifier = fieldModifier;
        }

        @Override
        public String getName() {
            return this.fieldName;
        }

        @Override
        public Integer getModifier() {
            return this.fieldModifier;
        }
    }

    private static class MCOldObjectArray
    implements IMCOldObjectArray {
        Long arrayIndex;
        Long arraySize;

        public MCOldObjectArray(IQuantity arrayIndex, IQuantity arraySize) {
            try {
                this.arrayIndex = arrayIndex.longValueIn(UnitLookup.NUMBER_UNITY);
                this.arraySize = arraySize.longValueIn(UnitLookup.NUMBER_UNITY);
            }
            catch (QuantityConversionException e) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "Could not convert number to number for array info", e);
                this.arrayIndex = null;
                this.arraySize = null;
            }
        }

        @Override
        public Long getSize() {
            return this.arraySize;
        }

        @Override
        public Long getIndex() {
            return this.arrayIndex;
        }
    }
}

