/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.operations;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.infinispan.client.hotrod.DataFormat;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.impl.ClientStatistics;
import org.infinispan.client.hotrod.impl.ClientTopology;
import org.infinispan.client.hotrod.impl.VersionedOperationResponse;
import org.infinispan.client.hotrod.impl.operations.AbstractKeyValueOperation;
import org.infinispan.client.hotrod.impl.protocol.Codec;
import org.infinispan.client.hotrod.impl.protocol.HotRodConstants;
import org.infinispan.client.hotrod.impl.transport.netty.ByteBufUtil;
import org.infinispan.client.hotrod.impl.transport.netty.ChannelFactory;
import org.infinispan.client.hotrod.impl.transport.netty.HeaderDecoder;
import org.infinispan.client.hotrod.telemetry.impl.TelemetryService;

public class ReplaceIfUnmodifiedOperation
extends AbstractKeyValueOperation<VersionedOperationResponse> {
    private final long version;

    public ReplaceIfUnmodifiedOperation(Codec codec, ChannelFactory channelFactory, Object key, byte[] keyBytes, byte[] cacheName, AtomicReference<ClientTopology> clientTopology, int flags, Configuration cfg, byte[] value, long lifespan, TimeUnit lifespanTimeUnit, long maxIdle, TimeUnit maxIdleTimeUnit, long version, DataFormat dataFormat, ClientStatistics clientStatistics, TelemetryService telemetryService) {
        super((short)9, (short)10, codec, channelFactory, key, keyBytes, cacheName, clientTopology, flags, cfg, value, lifespan, lifespanTimeUnit, maxIdle, maxIdleTimeUnit, dataFormat, clientStatistics, telemetryService);
        this.version = version;
    }

    @Override
    protected void executeOperation(Channel channel) {
        this.scheduleRead(channel);
        ByteBuf buf = channel.alloc().buffer(this.codec.estimateHeaderSize(this.header) + ByteBufUtil.estimateArraySize(this.keyBytes) + this.codec.estimateExpirationSize(this.lifespan, this.lifespanTimeUnit, this.maxIdle, this.maxIdleTimeUnit) + 8 + ByteBufUtil.estimateArraySize(this.value));
        this.codec.writeHeader(buf, this.header);
        ByteBufUtil.writeArray(buf, this.keyBytes);
        this.codec.writeExpirationParams(buf, this.lifespan, this.lifespanTimeUnit, this.maxIdle, this.maxIdleTimeUnit);
        buf.writeLong(this.version);
        ByteBufUtil.writeArray(buf, this.value);
        channel.writeAndFlush((Object)buf);
    }

    @Override
    public void acceptResponse(ByteBuf buf, short status, HeaderDecoder decoder) {
        if (HotRodConstants.isSuccess(status)) {
            this.statsDataStore();
        }
        this.complete(this.returnVersionedOperationResponse(buf, status));
    }
}

