/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetIdpGroupMappingRequest
extends BmcRequest<Void> {
    private String identityProviderId;
    private String mappingId;

    public String getIdentityProviderId() {
        return this.identityProviderId;
    }

    public String getMappingId() {
        return this.mappingId;
    }

    public Builder toBuilder() {
        return new Builder().identityProviderId(this.identityProviderId).mappingId(this.mappingId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",identityProviderId=").append(String.valueOf(this.identityProviderId));
        sb.append(",mappingId=").append(String.valueOf(this.mappingId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetIdpGroupMappingRequest)) {
            return false;
        }
        GetIdpGroupMappingRequest other = (GetIdpGroupMappingRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.identityProviderId, other.identityProviderId) && Objects.equals(this.mappingId, other.mappingId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.identityProviderId == null ? 43 : this.identityProviderId.hashCode());
        result = result * 59 + (this.mappingId == null ? 43 : this.mappingId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetIdpGroupMappingRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String identityProviderId = null;
        private String mappingId = null;

        public Builder identityProviderId(String identityProviderId) {
            this.identityProviderId = identityProviderId;
            return this;
        }

        public Builder mappingId(String mappingId) {
            this.mappingId = mappingId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetIdpGroupMappingRequest o) {
            this.identityProviderId(o.getIdentityProviderId());
            this.mappingId(o.getMappingId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetIdpGroupMappingRequest build() {
            GetIdpGroupMappingRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetIdpGroupMappingRequest buildWithoutInvocationCallback() {
            GetIdpGroupMappingRequest request = new GetIdpGroupMappingRequest();
            request.identityProviderId = this.identityProviderId;
            request.mappingId = this.mappingId;
            return request;
        }
    }
}

