/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.karma.util;

import java.io.File;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.modules.javascript.karma.util.Bundle;
import org.netbeans.modules.javascript.karma.util.StringUtils;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.LineCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.Line;
import org.openide.util.Mutex;
import org.openide.util.Parameters;
import org.openide.util.Utilities;

public final class FileUtils {
    static final Logger LOGGER = Logger.getLogger(FileUtils.class.getName());
    private static final boolean IS_WINDOWS = Utilities.isWindows();

    private FileUtils() {
    }

    public static List<File> sortFiles(Collection<File> files) {
        final Collator collator = Collator.getInstance();
        ArrayList<File> sortedFiles = new ArrayList<File>(files);
        sortedFiles.sort(new Comparator<File>(){

            @Override
            public int compare(File file1, File file2) {
                return collator.compare(file1.getName(), file2.getName());
            }
        });
        return sortedFiles;
    }

    public static List<String> findFileOnUsersPath(String filename) {
        Parameters.notNull((CharSequence)"filename", (Object)filename);
        return FileUtils.findFileOnUsersPath(new String[]{filename});
    }

    public static List<String> findFileOnUsersPath(String ... filenames) {
        Parameters.notNull((CharSequence)"filenames", (Object)filenames);
        String path = System.getenv("PATH");
        LOGGER.log(Level.FINE, "PATH: [{0}]", path);
        if (path == null) {
            return Collections.emptyList();
        }
        LinkedHashSet<String> dirs = new LinkedHashSet<String>(Arrays.asList(path.split(File.pathSeparator)));
        LOGGER.log(Level.FINE, "PATH dirs: {0}", dirs);
        ArrayList<String> found = new ArrayList<String>(dirs.size() * filenames.length);
        for (String filename : filenames) {
            Parameters.notNull((CharSequence)"filename", (Object)filename);
            for (String dir : dirs) {
                File file = new File(dir, filename);
                if (!file.isFile()) continue;
                String absolutePath = FileUtil.normalizeFile((File)file).getAbsolutePath();
                LOGGER.log(Level.FINE, "File ''{0}'' found", absolutePath);
                if (found.contains(absolutePath)) continue;
                LOGGER.log(Level.FINE, "File ''{0}'' added to found files", absolutePath);
                found.add(absolutePath);
            }
        }
        LOGGER.log(Level.FINE, "Found files: {0}", found);
        return found;
    }

    @CheckForNull
    public static String validateFile(String filePath, boolean writable) {
        return FileUtils.validateFile(Bundle.FileUtils_validateFile_file(), filePath, writable);
    }

    @CheckForNull
    public static String validateFile(String source, String filePath, boolean writable) {
        if (!StringUtils.hasText(filePath)) {
            return Bundle.FileUtils_validateFile_missing(source);
        }
        File file = new File(filePath);
        if (!file.isAbsolute()) {
            return Bundle.FileUtils_validateFile_notAbsolute(source);
        }
        if (!file.isFile()) {
            return Bundle.FileUtils_validateFile_notFile(source);
        }
        if (!file.canRead()) {
            return Bundle.FileUtils_validateFile_notReadable(source);
        }
        if (writable && !file.canWrite()) {
            return Bundle.FileUtils_validateFile_notWritable(source);
        }
        return null;
    }

    public static String getScriptExtension(boolean withDot, boolean cmdInsteadBatOnWin) {
        StringBuilder sb = new StringBuilder(4);
        if (withDot) {
            sb.append(".");
        }
        if (IS_WINDOWS) {
            sb.append(cmdInsteadBatOnWin ? "cmd" : "bat");
        } else {
            sb.append("sh");
        }
        return sb.toString();
    }

    public static void openFile(File file, int line) {
        DataObject dataObject;
        assert (file != null);
        FileObject fileObject = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file));
        if (fileObject == null) {
            LOGGER.log(Level.INFO, "FileObject not found for {0}", file);
            return;
        }
        try {
            dataObject = DataObject.find((FileObject)fileObject);
        }
        catch (DataObjectNotFoundException ex) {
            LOGGER.log(Level.INFO, "DataObject not found for {0}", file);
            return;
        }
        if (line == -1) {
            EditorCookie ec = (EditorCookie)dataObject.getLookup().lookup(EditorCookie.class);
            ec.open();
            return;
        }
        LineCookie lineCookie = (LineCookie)dataObject.getLookup().lookup(LineCookie.class);
        if (lineCookie == null) {
            LOGGER.log(Level.INFO, "LineCookie not found for {0}", file);
            return;
        }
        Line.Set lineSet = lineCookie.getLineSet();
        try {
            final Line currentLine = lineSet.getCurrent(line - 1);
            Mutex.EVENT.readAccess(new Runnable(){

                @Override
                public void run() {
                    currentLine.show(Line.ShowOpenType.OPEN, Line.ShowVisibilityType.FOCUS);
                }
            });
        }
        catch (IndexOutOfBoundsException exc) {
            LOGGER.log(Level.FINE, null, exc);
        }
    }
}

