/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.i18n.form;

import java.util.Map;
import org.netbeans.modules.form.FormDataObject;
import org.netbeans.modules.form.FormDesignValue;
import org.netbeans.modules.form.FormEditor;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.FormProperty;
import org.netbeans.modules.form.I18nValue;
import org.netbeans.modules.i18n.I18nSupport;
import org.netbeans.modules.i18n.I18nUtil;
import org.netbeans.modules.i18n.ResourceHolder;
import org.netbeans.modules.i18n.form.FormI18nSupport;
import org.netbeans.modules.i18n.form.I18nServiceImpl;
import org.netbeans.modules.i18n.java.JavaI18nString;
import org.netbeans.modules.i18n.java.JavaI18nSupport;
import org.netbeans.modules.i18n.java.JavaResourceHolder;
import org.openide.loaders.DataObject;

public class FormI18nString
extends JavaI18nString
implements I18nValue {
    String bundleName;
    Object allData;

    public FormI18nString(I18nSupport i18nSupport) {
        super(i18nSupport);
    }

    public FormI18nString(JavaI18nString source) {
        this(FormI18nString.createNewSupport(source.getSupport()), source.getKey(), source.getValue(), source.getComment(), source.getArguments(), source.getReplaceFormat(), source instanceof FormI18nString ? ((FormI18nString)source).bundleName : null);
        ((JavaResourceHolder)this.support.getResourceHolder()).setLocalization(((JavaResourceHolder)source.getSupport().getResourceHolder()).getLocalization());
    }

    FormI18nString(DataObject srcDataObject) {
        super(new FormI18nSupport.Factory().createI18nSupport(srcDataObject));
        boolean nbBundle = I18nServiceImpl.isNbBundleAvailable(srcDataObject.getPrimaryFile());
        if (I18nUtil.getDefaultReplaceFormat((!nbBundle ? 1 : 0) != 0).equals(this.getReplaceFormat())) {
            this.setReplaceFormat(I18nUtil.getDefaultReplaceFormat((boolean)nbBundle));
        }
    }

    private FormI18nString(I18nSupport i18nSupport, String key, String value, String comment, String[] arguments, String replaceFormat, String bundleName) {
        super(i18nSupport);
        this.key = key;
        this.value = value;
        this.comment = comment;
        this.arguments = arguments;
        this.replaceFormat = replaceFormat;
        this.bundleName = bundleName;
    }

    public Object copy(FormProperty formProperty) {
        FormI18nString newI18nString;
        FormModel form = formProperty.getPropertyContext().getFormModel();
        if (form == null) {
            return this.getValue();
        }
        FormDataObject sourceDO = FormEditor.getFormDataObject((FormModel)form);
        if (sourceDO == null) {
            return this.getValue();
        }
        if (form.getSettings().isI18nAutoMode()) {
            newI18nString = new FormI18nString(FormI18nString.createNewSupport((DataObject)sourceDO, null, ((FormI18nSupport)this.support).getIdentifier()), "#auto", (String)this.getValue(), this.getComment(), this.getArguments(), this.getReplaceFormat(), this.bundleName);
            JavaResourceHolder jrh = (JavaResourceHolder)this.support.getResourceHolder();
            newI18nString.allData = jrh.getAllData(this.getKey());
        } else {
            I18nSupport newSupport = FormI18nString.createNewSupport((DataObject)sourceDO, this.support.getResourceHolder().getResource(), ((FormI18nSupport)this.support).getIdentifier());
            newI18nString = new FormI18nString(newSupport, this.getKey(), (String)this.getValue(), this.getComment(), this.getArguments(), this.getReplaceFormat(), this.bundleName);
            if (sourceDO != this.support.getSourceDataObject()) {
                ResourceHolder rh = newSupport.getResourceHolder();
                newI18nString.value = rh.getValueForKey(this.getKey());
                newI18nString.comment = rh.getCommentForKey(this.getKey());
            }
        }
        return newI18nString;
    }

    public String toString() {
        return this.getValue();
    }

    private static I18nSupport createNewSupport(I18nSupport support) {
        return FormI18nString.createNewSupport(support.getSourceDataObject(), support.getResourceHolder().getResource(), support instanceof JavaI18nSupport ? ((JavaI18nSupport)support).getIdentifier() : null);
    }

    private static I18nSupport createNewSupport(DataObject sourceDataObject, DataObject resource, String identifier) {
        FormI18nSupport newSupport = (FormI18nSupport)new FormI18nSupport.Factory().createI18nSupport(sourceDataObject);
        newSupport.setIdentifier(identifier);
        if (resource != null) {
            newSupport.getResourceHolder().setResource(resource);
        }
        return newSupport;
    }

    public Object getDesignValue() {
        Object designValue = this.getValue();
        if (designValue == null) {
            return FormDesignValue.IGNORED_VALUE;
        }
        return designValue;
    }

    public Object getDesignValue(Object target) {
        return null;
    }

    public String getDescription() {
        return "<" + this.getKey() + ">";
    }

    protected void fillFormatMap(Map<String, String> map) {
        super.fillFormatMap(map);
        if (this.getSupport().getResourceHolder().getResource() == null && this.bundleName != null) {
            String base = this.bundleName;
            if (base.endsWith(".properties")) {
                base = base.substring(0, base.length() - 11);
            }
            map.put("bundleNameSlashes", base);
            map.put("bundleNameDots", base.replace('/', '.'));
        }
    }
}

