/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.java.classpath;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.Project;
import org.netbeans.modules.gradle.api.NbGradleProject;
import org.netbeans.spi.java.classpath.FlaggedClassPathImplementation;
import org.netbeans.spi.java.classpath.PathResourceImplementation;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.filesystems.FileUtil;
import org.openide.util.WeakListeners;

abstract class AbstractGradleClassPathImpl
implements FlaggedClassPathImplementation {
    private final PropertyChangeSupport support = new PropertyChangeSupport(this);
    private final PropertyChangeListener listener;
    private List<URL> rawResources;
    private List<PathResourceImplementation> resources;
    protected final Project project;
    private final NbGradleProject watcher;

    protected AbstractGradleClassPathImpl(Project proj) {
        this.project = proj;
        this.watcher = (NbGradleProject)proj.getLookup().lookup(NbGradleProject.class);
        this.listener = evt -> {
            boolean hasChanged;
            if (this.watcher.isUnloadable()) {
                return;
            }
            List<URL> newValue = this.createPath();
            AbstractGradleClassPathImpl abstractGradleClassPathImpl = this;
            synchronized (abstractGradleClassPathImpl) {
                hasChanged = this.hasChanged(this.rawResources, newValue);
                if (hasChanged) {
                    this.rawResources = newValue;
                    this.resources = null;
                }
            }
            if (hasChanged) {
                this.support.firePropertyChange("resources", null, null);
            }
            this.support.firePropertyChange("flags", null, null);
        };
        this.watcher.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.listener, (Object)this.watcher));
    }

    public Set<ClassPath.Flag> getFlags() {
        if (this.watcher.isUnloadable()) {
            return Collections.singleton(ClassPath.Flag.INCOMPLETE);
        }
        return Collections.emptySet();
    }

    protected abstract List<URL> createPath();

    private boolean hasChanged(List<URL> oldValue, List<URL> newValue) {
        boolean ret;
        boolean bl = ret = oldValue == null || oldValue.size() != newValue.size();
        if (!ret) {
            assert (oldValue != null);
            Iterator<URL> ol = oldValue.iterator();
            Iterator<URL> nl = newValue.iterator();
            while (!ret && ol.hasNext()) {
                ret = !ol.next().equals(nl.next());
            }
        }
        return ret;
    }

    public final synchronized List<? extends PathResourceImplementation> getResources() {
        if (this.resources == null) {
            this.resources = this.createPath().stream().map(ClassPathSupport::createResource).toList();
        }
        return this.resources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        PropertyChangeSupport propertyChangeSupport = this.support;
        synchronized (propertyChangeSupport) {
            this.support.addPropertyChangeListener(propertyChangeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        PropertyChangeSupport propertyChangeSupport = this.support;
        synchronized (propertyChangeSupport) {
            this.support.removePropertyChangeListener(propertyChangeListener);
        }
    }

    final synchronized void clearResourceCache() {
        this.resources = null;
        this.support.firePropertyChange("resources", null, null);
    }

    static void addAllFile(Collection<URL> ret, @NonNull Collection<File> files) {
        assert (files != null);
        for (File f : files) {
            URL u = FileUtil.urlForArchiveOrDir((File)f);
            if (u == null) continue;
            ret.add(u);
        }
    }
}

