/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.project.ant;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.ant.AntBuildExtenderAccessorImpl;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.modules.project.ant.AntBuildExtenderAccessor;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.netbeans.spi.project.ant.AntBuildExtenderImplementation;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.Parameters;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public final class AntBuildExtender {
    private HashMap<String, Extension> extensions;
    private AntBuildExtenderImplementation implementation;
    private ReferenceHelper refHelper;
    public static final String ANT_CUSTOMTASKS_LIBS_PROPNAME = "ant.customtasks.libs";
    private static final DocumentBuilder db;

    AntBuildExtender(AntBuildExtenderImplementation implementation) {
        this.implementation = implementation;
    }

    AntBuildExtender(AntBuildExtenderImplementation implementation, ReferenceHelper refHlpr) {
        this.implementation = implementation;
        this.refHelper = refHlpr;
    }

    public List<String> getExtensibleTargets() {
        ArrayList<String> targets = new ArrayList<String>();
        targets.addAll(this.implementation.getExtensibleTargets());
        targets = Collections.unmodifiableList(targets);
        return targets;
    }

    private String assertMessage(FileObject extensionXml) {
        try {
            return "Extension file:" + extensionXml.asText() + " is owned by " + FileOwnerQuery.getOwner((FileObject)extensionXml) + " but should be " + this.implementation.getOwningProject();
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return ex.getMessage();
        }
    }

    public synchronized Extension addExtension(String id, FileObject extensionXml) {
        assert (extensionXml != null);
        assert (extensionXml.isValid() && extensionXml.isData());
        assert (FileOwnerQuery.getOwner((FileObject)extensionXml) == this.implementation.getOwningProject()) : this.assertMessage(extensionXml);
        FileObject nbproj = this.implementation.getOwningProject().getProjectDirectory().getFileObject("nbproject/project.xml").getParent();
        assert (FileUtil.isParentOf((FileObject)nbproj, (FileObject)extensionXml));
        if (this.extensions == null) {
            this.readProjectMetadata();
        }
        if (this.extensions.get(id) != null) {
            throw new IllegalStateException("Extension with id '" + id + "' already exists.");
        }
        Extension ex = new Extension(id, extensionXml, FileUtil.getRelativePath((FileObject)nbproj, (FileObject)extensionXml));
        this.extensions.put(id, ex);
        this.updateProjectMetadata();
        return ex;
    }

    public synchronized void removeExtension(String id) {
        if (this.extensions == null) {
            this.readProjectMetadata();
        }
        if (this.extensions.get(id) == null) {
            return;
        }
        this.extensions.remove(id);
        this.updateProjectMetadata();
    }

    public synchronized Extension getExtension(String id) {
        if (this.extensions == null) {
            this.readProjectMetadata();
        }
        return this.extensions.get(id);
    }

    synchronized Set<Extension> getExtensions() {
        HashSet<Extension> ext = new HashSet<Extension>();
        if (this.extensions == null) {
            this.readProjectMetadata();
        }
        ext.addAll(this.extensions.values());
        return ext;
    }

    public void addLibrary(Library library) throws IOException {
        Parameters.notNull((CharSequence)"library", (Object)library);
        this.setValueOfProperty(ANT_CUSTOMTASKS_LIBS_PROPNAME, library.getName(), true);
        if (this.refHelper != null && this.refHelper.getProjectLibraryManager() != null && this.refHelper.getProjectLibraryManager().getLibrary(library.getName()) == null) {
            try {
                this.refHelper.copyLibrary(library);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    public void removeLibrary(Library library) throws IOException {
        Parameters.notNull((CharSequence)"library", (Object)library);
        this.setValueOfProperty(ANT_CUSTOMTASKS_LIBS_PROPNAME, library.getName(), false);
    }

    private void setValueOfProperty(final String propName, final String value, final boolean add) throws IOException {
        try {
            final FileObject projPropsFO = this.implementation.getOwningProject().getProjectDirectory().getFileObject("nbproject/project.properties");
            final InputStream is = projPropsFO.getInputStream();
            ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Void run() throws Exception {
                    EditableProperties editableProps = new EditableProperties(true);
                    try {
                        editableProps.load(is);
                    }
                    finally {
                        if (is != null) {
                            is.close();
                        }
                    }
                    String[] libIDs = new String[]{};
                    String savedPropVal = editableProps.getProperty(propName);
                    if (savedPropVal != null) {
                        libIDs = savedPropVal.split(",");
                    }
                    TreeSet<String> libIDSet = new TreeSet<String>(Arrays.asList(libIDs));
                    if (add) {
                        libIDSet.add(value);
                    } else {
                        libIDSet.remove(value);
                    }
                    String[] newLibIDs = libIDSet.toArray(new String[0]);
                    StringBuilder propValue = new StringBuilder();
                    for (String newLibID : newLibIDs) {
                        propValue.append(newLibID);
                        propValue.append(",");
                    }
                    propValue.delete(propValue.length() - 1, propValue.length());
                    editableProps.setProperty(propName, propValue.toString());
                    try (OutputStream os = projPropsFO.getOutputStream();){
                        editableProps.store(os);
                    }
                    return null;
                }
            });
        }
        catch (MutexException mux) {
            throw (IOException)mux.getException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Document createNewDocument() {
        DocumentBuilder documentBuilder = db;
        synchronized (documentBuilder) {
            return db.newDocument();
        }
    }

    private void updateProjectMetadata() {
        Document doc = AntBuildExtender.createNewDocument();
        Element root = doc.createElementNS(AntBuildExtenderAccessor.AUX_NAMESPACE, AntBuildExtenderAccessor.ELEMENT_ROOT);
        if (this.extensions != null) {
            FileObject nbproj = this.implementation.getOwningProject().getProjectDirectory().getFileObject("nbproject/project.xml").getParent();
            for (Extension ext : this.extensions.values()) {
                Element child = doc.createElementNS(AntBuildExtenderAccessor.AUX_NAMESPACE, AntBuildExtenderAccessor.ELEMENT_EXTENSION);
                child.setAttribute(AntBuildExtenderAccessor.ATTR_ID, ext.id);
                String relPath = FileUtil.getRelativePath((FileObject)nbproj, (FileObject)ext.file);
                assert (relPath != null);
                child.setAttribute(AntBuildExtenderAccessor.ATTR_FILE, relPath);
                root.appendChild(child);
                for (String target : ext.dependencies.keySet()) {
                    for (String depTarget : ext.dependencies.get(target)) {
                        Element dep = doc.createElementNS(AntBuildExtenderAccessor.AUX_NAMESPACE, AntBuildExtenderAccessor.ELEMENT_DEPENDENCY);
                        dep.setAttribute(AntBuildExtenderAccessor.ATTR_TARGET, target);
                        dep.setAttribute(AntBuildExtenderAccessor.ATTR_DEPENDSON, depTarget);
                        child.appendChild(dep);
                    }
                }
            }
        }
        AuxiliaryConfiguration config = ProjectUtils.getAuxiliaryConfiguration((Project)this.implementation.getOwningProject());
        config.putConfigurationFragment(root, true);
    }

    private void readProjectMetadata() {
        AuxiliaryConfiguration config = ProjectUtils.getAuxiliaryConfiguration((Project)this.implementation.getOwningProject());
        Element cfgEl = config.getConfigurationFragment(AntBuildExtenderAccessor.ELEMENT_ROOT, AntBuildExtenderAccessor.AUX_NAMESPACE, true);
        this.extensions = new HashMap();
        FileObject projectXMLFO = this.implementation.getOwningProject().getProjectDirectory().getFileObject("nbproject/project.xml");
        if (projectXMLFO == null) {
            return;
        }
        FileObject nbproj = projectXMLFO.getParent();
        if (cfgEl != null) {
            String namespace = cfgEl.getNamespaceURI();
            NodeList roots = cfgEl.getElementsByTagNameNS(namespace, AntBuildExtenderAccessor.ELEMENT_EXTENSION);
            for (int i = 0; i < roots.getLength(); ++i) {
                Element root = (Element)roots.item(i);
                String id = root.getAttribute(AntBuildExtenderAccessor.ATTR_ID);
                assert (id.length() > 0) : "Illegal project.xml";
                String value = root.getAttribute(AntBuildExtenderAccessor.ATTR_FILE);
                FileObject script = nbproj.getFileObject(value);
                if (script == null) {
                    Logger.getLogger(AntBuildExtender.class.getName()).log(Level.SEVERE, "Missing file {0} for build script extension {1}. The extension is skipped.", new Object[]{value, id});
                    continue;
                }
                Extension ext = new Extension(id, script, value);
                this.extensions.put(id, ext);
                NodeList deps = root.getElementsByTagNameNS(namespace, AntBuildExtenderAccessor.ELEMENT_DEPENDENCY);
                for (int j = 0; j < deps.getLength(); ++j) {
                    Element dep = (Element)deps.item(j);
                    String target = dep.getAttribute(AntBuildExtenderAccessor.ATTR_TARGET);
                    String dependsOn = dep.getAttribute(AntBuildExtenderAccessor.ATTR_DEPENDSON);
                    assert (target != null);
                    assert (dependsOn != null);
                    ext.loadDependency(target, dependsOn);
                }
            }
        }
    }

    static {
        AntBuildExtenderAccessorImpl.createAccesor();
        try {
            db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new AssertionError((Object)e);
        }
    }

    public final class Extension {
        String id;
        FileObject file;
        String path;
        TreeMap<String, Collection<String>> dependencies;

        Extension(String id, FileObject script, String relPath) {
            this.id = id;
            this.file = script;
            this.path = relPath;
            this.dependencies = new TreeMap();
        }

        String getPath() {
            return this.path;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addDependency(String mainBuildTarget, String extensionTarget) {
            assert (AntBuildExtender.this.implementation.getExtensibleTargets().contains(mainBuildTarget)) : "The target '" + mainBuildTarget + "' is not designated by the project type as extensible.";
            Extension extension = this;
            synchronized (extension) {
                if (this.loadDependency(mainBuildTarget, extensionTarget)) {
                    AntBuildExtender.this.updateProjectMetadata();
                }
            }
        }

        private synchronized boolean loadDependency(String mainBuildTarget, String extensionTarget) {
            Collection<String> tars = this.dependencies.get(mainBuildTarget);
            boolean changed = false;
            if (tars == null) {
                tars = new ArrayList<String>();
                this.dependencies.put(mainBuildTarget, tars);
                changed = true;
            }
            if (!tars.contains(extensionTarget)) {
                tars.add(extensionTarget);
                changed = true;
            }
            return changed;
        }

        public void removeDependency(String mainBuildTarget, String extensionTarget) {
            Collection<String> str = this.dependencies.get(mainBuildTarget);
            if (str != null && str.remove(extensionTarget)) {
                AntBuildExtender.this.updateProjectMetadata();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Map<String, Collection<String>> getDependencies() {
            TreeMap<String, Collection<String>> toRet = new TreeMap<String, Collection<String>>();
            Extension extension = this;
            synchronized (extension) {
                for (String str : this.dependencies.keySet()) {
                    ArrayList<String> col = new ArrayList<String>();
                    col.addAll(this.dependencies.get(str));
                    toRet.put(str, col);
                }
            }
            return toRet;
        }
    }
}

