/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.dbgp;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.netbeans.api.annotations.common.SuppressWarnings;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.modules.php.dbgp.SessionId;
import org.netbeans.modules.php.dbgp.SessionManager;
import org.openide.util.Cancellable;
import org.openide.util.NbBundle;

public final class SessionProgress
implements Cancellable {
    private static final ConcurrentMap<Session, SessionProgress> INSTANCE = new ConcurrentHashMap<Session, SessionProgress>();
    private final ProgressHandle h;
    private volatile Session session;
    private volatile boolean isFinished;
    private volatile boolean isStarted;

    public static SessionProgress forSession(Session session) {
        SessionProgress newval = new SessionProgress(session);
        SessionProgress retval = INSTANCE.putIfAbsent(session, newval);
        return retval == null ? newval : retval;
    }

    public static SessionProgress forSessionId(SessionId sessionId) {
        Session[] sessions = DebuggerManager.getDebuggerManager().getSessions();
        Session retval = null;
        for (Session session : sessions) {
            SessionId id = (SessionId)session.lookupFirst(null, SessionId.class);
            if (id == null || !id.getId().equals(sessionId.getId())) continue;
            retval = session;
            break;
        }
        return retval != null ? SessionProgress.forSession(retval) : null;
    }

    private SessionProgress(Session session) {
        this.session = session;
        String displayName = NbBundle.getMessage(SessionProgress.class, (String)"LBL_Progress_Connecting", (Object)session.getName());
        this.h = ProgressHandle.createHandle((String)displayName, (Cancellable)this);
    }

    public boolean cancel() {
        this.finish();
        SessionManager.getInstance().stopSession(this.session);
        return true;
    }

    void start() {
        this.h.start();
        this.isStarted = true;
    }

    public void notifyConnectionFinished() {
        String displayName = NbBundle.getMessage(SessionProgress.class, (String)"LBL_Progress_Suspend");
        this.h.setDisplayName(this.session.getName());
        this.h.suspend(displayName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressWarnings(value={"NN_NAKED_NOTIFY"})
    void finish() {
        if (this.isStarted && !this.isFinished) {
            this.isFinished = true;
            this.h.finish();
            SessionId id = (SessionId)this.session.lookupFirst(null, SessionId.class);
            if (id != null) {
                SessionId sessionId = id;
                synchronized (sessionId) {
                    id.cancel();
                    id.notifyAll();
                }
            }
        }
        INSTANCE.remove(this.session);
    }
}

