/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.editor.EditorRegistry;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.gsf.testrunner.ui.api.TestMethodController;
import org.netbeans.modules.php.api.editor.EditorSupport;
import org.netbeans.modules.php.api.editor.PhpClass;
import org.netbeans.modules.php.api.editor.PhpType;
import org.netbeans.modules.php.api.phpmodule.PhpModule;
import org.netbeans.modules.php.project.PhpProject;
import org.netbeans.modules.php.project.ui.actions.support.CommandUtils;
import org.netbeans.modules.php.project.util.PhpProjectUtils;
import org.netbeans.modules.php.spi.testing.PhpTestingProvider;
import org.netbeans.spi.project.SingleMethod;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;

public class ComputeTestMethodAnnotations
implements DocumentListener,
PropertyChangeListener,
Runnable {
    private static final Logger LOGGER = Logger.getLogger(ComputeTestMethodAnnotations.class.getName());
    private static final RequestProcessor RP = new RequestProcessor(ComputeTestMethodAnnotations.class);
    private static final ComputeTestMethodAnnotations INSTANCE = new ComputeTestMethodAnnotations();
    private static final AtomicInteger USAGES_COUNT = new AtomicInteger(0);
    private final RequestProcessor.Task task = RP.create((Runnable)this);
    private volatile Document handledDocument;

    public static ComputeTestMethodAnnotations getInstance() {
        return INSTANCE;
    }

    private ComputeTestMethodAnnotations() {
    }

    public void register() {
        if (USAGES_COUNT.getAndIncrement() == 0) {
            EditorRegistry.addPropertyChangeListener((PropertyChangeListener)this);
        }
    }

    public void unregister() {
        if (USAGES_COUNT.decrementAndGet() == 0) {
            EditorRegistry.removePropertyChangeListener((PropertyChangeListener)this);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        assert (SwingUtilities.isEventDispatchThread()) : "UI thread expected but is: " + Thread.currentThread().getName();
        Document document = this.getLastFocusedDocument();
        if (document == null) {
            return;
        }
        long startTime = 0L;
        if (LOGGER.isLoggable(Level.FINE)) {
            startTime = System.currentTimeMillis();
        }
        PhpTestingProvider testingProvider = this.getFirstTestingProvider(document);
        if (LOGGER.isLoggable(Level.FINE)) {
            long time = System.currentTimeMillis() - startTime;
            LOGGER.fine(String.format("getFirstTestingProvider() took %d ms", time));
        }
        if (testingProvider == null) {
            return;
        }
        String propertyName = event.getPropertyName();
        if (propertyName.equals("focusGained")) {
            this.handleFileChange(document);
            document.addDocumentListener(this);
        } else if (propertyName.equals("focusLost")) {
            document.removeDocumentListener(this);
        }
    }

    @Override
    public void insertUpdate(DocumentEvent event) {
        this.processUpdate();
    }

    @Override
    public void removeUpdate(DocumentEvent event) {
        this.processUpdate();
    }

    @Override
    public void changedUpdate(DocumentEvent event) {
        this.processUpdate();
    }

    private void handleFileChange(Document doc) {
        this.handledDocument = doc;
        this.processUpdate();
    }

    private void processUpdate() {
        this.task.schedule(500);
    }

    @CheckForNull
    private Document getLastFocusedDocument() {
        JTextComponent textComponent = EditorRegistry.lastFocusedComponent();
        if (textComponent == null) {
            return null;
        }
        return textComponent.getDocument();
    }

    @CheckForNull
    private PhpTestingProvider getFirstTestingProvider(Document document) {
        FileObject fileObject = NbEditorUtilities.getFileObject((Document)document);
        if (fileObject == null) {
            return null;
        }
        PhpProject project = PhpProjectUtils.getPhpProject(fileObject);
        if (project == null) {
            return null;
        }
        PhpModule phpModule = project.getPhpModule();
        for (PhpTestingProvider testingProvider : project.getTestingProviders()) {
            if (!testingProvider.isTestFile(phpModule, fileObject)) continue;
            return testingProvider;
        }
        return null;
    }

    @Override
    public void run() {
        List<TestMethodController.TestMethod> testMethods = this.getTestMethods(this.handledDocument);
        TestMethodController.setTestMethods((Document)this.handledDocument, testMethods);
    }

    private List<TestMethodController.TestMethod> getTestMethods(Document document) {
        FileObject fileObject = NbEditorUtilities.getFileObject((Document)document);
        if (fileObject == null) {
            return Collections.emptyList();
        }
        PhpProject project = PhpProjectUtils.getPhpProject(fileObject);
        if (project == null) {
            return Collections.emptyList();
        }
        PhpTestingProvider testingProvider = this.getFirstTestingProvider(document);
        if (testingProvider == null) {
            return Collections.emptyList();
        }
        return this.getTestMethods(document, fileObject, testingProvider, project.getPhpModule());
    }

    private List<TestMethodController.TestMethod> getTestMethods(Document document, FileObject fileObject, PhpTestingProvider testingProvider, PhpModule phpModule) {
        ArrayList<TestMethodController.TestMethod> testMethods = new ArrayList<TestMethodController.TestMethod>();
        Collection<PhpClass> phpClasses = this.getPhpClasses(fileObject);
        for (PhpClass phpClass : phpClasses) {
            if (!document.equals(this.handledDocument)) {
                return Collections.emptyList();
            }
            for (PhpType.Method method : phpClass.getMethods()) {
                TestMethodController.TestMethod testMethod;
                if (!document.equals(this.handledDocument)) {
                    return Collections.emptyList();
                }
                if (!testingProvider.isTestCase(phpModule, method) || (testMethod = this.createTestMethod(document, phpClass, method, fileObject)) == null) continue;
                testMethods.add(testMethod);
            }
        }
        return testMethods;
    }

    private Collection<PhpClass> getPhpClasses(FileObject fileObject) {
        EditorSupport editorSupport = (EditorSupport)Lookup.getDefault().lookup(EditorSupport.class);
        assert (editorSupport != null);
        return editorSupport.getClasses(fileObject);
    }

    @CheckForNull
    private TestMethodController.TestMethod createTestMethod(Document document, PhpClass phpClass, PhpType.Method method, FileObject fileObject) {
        Position startPosition = null;
        Position endPosition = null;
        try {
            startPosition = document.createPosition(method.getOffset());
            endPosition = document.createPosition(method.getOffset() + method.getName().length());
        }
        catch (BadLocationException exception) {
            LOGGER.log(Level.WARNING, "Unable to create position: offset: {0}; method: {1}; class: {2}.", new Object[]{exception.offsetRequested(), method.getName(), phpClass.getName()});
        }
        if (startPosition == null || endPosition == null) {
            return null;
        }
        String methodName = CommandUtils.encodeMethod(method.getPhpType().getFullyQualifiedName(), method.getName());
        return new TestMethodController.TestMethod(phpClass.getName(), new SingleMethod(fileObject, methodName), startPosition, endPosition);
    }
}

