/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints;

import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.LineMap;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.tools.Diagnostic;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.GeneratorUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.progress.BaseProgressUtils;
import org.netbeans.editor.BaseAction;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.GuardedDocument;
import org.netbeans.editor.MarkBlockChain;
import org.netbeans.modules.java.source.parsing.Hacks;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.java.hints.ErrorDescriptionFactory;
import org.netbeans.spi.java.hints.HintContext;
import org.netbeans.spi.java.hints.JavaFix;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class OrganizeMembers {
    public static ErrorDescription checkMembers(final HintContext context) {
        for (Diagnostic d : context.getInfo().getDiagnostics()) {
            if (!Hacks.isSyntaxError((Diagnostic)d)) continue;
            return null;
        }
        Source source = context.getInfo().getSnapshot().getSource();
        try {
            ModificationResult result = ModificationResult.runModificationTask(Collections.singleton(source), (UserTask)new UserTask(){

                public void run(ResultIterator resultIterator) throws Exception {
                    WorkingCopy copy = WorkingCopy.get((Parser.Result)resultIterator.getParserResult());
                    copy.toPhase(JavaSource.Phase.RESOLVED);
                    OrganizeMembers.doOrganizeMembers(copy, context.getPath());
                }
            });
            List diffs = result.getDifferences(source.getFileObject());
            if (diffs != null && !diffs.isEmpty() && !OrganizeMembers.checkGuarded(context.getInfo().getDocument(), diffs)) {
                Fix fix = new OrganizeMembersFix(context.getInfo(), context.getPath()).toEditorFix();
                SourcePositions sp = context.getInfo().getTrees().getSourcePositions();
                int offset = ((ModificationResult.Difference)diffs.get(0)).getStartPosition().getOffset();
                LineMap lm = context.getInfo().getCompilationUnit().getLineMap();
                long lno = lm.getLineNumber(offset);
                if (lno >= 1L) {
                    offset = (int)lm.getStartPosition(lno);
                }
                CompilationUnitTree cut = context.getPath().getCompilationUnit();
                ClassTree clazz = (ClassTree)context.getPath().getLeaf();
                for (Tree tree : clazz.getMembers()) {
                    if (context.getInfo().getTreeUtilities().isSynthetic(new TreePath(context.getPath(), tree)) || sp.getStartPosition(cut, tree) < (long)offset) continue;
                    return ErrorDescriptionFactory.forTree((HintContext)context, (Tree)tree, (String)NbBundle.getMessage(OrganizeMembers.class, (String)"MSG_OragnizeMembers"), (Fix[])new Fix[]{fix});
                }
                return ErrorDescriptionFactory.forTree((HintContext)context, (Tree)clazz, (String)NbBundle.getMessage(OrganizeMembers.class, (String)"MSG_OragnizeMembers"), (Fix[])new Fix[]{fix});
            }
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private static void doOrganizeMembers(WorkingCopy copy, TreePath path) {
        GeneratorUtilities gu = GeneratorUtilities.get((WorkingCopy)copy);
        ClassTree clazz = (ClassTree)path.getLeaf();
        clazz = (ClassTree)gu.importComments((Tree)clazz, copy.getCompilationUnit());
        TreeMaker maker = copy.getTreeMaker();
        ClassTree nue = maker.Class(clazz.getModifiers(), (CharSequence)clazz.getSimpleName(), clazz.getTypeParameters(), clazz.getExtendsClause(), clazz.getImplementsClause(), clazz.getPermitsClause(), Collections.emptyList());
        ArrayList<Tree> members = new ArrayList<Tree>();
        HashMap<Tree, Tree> memberMap = new HashMap<Tree, Tree>();
        ArrayList<Tree> fixedMembers = new ArrayList<Tree>();
        for (Tree tree : clazz.getMembers()) {
            if (copy.getTreeUtilities().isSynthetic(new TreePath(path, tree)) && (tree.getKind() != Tree.Kind.VARIABLE || !copy.getTreeUtilities().isRecordComponent((VariableTree)tree))) continue;
            Tree member = switch (tree.getKind()) {
                case Tree.Kind.CLASS, Tree.Kind.INTERFACE, Tree.Kind.ENUM, Tree.Kind.RECORD, Tree.Kind.ANNOTATION_TYPE -> maker.setLabel(tree, (CharSequence)((ClassTree)tree).getSimpleName());
                case Tree.Kind.VARIABLE -> {
                    VariableTree var12_17 = (VariableTree)tree;
                    Tree mem = maker.setLabel(tree, (CharSequence)var12_17.getName());
                    if (copy.getTreeUtilities().isEnumConstant(var12_17) || copy.getTreeUtilities().isRecordComponent(var12_17)) {
                        fixedMembers.add(mem);
                    }
                    yield mem;
                }
                case Tree.Kind.METHOD -> maker.setLabel(tree, (CharSequence)((MethodTree)tree).getName());
                case Tree.Kind.BLOCK -> (BlockTree)maker.asReplacementOf((Tree)maker.Block(((BlockTree)tree).getStatements(), ((BlockTree)tree).isStatic()), tree, true);
                default -> tree;
            };
            members.add(member);
            memberMap.put(member, tree);
        }
        if (fixedMembers.isEmpty()) {
            nue = GeneratorUtilities.get((WorkingCopy)copy).insertClassMembers(nue, members);
        } else {
            members.removeAll(fixedMembers);
            int max = nue.getMembers().size();
            for (Tree t : fixedMembers) {
                nue = maker.insertClassMember(nue, max++, t);
            }
            nue = GeneratorUtilities.get((WorkingCopy)copy).insertClassMembers(nue, members);
        }
        ClassTree changed = maker.Class(clazz.getModifiers(), (CharSequence)clazz.getSimpleName(), clazz.getTypeParameters(), clazz.getExtendsClause(), clazz.getImplementsClause(), clazz.getPermitsClause(), Collections.emptyList());
        boolean bl = false;
        for (Tree tree : nue.getMembers()) {
            void var10_15;
            Tree orig = (Tree)memberMap.get(tree);
            changed = maker.insertClassMember(changed, (int)var10_15, orig);
            ++var10_15;
        }
        copy.rewrite((Tree)clazz, (Tree)changed);
    }

    private static boolean checkGuarded(Document doc, List<? extends ModificationResult.Difference> diffs) {
        if (doc instanceof GuardedDocument) {
            GuardedDocument guardedDocument = (GuardedDocument)doc;
            MarkBlockChain chain = guardedDocument.getGuardedBlockChain();
            for (ModificationResult.Difference difference : diffs) {
                if ((chain.compareBlock(difference.getStartPosition().getOffset(), difference.getEndPosition().getOffset()) & 1) == 0) continue;
                return true;
            }
        }
        return false;
    }

    private static class OrganizeMembersFix
    extends JavaFix {
        public OrganizeMembersFix(CompilationInfo info, TreePath tp) {
            super(info, tp);
        }

        public String getText() {
            return NbBundle.getMessage(OrganizeMembers.class, (String)"FIX_OrganizeMembers");
        }

        protected void performRewrite(JavaFix.TransformationContext ctx) {
            OrganizeMembers.doOrganizeMembers(ctx.getWorkingCopy(), ctx.getPath());
        }
    }

    public static class OrganizeMembersAction
    extends BaseAction {
        public void actionPerformed(ActionEvent evt, final JTextComponent component) {
            if (component == null || !component.isEditable() || !component.isEnabled()) {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            final BaseDocument doc = (BaseDocument)component.getDocument();
            final Source source = Source.create((Document)doc);
            if (source != null) {
                AtomicBoolean cancel = new AtomicBoolean();
                BaseProgressUtils.runOffEventDispatchThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        try {
                            ModificationResult result = ModificationResult.runModificationTask(Collections.singleton(source), (UserTask)new UserTask(){

                                public void run(ResultIterator resultIterator) throws Exception {
                                    WorkingCopy copy = WorkingCopy.get((Parser.Result)resultIterator.getParserResult());
                                    copy.toPhase(JavaSource.Phase.RESOLVED);
                                    TreeUtilities tu = copy.getTreeUtilities();
                                    TreePath path = tu.pathFor(component.getCaretPosition());
                                    path = tu.getPathElementOfKind(EnumSet.of(Tree.Kind.CLASS, Tree.Kind.ENUM, Tree.Kind.INTERFACE, Tree.Kind.ANNOTATION_TYPE), path);
                                    if (path != null) {
                                        OrganizeMembers.doOrganizeMembers(copy, path);
                                    } else {
                                        CompilationUnitTree cut = copy.getCompilationUnit();
                                        List<? extends Tree> typeDecls = cut.getTypeDecls();
                                        if (typeDecls.isEmpty()) {
                                            Toolkit.getDefaultToolkit().beep();
                                        } else {
                                            OrganizeMembers.doOrganizeMembers(copy, copy.getTrees().getPath(cut, typeDecls.get(0)));
                                        }
                                    }
                                }
                            });
                            List diffs = result.getDifferences(source.getFileObject());
                            if (diffs != null && !diffs.isEmpty() && !OrganizeMembers.checkGuarded((Document)doc, diffs)) {
                                result.commit();
                            } else {
                                Toolkit.getDefaultToolkit().beep();
                            }
                        }
                        catch (Exception ex) {
                            Toolkit.getDefaultToolkit().beep();
                        }
                    }
                }, (String)NbBundle.getMessage(OrganizeMembers.class, (String)"MSG_OragnizeMembers"), (AtomicBoolean)cancel, (boolean)false);
            }
        }
    }
}

