/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.symfony2.util;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.modules.php.api.editor.PhpBaseElement;
import org.netbeans.modules.php.api.editor.PhpType;
import org.netbeans.modules.php.api.util.StringUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public final class SymfonyUtils {
    private static final String TWIG_MIME_TYPE = "text/x-twig";
    private static final String SRC_DIR_NAME = "src";
    private static final String RESOURCES_DIR_NAME = "Resources";
    private static final String VIEWS_DIR_NAME = "views";
    private static final String RESOURCES_VIEWS_REL_PATH = "Resources/views/";
    private static final String RESOURCES_VIEWS_ABS_PATH = File.separator + "Resources" + File.separator + "views" + File.separator;
    private static final String CONTROLLER_DIR_NAME = "Controller";
    private static final String CONTROLLER_SUFFIX = "Controller.php";
    private static final String VIEW_HTML_SUFFIX = ".html";
    private static final String VIEW_HTML_TWIG_SUFFIX = ".html.twig";
    private static final String ACTION_SUFFIX = "Action";
    private static final String BUNDLE_SUFFIX = "Bundle";

    private SymfonyUtils() {
    }

    public static boolean isViewWithAction(FileObject file) {
        if (!SymfonyUtils.isView(file)) {
            return false;
        }
        return SymfonyUtils.getViewRelPath(file) != null;
    }

    public static boolean isController(FileObject file) {
        if (!SymfonyUtils.isController(file.getNameExt())) {
            return false;
        }
        return SymfonyUtils.getControllerRelPath(file) != null;
    }

    @CheckForNull
    public static FileObject getController(FileObject sourceDir, FileObject view) {
        assert (SymfonyUtils.isView(view)) : view;
        List<String> viewRelPath = SymfonyUtils.getViewRelPath(view);
        assert (viewRelPath != null) : view;
        FileObject src = sourceDir.getFileObject(SRC_DIR_NAME);
        if (src == null) {
            return null;
        }
        int size = viewRelPath.size();
        StringBuilder sb = new StringBuilder();
        sb.append(CONTROLLER_DIR_NAME);
        sb.append('/');
        for (int i = 0; i < size; ++i) {
            sb.append(SymfonyUtils.capitalize(viewRelPath.get(i), true));
            if (i >= size - 1) continue;
            sb.append('/');
        }
        sb.append(CONTROLLER_SUFFIX);
        String controllerPath = sb.toString();
        for (FileObject child : src.getChildren()) {
            FileObject controller;
            if (child.isData() || !child.getNameExt().endsWith(BUNDLE_SUFFIX) || (controller = child.getFileObject(controllerPath)) == null) continue;
            return controller;
        }
        return null;
    }

    public static String getActionMethodName(String viewName) {
        String actionName = viewName;
        if (actionName.endsWith(VIEW_HTML_SUFFIX)) {
            actionName = actionName.substring(0, actionName.length() - VIEW_HTML_SUFFIX.length());
        }
        return SymfonyUtils.capitalize(actionName, false) + ACTION_SUFFIX;
    }

    @CheckForNull
    public static FileObject getView(FileObject controller, FileObject appDir, PhpBaseElement phpElement) {
        if (!(phpElement instanceof PhpType.Method)) {
            return null;
        }
        String methodName = phpElement.getName();
        if (!methodName.endsWith(ACTION_SUFFIX)) {
            return null;
        }
        String viewName = methodName.substring(0, methodName.length() - ACTION_SUFFIX.length());
        List<String> relPath = SymfonyUtils.getControllerRelPath(controller);
        assert (relPath != null) : controller;
        StringBuilder sb = new StringBuilder();
        sb.append(RESOURCES_VIEWS_REL_PATH);
        for (int i = relPath.size() - 1; i >= 0; --i) {
            sb.append(SymfonyUtils.decapitalize(relPath.get(i)));
            sb.append('/');
        }
        sb.append(SymfonyUtils.decapitalize(viewName));
        sb.append(VIEW_HTML_TWIG_SUFFIX);
        return appDir.getFileObject(sb.toString());
    }

    @CheckForNull
    private static List<String> getViewRelPath(FileObject view) {
        assert (SymfonyUtils.isView(view)) : view;
        String name = view.getNameExt();
        if (StringUtils.hasText((String)name) && name.charAt(0) == '_') {
            return null;
        }
        String absolutePath = FileUtil.toFile((FileObject)view).getAbsolutePath();
        int lastIndexOf = absolutePath.lastIndexOf(RESOURCES_VIEWS_ABS_PATH);
        if (lastIndexOf == -1) {
            return null;
        }
        return StringUtils.explode((String)absolutePath.substring(lastIndexOf + RESOURCES_VIEWS_ABS_PATH.length(), absolutePath.length() - name.length()), (String)File.separator);
    }

    @CheckForNull
    private static List<String> getControllerRelPath(FileObject controller) {
        assert (SymfonyUtils.isController(controller.getNameExt())) : controller;
        ArrayList<String> path = new ArrayList<String>();
        String name = controller.getNameExt();
        path.add(name.substring(0, name.length() - CONTROLLER_SUFFIX.length()));
        for (FileObject parent = controller.getParent(); parent != null; parent = parent.getParent()) {
            String parentName = parent.getNameExt();
            if (parentName.equals(CONTROLLER_DIR_NAME)) {
                FileObject bundle = parent.getParent();
                if (bundle.getNameExt().endsWith(BUNDLE_SUFFIX)) break;
                return null;
            }
            path.add(parentName);
        }
        return path;
    }

    private static boolean isView(FileObject file) {
        return FileUtil.getMIMEType((FileObject)file, (String[])new String[]{null, TWIG_MIME_TYPE}) != null;
    }

    public static boolean isController(String filename) {
        return filename.endsWith(CONTROLLER_SUFFIX);
    }

    static String capitalize(String input, boolean capitalizeFirstChar) {
        assert (input != null);
        StringBuilder sb = new StringBuilder(input.length());
        boolean capitalize = capitalizeFirstChar;
        for (int i = 0; i < input.length(); ++i) {
            char ch = input.charAt(i);
            if (ch == '_') {
                capitalize = true;
                continue;
            }
            if (capitalize) {
                capitalize = false;
                ch = Character.toUpperCase(ch);
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    static String decapitalize(String input) {
        assert (input != null);
        StringBuilder sb = new StringBuilder(input.length() * 2);
        for (int i = 0; i < input.length(); ++i) {
            char ch = input.charAt(i);
            if (Character.isUpperCase(ch)) {
                if (i > 0) {
                    sb.append('_');
                }
                ch = Character.toLowerCase(ch);
            }
            sb.append(ch);
        }
        return sb.toString();
    }
}

