/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.adapter;

import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Set;
import org.gradle.internal.impldep.javax.annotation.Nullable;

class WeakIdentityHashMap<K, V> {
    private final HashMap<WeakKey<K>, V> map = new HashMap();

    WeakIdentityHashMap() {
    }

    void put(K key, V value) {
        this.map.put(new WeakKey<K>(key), value);
    }

    @Nullable
    V get(K key) {
        return this.map.get(new WeakKey<K>(key));
    }

    Set<WeakKey<K>> keySet() {
        return this.map.keySet();
    }

    V computeIfAbsent(K key, AbsentValueProvider<V> absentValueProvider) {
        WeakKey<K> weakKey = new WeakKey<K>(key);
        V value = this.map.get(weakKey);
        if (value == null) {
            value = absentValueProvider.provide();
            this.map.put(weakKey, value);
        }
        return value;
    }

    public static class WeakKey<T>
    extends WeakReference<T> {
        private final int hashCode;

        public WeakKey(T referent) {
            super(referent);
            this.hashCode = System.identityHashCode(referent);
        }

        public boolean equals(Object obj) {
            Object objReferent;
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof WeakKey)) {
                return false;
            }
            Object thisReferent = this.get();
            return thisReferent == (objReferent = ((WeakKey)obj).get());
        }

        public int hashCode() {
            return this.hashCode;
        }
    }

    public static interface AbsentValueProvider<T> {
        public T provide();
    }
}

