/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.common.ui.api;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.netbeans.api.project.Project;
import org.netbeans.modules.web.common.ui.api.CssPreprocessorUI;
import org.netbeans.modules.web.common.ui.cssprep.CssPrepOptionsPanelController;
import org.netbeans.modules.web.common.ui.cssprep.CssPreprocessorAccessor;
import org.netbeans.modules.web.common.ui.cssprep.CssPreprocessorsAccessor;
import org.netbeans.modules.web.common.ui.cssprep.CssPreprocessorsCustomizer;
import org.netbeans.modules.web.common.ui.cssprep.CssPreprocessorsProblemProvider;
import org.netbeans.modules.web.common.ui.spi.CssPreprocessorUIImplementation;
import org.netbeans.spi.options.OptionsPanelController;
import org.netbeans.spi.project.ui.ProjectProblemsProvider;
import org.netbeans.spi.project.ui.support.ProjectCustomizer;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.lookup.Lookups;

public final class CssPreprocessorsUI {
    public static final String CUSTOMIZER_IDENT = "CssPreprocessors";
    public static final String OPTIONS_CATEGORY = "Html5";
    public static final String OPTIONS_SUBCATEGORY = "CssPreprocessors";
    public static final String OPTIONS_PATH = "Html5/CssPreprocessors";
    private static final Lookup.Result<CssPreprocessorUIImplementation> PREPROCESSORS = Lookups.forPath((String)"CSS/PreProcessors").lookupResult(CssPreprocessorUIImplementation.class);
    private static final CssPreprocessorsUI INSTANCE = new CssPreprocessorsUI();
    private final List<CssPreprocessorUI> preprocessors = new CopyOnWriteArrayList<CssPreprocessorUI>();

    private CssPreprocessorsUI() {
        this.initProcessors();
    }

    public static CssPreprocessorsUI getDefault() {
        return INSTANCE;
    }

    public ProjectCustomizer.CompositeCategoryProvider createCustomizer() {
        return new CssPreprocessorsCustomizer();
    }

    public OptionsPanelController createOptions() {
        return new CssPrepOptionsPanelController();
    }

    public ProjectProblemsProvider createProjectProblemsProvider(Project project) {
        return CssPreprocessorsProblemProvider.create(project);
    }

    List<CssPreprocessorUI> getPreprocessors() {
        return new ArrayList<CssPreprocessorUI>(this.preprocessors);
    }

    private void initProcessors() {
        assert (this.preprocessors.isEmpty()) : "Empty preprocessors expected but: " + this.preprocessors;
        this.preprocessors.addAll(this.map(PREPROCESSORS.allInstances()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reinitProcessors() {
        List<CssPreprocessorUI> list = this.preprocessors;
        synchronized (list) {
            this.clearProcessors();
            this.initProcessors();
        }
    }

    private void clearProcessors() {
        this.preprocessors.clear();
    }

    private List<CssPreprocessorUI> map(Collection<? extends CssPreprocessorUIImplementation> preprocessors) {
        ArrayList<CssPreprocessorUI> result = new ArrayList<CssPreprocessorUI>();
        for (CssPreprocessorUIImplementation cssPreprocessorUIImplementation : preprocessors) {
            result.add(CssPreprocessorAccessor.getDefault().create(cssPreprocessorUIImplementation));
        }
        return result;
    }

    static {
        PREPROCESSORS.addLookupListener(new LookupListener(){

            public void resultChanged(LookupEvent ev) {
                INSTANCE.reinitProcessors();
            }
        });
        CssPreprocessorsAccessor.setDefault(new CssPreprocessorsAccessor(){

            @Override
            public List<CssPreprocessorUI> getPreprocessors() {
                return INSTANCE.getPreprocessors();
            }
        });
    }
}

