/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.features;

import java.util.List;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import org.netbeans.api.languages.LanguageDefinitionNotFoundException;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.ext.ExtKit;
import org.netbeans.modules.languages.Feature;
import org.netbeans.modules.languages.Language;
import org.netbeans.modules.languages.LanguagesManager;
import org.netbeans.modules.languages.Utils;

public class BraceCompletionInsertAction
extends ExtKit.ExtDefaultKeyTypedAction {
    protected void insertString(BaseDocument document, int offset, Caret caret, String insertString, boolean overwrite) throws BadLocationException {
        TokenSequence tokenSequence = Utils.getTokenSequence((Document)document, caret.getDot());
        if (tokenSequence != null) {
            String mimeType = tokenSequence.language().mimeType();
            try {
                Language l = LanguagesManager.getDefault().getLanguage(mimeType);
                List<Feature> completes = l.getFeatureList().getFeatures("COMPLETE");
                if (completes != null) {
                    this.complete(document, offset, caret, insertString, overwrite, tokenSequence, completes);
                    return;
                }
            }
            catch (LanguageDefinitionNotFoundException languageDefinitionNotFoundException) {
                // empty catch block
            }
        }
        super.insertString(document, offset, caret, insertString, overwrite);
    }

    private void complete(BaseDocument document, int offset, Caret caret, String insertString, boolean overwrite, TokenSequence tokenSequence, List<Feature> completes) throws BadLocationException {
        for (Feature complete : completes) {
            String previousTest;
            if (complete.getType() == Feature.Type.METHOD_CALL) {
                complete.getValue(new Object[]{document, caret, insertString});
                return;
            }
            String bracketPair = (String)complete.getValue();
            int i = bracketPair.indexOf(58);
            if (i < 0) continue;
            if (caret.getDot() + bracketPair.length() - i - 1 < document.getLength()) {
                String followingText = document.getText(caret.getDot(), bracketPair.length() - i - 1);
                if (bracketPair.endsWith(":" + followingText) && insertString.equals(followingText)) {
                    caret.setDot(caret.getDot() + 1);
                    return;
                }
            }
            if (caret.getDot() - i + insertString.length() < 0 || !bracketPair.startsWith((previousTest = document.getText(caret.getDot() - i + insertString.length(), i - insertString.length()) + insertString) + ":")) continue;
            Token token = tokenSequence.token();
            boolean startsWithWhiteSpace = false;
            if (token != null) {
                char firstCharOfTokenText = token.text().charAt(0);
                boolean bl = startsWithWhiteSpace = firstCharOfTokenText == '\n' || firstCharOfTokenText == ' ';
            }
            if (token != null && tokenSequence.offset() != caret.getDot() && token.id().name().indexOf("whitespace") < 0 && !startsWithWhiteSpace) continue;
            insertString = insertString + bracketPair.substring(i + 1);
            super.insertString(document, offset, caret, insertString, overwrite);
            caret.setDot(offset + 1);
            return;
        }
        super.insertString(document, offset, caret, insertString, overwrite);
    }
}

