/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.commands;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.netbeans.modules.mercurial.HgException;
import org.netbeans.modules.mercurial.OutputLogger;
import org.netbeans.modules.mercurial.commands.Bundle;
import org.netbeans.modules.mercurial.util.HgCommand;
import org.openide.util.Parameters;

public final class RebaseCommand
extends HgCommand<Result> {
    private static final String HG_REBASE_EXT_CMD = "extensions.rebase=";
    private static final String HG_REBASE_OPT_ABORT = "--abort";
    private static final String HG_REBASE_OPT_CONTINUE = "--continue";
    private static final String HG_REBASE_OPT_BASE = "--base";
    private static final String HG_REBASE_OPT_SOURCE = "--source";
    private static final String HG_REBASE_OPT_DEST = "--dest";
    private final File repository;
    private final Operation operation;
    private final OutputLogger logger;
    private String revisionBase;
    private String revisionSource;
    private String revisionDest;
    private List<String> output;

    public RebaseCommand(File repository, Operation operation, OutputLogger logger) {
        Parameters.notNull((CharSequence)"repository", (Object)repository);
        Parameters.notNull((CharSequence)"operation", (Object)((Object)operation));
        this.repository = repository;
        this.operation = operation;
        this.logger = logger;
    }

    public RebaseCommand setRevisionBase(String revisionBase) {
        this.revisionBase = revisionBase;
        return this;
    }

    public RebaseCommand setRevisionSource(String revisionSource) {
        this.revisionSource = revisionSource;
        return this;
    }

    public RebaseCommand setRevisionDest(String revisionDest) {
        this.revisionDest = revisionDest;
        return this;
    }

    @Override
    public Result call() throws HgException {
        HgCommand.CommandParameters args = new HgCommand.CommandParameters("rebase");
        switch (this.operation) {
            case ABORT: {
                args.add(HG_REBASE_OPT_ABORT);
                break;
            }
            case CONTINUE: {
                args.add(HG_REBASE_OPT_CONTINUE);
                break;
            }
            case START: {
                if (this.revisionBase != null) {
                    args.add(HG_REBASE_OPT_BASE);
                    args.add(this.revisionBase);
                }
                if (this.revisionSource != null) {
                    args.add(HG_REBASE_OPT_SOURCE);
                    args.add(this.revisionSource);
                }
                if (this.revisionDest == null) break;
                args.add(HG_REBASE_OPT_DEST);
                args.add(this.revisionDest);
            }
        }
        args.addVerboseOption().addConfigOption(HG_REBASE_EXT_CMD).addConfigOption("ui.merge=internal:merge").addRepositoryLocation(this.repository.getAbsolutePath());
        List<String> command = args.toCommand();
        this.output = RebaseCommand.exec(command);
        if (!this.output.isEmpty() && RebaseCommand.isErrorAbort(this.output.get(0))) {
            RebaseCommand.handleError(command, this.output, Bundle.MSG_HgCommand_Rebase_failed(), this.logger);
        }
        return Result.build(this.repository, this.output);
    }

    public List<String> getOutput() {
        return this.output;
    }

    public static enum Operation {
        CONTINUE,
        ABORT,
        START;

    }

    public static class Result {
        private static final String SAVED_BACKUP_BUNDLE_TO = "saved backup bundle to ";
        private File bundleFile;
        private final List<String> output;
        private final Set<File> touchedFiles;
        private final List<File> conflicts;
        private State state;

        private Result(List<String> output) {
            this.output = output;
            this.touchedFiles = new LinkedHashSet<File>();
            this.conflicts = new ArrayList<File>();
        }

        public static Result build(File repo, List<String> output) {
            Result res = new Result(output);
            res.state = State.OK;
            for (String line : output) {
                boolean removed = false;
                boolean merging = false;
                if (line.startsWith("getting ") || (merging = line.startsWith("merging ")) || (removed = line.startsWith("removing "))) {
                    String name = line.substring(removed ? 9 : 8);
                    if (merging && name.endsWith(" failed!")) {
                        name = name.substring(0, name.length() - 8);
                        res.conflicts.add(new File(repo, name));
                        continue;
                    }
                    res.touchedFiles.add(new File(repo, name));
                    continue;
                }
                if (line.startsWith("abort: unresolved conflicts")) {
                    res.state = State.MERGING;
                    continue;
                }
                if (line.equals("rebase aborted")) {
                    res.state = State.ABORTED;
                    continue;
                }
                if (!line.startsWith(SAVED_BACKUP_BUNDLE_TO)) continue;
                res.bundleFile = new File(line.substring(SAVED_BACKUP_BUNDLE_TO.length()));
            }
            return res;
        }

        public File getBundleFile() {
            return this.bundleFile;
        }

        public Collection<File> getConflicts() {
            return this.conflicts;
        }

        public State getState() {
            return this.state;
        }

        public Collection<File> getTouchedFiles() {
            return this.touchedFiles;
        }

        public List<String> getOutput() {
            return this.output;
        }

        public static enum State {
            OK,
            ABORTED,
            MERGING;

        }
    }
}

