/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.nodejs.platform;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.project.Project;
import org.netbeans.modules.javascript.nodejs.util.NodeJsUtils;
import org.openide.filesystems.FileUtil;
import org.openide.util.Utilities;

public final class NodeJsSourceRoots {
    private static final Logger LOGGER = Logger.getLogger(NodeJsSourceRoots.class.getName());
    public static final String LIB_DIRECTORY = "lib";
    private final Project project;
    private List<URL> sourceRoots = null;

    public NodeJsSourceRoots(Project project) {
        assert (project != null);
        this.project = project;
    }

    public synchronized List<URL> getSourceRoots() {
        if (this.sourceRoots == null) {
            this.sourceRoots = this.findSourceRoots();
        }
        return new ArrayList<URL>(this.sourceRoots);
    }

    public synchronized void resetSourceRoots() {
        this.sourceRoots = null;
    }

    private List<URL> findSourceRoots() {
        File nodeSources = NodeJsUtils.getNodeSources(this.project);
        if (nodeSources == null) {
            return Collections.emptyList();
        }
        File lib = new File(nodeSources, LIB_DIRECTORY);
        if (!lib.isDirectory()) {
            return Collections.emptyList();
        }
        try {
            URL nodeLib = Utilities.toURI((File)FileUtil.normalizeFile((File)lib)).toURL();
            return Collections.singletonList(nodeLib);
        }
        catch (MalformedURLException ex) {
            LOGGER.log(Level.INFO, null, ex);
            assert (false);
            return Collections.emptyList();
        }
    }
}

