/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.editor;

import java.util.concurrent.atomic.AtomicReference;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.modules.websvc.rest.editor.RestConfigurationEditorAwareTaskFactory;
import org.netbeans.modules.websvc.rest.editor.RestScanTask;
import org.netbeans.spi.editor.hints.HintsController;
import org.openide.filesystems.FileObject;

class RestConfigurationTask
implements CancellableTask<CompilationInfo> {
    private AtomicReference<RestScanTask> task;
    private FileObject fileObject;
    private RestConfigurationEditorAwareTaskFactory factory;

    RestConfigurationTask(RestConfigurationEditorAwareTaskFactory factory, FileObject fileObject) {
        this.factory = factory;
        this.fileObject = fileObject;
        this.task = new AtomicReference();
    }

    public void run(CompilationInfo info) throws Exception {
        RestScanTask scanTask = new RestScanTask(this.factory, this.fileObject, info);
        this.task.set(scanTask);
        scanTask.run();
        this.task.compareAndSet(scanTask, null);
        HintsController.setErrors((FileObject)this.fileObject, (String)"REST Configuration", scanTask.getHints());
    }

    public void cancel() {
        RestScanTask scanTask = this.task.getAndSet(null);
        if (scanTask != null) {
            scanTask.stop();
        }
    }
}

