/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.svnclientadapter;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNInfo;
import org.tigris.subversion.svnclientadapter.ISVNLogMessage;
import org.tigris.subversion.svnclientadapter.ISVNLogMessageCallback;
import org.tigris.subversion.svnclientadapter.ISVNPromptUserPassword;
import org.tigris.subversion.svnclientadapter.ISVNProperty;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNKeywords;
import org.tigris.subversion.svnclientadapter.SVNLogMessageCallback;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNScheduleKind;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public abstract class AbstractClientAdapter
implements ISVNClientAdapter {
    @Override
    public void setKeywords(File path, SVNKeywords keywords, boolean recurse) throws SVNClientException {
        this.propertySet(path, "svn:keywords", keywords.toString(), recurse);
    }

    @Override
    public SVNKeywords addKeywords(File path, SVNKeywords keywords) throws SVNClientException {
        SVNKeywords currentKeywords = this.getKeywords(path);
        if (keywords.isHeadUrl()) {
            currentKeywords.setHeadUrl(true);
        }
        if (keywords.isId()) {
            currentKeywords.setId(true);
        }
        if (keywords.isLastChangedBy()) {
            currentKeywords.setLastChangedBy(true);
        }
        if (keywords.isLastChangedDate()) {
            currentKeywords.setLastChangedDate(true);
        }
        if (keywords.isLastChangedRevision()) {
            currentKeywords.setLastChangedRevision(true);
        }
        this.setKeywords(path, currentKeywords, false);
        return currentKeywords;
    }

    @Override
    public SVNKeywords removeKeywords(File path, SVNKeywords keywords) throws SVNClientException {
        SVNKeywords currentKeywords = this.getKeywords(path);
        if (keywords.isHeadUrl()) {
            currentKeywords.setHeadUrl(false);
        }
        if (keywords.isId()) {
            currentKeywords.setId(false);
        }
        if (keywords.isLastChangedBy()) {
            currentKeywords.setLastChangedBy(false);
        }
        if (keywords.isLastChangedDate()) {
            currentKeywords.setLastChangedBy(false);
        }
        if (keywords.isLastChangedRevision()) {
            currentKeywords.setLastChangedRevision(false);
        }
        this.setKeywords(path, currentKeywords, false);
        return currentKeywords;
    }

    @Override
    public List getIgnoredPatterns(File path) throws SVNClientException {
        if (!path.isDirectory()) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        ISVNProperty pd = this.propertyGet(path, "svn:ignore");
        if (pd == null) {
            return list;
        }
        String patterns = pd.getValue();
        StringTokenizer st = new StringTokenizer(patterns, "\n\r");
        while (st.hasMoreTokens()) {
            String entry = st.nextToken();
            if (entry == null || entry.length() <= 0) continue;
            list.add(entry);
        }
        return list;
    }

    @Override
    public ISVNLogMessage[] getLogMessages(File arg0, SVNRevision arg1, SVNRevision arg2) throws SVNClientException {
        return this.getLogMessages(arg0, arg1, arg2, true);
    }

    @Override
    public ISVNLogMessage[] getLogMessages(SVNUrl arg0, SVNRevision arg1, SVNRevision arg2) throws SVNClientException {
        return this.getLogMessages(arg0, arg1, arg2, true);
    }

    @Override
    public ISVNLogMessage[] getLogMessages(SVNUrl url, String[] paths, SVNRevision revStart, SVNRevision revEnd, boolean stopOnCopy, boolean fetchChangePath) throws SVNClientException {
        return this.getLogMessages(url, SVNRevision.HEAD, revStart, revEnd, stopOnCopy, fetchChangePath, 0L, false);
    }

    @Override
    public ISVNLogMessage[] getLogMessages(File path, SVNRevision revisionStart, SVNRevision revisionEnd, boolean fetchChangePath) throws SVNClientException {
        return this.getLogMessages(path, SVNRevision.HEAD, revisionStart, revisionEnd, false, fetchChangePath, 0L, false);
    }

    @Override
    public ISVNLogMessage[] getLogMessages(File path, SVNRevision revisionStart, SVNRevision revisionEnd, boolean stopOnCopy, boolean fetchChangePath) throws SVNClientException {
        return this.getLogMessages(path, SVNRevision.HEAD, revisionStart, revisionEnd, stopOnCopy, fetchChangePath, 0L, false);
    }

    @Override
    public ISVNLogMessage[] getLogMessages(File path, SVNRevision revisionStart, SVNRevision revisionEnd, boolean stopOnCopy, boolean fetchChangePath, long limit) throws SVNClientException {
        ISVNInfo info = this.getInfoFromWorkingCopy(path);
        if (SVNScheduleKind.ADD == info.getSchedule() && info.getCopyUrl() != null) {
            return this.getLogMessages(info.getCopyUrl(), SVNRevision.HEAD, revisionStart, revisionEnd, stopOnCopy, fetchChangePath, limit, false);
        }
        return this.getLogMessages(path, SVNRevision.HEAD, revisionStart, revisionEnd, stopOnCopy, fetchChangePath, limit, false);
    }

    @Override
    public ISVNLogMessage[] getLogMessages(SVNUrl url, SVNRevision revisionStart, SVNRevision revisionEnd, boolean fetchChangePath) throws SVNClientException {
        return this.getLogMessages(url, SVNRevision.HEAD, revisionStart, revisionEnd, false, fetchChangePath, 0L, false);
    }

    @Override
    public ISVNLogMessage[] getLogMessages(SVNUrl url, SVNRevision pegRevision, SVNRevision revisionStart, SVNRevision revisionEnd, boolean stopOnCopy, boolean fetchChangePath, long limit) throws SVNClientException {
        return this.getLogMessages(url, pegRevision, revisionStart, revisionEnd, stopOnCopy, fetchChangePath, limit, false);
    }

    @Override
    public ISVNLogMessage[] getLogMessages(File path, SVNRevision pegRevision, SVNRevision revisionStart, SVNRevision revisionEnd, boolean stopOnCopy, boolean fetchChangePath, long limit, boolean includeMergedRevisions) throws SVNClientException {
        SVNLogMessageCallback worker = new SVNLogMessageCallback();
        this.getLogMessages(path, pegRevision, revisionStart, revisionEnd, stopOnCopy, fetchChangePath, limit, includeMergedRevisions, ISVNClientAdapter.DEFAULT_LOG_PROPERTIES, (ISVNLogMessageCallback)worker);
        return worker.getLogMessages();
    }

    @Override
    public ISVNLogMessage[] getLogMessages(SVNUrl url, SVNRevision pegRevision, SVNRevision revisionStart, SVNRevision revisionEnd, boolean stopOnCopy, boolean fetchChangePath, long limit, boolean includeMergedRevisions) throws SVNClientException {
        SVNLogMessageCallback worker = new SVNLogMessageCallback();
        this.getLogMessages(url, pegRevision, revisionStart, revisionEnd, stopOnCopy, fetchChangePath, limit, includeMergedRevisions, ISVNClientAdapter.DEFAULT_LOG_PROPERTIES, (ISVNLogMessageCallback)worker);
        return worker.getLogMessages();
    }

    @Override
    public void setIgnoredPatterns(File path, List patterns) throws SVNClientException {
        if (!path.isDirectory()) {
            return;
        }
        String separator = System.getProperty("line.separator");
        StringBuffer value = new StringBuffer();
        for (String pattern : patterns) {
            value.append(pattern + separator);
        }
        this.propertySet(path, "svn:ignore", value.toString(), false);
    }

    @Override
    public void addToIgnoredPatterns(File path, String pattern) throws SVNClientException {
        List patterns = this.getIgnoredPatterns(path);
        if (patterns == null) {
            return;
        }
        Iterator it = patterns.iterator();
        while (it.hasNext()) {
            if (!((String)it.next()).equals(pattern)) continue;
            return;
        }
        patterns.add(pattern);
        this.setIgnoredPatterns(path, patterns);
    }

    @Override
    public SVNKeywords getKeywords(File path) throws SVNClientException {
        ISVNProperty prop = this.propertyGet(path, "svn:keywords");
        if (prop == null) {
            return new SVNKeywords();
        }
        String value = prop.getValue();
        return new SVNKeywords(value);
    }

    @Override
    public void addPasswordCallback(ISVNPromptUserPassword callback) {
    }

    @Override
    public boolean statusReturnsRemoteInfo() {
        return false;
    }

    @Override
    public long[] commitAcrossWC(File[] paths, String message, boolean recurse, boolean keepLocks, boolean Atomic) throws SVNClientException {
        this.notImplementedYet();
        return null;
    }

    protected void notImplementedYet() throws SVNClientException {
        throw new SVNClientException("Not implemented yet");
    }

    @Override
    public boolean canCommitAcrossWC() {
        return false;
    }

    @Override
    public void mkdir(SVNUrl url, boolean makeParents, String message) throws SVNClientException {
        SVNUrl parent;
        if (makeParents && (parent = url.getParent()) != null) {
            ISVNInfo info = null;
            try {
                info = this.getInfo(parent);
            }
            catch (SVNClientException sVNClientException) {
                // empty catch block
            }
            if (info == null) {
                this.mkdir(parent, makeParents, message);
            }
        }
        this.mkdir(url, message);
    }

    public static boolean isOsWindows() {
        try {
            return System.getProperty("os.name").startsWith("Windows");
        }
        catch (SecurityException ex) {
            return false;
        }
    }

    @Override
    public ISVNInfo getInfo(SVNUrl url) throws SVNClientException {
        return this.getInfo(url, SVNRevision.HEAD, SVNRevision.HEAD);
    }

    @Override
    public void merge(SVNUrl path1, SVNRevision revision1, SVNUrl path2, SVNRevision revision2, File localPath, boolean force, boolean recurse, boolean dryRun) throws SVNClientException {
        this.merge(path1, revision1, path2, revision2, localPath, force, recurse, dryRun, false);
    }

    @Override
    public void merge(SVNUrl path1, SVNRevision revision1, SVNUrl path2, SVNRevision revision2, File localPath, boolean force, boolean recurse) throws SVNClientException {
        this.merge(path1, revision1, path2, revision2, localPath, force, recurse, false, false);
    }

    @Override
    public ISVNProperty propertyGet(SVNUrl url, String propertyName) throws SVNClientException {
        return this.propertyGet(url, SVNRevision.HEAD, SVNRevision.HEAD, propertyName);
    }

    @Override
    public void diff(File[] paths, File outFile, boolean recurse) throws SVNClientException {
        FileOutputStream os = null;
        try {
            ArrayList<File> tempFiles = new ArrayList<File>();
            for (int i = 0; i < paths.length; ++i) {
                File tempFile = File.createTempFile("tempDiff", ".txt");
                tempFile.deleteOnExit();
                this.diff(paths[i], tempFile, recurse);
                tempFiles.add(tempFile);
            }
            os = new FileOutputStream(outFile);
            for (File tempFile : tempFiles) {
                int bytes_read;
                FileInputStream is = new FileInputStream(tempFile);
                byte[] buffer = new byte[4096];
                while ((bytes_read = is.read(buffer)) != -1) {
                    os.write(buffer, 0, bytes_read);
                }
                is.close();
            }
        }
        catch (Exception e) {
            throw new SVNClientException(e);
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    public void createPatch(File[] paths, File relativeToPath, File outFile, boolean recurse) throws SVNClientException {
        File tmpFile;
        try {
            tmpFile = File.createTempFile("svn", "patch");
            tmpFile.deleteOnExit();
        }
        catch (IOException e) {
            throw new SVNClientException(e);
        }
        this.diff(paths, tmpFile, recurse);
        this.stripPathsFromPatch(tmpFile, outFile, relativeToPath);
    }

    private void stripPathsFromPatch(File tmpFile, File outFile, File relativeToPath) throws SVNClientException {
        String relativeStr = null;
        if (relativeToPath != null) {
            try {
                relativeStr = relativeToPath.isDirectory() ? relativeToPath.getCanonicalPath() : relativeToPath.getParentFile().getCanonicalPath();
            }
            catch (IOException e1) {
                relativeStr = relativeToPath.isDirectory() ? relativeToPath.getAbsolutePath() : relativeToPath.getParentFile().getAbsolutePath();
            }
            relativeStr = relativeStr + "/";
            relativeStr = relativeStr.replace('\\', '/');
        }
        FileInputStream fis = null;
        FileOutputStream fos = null;
        try {
            fis = new FileInputStream(tmpFile);
            fos = new FileOutputStream(outFile);
            byte[] b = new byte[fis.available()];
            fis.read(b);
            if (relativeToPath != null) {
                byte[] o = new String(b).replaceAll(relativeStr, "").getBytes();
                fos.write(o);
            } else {
                fos.write(b);
            }
        }
        catch (FileNotFoundException e) {
            throw new SVNClientException(e);
        }
        catch (IOException e) {
            throw new SVNClientException(e);
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException iOException) {}
        }
    }
}

