/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetDbSystemUpgradeHistoryEntryRequest
extends BmcRequest<Void> {
    private String dbSystemId;
    private String upgradeHistoryEntryId;
    private String opcRequestId;

    public String getDbSystemId() {
        return this.dbSystemId;
    }

    public String getUpgradeHistoryEntryId() {
        return this.upgradeHistoryEntryId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().dbSystemId(this.dbSystemId).upgradeHistoryEntryId(this.upgradeHistoryEntryId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",dbSystemId=").append(String.valueOf(this.dbSystemId));
        sb.append(",upgradeHistoryEntryId=").append(String.valueOf(this.upgradeHistoryEntryId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetDbSystemUpgradeHistoryEntryRequest)) {
            return false;
        }
        GetDbSystemUpgradeHistoryEntryRequest other = (GetDbSystemUpgradeHistoryEntryRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.dbSystemId, other.dbSystemId) && Objects.equals(this.upgradeHistoryEntryId, other.upgradeHistoryEntryId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.dbSystemId == null ? 43 : this.dbSystemId.hashCode());
        result = result * 59 + (this.upgradeHistoryEntryId == null ? 43 : this.upgradeHistoryEntryId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetDbSystemUpgradeHistoryEntryRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String dbSystemId = null;
        private String upgradeHistoryEntryId = null;
        private String opcRequestId = null;

        public Builder dbSystemId(String dbSystemId) {
            this.dbSystemId = dbSystemId;
            return this;
        }

        public Builder upgradeHistoryEntryId(String upgradeHistoryEntryId) {
            this.upgradeHistoryEntryId = upgradeHistoryEntryId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetDbSystemUpgradeHistoryEntryRequest o) {
            this.dbSystemId(o.getDbSystemId());
            this.upgradeHistoryEntryId(o.getUpgradeHistoryEntryId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetDbSystemUpgradeHistoryEntryRequest build() {
            GetDbSystemUpgradeHistoryEntryRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetDbSystemUpgradeHistoryEntryRequest buildWithoutInvocationCallback() {
            GetDbSystemUpgradeHistoryEntryRequest request = new GetDbSystemUpgradeHistoryEntryRequest();
            request.dbSystemId = this.dbSystemId;
            request.upgradeHistoryEntryId = this.upgradeHistoryEntryId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

