/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.editor;

import java.lang.invoke.CallSite;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.text.Document;
import org.netbeans.api.html.lexer.HTMLTokenId;
import org.netbeans.api.lexer.InputAttributes;
import org.netbeans.modules.html.editor.api.gsf.HtmlParserResult;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.spi.ParserResultTask;
import org.netbeans.modules.parsing.spi.Scheduler;
import org.netbeans.modules.parsing.spi.SchedulerEvent;
import org.netbeans.modules.parsing.spi.SchedulerTask;
import org.netbeans.modules.parsing.spi.TaskFactory;
import org.netbeans.modules.web.jsf.editor.JsfSupportImpl;
import org.netbeans.modules.web.jsfapi.api.Attribute;
import org.netbeans.modules.web.jsfapi.api.DefaultLibraryInfo;
import org.netbeans.modules.web.jsfapi.api.Library;
import org.netbeans.modules.web.jsfapi.api.LibraryComponent;
import org.netbeans.modules.web.jsfapi.api.LibraryInfo;
import org.netbeans.modules.web.jsfapi.api.Tag;

public final class HtmlSourceTask
extends ParserResultTask<HtmlParserResult> {
    private static final String CSS_CLASS_MAP_PROPERTY_KEY = "cssClassTagAttrMap";
    private static final String CLASS = "Class";
    private static final String CLASSES = "Classes";
    private static final EnumSet<DefaultLibraryInfo> LIBRARIES_TO_SKIP = EnumSet.of(DefaultLibraryInfo.FACELETS, new DefaultLibraryInfo[]{DefaultLibraryInfo.JSF, DefaultLibraryInfo.COMPOSITE, DefaultLibraryInfo.JSF_CORE, DefaultLibraryInfo.JSTL_CORE, DefaultLibraryInfo.JSTL_CORE_FUNCTIONS, DefaultLibraryInfo.PASSTHROUGH});

    public int getPriority() {
        return 50;
    }

    public Class<? extends Scheduler> getSchedulerClass() {
        return Scheduler.EDITOR_SENSITIVE_TASK_SCHEDULER;
    }

    public void cancel() {
    }

    public void run(HtmlParserResult result, SchedulerEvent event) {
        Source source = result.getSnapshot().getSource();
        if (!source.getMimeType().equals("text/xhtml")) {
            return;
        }
        JsfSupportImpl sup = JsfSupportImpl.findFor(source);
        if (sup == null) {
            return;
        }
        Document doc = result.getSnapshot().getSource().getDocument(true);
        if (doc == null) {
            return;
        }
        InputAttributes inputAttributes = (InputAttributes)doc.getProperty(InputAttributes.class);
        if (inputAttributes == null) {
            inputAttributes = new InputAttributes();
            doc.putProperty(InputAttributes.class, inputAttributes);
        }
        HashMap<CallSite, List<String>> cssClassTagAttrMap = new HashMap<CallSite, List<String>>();
        for (Map.Entry entry : result.getNamespaces().entrySet()) {
            Library lib;
            DefaultLibraryInfo dli;
            String namespace;
            LibraryInfo libraryInfo;
            String prefix = (String)entry.getValue();
            if (prefix == null || (libraryInfo = DefaultLibraryInfo.forNamespace((String)(namespace = (String)entry.getKey()))) instanceof DefaultLibraryInfo && LIBRARIES_TO_SKIP.contains(dli = (DefaultLibraryInfo)libraryInfo) || (lib = sup.getLibrary(namespace)) == null) continue;
            Collection components = lib.getComponents();
            for (LibraryComponent comp : components) {
                List<String> cssClassAttributes;
                Tag tag = comp.getTag();
                if (tag == null || (cssClassAttributes = tag.getAttributes().stream().map(Attribute::getName).filter(name -> name.endsWith(CLASS) || name.endsWith(CLASSES)).toList()).isEmpty()) continue;
                cssClassTagAttrMap.put((CallSite)((Object)(prefix + ":" + tag.getName())), cssClassAttributes);
            }
        }
        inputAttributes.setValue(HTMLTokenId.language(), (Object)CSS_CLASS_MAP_PROPERTY_KEY, cssClassTagAttrMap, true);
    }

    public static class Factory
    extends TaskFactory {
        public Collection<? extends SchedulerTask> create(Snapshot snapshot) {
            String mimeType = snapshot.getMimeType();
            if (mimeType.equals("text/html")) {
                return Collections.singletonList(new HtmlSourceTask());
            }
            return Collections.emptyList();
        }
    }
}

