/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.git.coverage;

import com.intellij.openapi.util.registry.Registry;
import com.intellij.vcs.git.coverage.CurrentFeatureBranchBaseDetector;
import com.intellij.vcs.log.graph.api.LinearGraph;
import com.intellij.vcs.log.graph.api.LiteLinearGraph;
import com.intellij.vcs.log.graph.utils.BfsWalk;
import com.intellij.vcs.log.graph.utils.DfsWalk;
import com.intellij.vcs.log.graph.utils.Flags;
import com.intellij.vcs.log.graph.utils.LinearGraphUtils;
import com.intellij.vcs.log.graph.utils.impl.BitSetFlags;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a.\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u00062\u0010\u0010\u0007\u001a\f\u0012\b\u0012\u00060\u0005j\u0002`\u00060\bH\u0001\u001a=\u0010\t\u001a\u0004\u0018\u00010\u00052\n\u0010\n\u001a\u00060\u0005j\u0002`\u00062\u0006\u0010\u0002\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0010\u0010\u0007\u001a\f\u0012\b\u0012\u00060\u0005j\u0002`\u00060\bH\u0002\u00a2\u0006\u0002\u0010\u000e\u00a8\u0006\u000f"}, d2={"findBaseCommit", "Lcom/intellij/vcs/git/coverage/CurrentFeatureBranchBaseDetector$Status;", "linearGraph", "Lcom/intellij/vcs/log/graph/api/LinearGraph;", "headNodeId", "", "Lcom/intellij/vcs/log/graph/api/permanent/VcsLogGraphNodeId;", "protectedNodeIds", "", "findProtectedBranchNodeId", "nodeId", "Lcom/intellij/vcs/log/graph/api/LiteLinearGraph;", "visited", "Lcom/intellij/vcs/log/graph/utils/impl/BitSetFlags;", "(ILcom/intellij/vcs/log/graph/api/LiteLinearGraph;Lcom/intellij/vcs/log/graph/utils/impl/BitSetFlags;Ljava/util/Set;)Ljava/lang/Integer;", "intellij.vcs.git.coverage"})
public final class CurrentFeatureBranchBaseDetectorKt {
    @VisibleForTesting
    @NotNull
    public static final CurrentFeatureBranchBaseDetector.Status findBaseCommit(@NotNull LinearGraph linearGraph, int headNodeId, @NotNull Set<Integer> protectedNodeIds) {
        Intrinsics.checkNotNullParameter((Object)linearGraph, (String)"linearGraph");
        Intrinsics.checkNotNullParameter(protectedNodeIds, (String)"protectedNodeIds");
        LiteLinearGraph liteLinearGraph = LinearGraphUtils.asLiteLinearGraph((LinearGraph)linearGraph);
        Intrinsics.checkNotNullExpressionValue((Object)liteLinearGraph, (String)"asLiteLinearGraph(...)");
        LiteLinearGraph graph = liteLinearGraph;
        BitSetFlags visited = new BitSetFlags(graph.nodesCount());
        if (CurrentFeatureBranchBaseDetectorKt.findProtectedBranchNodeId(headNodeId, graph, visited, protectedNodeIds) != null) {
            return CurrentFeatureBranchBaseDetector.Status.HeadInProtectedBranch.INSTANCE;
        }
        visited.set(headNodeId, false);
        BfsWalk bfsWalk = new BfsWalk(headNodeId, graph, (Flags)visited, false, 8, null);
        List foundCommits = new ArrayList();
        int searchLimit = Registry.Companion.intValue("coverage.git.log.commit.search.depth", 100);
        int searchDepth = 0;
        block0: while (true) {
            if (searchDepth++ > searchLimit) {
                if (!((Collection)foundCommits).isEmpty()) break;
                return CurrentFeatureBranchBaseDetector.Status.SearchLimitReached.INSTANCE;
            }
            List nextLayer = BfsWalk.step$default((BfsWalk)bfsWalk, null, (int)1, null);
            if (nextLayer.isEmpty()) break;
            HashSet<Integer> protectedCommits = new HashSet<Integer>();
            Iterator iterator = nextLayer.iterator();
            while (iterator.hasNext()) {
                int commit = ((Number)iterator.next()).intValue();
                Integer n = CurrentFeatureBranchBaseDetectorKt.findProtectedBranchNodeId(commit, graph, visited, protectedNodeIds);
                if (n == null) {
                    continue;
                }
                int protectedNodeId = n;
                ((Collection)foundCommits).add(new CurrentFeatureBranchBaseDetector.BaseCommit(commit, protectedNodeId));
                protectedCommits.add(commit);
            }
            iterator = nextLayer.iterator();
            while (true) {
                if (!iterator.hasNext()) continue block0;
                int nodeId = ((Number)iterator.next()).intValue();
                if (protectedCommits.contains(nodeId)) continue;
                visited.set(nodeId, false);
            }
            break;
        }
        if (foundCommits.isEmpty()) {
            return CurrentFeatureBranchBaseDetector.Status.CommitHasNoProtectedParents.INSTANCE;
        }
        return new CurrentFeatureBranchBaseDetector.Status.InternalSuccess(foundCommits);
    }

    private static final Integer findProtectedBranchNodeId(int nodeId, LiteLinearGraph linearGraph, BitSetFlags visited, Set<Integer> protectedNodeIds) {
        Ref.ObjectRef protectedNodeId = new Ref.ObjectRef();
        new DfsWalk((Collection)CollectionsKt.listOf((Object)nodeId), linearGraph, (Flags)visited).walk(false, arg_0 -> CurrentFeatureBranchBaseDetectorKt.findProtectedBranchNodeId$lambda$0(protectedNodeIds, protectedNodeId, arg_0));
        return (Integer)protectedNodeId.element;
    }

    private static final boolean findProtectedBranchNodeId$lambda$0(Set $protectedNodeIds, Ref.ObjectRef $protectedNodeId, int nodeId) {
        boolean bl;
        if ($protectedNodeIds.contains(nodeId)) {
            $protectedNodeId.element = nodeId;
            bl = false;
        } else {
            bl = true;
        }
        return bl;
    }
}

