/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.settings.local;

import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.metrics.ObservableLongMeasurement;
import io.opentelemetry.api.metrics.ObservableMeasurement;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/platform/settings/local/Measurer;", "", "meter", "Lio/opentelemetry/api/metrics/Meter;", "subKey", "", "<init>", "(Lio/opentelemetry/api/metrics/Meter;Ljava/lang/String;)V", "time", "Ljava/util/concurrent/atomic/LongAdder;", "counter", "timeObserver", "Lio/opentelemetry/api/metrics/ObservableLongMeasurement;", "kotlin.jvm.PlatformType", "counterObserver", "add", "", "nano", "", "intellij.platform.settings.local"})
final class Measurer {
    @NotNull
    private final LongAdder time;
    @NotNull
    private final LongAdder counter;
    private final ObservableLongMeasurement timeObserver;
    private final ObservableLongMeasurement counterObserver;

    public Measurer(@NotNull Meter meter, @NotNull String subKey) {
        Intrinsics.checkNotNullParameter((Object)meter, (String)"meter");
        Intrinsics.checkNotNullParameter((Object)subKey, (String)"subKey");
        this.time = new LongAdder();
        this.counter = new LongAdder();
        this.timeObserver = meter.counterBuilder("cacheStateStorage." + subKey + ".duration").buildObserver();
        this.counterObserver = meter.counterBuilder("cacheStateStorage." + subKey + ".counter").buildObserver();
        ObservableMeasurement[] observableMeasurementArray = new ObservableMeasurement[]{this.timeObserver};
        meter.batchCallback(() -> Measurer._init_$lambda$0(this), (ObservableMeasurement)this.counterObserver, observableMeasurementArray);
    }

    public final void add(long nano) {
        this.time.add(nano);
        this.counter.increment();
    }

    private static final void _init_$lambda$0(Measurer this$0) {
        this$0.timeObserver.record(TimeUnit.NANOSECONDS.toMillis(this$0.time.sum()));
        this$0.counterObserver.record(this$0.counter.sum());
    }
}

