/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute;

import io.quarkus.qute.Expression;
import io.quarkus.qute.RawString;
import io.quarkus.qute.ResultMapper;
import io.quarkus.qute.TemplateNode;
import io.quarkus.qute.Variant;
import java.util.Arrays;
import java.util.Optional;

public final class JsonEscaper
implements ResultMapper {
    private static final int LENGTH_BITS_OFFSET = 24;
    private static final int SECOND_CHAR_OFFSET = 8;
    private static final int MAX_LATIN_CHAR = 255;
    private static final int NO_REPLACEMENT_DATA = JsonEscaper.packReplacementData(0, 0, 1);
    private static final int[] REPLACEMENTS_DATA = JsonEscaper.createReplacementData();
    private static final char[][] CTRL_REPLACEMENTS = new char[32][];

    private static int packReplacementData(int first, int second, int length) {
        if (length != 1 && length != 2 && length != 6) {
            throw new IllegalArgumentException("Length must be 1, 2 or 6 but was: " + length);
        }
        if (first < 0 || first > 255) {
            throw new IllegalArgumentException("First char must be in range [0, 255] but was: " + first);
        }
        if (second < 0 || second > 255) {
            throw new IllegalArgumentException("Second char must be in range [0, 255] but was: " + second);
        }
        return first | second << 8 | length << 24;
    }

    private static int replacementLength(int replacementData) {
        return replacementData >> 24;
    }

    private static char secondChar(int replacementData) {
        return (char)(replacementData >> 8);
    }

    private static char firstChar(int replacementData) {
        return (char)(replacementData & 0xFF);
    }

    private static int toLatinChar(int c) {
        return c & 0xFF;
    }

    private static int replacementDataOf(char c) {
        if (c > '\u00ff') {
            return NO_REPLACEMENT_DATA;
        }
        return REPLACEMENTS_DATA[JsonEscaper.toLatinChar(c)];
    }

    private static void writeReplacementData(char[] out, int pos, int replacementData) {
        out[pos] = JsonEscaper.firstChar(replacementData);
        out[pos + 1] = JsonEscaper.secondChar(replacementData);
    }

    private static int[] createReplacementData() {
        int[] table = new int[256];
        Arrays.fill(table, 0, 32, JsonEscaper.packReplacementData(0, 0, 6));
        for (int i = 32; i < 256; ++i) {
            table[i] = JsonEscaper.packReplacementData(i, 0, 1);
        }
        table[34] = JsonEscaper.packReplacementData(92, 34, 2);
        table[92] = JsonEscaper.packReplacementData(92, 92, 2);
        table[13] = JsonEscaper.packReplacementData(92, 114, 2);
        table[8] = JsonEscaper.packReplacementData(92, 98, 2);
        table[10] = JsonEscaper.packReplacementData(92, 110, 2);
        table[9] = JsonEscaper.packReplacementData(92, 116, 2);
        table[12] = JsonEscaper.packReplacementData(92, 102, 2);
        table[47] = JsonEscaper.packReplacementData(92, 47, 2);
        return table;
    }

    private static char[] doEscapeCtrl(int c) {
        char[] replacement = CTRL_REPLACEMENTS[c];
        if (replacement == null) {
            replacement = String.format("\\u%04x", c).toCharArray();
            assert (replacement.length == 6);
            JsonEscaper.CTRL_REPLACEMENTS[c] = replacement;
        }
        return replacement;
    }

    static String escape(String toEscape) {
        for (int i = 0; i < toEscape.length(); ++i) {
            char c = toEscape.charAt(i);
            int replacementLength = JsonEscaper.replacementLength(JsonEscaper.replacementDataOf(c));
            if (replacementLength <= 1) continue;
            return JsonEscaper.doEscape(toEscape, i, replacementLength);
        }
        return toEscape;
    }

    private static String doEscape(String value, int firstToReplace, int firstReplacementLength) {
        assert (firstReplacementLength > 1);
        int remainingChars = value.length() - firstToReplace;
        assert (remainingChars >= 1);
        char[] buffer = new char[firstToReplace + firstReplacementLength + (remainingChars - 1) * 2];
        value.getChars(0, firstToReplace, buffer, 0);
        int outputLength = firstToReplace;
        for (int i = 0; i < remainingChars; ++i) {
            char c = value.charAt(firstToReplace + i);
            if (c <= '\u00ff') {
                int latinChar = JsonEscaper.toLatinChar(c);
                int replacementData = REPLACEMENTS_DATA[latinChar];
                int replacementLength = JsonEscaper.replacementLength(replacementData);
                if (replacementLength == 6) {
                    char[] ctrlEscape = JsonEscaper.doEscapeCtrl(c);
                    buffer = JsonEscaper.ensureCapacity(buffer, outputLength, 6, remainingChars - i - 1);
                    System.arraycopy(ctrlEscape, 0, buffer, outputLength, ctrlEscape.length);
                    outputLength += 6;
                    continue;
                }
                assert (replacementLength == 1 || replacementLength == 2);
                buffer = JsonEscaper.ensureCapacity(buffer, outputLength, 2, remainingChars - i - 1);
                JsonEscaper.writeReplacementData(buffer, outputLength, replacementData);
                outputLength += replacementLength;
                continue;
            }
            buffer = JsonEscaper.ensureCapacity(buffer, outputLength, 1, remainingChars - i - 1);
            buffer[outputLength++] = c;
        }
        return new String(buffer, 0, outputLength);
    }

    private static char[] ensureCapacity(char[] buffer, int currentLength, int additionalLength, int remainingChars) {
        if (currentLength + additionalLength > buffer.length) {
            assert (remainingChars >= 0);
            return JsonEscaper.enlargeBuffer(buffer, currentLength, additionalLength, remainingChars);
        }
        return buffer;
    }

    private static char[] enlargeBuffer(char[] buffer, int currentLength, int additionalLength, int remainingChars) {
        int newLength = currentLength + additionalLength + remainingChars * 2;
        char[] newBuffer = new char[newLength];
        System.arraycopy(buffer, 0, newBuffer, 0, currentLength);
        return newBuffer;
    }

    @Override
    public boolean appliesTo(TemplateNode.Origin origin, Object result) {
        String contentType;
        if (result instanceof RawString) {
            return false;
        }
        Optional<Variant> variant = origin.getVariant();
        if (variant.isPresent() && (contentType = variant.get().getContentType()) != null) {
            return contentType.startsWith("application/json");
        }
        return false;
    }

    @Override
    public String map(Object result, Expression expression) {
        return JsonEscaper.escape(result.toString());
    }
}

