/*
 * Decompiled with CFR 0.152.
 */
package de.escape.quincunx.dxf;

import de.escape.quincunx.dxf.DxfColorModel;
import de.escape.quincunx.dxf.LineStyle;
import de.escape.quincunx.dxf.LineStyleManager;
import de.escape.quincunx.dxf.reader.DxfLAYER;
import de.escape.quincunx.trafo.Matrix4D;
import de.escape.quincunx.trafo.Point3D;
import de.escape.quincunx.trafo.Vector3D;
import java.awt.Graphics;

public abstract class DrawAble {
    protected DxfLAYER layer;
    protected short color;
    protected String lineType;

    public abstract void draw(Graphics var1, Matrix4D var2, DxfLAYER var3, DxfColorModel var4, short var5);

    public void draw(Graphics g, Matrix4D mat, DxfLAYER insLayer, DxfColorModel colorModel, short insColor, LineStyleManager lineStyles, LineStyle insLStyle) {
        this.draw(g, mat, insLayer, colorModel, insColor);
    }

    public abstract void draw(Graphics var1, Matrix4D var2, DxfLAYER var3, DxfColorModel var4, short var5, int var6, int var7);

    public abstract int calcBB(Point3D var1, Point3D var2, Matrix4D var3, DxfLAYER var4, boolean var5);

    public abstract void transformBy(Matrix4D var1);

    public void setLayer(DxfLAYER l) {
        this.layer = l;
    }

    public void setColor(short c) {
        this.color = c;
    }

    public boolean isVisible(DxfLAYER insertLayer) {
        DxfLAYER myLayer = this.getCorrectLayer(insertLayer);
        if (myLayer != null) {
            return myLayer.getVisibility();
        }
        return true;
    }

    public DxfLAYER getCorrectLayer(DxfLAYER insertLayer) {
        if (this.layer != null && !this.layer.isLayer0()) {
            return this.layer;
        }
        return insertLayer;
    }

    public short calcColor(short insColor, DxfLAYER insLayer) {
        short retColor = this.color == 0 ? insColor : this.color;
        if (retColor == -1) {
            if (this.layer != null && !this.layer.isLayer0()) {
                retColor = this.layer.getColor();
            } else if (insLayer != null) {
                retColor = insLayer.getColor();
            }
        }
        return retColor;
    }

    public DrawAble extrude(float dist) {
        return this.extrude(dist, new Vector3D(0.0f, 0.0f, 1.0f));
    }

    public abstract DrawAble extrude(float var1, Vector3D var2);

    public void setLineTypeName(String ltype) {
        this.lineType = ltype;
    }
}

