<?php
/*********************************************************************************
 * The contents of this file are subject to the TimeTrex Public License Version
 * 1.1.0 ("License"); You may not use this file except in compliance with the
 * License. You may obtain a copy of the License at http://www.TimeTrex.com/TPL
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * All copies of the Covered Code must include on each user interface screen:
 *    (i) the "Powered by TimeTrex" logo and
 *    (ii) the TimeTrex copyright notice
 * in the same form as they appear in the distribution.  See full license for
 * requirements.
 *
 * The Original Code is: TimeTrex Open Source
 * The Initial Developer of the Original Code is TimeTrex Payroll Services
 * Portions created by TimeTrex are Copyright (C) 2004-2007 TimeTrex Payroll Services;
 * All Rights Reserved.
 *
 ********************************************************************************/
/*
 * $Revision: 2308 $
 * $Id: MD_ALL.class.php 2308 2008-12-22 23:06:24Z ipso $
 * $Date: 2008-12-22 15:06:24 -0800 (Mon, 22 Dec 2008) $
 */

/**
 * @package PayrollDeduction
 */
class PayrollDeduction_US_MD_ALL extends PayrollDeduction_US_MD {

	var $district_options = array(
								//01-Jan-09: No change.
								1214899200 => array(
													'standard_deduction_rate' => 15,
													'standard_deduction_minimum' => 1500,
													'standard_deduction_maximum' => 2000,
													'allowance' => 3200
													),
								1136102400 => array(
													'standard_deduction_rate' => 15,
													'standard_deduction_minimum' => 1500,
													'standard_deduction_maximum' => 2000,
													'allowance' => 2400
													)
								);

	function getDistrictPayPeriodDeductions() {
		return bcdiv($this->getDistrictTaxPayable(), $this->getAnnualPayPeriods() );
	}

	function getDistrictAnnualTaxableIncome() {
		$annual_income = $this->getAnnualTaxableIncome();
		$standard_deduction = $this->getDistrictStandardDeductionAmount();
		$district_allowance = $this->getDistrictAllowanceAmount();

		$income = bcsub( bcsub( $annual_income, $standard_deduction), $district_allowance);

		Debug::text('District Annual Taxable Income: '. $income, __FILE__, __LINE__, __METHOD__,10);

		return $income;
	}

	function getDistrictStandardDeductionAmount() {
		$retarr = $this->getDataFromRateArray($this->getDate(), $this->district_options);
		if ( $retarr == FALSE ) {
			return FALSE;
		}

		$rate = bcdiv( $retarr['standard_deduction_rate'], 100);

		$deduction = bcmul( $this->getAnnualTaxableIncome(), $rate );

		if ( $deduction < $retarr['standard_deduction_minimum'] ) {
			$retval = $retarr['standard_deduction_minimum'];
		} elseif ( $deduction > $retarr['standard_deduction_maximum'] ) {
			$retval = $retarr['standard_deduction_maximum'];
		} else {
			$retval = $deduction;
		}

		Debug::text('District Standard Deduction Amount: '. $retval, __FILE__, __LINE__, __METHOD__,10);

		return $retval;
	}

	function getDistrictAllowanceAmount() {
		$retarr = $this->getDataFromRateArray($this->getDate(), $this->district_options);
		if ( $retarr == FALSE ) {
			return FALSE;
		}

		$allowance_arr = $retarr['allowance'];

		$retval = bcmul( $this->getDistrictAllowance(), $allowance_arr );

		Debug::text('District Allowance Amount: '. $retval, __FILE__, __LINE__, __METHOD__,10);

		return $retval;
	}

	function getDistrictTaxPayable() {
		$annual_income = $this->getDistrictAnnualTaxableIncome();

		$rate = bcdiv( $this->getUserValue1(), 100 );

		$retval = bcmul( $annual_income, $rate );

		if ( $retval < 0 ) {
			$retval = 0;
		}

		Debug::text('District Annual Tax Payable: '. $retval, __FILE__, __LINE__, __METHOD__,10);

		return $retval;
	}
}
?>
