<?php
/*********************************************************************************
 * The contents of this file are subject to the TimeTrex Public License Version
 * 1.1.0 ("License"); You may not use this file except in compliance with the
 * License. You may obtain a copy of the License at http://www.TimeTrex.com/TPL
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * All copies of the Covered Code must include on each user interface screen:
 *    (i) the "Powered by TimeTrex" logo and
 *    (ii) the TimeTrex copyright notice
 * in the same form as they appear in the distribution.  See full license for
 * requirements.
 *
 * The Original Code is: TimeTrex Open Source
 * The Initial Developer of the Original Code is TimeTrex Payroll Services
 * Portions created by TimeTrex are Copyright (C) 2004-2007 TimeTrex Payroll Services;
 * All Rights Reserved.
 *
 ********************************************************************************/
/*
 * $Revision: 1246 $
 * $Id: EditStationUser.php 1246 2007-09-14 23:47:42Z ipso $
 * $Date: 2007-09-14 16:47:42 -0700 (Fri, 14 Sep 2007) $
 */
require_once('../../includes/global.inc.php');
require_once(Environment::getBasePath() .'includes/Interface.inc.php');

if ( !$permission->Check('station','enabled')
		OR !( $permission->Check('station','assign') ) ) {

	$permission->Redirect( FALSE ); //Redirect

}

$smarty->assign('title', TTi18n::gettext($title = 'Edit Station')); // See index.php

/*
 * Get FORM variables
 */
extract	(FormVariables::GetVariables(
										array	(
												'action',
												'id',
												'station_data'
												) ) );

$sf = new StationFactory();

$action = Misc::findSubmitButton();
switch ($action) {
	case 'submit':
		Debug::Text('Submit!', __FILE__, __LINE__, __METHOD__,10);

		Debug::Arr($station_data['user_ids'],'Selected Users', __FILE__, __LINE__, __METHOD__,10);

		$sf->setId($station_data['id']);
		$sf->setUser( $station_data['user_ids'] );

		if ( $sf->isValid() ) {
			$sf->Save(FALSE);

			Redirect::Page( URLBuilder::getURL(NULL, 'StationList.php') );

			break;
		}

	default:
		if ( isset($station_data['id']) ) {
			$id = $station_data['id'];
		}

		if ( isset($id) ) {
			BreadCrumb::setCrumb($title);

			$slf = new StationListFactory();
			$sulf = new StationUserListFactory();

			$slf->GetByIdAndCompanyId($id, $current_company->getId() );

			foreach ($slf as $station) {
				//Debug::Arr($station,'Department', __FILE__, __LINE__, __METHOD__,10);

				if ( isset( $station_data['user_ids'] ) ) {
					Debug::Text('Using Selected Users', __FILE__, __LINE__, __METHOD__,10);
					//Use selected values
                    $user_ids = $station_data['user_ids'];
				} else {
					Debug::Text('Grabbing Users from DB', __FILE__, __LINE__, __METHOD__,10);
					$sulf->getByStationId( $station->getId() );

					$user_ids = array();
					foreach ($sulf as $station_user) {
						$user_ids[] = $station_user->getUser();
					}
				}
				$station_data = array(
									'id' => $station->getId(),
									'status' => TTi18n::gettext($station->getStatus()),
									'type' => $station->getType(),
									'station' => $station->getStation(),
									'source' => $station->getSource(),
									'description' => $station->getDescription(),
									'user_ids' => $user_ids,
									'created_date' => $station->getCreatedDate(),
									'created_by' => $station->getCreatedBy(),
									'updated_date' => $station->getUpdatedDate(),
									'updated_by' => $station->getUpdatedBy(),
									'deleted_date' => $station->getDeletedDate(),
									'deleted_by' => $station->getDeletedBy()
								);
			}
		}

		//Select box options;
		$station_data['status_options'] = $sf->getOptions('status');
		$station_data['type_options'] = $sf->getOptions('type');

		$user_options = UserListFactory::getByCompanyIdArray( $current_company->getId(), FALSE );
		$user_options = Misc::prependArray( array( -1 => TTi18n::gettext('-- ALL --')), $user_options );
		$station_data['user_options'] = $user_options;

		$smarty->assign_by_ref('station_data', $station_data);

		break;
}

$smarty->assign_by_ref('sf', $sf);

$smarty->display('station/EditStationUser.tpl');
?>