<?php
/*********************************************************************************
 * The contents of this file are subject to the TimeTrex Public License Version
 * 1.1.0 ("License"); You may not use this file except in compliance with the
 * License. You may obtain a copy of the License at http://www.TimeTrex.com/TPL
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * All copies of the Covered Code must include on each user interface screen:
 *    (i) the "Powered by TimeTrex" logo and
 *    (ii) the TimeTrex copyright notice
 * in the same form as they appear in the distribution.  See full license for
 * requirements.
 *
 * The Original Code is: TimeTrex Open Source
 * The Initial Developer of the Original Code is TimeTrex Payroll Services
 * Portions created by TimeTrex are Copyright (C) 2004-2007 TimeTrex Payroll Services;
 * All Rights Reserved.
 *
 ********************************************************************************/
/*
 * $Revision: 2095 $
 * $Id: fix_hierarchy.php 2095 2008-09-01 07:04:25Z ipso $
 * $Date: 2008-09-01 00:04:25 -0700 (Mon, 01 Sep 2008) $
 */
require_once( dirname(__FILE__) . DIRECTORY_SEPARATOR .'..'. DIRECTORY_SEPARATOR .'includes'. DIRECTORY_SEPARATOR .'global.inc.php');
require_once( dirname(__FILE__) . DIRECTORY_SEPARATOR .'..'. DIRECTORY_SEPARATOR .'includes'. DIRECTORY_SEPARATOR .'CLI.inc.php');
require_once( dirname(__FILE__) . DIRECTORY_SEPARATOR .'..'. DIRECTORY_SEPARATOR .'classes/payroll_deduction/PayrollDeduction.class.php');

if ( $argc < 2 OR in_array ($argv[1], array('--help', '-help', '-h', '-?') ) ) {
	$help_output = "Usage: generate_payroll_deduction_test_csv.php [country_code] [date]\n";
	echo $help_output;
} else {
	$country = $argv[1];
	$effective_date = strtotime($argv[2]);

	$cf = new CompanyFactory();
	$province_arr = $cf->getOptions('province');
	if ( !isset($province_arr[$country]) ) {
		echo "Country does not have any province/states.\n";
	}

	$pay_periods = 26;
	$static_test_data = array(
					   'US' => array(
									'income' => array(
														192, //5000/year
														384, //10000/year
														961, //25000/year
														1923, //50000,
														3846, //100000,
														9615, //250000
														),
									'filing_status' => array(10,20),
									'allowance' => array(0,1,2,3,5),
									)
						);

	$test_data = array();

	if ( $country != '' AND isset($province_arr[$country]) AND $effective_date != '' ) {
		foreach( $province_arr[$country] as $province_code => $province ) {
			//echo "Province: $province_code\n";

			//Get all tax rates for each province.
			switch ( $country ) {
				case 'US':
					$table = 'income_tax_rate_us';
					$province_name = 'state';
					break;
				case 'CR':
					$table = 'income_tax_rate_cr';
					$province_name = 'state';
					break;
				case 'CA':
					$table = 'income_tax_rate';
					$province_name = 'province';
					break;
			}

			$ph = array(
						'country' => $country,
						'province' => $province_code,
						'effective_date' => $effective_date,
						);

			$query = 'select * from '. $table .'
						where country = ? and '.$province_name .' = ? and effective_date >= ?
						order by effective_date asc, status, income';
			$result = $db->Execute($query, $ph);

			//echo 'Tax Bracket Rows: '. $result->RecordCount() ."\n";
			if ( $result->RecordCount() == 0 ) {
				//Use static test rates.
				$test_data[$country][$province_code] = $static_test_data[$country];
			} else {
				$i=1;
				$prev_income = NULL;
				$prev_status = NULL;
				$prev_province = NULL;
				foreach( $result as $tax_row ) {
					//Test $100 less then the first bracket, and $100 more then all other brackets for each status.
					$income = round($tax_row['income'] / $pay_periods);
					$variance = round(100 / $pay_periods);

					if ( $prev_income == NULL OR $prev_income > $income ) {
						//echo "First bracket! $country $province ".$tax_row['income']." T: ". ($tax_row['income']-$variance) ."\n";
						$test_data[$country][$province_code]['income'][] = $income-$variance;
						$test_data[$country][$province_code]['filing_status'][] = $tax_row['status'];
					}

					$test_data[$country][$province_code]['income'][] = $income+$variance;
					$test_data[$country][$province_code]['filing_status'][] = $tax_row['status'];
					$test_data[$country][$province_code]['allowance'] = $static_test_data[$country]['allowance'];

					$test_data[$country][$province_code]['income'] = array_unique($test_data[$country][$province_code]['income']);
					$test_data[$country][$province_code]['filing_status'] = array_unique($test_data[$country][$province_code]['filing_status']);

					$prev_income = $income;
					$prev_status = $tax_row['status'];
					$prev_province = $province_code;
					$i++;
					unset($income);
				}
			}


			foreach( $test_data[$country][$province_code]['filing_status'] as $filing_status ) {
				foreach( $test_data[$country][$province_code]['allowance'] as $allowance ) {
					foreach( $test_data[$country][$province_code]['income'] as $income ) {
						$pd_obj = new PayrollDeduction( $country, $province_code);
						$pd_obj->setDate( $effective_date);
						$pd_obj->setAnnualPayPeriods( $pay_periods );

						//$pd_obj->setEICFilingStatus( 10 ); //Single
						$pd_obj->setFederalFilingStatus( $filing_status ); //Single
						$pd_obj->setFederalAllowance( $allowance );

						$pd_obj->setStateFilingStatus( $filing_status ); //Single
						$pd_obj->setStateAllowance( $allowance );

						$pd_obj->setFederalTaxExempt( FALSE );
						$pd_obj->setProvincialTaxExempt( FALSE );

						$pd_obj->setGrossPayPeriodIncome( $income );

						$retarr[] = array(
										'country' => $country,
										'province' => $province_code,
										'date' => date('m/d/y', $effective_date),
										'pay_periods' => $pay_periods,
										'filing_status' => $filing_status,
										'allowance' => $allowance,
										'gross_income' => $income,
										'federal_deduction' => Misc::MoneyFormat($pd_obj->getFederalPayPeriodDeductions(), FALSE),
										'provincial_deduction' => Misc::MoneyFormat($pd_obj->getStatePayPeriodDeductions(), FALSE)
										);
					}
				}
			}
		}

		//generate column array.
		$column_keys = array_keys($retarr[0]);
		foreach( $column_keys as $column_key ) {
			$columns[$column_key] = $column_key;
		}

		//var_dump($test_data);
		//var_dump($retarr);
		echo Misc::Array2CSV( $retarr, $columns, FALSE, $include_header = TRUE );
	}
}
//Debug::Display();
?>
