/* aewm - a minimalist X11 window mananager. vim:sw=4:ts=4:et
 * Copyright 1998-2004 Decklin Foster <decklin@red-bean.com>
 * This program is free software; see LICENSE for details. */

#include <gtk/gtk.h>
#include <gdk/gdkx.h>
#include "aeclients.h"
#include "launch.h"
#include "switch.h"

void make_launch_menu_item(menu_t, char *, char *);
menu_t make_launch_sub_menu(menu_t, char *);
void make_client_menu_item(unsigned char *, void *);
void fork_exec_cb(GtkWidget *, char *);
void raise_win_cb(GtkWidget *, Window);

int main(int argc, char **argv)
{
    GtkWidget *main_menu;
    int i, mode = LAUNCH;
    char *opt_config = NULL;

    gtk_init(&argc, &argv);

    for (i = 1; i < argc; i++) {
        if ARG("config", "rc", 1)  {
            opt_config = argv[++i];
            continue;
        }
        if ARG("launch", "l", 0)   {
            mode = LAUNCH;
            continue;
        }
        if ARG("switch", "s", 0)   {
            mode = SWITCH;
            continue;
        }
        /* nothing matched */
        fprintf(stderr, "usage: aemenu [--switch|-s] [--config|-rc <file>]\n");
        exit(2);
    }

    main_menu = gtk_menu_new();

    if (mode == LAUNCH) {
        make_launch_menu(opt_config, main_menu,
            make_launch_menu_item, make_launch_sub_menu);
    } else /* mode == SWITCH */ {
        dpy = GDK_DISPLAY();
        root = GDK_ROOT_WINDOW();
        wm_state = XInternAtom(dpy,
            "WM_STATE", False);
        net_client_list = XInternAtom(dpy,
            "_NET_CLIENT_LIST", False);
        net_current_desktop = XInternAtom(dpy,
            "_NET_CURRENT_DESKTOP", False);
        net_wm_desktop = XInternAtom(dpy,
            "_NET_WM_DESKTOP", False);
        net_wm_state = XInternAtom(dpy,
            "_NET_WM_STATE", False);
        net_wm_state_skip_taskbar = XInternAtom(dpy,
            "_NET_WM_STATE_SKIP_TASKBAR", False);
        net_wm_state_skip_pager = XInternAtom(dpy,
            "_NET_WM_STATE_SKIP_PAGER", False);
        atom_foreach(root, net_client_list, XA_WINDOW,
            make_client_menu_item, (void *)main_menu);
    }

    gtk_signal_connect_object(GTK_OBJECT(main_menu), "deactivate",
        GTK_SIGNAL_FUNC(gtk_main_quit), NULL);
    gtk_menu_popup(GTK_MENU(main_menu), NULL, NULL, NULL, NULL, 0, 0);

    gtk_main();
    return 0;
}

void make_launch_menu_item(menu_t menu, char *label, char *cmd)
{
    GtkWidget *item;

    item = gtk_menu_item_new_with_label(label);
    gtk_menu_append(GTK_MENU(menu), item);
    gtk_signal_connect(GTK_OBJECT(item), "activate",
        GTK_SIGNAL_FUNC(fork_exec_cb), cmd);
    gtk_widget_show(item);
}

menu_t make_launch_sub_menu(menu_t menu, char *label)
{
    GtkWidget *item, *new_menu;

    new_menu = gtk_menu_new();
    item = gtk_menu_item_new_with_label(label);
    gtk_menu_append(GTK_MENU(menu), item);
    gtk_menu_item_set_submenu(GTK_MENU_ITEM(item), new_menu);
    gtk_widget_show(item);

    return new_menu;
}

void make_client_menu_item(unsigned char *data, void *cb_data)
{
    Window w = *(Window *)data;
    GtkWidget *menu = GTK_WIDGET(cb_data);
    GtkWidget *item;
    char buf[BUF_SIZE];

    if (is_on_cur_desk(w) && !is_skip(w)) {
        get_wm_name(w, buf, sizeof buf);
        item = gtk_menu_item_new_with_label(buf);
        gtk_menu_append(GTK_MENU(menu), item);
        gtk_signal_connect(GTK_OBJECT(item), "activate",
            GTK_SIGNAL_FUNC(raise_win_cb), (gpointer)w);
        gtk_widget_show(item);
    }
}

void fork_exec_cb(GtkWidget *widget, char *data)
{
    fork_exec(data);
    gtk_main_quit();
}

void raise_win_cb(GtkWidget *widget, Window w)
{
    raise_win(w);
    gtk_main_quit();
}
