/* aewm - a minimalist X11 window mananager. vim:sw=4:ts=4:et
 * Copyright 1998-2004 Decklin Foster <decklin@red-bean.com>
 * This program is free software; see LICENSE for details. */

#include <X11/StringDefs.h>
#include <X11/Intrinsic.h>
#include <X11/IntrinsicP.h>
#include <X11/Xaw/Paned.h>
#include <X11/Xaw/SimpleMenu.h>
#include <X11/Xaw/SmeBSB.h>
#include <X11/Xaw/MenuButton.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Command.h>
#include "aeclients.h"
#include "launch.h"
#include "switch.h"
#include "panel.h"
#include "xaw-util.h"

#define NAME_SIZE 32

void add_launch_menu_item(menu_t, char *, char *);
menu_t add_launch_sub_menu(menu_t menu, char *label);
void make_client_button(menu_t, Window);
void update_client_button(unsigned char *, void *);
void cleanup_client_button(client_t *, Widget);
void check_event(Widget, XtPointer, XEvent *, Boolean *);
int ignore_xerror(Display *, XErrorEvent *);
void quit_cb(Widget, XtPointer, XtPointer);
void fork_exec_cb(Widget, XtPointer, XtPointer);
void raise_win_cb(Widget, XtPointer, XtPointer);

client_t *head_client = NULL;
Widget dummy;

int main(int argc, char **argv)
{
    Widget toplevel, paned, cmds_box, menu_button, launch_menu, quit_button;
    Widget clients_box;
    client_t *c;
    strut_t s = { 0, 0, 0, 0 };
    XWindowAttributes attr;
    int root_width, root_height;
    char *opt_config = NULL;
    int opt_bottom = 0;
    struct sigaction act;
    int i;

    toplevel = XtInitialize(argv[0], "AePanel", NULL, 0, &argc, argv);

    for (i = 1; i < argc; i++) {
        if ARG("config", "rc", 1)  {
            opt_config = argv[++i];
            continue;
        }
        if ARG("bottom", "b", 0)  {
            opt_bottom = 1;
            continue;
        }
        /* nothing matched */
        fprintf(stderr, "usage: aepanel [--bottom|-b] [--config|-rc <file>]\n");
        exit(2);
    }

    act.sa_handler = sig_handler;
    act.sa_flags = 0;
    sigaction(SIGCHLD, &act, NULL);

    dpy = XtDisplay(toplevel);
    root = DefaultRootWindow(dpy);
    XSetErrorHandler(ignore_xerror);

    wm_state = XInternAtom(dpy,
        "WM_STATE", False);
    net_client_list = XInternAtom(dpy,
        "_NET_CLIENT_LIST", False);
    net_current_desktop = XInternAtom(dpy,
        "_NET_CURRENT_DESKTOP", False);
    net_wm_desktop = XInternAtom(dpy,
        "_NET_WM_DESKTOP", False);
    net_wm_strut = XInternAtom(dpy,
        "_NET_WM_STRUT", False);
    net_wm_strut_partial = XInternAtom(dpy,
        "_NET_WM_STRUT_PARTIAL", False);
    net_wm_state = XInternAtom(dpy,
        "_NET_WM_STATE", False);
    net_wm_state_skip_taskbar = XInternAtom(dpy,
        "_NET_WM_STATE_SKIP_TASKBAR", False);
    net_wm_state_skip_pager = XInternAtom(dpy,
        "_NET_WM_STATE_SKIP_PAGER", False);
    net_wm_window_type = XInternAtom(dpy,
        "_NET_WM_WINDOW_TYPE", False);
    net_wm_window_type_dock = XInternAtom(dpy,
        "_NET_WM_WINDOW_TYPE_DOCK", False);

    paned = XtVaCreateManagedWidget("paned",
        panedWidgetClass, toplevel,
        XtNorientation, XtEhorizontal,
        XtNshowGrip, XtEfalse, NULL);
    cmds_box = XtVaCreateManagedWidget("commands",
        boxWidgetClass, paned,
        XtNorientation, XtEhorizontal, NULL);
    menu_button = XtVaCreateManagedWidget("Menu",
        menuButtonWidgetClass, cmds_box, NULL);
    launch_menu = XtVaCreatePopupShell("menu",
        simpleMenuWidgetClass, menu_button, NULL);
    quit_button = XtVaCreateManagedWidget("Quit",
        commandWidgetClass, cmds_box, NULL);
    XtAddCallback(quit_button,
        XtNcallback, quit_cb, NULL);
    clients_box = XtVaCreateManagedWidget("clients",
        boxWidgetClass, paned,
        XtNorientation, XtEhorizontal, NULL);

    dummy = XtVaCreateWidget("dummy",
        coreWidgetClass, toplevel, XtNwidth, 1, XtNheight, 1, NULL);
    XtRegisterDrawable(dpy, root, dummy);
    XSelectInput(dpy, root, PropertyChangeMask);
    XtAddRawEventHandler(dummy, PropertyChangeMask,
        False, check_event, clients_box);

    make_launch_menu(opt_config, launch_menu,
        add_launch_menu_item, add_launch_sub_menu);
    atom_foreach(root, net_client_list, XA_WINDOW,
        update_client_button, (void *)clients_box);
    for (c = head_client; c; c = c->next)
        cleanup_client_button(c, clients_box);

    XtRealizeWidget(toplevel);

    XtVaGetValues(toplevel, XtNheight, &attr.height,
        XtNwidth, &attr.width, NULL);

    append_to_atom(XtWindow(toplevel), net_wm_state, XA_ATOM,
        net_wm_state_skip_taskbar);
    append_to_atom(XtWindow(toplevel), net_wm_state, XA_ATOM,
        net_wm_state_skip_pager);
    set_atom(XtWindow(toplevel), net_wm_desktop, XA_CARDINAL,
        0xFFFFFFFF);
    set_atom(XtWindow(toplevel), net_wm_window_type, XA_ATOM,
        net_wm_window_type_dock);

    if (opt_bottom) s.bottom = attr.height;
    else s.top = attr.height;
    set_strut(XtWindow(toplevel), &s);

    root_width = DisplayWidth(dpy, DefaultScreen(dpy));
    root_height = DisplayHeight(dpy, DefaultScreen(dpy));

    XtMoveWidget(toplevel,
        0, opt_bottom ? root_height - attr.height : 0);
    XtResizeWidget(toplevel,
        root_width, attr.height, attr.border_width);

    XtMainLoop();
    return 0;
}

void add_launch_menu_item(menu_t menu, char *label, char *cmd)
{
    Widget menu_item = XtVaCreateManagedWidget(label,
        smeBSBObjectClass, menu, NULL);
    XtAddCallback(menu_item, XtNcallback,
        fork_exec_cb, cmd);
}

menu_t add_launch_sub_menu(menu_t menu, char *label)
{
    Widget new_menu, menu_item;

    new_menu = XtVaCreatePopupShell(label,
        simpleMenuWidgetClass, menu, NULL);
    menu_item = XtVaCreateManagedWidget(label,
        smeBSBObjectClass, menu,
        XtNmenuName, label, NULL);
    XtAddCallback(menu_item,
        XtNcallback, popup_cb, (XtPointer)new_menu);
    return new_menu;
}

void update_client_button(unsigned char *data, void *cb_data)
{
    Window w = *(Window *)data;
    Widget container = cb_data;
    client_t *c;
    char buf[NAME_SIZE];

    for (c = head_client; c; c = c->next) {
        if (c->window == w) {
            if (is_on_cur_desk(w))
                XtManageChild((Widget)c->widget);
            else
                XtUnmanageChild((Widget)c->widget);
            c->save = 1;
            return;
        }
    }

    if (is_on_cur_desk(w) && !is_skip(w)) {
        c = malloc(sizeof *c);
        c->next = head_client;
        head_client = c;
        c->window = w;
        c->save = 1;

        get_wm_name(w, buf, sizeof buf);
        c->widget = XtVaCreateManagedWidget(buf,
            commandWidgetClass, container, NULL);
        XtAddCallback((Widget)c->widget,
            XtNcallback, raise_win_cb, (XtPointer)w);

        XtRegisterDrawable(dpy, c->window, dummy);
        XSelectInput(dpy, c->window, PropertyChangeMask);
    }
}

void cleanup_client_button(client_t *c, Widget dummy)
{
    client_t *p;

    if (c->save) {
        c->save = 0;
    } else {
        XtDestroyWidget((Widget) c->widget);
        if (head_client == c) head_client = c->next;
        else for (p = head_client; p && p->next; p = p->next)
            if (p->next == c) p->next = c->next;
        free(c);
    }
}

void check_event(Widget w, XtPointer data, XEvent *e, Boolean *dispatch)
{
    client_t *c, *next;
    char buf[NAME_SIZE];

    if (e->type == PropertyNotify) {
        if (e->xproperty.window == root) {
            if (e->xproperty.atom == net_current_desktop ||
                    e->xproperty.atom == net_client_list) {
                atom_foreach(root, net_client_list, XA_WINDOW,
                    update_client_button, (void *)data);
                for (c = head_client; c; c = next) {
                    next = c->next;
                    cleanup_client_button(c, data);
                }
            }
        } else {
            for (c = head_client; c; c = c->next) {
                if (c->window == e->xproperty.window) {
                    get_wm_name(c->window, buf, sizeof buf);
                    XtVaSetValues((Widget)c->widget, XtNlabel, buf, NULL);
                }
            }
        }
    }
}

/* icky icky icky */

int ignore_xerror(Display *dpy, XErrorEvent *e)
{
    return 0;
}

void quit_cb(Widget w, XtPointer data, XtPointer call)
{
    exit(0);
}

void fork_exec_cb(Widget w, XtPointer data, XtPointer call)
{
    fork_exec(data);
}

void raise_win_cb(Widget w, XtPointer data, XtPointer call)
{
    raise_win((Window)data);
}
