/* aewm - a minimalist X11 window mananager. vim:sw=4:ts=4:et
 * Copyright 1998-2004 Decklin Foster <decklin@red-bean.com>
 * This program is free software; see LICENSE for details. */

#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <unistd.h>
#include <sys/types.h>
#include "switch.h"
#include "atom.h"

Display *dpy;
Window root;
Atom wm_state;
Atom net_client_list;
Atom net_current_desktop;
Atom net_wm_desktop;
Atom net_wm_state;
Atom net_wm_state_skip_taskbar;
Atom net_wm_state_skip_pager;

long get_wm_state(Window w)
{
    long state;

    if (get_atom(w, wm_state, wm_state, &state))
        return state;
    else
        return WithdrawnState;
}

void get_wm_name(Window w, char *buf, size_t len)
{
    char *name;

    XFetchName(dpy, w, &name);
    if (name) {
        if (get_wm_state(w) == NormalState) {
            if (strlen(name) >= len) strcpy(name+len-4, "...");
            strcpy(buf, name);
        } else {
            if (strlen(name) >= len-2) strcpy(name+len-6, "...");
            sprintf(buf, "[%s]", name);
        }
        XFree(name);
    } else {
        buf[0] = '\0';
    }
}

int is_on_cur_desk(Window w)
{
    long cur_desk, w_desk;

    if(get_atom(root, net_current_desktop, XA_CARDINAL, &cur_desk) &&
            get_atom(w, net_wm_desktop, XA_CARDINAL, &w_desk))
        return w_desk == cur_desk || w_desk == 0xFFFFFFFF;
    else
        return 1;
}

int is_skip(Window w)
{
    int skippy = 0;

    atom_foreach(w, net_wm_state, XA_ATOM, test_skip, &skippy);
    return skippy;
}

void test_skip(unsigned char *data, void *cb_data)
{
    Atom prop = *(Atom *)data;
    int *skip = cb_data;

    if (prop == net_wm_state_skip_taskbar || prop == net_wm_state_skip_pager)
        *skip = 1;
}

void raise_win(Window w)
{
    XMapRaised(dpy, w);
    XSync(dpy, False);
}
