/* aewm - a minimalist X11 window mananager. vim:sw=4:ts=4:et
 * Copyright 1998-2004 Decklin Foster <decklin@red-bean.com>
 * This program is free software; see LICENSE for details. */

#include "atom.h"

int get_atom(Window w, Atom a, Atom type, long *data_return)
{
    Atom real_type;
    int real_format = 0;
    unsigned long items_read = 0;
    unsigned long bytes_left = 0;
    unsigned char *data;

    XGetWindowProperty(dpy, w, a, 0, 1, False, type,
            &real_type, &real_format, &items_read, &bytes_left, &data);

    if (real_format == 32 && items_read >= 1) {
        *data_return = *(long *)data;
        XFree(data);
        return 1;
    } else {
        return 0;
    }
}

int set_atom(Window w, Atom a, Atom type, long value)
{
    CARD32 data[1] = { value };

    return (XChangeProperty(dpy, w, a, type,
        32, PropModeReplace, (unsigned char *)data, 1) == Success);
}

void atom_foreach(Window w, Atom a, Atom type, atom_func atom_cb,
    void *cb_data)
{
    Atom real_type;
    int real_format = 0;
    unsigned long items_read = 0;
    unsigned long bytes_left = 0;
    unsigned char *data;
    long start = 0;

    do {
        XGetWindowProperty(dpy, w, a, start, 1, False, type,
            &real_type, &real_format, &items_read, &bytes_left, &data);
        if (real_format == 32 && items_read >= 1) {
            atom_cb(data, cb_data);
            XFree(data);
            start += items_read;
        }
    } while (real_format == 32 && bytes_left);
}

void append_to_atom(Window w, Atom a, Atom type, long new_val)
{
    XChangeProperty(dpy, w, a, type, 32,
        PropModeAppend, (unsigned char *)&new_val, 1);
}
