/* aewm - a minimalist X11 window mananager. vim:sw=4:ts=4:et
 * Copyright 1998-2004 Decklin Foster <decklin@red-bean.com>
 * This program is free software; see LICENSE for details. */

#include "strut.h"

/* Reads the _NET_WM_STRUT_PARTIAL or _NET_WM_STRUT hint into the
 * args, if it exists. In the case of _NET_WM_STRUT_PARTIAL we cheat
 * and only take the first 4 values, because that's all we care about.
 * This means we can use the same code for both (_NET_WM_STRUT only
 * specifies 4 elements). Each number is the margin in pixels on that
 * side of the display where we don't want to place clients. If there
 * is no hint, we act as if it was all zeros (no margin). */

int get_strut(Window w, strut_t *s)
{
    Atom real_type;
    int real_format = 0;
    unsigned long items_read = 0;
    unsigned long bytes_left = 0;
    unsigned char *data;
    int *strut_data;

    XGetWindowProperty(dpy, w, net_wm_strut_partial, 0, 12, False, XA_CARDINAL,
        &real_type, &real_format, &items_read, &bytes_left, &data);

    if (!(real_format == 32 && items_read >= 12))
        XGetWindowProperty(dpy, w, net_wm_strut, 0, 4, False, XA_CARDINAL,
            &real_type, &real_format, &items_read, &bytes_left, &data);

    if (real_format == 32 && items_read >= 4) {
        strut_data = (int *)data;
        s->left = strut_data[0];
        s->right = strut_data[1];
        s->top = strut_data[2];
        s->bottom = strut_data[3];
        XFree(data);
        return 1;
    } else {
        s->left = 0;
        s->right = 0;
        s->top = 0;
        s->bottom = 0;
        return 0;
    }
}
