/*
 * Interpreter state management
 */

#include <stdlib.h>

#include "misc.h"

/*
 * Allocate new state structure
 */
arena_state *state_alloc(void)
{
  arena_state *res;

  res = oom(calloc(1, sizeof(arena_state)));
  res->resource_max = RESOURCE_MAX;
  return res;
}

/*
 * Run cleanup functions and free state structure
 */
void state_free(arena_state *state)
{
  free(state);
}
