#include <curl/curl.h>
#include <curl/easy.h>

#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <pthread.h>

#include "hscurl.h"

int curl_init() {
  curl_global_init(CURL_GLOBAL_ALL);
}

struct silly {
  int fd;
  CURL *c;
};

static void *do_curl(void *s) {
  int fd = ((struct silly *)s)->fd;
  CURL *c = ((struct silly *)s)->c;
  free(s);
  curl_easy_perform(c);
  curl_easy_cleanup(c);

  close(fd);
  return NULL;
}

size_t write_data(void *buffer, size_t size, size_t nmemb, void *userp) {
  return write((int)userp, buffer, size*nmemb);
}

// get_curl returns a file descriptor...
int get_curl(const char *url) {
  CURLcode res;
  struct silly *s = (void *)malloc(sizeof(struct silly));
  int inout[2], err;

  if (!s) return -1;
  if (pipe(inout)) return -1;

  s->fd = inout[1];
  s->c = curl_easy_init();
  if (s->c) {
    pthread_attr_t tha;
    pthread_t tt;
    curl_easy_setopt(s->c, CURLOPT_URL, url);
    curl_easy_setopt(s->c, CURLOPT_NOSIGNAL, NULL);
    curl_easy_setopt(s->c, CURLOPT_WRITEFUNCTION, write_data);
    curl_easy_setopt(s->c, CURLOPT_WRITEDATA, inout[1]);
    pthread_attr_init(&tha);
    pthread_attr_setdetachstate(&tha, PTHREAD_CREATE_DETACHED);
    while (err = pthread_create(&tt, &tha, do_curl, s)) {
      printf("Got an error creating a thread!!! (%d)\n", err);
      printf("Trying again in a few seconds...\n");
      sleep(5);
    }
  }
  return inout[0];
}
