/*--------------------------------------------------------------------
 *	$Id: gmt_funcnames.h,v 1.83 2006/02/22 22:50:57 pwessel Exp $
 *
 *	Copyright (c) 1991-2006 by P. Wessel and W. H. F. Smith
 *	See COPYING file for copying and redistribution conditions.
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; version 2 of the License.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	Contact info: gmt.soest.hawaii.edu
 *--------------------------------------------------------------------*/

/*
 * ANSI-C prototypes of all GMT functions called outside the file they
 * are declared in.
 *
 * Author:	Paul Wessel
 * Date:	10-AUG-1995
 * Revised:	15-FEB-2000
 * Version:	3.4
 */

#ifndef _GMT_FUNCNAMES_H
#define _GMT_FUNCNAMES_H

EXTERN_MSC void GMT_x_axis (double x0, double y0, double length, double va10, double val1, struct PLOT_AXIS *A, int below, int annotate);
EXTERN_MSC void GMT_y_axis (double x0, double y0, double length, double va10, double val1, struct PLOT_AXIS *A, int left_side, int annotate);
EXTERN_MSC void GMT_x_to_xx (double x, double *xx); 
EXTERN_MSC void GMT_xx_to_x (double *x, double xx); 
EXTERN_MSC void GMT_y_to_yy (double y, double *yy); 
EXTERN_MSC void GMT_yy_to_y (double *y, double yy); 
EXTERN_MSC void GMT_z_to_zz (double z, double *zz); 
EXTERN_MSC void GMT_zz_to_z (double *z, double zz);
EXTERN_MSC void *GMT_memory (void *prev_addr, size_t nelem, size_t size, char *progname);
EXTERN_MSC void GMT_free (void *addr);
EXTERN_MSC double GMT_dist_to_point (double lon, double lat, double *xp, double *yp, int np, int *id);
EXTERN_MSC double GMT_cartesian_dist (double x0, double y0, double x1, double y1);
EXTERN_MSC double GMT_flatearth_dist_km (double x0, double y0, double x1, double y1);
EXTERN_MSC double GMT_flatearth_dist_meter (double x0, double y0, double x1, double y1);
EXTERN_MSC double GMT_great_circle_dist_km (double x0, double y0, double x1, double y1);
EXTERN_MSC double GMT_great_circle_dist_meter (double x0, double y0, double x1, double y1);
EXTERN_MSC int GMT_near_a_point_cart (double x, double y, double *xp, double *yp, double *dp, int np);
EXTERN_MSC int GMT_near_a_point (double x, double y, double *xp, double *yp, double *dp, int np);
EXTERN_MSC int GMT_near_a_line_cartesian (double lon, double lat, struct GMT_LINES *p, int np, BOOLEAN return_mindist, double *dist_min, double *x_near, double *y_near);
EXTERN_MSC int GMT_near_a_line_spherical (double lon, double lat, struct GMT_LINES *p, int np, BOOLEAN return_mindist, double *dist_min, double *x_near, double *y_near);
EXTERN_MSC int GMT_get_dist_scale (char c, double *d_scale, int *proj_type, PFD *distance_func);

EXTERN_MSC double GMT_great_circle_dist (double lon1, double lat1, double lon2, double lat2);
EXTERN_MSC int GMT_great_circle_intersection (double A[], double B[], double C[], double X[], double *CX_dist);
EXTERN_MSC double GMT_az_backaz_cartesian (double lonE, double latE, double lonS, double latS, BOOLEAN baz);
EXTERN_MSC double GMT_az_backaz_flatearth (double lonE, double latE, double lonS, double latS, BOOLEAN baz);
EXTERN_MSC double GMT_az_backaz_sphere (double lonE, double latE, double lonS, double latS, BOOLEAN baz);
EXTERN_MSC double GMT_az_backaz_geodesic (double lonE, double latE, double lonS, double latS, BOOLEAN baz);
EXTERN_MSC double GMT_geodesic_dist_degree (double lonS, double latS, double lonE, double latE);
EXTERN_MSC double GMT_geodesic_dist_meter (double lonS, double latS, double lonE, double latE);
EXTERN_MSC double GMT_geodesic_dist_km (double lonS, double latS, double lonE, double latE);
EXTERN_MSC double *GMT_distances (double x[], double y[], int n, double scale, int dist_flag);
EXTERN_MSC double GMT_half_map_width (double y);
EXTERN_MSC double GMT_dot3v (double *a, double *b);
EXTERN_MSC struct EPS *GMT_epsinfo (char *program);
EXTERN_MSC int GMT_comp_double_asc (const void *p_1, const void *p_2);
EXTERN_MSC int GMT_comp_float_asc (const void *p_1, const void *p_2);
EXTERN_MSC int GMT_comp_int_asc (const void *p_1, const void *p_2);
EXTERN_MSC int GMT_begin (int argc, char **argv);
EXTERN_MSC void GMT_end (int argc, char **argv);
EXTERN_MSC void GMT_put_history (int argc, char **argv);
EXTERN_MSC int GMT_get_common_args (char *item, double *w, double *e, double *s, double *n);
EXTERN_MSC int GMT_getinc (char *line, double *dx, double *dy);
EXTERN_MSC double GMT_getradius (char *line);
EXTERN_MSC int GMT_getincn (char *line, double inc[], int n);
EXTERN_MSC void GMT_getdefaults (char *this_file);
EXTERN_MSC void GMT_setdefaults (int argc, char **argv);
EXTERN_MSC int GMT_savedefaults (char *file);
EXTERN_MSC void GMT_default_error (char option);
EXTERN_MSC void GMT_explain_option (char option);
EXTERN_MSC void GMT_map_setup (double west, double east, double south, double north);
EXTERN_MSC int GMT_get_ellipsoid (char *name);
EXTERN_MSC int GMT_map_getproject (char *args);
EXTERN_MSC int GMT_datum_init (char *text);
EXTERN_MSC int GMT_ECEF_init (char *text);
EXTERN_MSC void GMT_conv_datum (double in[], double out[]);
EXTERN_MSC void GMT_ECEF_forward (double in[], double out[]);
EXTERN_MSC void GMT_ECEF_inverse (double in[], double out[]);
EXTERN_MSC void GMT_geoplot (double lon, double lat, int pen);
EXTERN_MSC void GMT_hash_init (struct GMT_HASH *hashnode , char **keys, int n_hash, int n_keys);
EXTERN_MSC int GMT_hash_lookup (char *key, struct GMT_HASH *hashnode, int n, int n_hash);
EXTERN_MSC int GMT_hash (char *v, int n_hash);
EXTERN_MSC void GMT_linearx_grid (double w, double e, double s, double n, double dval);
EXTERN_MSC int GMT_key_lookup (char *name, char **list, int n);
EXTERN_MSC int GMT_font_lookup (char *name, struct GMT_FONT *list, int n);
EXTERN_MSC void GMT_grdio_init (void);
EXTERN_MSC void GMT_geoz_to_xy (double x, double y, double z, double *x_out, double *y_out);
EXTERN_MSC void GMT_xy_do_z_to_xy (double x, double y, double z, double *x_out, double *y_out);
EXTERN_MSC int GMT_intpol (double *x, double *y, int n, int m, double *u, double *v, int mode);
EXTERN_MSC int GMT_cspline (double *x, double *y, int n, double *c);
EXTERN_MSC int GMT_akima (double *x, double *y, int nx, double *c);
EXTERN_MSC int GMT_map_outside (double lon, double lat);
EXTERN_MSC int GMT_wesn_outside_np (double lon, double lat);
EXTERN_MSC void GMT_get_plot_array (void);
EXTERN_MSC int GMT_log_array (double min, double max, double delta, double **array);
EXTERN_MSC int GMT_graticule_path (double **x, double **y, int dir, double w, double e, double s, double n);
EXTERN_MSC int GMT_map_path (double lon1, double lat1, double lon2, double lat2, double **x, double **y);
EXTERN_MSC int GMT_latpath (double lat, double lon1, double lon2, double **x, double **y);
EXTERN_MSC int GMT_lonpath (double lon, double lat1, double lat2, double **x, double **y);
EXTERN_MSC int *GMT_split_line (double **xx, double **yy, int *nn, BOOLEAN add_crossings);
EXTERN_MSC int GMT_get_format (double interval, char *unit, char *prefix, char *format);
EXTERN_MSC void GMT_geo_to_xy (double lon, double lat, double *x, double *y);
EXTERN_MSC void GMT_xy_to_geo (double *lon, double *lat, double x, double y);
EXTERN_MSC int GMT_break_through (double x0, double y0, double x1, double y1);
EXTERN_MSC int GMT_map_crossing (double lon1, double lat1, double lon2, double lat2, double *xlon, double *xlat, double *xx, double *yy, int *sides);
EXTERN_MSC void GMT_vertical_axis (int mode);
EXTERN_MSC void GMT_project3D (double x, double y, double z, double *x_out, double *y_out, double *z_out);
EXTERN_MSC int GMT_map_clip_path (double **x, double **y, BOOLEAN *donut);
EXTERN_MSC int GMT_fix_up_path (double **a_lon, double **a_lat, int n, BOOLEAN greenwich, double step);
EXTERN_MSC int GMT_clip_to_map (double *lon, double *lat, int np, double **x, double **y);
EXTERN_MSC int GMT_compact_line (double *x, double *y, int n, BOOLEAN pen_flag, int *pen);
EXTERN_MSC void GMT_plot_line (double *x, double *y, int *pen, int n);
EXTERN_MSC void GMT_2D_to_3D (double *x, double *y, double z, int n);
EXTERN_MSC void GMT_2Dz_to_3D (double *x, double *y, double z, int n);
EXTERN_MSC void GMT_xyz_to_xy (double x, double y, double z, double *x_out, double *y_out);
EXTERN_MSC void GMT_ngeo_to_xy (double *lon, double *lat, int n);
EXTERN_MSC int GMT_geo_to_xy_line (double *lon, double *lat, int n);
EXTERN_MSC void GMT_rotate2D (double x[], double y[], int n, double x0, double y0, double angle, double xp[], double yp[]);
EXTERN_MSC int GMT_grd_get_format (char *file, struct GRD_HEADER *header);
EXTERN_MSC void GMT_grd_init (struct GRD_HEADER *header, int argc, char **argv, BOOLEAN update);
EXTERN_MSC int GMT_median (double *x, size_t n, double xmin, double xmax, double m_initial, double *med);
EXTERN_MSC int GMT_median_f (float *x, size_t n, double xmin, double xmax, double m_initial, double *med);
EXTERN_MSC int GMT_mode (double *x, size_t n, size_t j, int sort, int mode_selection, int *n_multiples, double *mode_est);
EXTERN_MSC int GMT_mode_f (float *x, size_t n, size_t j, int sort, int mode_selection, int *n_multiples, double *mode_est);
EXTERN_MSC void GMT_getmad (double *x, size_t n, double location, double *scale);
EXTERN_MSC void GMT_getmad_f (float *x, size_t n, double location, double *scale);
EXTERN_MSC double GMT_extreme (double x[], size_t n, double x_default, int kind, int way);
EXTERN_MSC void GMT_geo_to_cart (double *alat, double *alon, double *a, int rads);
EXTERN_MSC void GMT_cart_to_geo (double *alat, double *alon, double *a, int rads);
EXTERN_MSC void GMT_normalize3v (double *a);
EXTERN_MSC void GMT_cross3v (double *a, double *b, double *c);
EXTERN_MSC double GMT_mag3v (double *a);
EXTERN_MSC int GMT_jacobi (double *a, int *n, int *m, double *d, double *v, double *b, double *z, int *nrots);
EXTERN_MSC int GMT_chol_dcmp (double *a, double *d, double *cond, int nr, int n);
EXTERN_MSC void GMT_chol_recover (double *a, double *d, int nr, int n, int nerr, int donly);
EXTERN_MSC void GMT_chol_solv (double *a, double *x, double *y, int nr, int n);
EXTERN_MSC int GMT_non_zero_winding (double xp, double yp, double *x, double *y, int n_path);
EXTERN_MSC int GMT_inonout_sphpol (double plon, double plat, const struct GMT_LINES *P);
EXTERN_MSC int GMT_grd_setregion (struct GRD_HEADER *h, double *xmin, double *xmax, double *ymin, double *ymax);
EXTERN_MSC void GMT_init_pen (struct GMT_PEN *pen, double width);
EXTERN_MSC void GMT_pen_syntax (char option);
EXTERN_MSC int GMT_getrgb (char *line, int *rgb);
EXTERN_MSC int GMT_getpen (char *line, struct GMT_PEN *pen);
EXTERN_MSC int GMT_unit_lookup (int c);
EXTERN_MSC char *GMT_convertpen (struct GMT_PEN *pen, int *width, int *offset, int rgb[]);
EXTERN_MSC void GMT_setpen (struct GMT_PEN *pen);
EXTERN_MSC void GMT_echo_command (int argc, char **argv);
EXTERN_MSC void GMT_timestamp (int argc, char **argv);
EXTERN_MSC int GMT_set_cpt_path (char *cpt_file, char *table);
EXTERN_MSC void GMT_read_cpt (char *cpt_file);
EXTERN_MSC int GMT_contours (float *grd, struct GRD_HEADER *header, int smooth_factor, int int_scheme, int *side, int *edge, int first, double **x_array, double **y_array);
EXTERN_MSC void GMT_dump_contour (double *xx, double *yy, int nn, double cval, int id, BOOLEAN interior, char *file);
EXTERN_MSC void GMT_fill (double x[], double y[], int n, struct GMT_FILL *fill, BOOLEAN outline);
EXTERN_MSC void GMT_textbox3D (double x, double y, double z, double size, int font, char *label, double angle, int just, BOOLEAN outline, double dx, double dy, int rgb[]);
EXTERN_MSC void GMT_text3D (double x, double y, double z, double fsize, int fontno, char *text, double angle, int justify, int form);
EXTERN_MSC void GMT_vector3D (double x0, double y0, double x1, double y1, double z0, double tailwidth, double headlength, double headwidth, double shape, int rgb[], BOOLEAN outline);
EXTERN_MSC void GMT_map_basemap (void);
EXTERN_MSC void GMT_draw_map_scale (struct MAP_SCALE *ms);
EXTERN_MSC void GMT_draw_map_rose (struct MAP_ROSE *mr);
EXTERN_MSC void GMT_grd_shift (struct GRD_HEADER *header, float *grd, double shift);
EXTERN_MSC void GMT_fourt (float *data, int *nn, int ndim, int ksign, int iform, float *work);
EXTERN_MSC void GMT_grdproject_init (struct GRD_HEADER *head, double x_inc, double y_inc, int nx, int ny, int dpi, int offset);
EXTERN_MSC void GMT_grd_forward (float *geo, struct GRD_HEADER *g_head, float *rect, struct GRD_HEADER *r_head, double max_radius);
EXTERN_MSC void GMT_grd_inverse (float *geo, struct GRD_HEADER *g_head, float *rect, struct GRD_HEADER *r_head, double max_radius);
EXTERN_MSC int GMT_grd_project (float *z_in, struct GRD_HEADER *I, float *z_out, struct GRD_HEADER *O, struct GMT_EDGEINFO *edgeinfo, BOOLEAN bilinear, BOOLEAN inverse);
EXTERN_MSC void GMT_illuminate (double intensity, int *rgb);
EXTERN_MSC int GMT_get_rgb24 (double value, int *rgb);
EXTERN_MSC void GMT_init_ellipsoid (void);
EXTERN_MSC void GMT_grid_clip_on (struct GRD_HEADER *h, int rgb[], int flag);
EXTERN_MSC void GMT_map_clip_on (int rgb[], int flag);
EXTERN_MSC void GMT_map_clip_off (void);
EXTERN_MSC void GMT_grid_clip_off (void);
EXTERN_MSC void GMT_xy_axis (double x0, double y0, double length, double val0, double val1, struct PLOT_AXIS *A, int below, int annotate);
EXTERN_MSC void GMT_color_image (double x0, double y0, double x_side, double y_side, unsigned char *image, int nx, int ny, int depth);
EXTERN_MSC void GMT_init_fill (struct GMT_FILL *fill, int r, int g, int b);
EXTERN_MSC void GMT_fill_syntax (char option);
EXTERN_MSC void GMT_rgb_syntax (char option);
EXTERN_MSC void GMT_label_syntax (int indent, int kind);
EXTERN_MSC void GMT_cont_syntax (int indent, int kind);
EXTERN_MSC void GMT_inc_syntax (char option, int error);
EXTERN_MSC int GMT_getfill (char *line, struct GMT_FILL *fill);
EXTERN_MSC int GMT_check_rgb (int *rgb);
EXTERN_MSC void GMT_azim_to_angle (double lon, double lat, double c, double azim, double *angle);
EXTERN_MSC int GMT_delaunay (double *x_in, double *y_in, int n, int **link);
EXTERN_MSC int GMT_sig_f (double chi1, int n1, double chi2, int n2, double level, double *prob);
EXTERN_MSC int GMT_f_test_new (double chisq1, int nu1, double chisq2, int nu2, double *prob, int iside);
EXTERN_MSC int GMT_student_t_a (double t, int n, double *prob);
EXTERN_MSC int GMT_f_q (double chisq1, int nu1, double chisq2, int nu2, double *prob);
EXTERN_MSC void GMT_chi2 (double chi2, double nu, double *prob);
EXTERN_MSC void GMT_cumpoission (double k, double mu, double *prob);
EXTERN_MSC double GMT_zcrit (double alpha);
EXTERN_MSC double GMT_tcrit (double alpha, double nu);
EXTERN_MSC double GMT_chi2crit (double alpha, double nu);
EXTERN_MSC double GMT_Fcrit (double alpha, double nu1, double nu2);
EXTERN_MSC double GMT_coffcoeff (double *x, double *y, int n, int mode);
EXTERN_MSC double GMT_coffcoeff_f (float *x, float *y, int n, int mode);
EXTERN_MSC void GMT_grd_RI_verify (struct GRD_HEADER *h, int mode);
EXTERN_MSC void GMT_RI_prepare (struct GRD_HEADER *h);
EXTERN_MSC int GMT_minmaxinc_verify (double min, double max, double inc, double slop);
EXTERN_MSC double GMT_convert_units (char *from, int new_format);
EXTERN_MSC int GMT_get_unit (char c);
EXTERN_MSC BOOLEAN GMT_getpathname (char *name, char *path);
EXTERN_MSC char *GMT_getdefpath (int get);
EXTERN_MSC int GMT_getscale (char *text, struct MAP_SCALE *ms);
EXTERN_MSC int GMT_getrose (char *text, struct MAP_ROSE *mr);
EXTERN_MSC void GMT_set_measure_unit (char *args);
EXTERN_MSC int GMT_check_scalingopt (char *args, char *unit_name);
EXTERN_MSC void GMT_init_scales (int unit, double *fwd_scale, double *inv_scale, double *inch_to_unit, double *unit_to_inch, char *unit_name);
EXTERN_MSC void GMT_init_search_radius (double *radius, struct GRD_HEADER *r_head, struct GRD_HEADER *g_head, BOOLEAN inverse);
EXTERN_MSC void GMT_wesn_search (double xmin, double xmax, double ymin, double ymax, double *west, double *east, double *south, double *north);
EXTERN_MSC void GMT_decode_grd_h_info (char *input, struct GRD_HEADER *h);
EXTERN_MSC void GMT_chop (char *string);
EXTERN_MSC int GMT_strtok (const char *string, const char *sep, int *start, char *token);
EXTERN_MSC void GMT_str_tolower (char *string);
EXTERN_MSC void GMT_str_toupper (char *string);
EXTERN_MSC double GMT_get_map_interval (int axis, int item);
EXTERN_MSC int GMT_just_decode (char *key, int i, int j);
EXTERN_MSC void GMT_smart_justify (int just, double angle, double dx, double dy, double *x_shift, double *y_shift);
EXTERN_MSC int GMT_verify_expectations (int wanted, int got, char *item);
EXTERN_MSC void GMT_cross3D (double x, double y, double z, double size);
EXTERN_MSC void GMT_square3D (double x, double y, double z, double size, int rgb[], int outline);
EXTERN_MSC void GMT_rect3D (double x, double y, double z, double xsize, double ysize, int rgb[], int outline);
EXTERN_MSC void GMT_circle3D (double x, double y, double z, double size, int rgb[], int outline);
EXTERN_MSC void GMT_ellipse3D (double x, double y, double z, double direction, double major, double minor, int rgb[], int outline);
EXTERN_MSC void GMT_pie3D (double x, double y, double z, double size, double dir1, double dir2, int rgb[], int outline);
EXTERN_MSC void GMT_triangle3D (double x, double y, double z, double size, int rgb[], int outline);
EXTERN_MSC void GMT_itriangle3D (double x, double y, double z, double size, int rgb[], int outline);
EXTERN_MSC void GMT_diamond3D (double x, double y, double z, double size, int rgb[], int outline);
EXTERN_MSC void GMT_hexagon3D (double x, double y, double z, double size, int rgb[], int outline);
EXTERN_MSC void GMT_pentagon3D (double x, double y, double z, double size, int rgb[], int outline);
EXTERN_MSC void GMT_octagon3D (double x, double y, double z, double size, int rgb[], int outline);
EXTERN_MSC void GMT_star3D (double x, double y, double z, double size, int rgb[], int outline);
EXTERN_MSC void GMT_set_home (void);
EXTERN_MSC void GMT_syntax (char option);
EXTERN_MSC int GMT_check_region (double w, double e, double s, double n);
EXTERN_MSC void GMT_init_fonts (int *n_fonts);
EXTERN_MSC void GMT_list_custom_symbols (void);
EXTERN_MSC void GMT_set_processed_option (int key, BOOLEAN state);
EXTERN_MSC double GMT_get_annot_offset (BOOLEAN *flip, int level);
EXTERN_MSC int GMT_flip_justify (int justify);
EXTERN_MSC int GMT_annot_pos (double min, double max, struct PLOT_AXIS_ITEM *T, double coord[], double *pos);
EXTERN_MSC void GMT_get_primary_annot (struct PLOT_AXIS *A, int *primary, int *secondary);
EXTERN_MSC BOOLEAN GMT_polygon_is_open (double x[], double y[], int n);
EXTERN_MSC int GMT_get_time_system (char *name);

#endif /* _GMT_FUNCNAMES_H */
