#include "artsmodules.h"
#include "debug.h"
#include "connect.h"

namespace Arts {

	class MonoSimpleMixerChannelGuiFactory_impl : virtual public MonoSimpleMixerChannelGuiFactory_skel
	{
		public:
			Widget createGui(Object object)
			{
				arts_return_val_if_fail(!object.isNull(), Arts::Widget::null());
				MonoSimpleMixerChannel ch= DynamicCast(object);
				arts_return_val_if_fail(!ch.isNull(), Arts::Widget::null());

				VBox vbox;

				Poti gain;
				gain.caption("volume");
				gain.color("red"); gain.min(0.01); gain.max(4);
				gain.value(ch.gain());
				gain.parent(vbox);
				gain.show();
				connect(gain,"value_changed", ch, "gain");
				vbox._addChild(gain,"gain");

				Poti high;
				high.caption("high");
				high.color("blue"); high.min(-12); high.max(12);
				high.value(ch.equalizer().high());
				high.parent(vbox);
				high.show();
				connect(high,"value_changed", ch.equalizer(), "high");
				vbox._addChild(high,"highWidget");

				Poti mid;
				mid.caption("mid");
				mid.color("blue"); mid.min(-12); mid.max(12);
				mid.value(ch.equalizer().mid());
				mid.parent(vbox);
				mid.show();
				connect(mid,"value_changed", ch.equalizer(), "mid");
				vbox._addChild(mid,"midWidget");

				Poti low;
				low.caption("low");
				low.color("blue"); low.min(-12); low.max(12);
				low.value(ch.equalizer().low());
				low.parent(vbox);
				low.show();
				connect(low,"value_changed", ch.equalizer(), "low");
				vbox._addChild(low,"lowWidget");

				Poti frequency;
				frequency.caption("frequency");
				frequency.color("darkgreen"); frequency.min(20); frequency.max(10000);
				frequency.value(ch.equalizer().frequency());
				frequency.logarithmic(2.0);
				frequency.parent(vbox);
				frequency.show();
				connect(frequency,"value_changed", ch.equalizer(), "frequency");
				vbox._addChild(frequency,"frequencyWidget");

				Poti q;
				q.caption("q");
				q.color("darkgreen"); q.min(0.01); q.max(10);
				q.value(ch.equalizer().q());
				q.logarithmic(2.0);
				q.parent(vbox);
				q.show();
				connect(q,"value_changed", ch.equalizer(), "q");
				vbox._addChild(q,"qWidget");

				Poti pan;
				pan.caption("pan");
				pan.color("grey"); pan.min(-1.0); pan.max(1.0);
				pan.value(ch.pan());
				pan.parent(vbox);
				pan.show();
				connect(pan,"value_changed",ch,"pan");
				vbox._addChild(pan,"panWidget");

				Fader volume;
				volume.caption("volume");
				volume.color("red"); volume.min(0.01); volume.max(4);
				volume.value(ch.volume());
				volume.parent(vbox);
				volume.show();
				connect(volume,"value_changed", ch, "volume");
				vbox._addChild(volume,"volume");

				return vbox;
			}
	};
	REGISTER_IMPLEMENTATION(MonoSimpleMixerChannelGuiFactory_impl);
};

// vim:ts=4:sw=4
