/*
    Copyright (C) 2000 - 2001 Kai Heitkamp, kai@kde.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 */

#ifndef RIPCD_H
#define RIPCD_H

#include <qwidget.h>
#include <qstring.h>
#include <qvaluelist.h>

#include <kprocess.h>
#include <klistview.h>
#include <kio/job.h>
#include <kio/netaccess.h>
#include <kfileitem.h>

#include <ripcd_gui.h>
#include "imgprocout.h"
#include "tracklist.h"

/**
  *@author Kai Heitkamp
  */

class RipCD : public RipCD_GUI  {
   Q_OBJECT

public:
	RipCD(QWidget *parent=0, const char *name=0);
	~RipCD();

	char *tracks;
	QValueList<TrackList> tlist;
	bool startJob, formatChanged, CDDBInfos;

private:
	QString tempFile;
	KProcess GetTracksProcess;
	KShellProcess *RipProcess;
	KListViewItem *TrackListItem;

protected:
	QString CDDBdiscID;
	ImgProcOut imgprocoutdlg;

protected slots:
  void slot_exit();
  void slot_start();
	void slot_startJob();
  void slot_selectDirectory();
  void slot_getTracks();
	void slot_completed();
	void slot_NewItemsData( const KFileItemList& );
	void slot_Data( const KFileItemList& );
	void slot_DataCompleted();
	void slot_CopyingResult( KIO::Job * );
	void slot_fileFormatChanged( int index );
};

#endif
