#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "prescheme.h"
#include "scheme48vm.h"
#include "scheme48heap.h"

struct image_location {
  long new_descriptor;
  long next;
};
struct table {
  long *keys;
  struct image_location **values;
  long count;
  long size;
};
static struct image_location *table_ref(struct table*, long);
static long copy_weak_pointer(long, char *, char **);
static void table_setB(struct table*, long, struct image_location*);
static long real_copy_object(long, char *, char **);
static char resumer_recordP(long);
static long trace_image_value(long);
void s48_write_barrier(long, char *, long);
void s48_forbid_gcB(void);
void s48_allow_gcB(void);
long s48_heap_size(void);
long s48_gc_count(void);
long s48_gc_run_time(long*);
void s48_initialization_completeB(void);
long s48_max_heap_size(void);
long s48_startup_procedure(void);
long s48_initial_symbols(void);
long s48_initial_imported_bindings(void);
long s48_initial_exported_bindings(void);
long s48_resumer_records(void);
void s48_set_image_valuesB(long, long, long, long, long);
char * s48_allocate_small(long);
char s48_stob_in_heapP(long);
long s48_available(void);
char s48_extantP(long);
long s48_gather_objects(char(*)(long), char(*)(char(*)(long)));
static char pD1(long);
char s48_check_heap(long);
long s48_find_all(long);
long s48_trace_value(long);
long s48_find_all_records(long);
void s48_trace_continuation_contentsB(char *, char *, long);
void s48_initializing_gc_root(void);
long s48_write_image(long, long, FILE *);
void s48_trace_locationsB(char *, char *);
void s48_trace_stob_contentsB(long);
void s48_collect(char);
void s48_make_availableAgc(long);
char * s48_allocate_tracedAgc(long);
char * s48_allocate_weakAgc(long);
char * s48_allocate_untracedAgc(long);
long s48_allocate_stob(long, long);
long s48_read_image(char*, long);
static char * Soldspace_hpS;
static char * Soldspace_limitS;
static char * Snewspace_beginS;
static char * Snewspace_endS;
static char * Soldspace_beginS;
static char * Soldspace_endS;
static char * Snew_heap_start_addrS;
static char * *Spure_areasS;
static char * *Simpure_areasS;
static long *Spure_sizesS;
static long *Simpure_sizesS;
static long Spure_area_countS;
static long Simpure_area_countS;
static char (*Scollect_predicateS)(long);
static long Sfinding_typeS;
static long Sheap_errors_leftS;
static long Sgc_countS;
static long Sgc_secondsS;
static long Sgc_msecondsS;
static char * Sfrom_beginS;
static char * Sfrom_endS;
static char * Sweak_pointer_hpS;
static char * Sweak_pointer_limitS;
static long SstatusS;
static char SeofPS;
static long Sstartup_procedureS;
static long SsymbolsS;
static long Simported_bindingsS;
static long Sexported_bindingsS;
static long Sresumer_recordsS;
static char * Simg_start_addrS;
static char * Simg_end_addrS;
static long Simg_heap_sizeS;
static char * Ssmall_img_start_addrS;
static char * Ssmall_img_hp_addrS;
static char * Ssmall_img_end_addrS;
static long Ssmall_img_heap_sizeS;
static char * Slarge_img_start_addrS;
static char * Slarge_img_hp_addrS;
static char * Slarge_img_end_addrS;
static long Slarge_img_heap_sizeS;
static char * Sweaks_img_start_addrS;
static char * Sweaks_img_hp_addrS;
static char * Sweaks_img_end_addrS;
static long Sweaks_img_heap_sizeS;
static char * Sheap_image_pointerS;
static char * Ssymbol_addressS;
static long Sheap_object_remaining_cellsS;
static char * Sheap_object_pointerS;
static struct table *Sstob_tableS;
static long SoffsetS;
static char * Sarea_startS;
static char SinitializingPS;
static long SstatusS;
static FILE * Simage_portS;
static char * Simage_bufferS;
static char * Simage_buffer_pointerS;
static long image_start_address;
static char * Simage_beginS;
static char * Simage_hpS;
static struct table *Sstob_tableS;
static long Sfirst_stobS;
static struct image_location *Slast_stobS;
static long Sresumer_countS;
static long Sresumer_recordsS;
static long Sundumpable_recordsS;
static long Sundumpable_countS;
static long Hthe_record_type280;
char * s48_ShpS;
char * s48_SlimitS;

static struct image_location *table_ref(struct table *table_1X, long key_2X)
{
  long arg0K0;
  long next_6X;
  long i_5X;
  long *keys_4X;
  long size_3X;
 {  if ((0 < (table_1X->size))) {
    size_3X = table_1X->size;
    keys_4X = table_1X->keys;
    arg0K0 = ((key_2X ^ ((((key_2X)<<1)) ^ (((key_2X)>>10)))) & (-1 + size_3X));
    goto L3022;}
  else {
    return (NULL);}}
 L3022: {
  i_5X = arg0K0;
  next_6X = *(keys_4X + i_5X);
  if ((key_2X == next_6X)) {
    return (*((table_1X->values) + i_5X));}
  else {
    if ((0 == next_6X)) {
      if ((i_5X == (table_1X->size))) {
        arg0K0 = 0;
        goto L3022;}
      else {
        return (NULL);}}
    else {
      arg0K0 = (1 + i_5X);
      goto L3022;}}}
}
static long copy_weak_pointer(long weak_7X, char * frontier_8X, char * *TT0)
{
  char * arg1K0;
  long new_13X;
  char * frontier_12X;
  char * new_frontier_11X;
  char * old_10X;
  char * x_9X;
 {  x_9X = Sweak_pointer_hpS;
  if ((x_9X == NULL)) {
    goto L6495;}
  else {
    if (((Sweak_pointer_hpS) < (Sweak_pointer_limitS))) {
      arg1K0 = frontier_8X;
      goto L6500;}
    else {
      goto L6495;}}}
 L6495: {
  old_10X = Sweak_pointer_hpS;
  new_frontier_11X = frontier_8X + 2048;
  Sweak_pointer_hpS = frontier_8X;
  Sweak_pointer_limitS = new_frontier_11X;
  *((long *) (Sweak_pointer_hpS)) = (long) (522310);
  *((long *) ((Sweak_pointer_hpS) + 16)) = (long) ((((long) old_10X)));
  arg1K0 = new_frontier_11X;
  goto L6500;}
 L6500: {
  frontier_12X = arg1K0;
  new_13X = 3 + (((long) ((Sweak_pointer_hpS) + 8)));
  *((long *) ((Sweak_pointer_hpS) + 8)) = (long) ((*((long *) (((char *) (-3 + weak_7X))))));
  Sweak_pointer_hpS = ((Sweak_pointer_hpS) + 16);
  *((long *) ((((char *) (-3 + weak_7X))) + -8)) = (long) (new_13X);
  *TT0 = frontier_12X;
  return new_13X;}
}
static void table_setB(struct table *table_14X, long key_15X, struct image_location *value_16X)
{
  long arg0K0;
  long i_32X;
  struct image_location *value_31X;
  long key_30X;
  long i_29X;
  long i_28X;
  struct image_location **new_values_27X;
  long *new_keys_26X;
  long new_size_25X;
  struct image_location **old_values_24X;
  long v_23X;
  long old_size_22X;
  long *old_keys_21X;
  long next_20X;
  long i_19X;
  long *keys_18X;
  long size_17X;
 {  if ((0 < (table_14X->size))) {
    size_17X = table_14X->size;
    keys_18X = table_14X->keys;
    arg0K0 = ((key_15X ^ ((((key_15X)<<1)) ^ (((key_15X)>>10)))) & (-1 + size_17X));
    goto L7112;}
  else {
    return;}}
 L7112: {
  i_19X = arg0K0;
  next_20X = *(keys_18X + i_19X);
  if ((key_15X == next_20X)) {
    *((table_14X->values) + i_19X) = value_16X;
    return;}
  else {
    if ((0 == next_20X)) {
      if ((i_19X == (table_14X->size))) {
        arg0K0 = 0;
        goto L7112;}
      else {
        *((table_14X->keys) + i_19X) = key_15X;
        *((table_14X->values) + i_19X) = value_16X;
        table_14X->count = (1 + (table_14X->count));
        if (((table_14X->count) == ((table_14X->size) / 3))) {
          old_keys_21X = table_14X->keys;
          old_size_22X = table_14X->size;
          v_23X = table_14X->size;
          old_values_24X = table_14X->values;
          new_size_25X = ((v_23X)<<1);
          new_keys_26X = (long*)malloc(sizeof(long) * (1 + new_size_25X));
          new_values_27X = (struct image_location**)malloc(sizeof(struct image_location*) * new_size_25X);
          if ((NULL == new_keys_26X)) {
            goto L4245;}
          else {
            if ((NULL == new_values_27X)) {
              goto L4245;}
            else {
              table_14X->keys = new_keys_26X;
              table_14X->values = new_values_27X;
              table_14X->size = new_size_25X;
              table_14X->count = 0;
              arg0K0 = 0;
              goto L4398;}}}
        else {
          return;}}}
    else {
      arg0K0 = (1 + i_19X);
      goto L7112;}}}
 L4245: {
  if ((NULL == new_keys_26X)) {
    goto L4253;}
  else {
    free(new_keys_26X);
    goto L4253;}}
 L4398: {
  i_28X = arg0K0;
  if ((i_28X < (1 + new_size_25X))) {
    *(new_keys_26X + i_28X) = 0;
    arg0K0 = (1 + i_28X);
    goto L4398;}
  else {
    arg0K0 = 0;
    goto L4276;}}
 L4253: {
  if ((NULL == new_values_27X)) {
    goto L4261;}
  else {
    free(new_values_27X);
    goto L4261;}}
 L4276: {
  i_29X = arg0K0;
  if ((i_29X == old_size_22X)) {
    free(old_keys_21X);
    free(old_values_24X);
    return;}
  else {
    key_30X = *(old_keys_21X + i_29X);
    if ((0 == key_30X)) {
      goto L4292;}
    else {
      value_31X = *(old_values_24X + i_29X);
      arg0K0 = ((key_30X ^ ((((key_30X)<<1)) ^ (((key_30X)>>10)))) & (-1 + new_size_25X));
      goto L4420;}}}
 L4261: {
  table_14X->size = 0;
  return;}
 L4292: {
  arg0K0 = (1 + i_29X);
  goto L4276;}
 L4420: {
  i_32X = arg0K0;
  if ((0 == (*(new_keys_26X + i_32X)))) {
    if ((i_32X == new_size_25X)) {
      arg0K0 = 0;
      goto L4420;}
    else {
      *(new_keys_26X + i_32X) = key_30X;
      *(new_values_27X + i_32X) = value_31X;
      goto L4292;}}
  else {
    arg0K0 = (1 + i_32X);
    goto L4420;}}
}
static long real_copy_object(long thing_33X, char * frontier_34X, char * *TT0)
{
  long new_39X;
  char * data_addr_38X;
  char * a_37X;
  long descriptor_36X;
  long h_35X;
 {  h_35X = *((long *) ((((char *) (-3 + thing_33X))) + -8));
  if ((3 == (3 & h_35X))) {
    *TT0 = frontier_34X;
    return h_35X;}
  else {
    if ((2102 == h_35X)) {
      descriptor_36X = *((long *) (((char *) (-3 + thing_33X))));
      if ((3 == (3 & descriptor_36X))) {
        a_37X = ((char *) (-3 + descriptor_36X));
        if ((a_37X < (Sfrom_beginS))) {
          goto L10375;}
        else {
          if ((a_37X < (Sfrom_endS))) {
            return copy_weak_pointer(thing_33X, frontier_34X, TT0);}
          else {
            goto L10375;}}}
      else {
        goto L10375;}}
    else {
      goto L10375;}}}
 L10375: {
  *((long *) frontier_34X) = (long) (h_35X);
  data_addr_38X = frontier_34X + 8;
  new_39X = 3 + (((long) data_addr_38X));
  *((long *) ((((char *) (-3 + thing_33X))) + -8)) = (long) (new_39X);
  memmove((void *)data_addr_38X, (void *)(((char *) (-3 + thing_33X))),((long)(((unsigned long)h_35X)>>8)));
  *TT0 = (data_addr_38X + (-8 & (7 + ((long)(((unsigned long)h_35X)>>8)))));
  return new_39X;}
}
static char resumer_recordP(long stob_40X)
{
  long type_41X;
 {  if ((3 == (3 & stob_40X))) {
    if ((9 == (31 & ((((*((long *) ((((char *) (-3 + stob_40X))) + -8))))>>2))))) {
      type_41X = *((long *) (((char *) (-3 + stob_40X))));
      if ((3 == (3 & type_41X))) {
        if ((9 == (31 & ((((*((long *) ((((char *) (-3 + type_41X))) + -8))))>>2))))) {
          return (3 == (3 & (*((long *) ((((char *) (-3 + type_41X))) + 8)))));}
        else {
          return 0;}}
      else {
        return 0;}}
    else {
      return 0;}}
  else {
    return 0;}}
}
static long trace_image_value(long thing_42X)
{
  struct image_location *arg2K0;
  struct image_location *arg2K1;
  long arg0K0;
  long merged_arg0K0;

  int gc_recordP_return_tag;
  char gc_recordP0_return_value;
  long x_43X;
  long header_63X;
  char v_62X;
  long x_61X;
  struct image_location *new_60X;
  long new_descriptor_59X;
  struct image_location *new_58X;
  struct image_location *image_location_57X;
  long new_descriptor_56X;
  char * data_addr_55X;
  long h_54X;
  long stob_53X;
  struct image_location *image_location_52X;
  long new_alias_51X;
  long i_50X;
  long len_49X;
  long vector_48X;
  char v_47X;
  long type_46X;
  char v_45X;
  struct image_location *have_44X;
 {  if ((3 == (3 & thing_42X))) {
    have_44X = table_ref((Sstob_tableS), thing_42X);
    if ((NULL == have_44X)) {
      merged_arg0K0 = thing_42X;
      gc_recordP_return_tag = 0;
      goto gc_recordP;
     gc_recordP_return_0:
      v_45X = gc_recordP0_return_value;
      if (v_45X) {
        type_46X = *((long *) (((char *) (-3 + thing_42X))));
        merged_arg0K0 = type_46X;
        gc_recordP_return_tag = 1;
        goto gc_recordP;
       gc_recordP_return_1:
        v_47X = gc_recordP0_return_value;
        if (v_47X) {
          if ((1 == (*((long *) ((((char *) (-3 + type_46X))) + 8))))) {
            if (((Sundumpable_countS) < ((((7 + ((long)(((unsigned long)(*((long *) ((((char *) (-3 + (Sundumpable_recordsS)))) + -8))))>>8))))>>3)))) {
              vector_48X = Sundumpable_recordsS;
              len_49X = (((7 + ((long)(((unsigned long)(*((long *) ((((char *) (-3 + vector_48X))) + -8))))>>8))))>>3);
              arg0K0 = 0;
              goto L12366;}
            else {
              goto L14248;}}
          else {
            arg0K0 = thing_42X;
            goto L13131;}}
        else {
          arg0K0 = thing_42X;
          goto L13131;}}
      else {
        arg0K0 = thing_42X;
        goto L13131;}}
    else {
      return (have_44X->new_descriptor);}}
  else {
    return thing_42X;}}
 L12366: {
  i_50X = arg0K0;
  if ((i_50X == len_49X)) {
    *((long *) ((((char *) (-3 + (Sundumpable_recordsS)))) + ((((Sundumpable_countS))<<3)))) = (long) (thing_42X);
    Sundumpable_countS = (1 + (Sundumpable_countS));
    goto L14248;}
  else {
    if (((*((long *) ((((char *) (-3 + vector_48X))) + (((i_50X)<<3))))) == thing_42X)) {
      goto L14248;}
    else {
      arg0K0 = (1 + i_50X);
      goto L12366;}}}
 L14248: {
  new_alias_51X = trace_image_value((*((long *) ((((char *) (-3 + thing_42X))) + 8))));
  image_location_52X = (struct image_location*)malloc(sizeof(struct image_location));
  if ((NULL == image_location_52X)) {
    arg2K0 = image_location_52X;
    goto L14252;}
  else {
    image_location_52X->new_descriptor = new_alias_51X;
    image_location_52X->next = 0;
    arg2K0 = image_location_52X;
    goto L14252;}}
 L13131: {
  stob_53X = arg0K0;
  h_54X = *((long *) ((((char *) (-3 + stob_53X))) + -8));
  data_addr_55X = (Simage_hpS) + 8;
  Simage_hpS = (data_addr_55X + (-8 & (7 + ((long)(((unsigned long)h_54X)>>8)))));
  new_descriptor_56X = 3 + (((long) data_addr_55X));
  image_location_57X = (struct image_location*)malloc(sizeof(struct image_location));
  if ((NULL == image_location_57X)) {
    arg0K0 = new_descriptor_56X;
    arg2K1 = image_location_57X;
    goto L13135;}
  else {
    image_location_57X->new_descriptor = new_descriptor_56X;
    image_location_57X->next = 0;
    arg0K0 = new_descriptor_56X;
    arg2K1 = image_location_57X;
    goto L13135;}}
 L14252: {
  new_58X = arg2K0;
  if ((NULL == new_58X)) {
    (Sstob_tableS)->size = 0;
    return new_alias_51X;}
  else {table_setB((Sstob_tableS), thing_42X, new_58X);
    return new_alias_51X;}}
 L13135: {
  new_descriptor_59X = arg0K0;
  new_60X = arg2K1;
  if ((NULL == new_60X)) {
    (Sstob_tableS)->size = 0;
    return new_descriptor_59X;}
  else {
    x_61X = Sfirst_stobS;
    if ((1 == x_61X)) {
      Sfirst_stobS = stob_53X;
      goto L13156;}
    else {
      (Slast_stobS)->next = stob_53X;
      goto L13156;}}}
 L13156: {
  Slast_stobS = new_60X;
  new_60X->next = 1;table_setB((Sstob_tableS), stob_53X, new_60X);
  v_62X = resumer_recordP(stob_53X);
  if (v_62X) {
    Sresumer_countS = (1 + (Sresumer_countS));
    return new_descriptor_59X;}
  else {
    return new_descriptor_59X;}}
 gc_recordP: {
  x_43X = merged_arg0K0;{
  if ((3 == (3 & x_43X))) {
    header_63X = *((long *) ((((char *) (-3 + x_43X))) + -8));
    if ((3 == (3 & header_63X))) {
      if ((3 == (3 & header_63X))) {
        gc_recordP0_return_value = (9 == (31 & ((((*((long *) ((((char *) (-3 + header_63X))) + -8))))>>2))));
        goto gc_recordP_return;}
      else {
        gc_recordP0_return_value = 0;
        goto gc_recordP_return;}}
    else {
      if ((3 == (3 & x_43X))) {
        gc_recordP0_return_value = (9 == (31 & ((((*((long *) ((((char *) (-3 + x_43X))) + -8))))>>2))));
        goto gc_recordP_return;}
      else {
        gc_recordP0_return_value = 0;
        goto gc_recordP_return;}}}
  else {
    gc_recordP0_return_value = 0;
    goto gc_recordP_return;}}
 gc_recordP_return:
  switch (gc_recordP_return_tag) {
  case 0: goto gc_recordP_return_0;
  default: goto gc_recordP_return_1;
  }}

}
void s48_write_barrier(long stob_64X, char * address_65X, long value_66X)
{

 {  return;}
}
void s48_forbid_gcB(void)
{

 {  return;}
}
void s48_allow_gcB(void)
{

 {  return;}
}
long s48_heap_size(void)
{

 {  return ((Snewspace_endS) - (Snewspace_beginS));}
}
long s48_gc_count(void)
{

 {  return (Sgc_countS);}
}
long s48_gc_run_time(long *TT0)
{

 {  *TT0 = (Sgc_msecondsS);
  return (Sgc_secondsS);}
}
void s48_initialization_completeB(void)
{

 {  SinitializingPS = 0;
  return;}
}
long s48_max_heap_size(void)
{

 {  return ((((7 + ((Snewspace_endS) - (Snewspace_beginS))))>>3));}
}
long s48_startup_procedure(void)
{

 {  return (Sstartup_procedureS);}
}
long s48_initial_symbols(void)
{

 {  return (SsymbolsS);}
}
long s48_initial_imported_bindings(void)
{

 {  return (Simported_bindingsS);}
}
long s48_initial_exported_bindings(void)
{

 {  return (Sexported_bindingsS);}
}
long s48_resumer_records(void)
{

 {  return (Sresumer_recordsS);}
}
void s48_set_image_valuesB(long startup_proc_67X, long symbols_68X, long imports_69X, long exports_70X, long records_71X)
{

 {  Sstartup_procedureS = startup_proc_67X;
  SsymbolsS = symbols_68X;
  Simported_bindingsS = imports_69X;
  Sexported_bindingsS = exports_70X;
  Sresumer_recordsS = records_71X;
  return;}
}
char * s48_allocate_small(long len_72X)
{
  char * new_73X;
 {  new_73X = s48_ShpS;
  s48_ShpS = ((s48_ShpS) + (-8 & (7 + len_72X)));
  return new_73X;}
}
char s48_stob_in_heapP(long stob_74X)
{
  char temp_76X;
  char * addr_75X;
 {  addr_75X = (((char *) (-3 + stob_74X))) + -8;
  temp_76X = addr_75X < (Snewspace_beginS);
  if (temp_76X) {
    goto L3693;}
  else {
    if ((addr_75X < (s48_ShpS))) {
      if ((2 == (3 & (*((long *) addr_75X))))) {
        return 1;}
      else {
        ps_write_string("Heap-check: stob has no header.", (stderr));
        { long ignoreXX;
        PS_WRITE_CHAR(10, (stderr), ignoreXX) }
        Sheap_errors_leftS = (-1 + (Sheap_errors_leftS));
        return ((Sheap_errors_leftS) < 1);}}
    else {
      goto L3693;}}}
 L3693: {
  ps_write_string("Heap-check: address out of bounds.", (stderr));
  { long ignoreXX;
  PS_WRITE_CHAR(10, (stderr), ignoreXX) }
  Sheap_errors_leftS = (-1 + (Sheap_errors_leftS));
  return ((Sheap_errors_leftS) < 1);}
}
long s48_available(void)
{

 {  return (((((s48_SlimitS) - (s48_ShpS)))>>3));}
}
char s48_extantP(long thing_77X)
{
  char * a_78X;
 {  if ((3 == (3 & thing_77X))) {
    if ((3 == (3 & thing_77X))) {
      a_78X = ((char *) (-3 + thing_77X));
      if ((a_78X < (Sfrom_beginS))) {
        return 1;}
      else {
        if ((a_78X < (Sfrom_endS))) {
          return (3 == (3 & (*((long *) ((((char *) (-3 + thing_77X))) + -8)))));}
        else {
          return 1;}}}
    else {
      return 1;}}
  else {
    return 1;}}
}
long s48_gather_objects(char (*predicate_79X)(long), char (*for_each_object_80X)(char(*)(long)))
{
  char v_82X;
  char * start_hp_81X;
 {  Scollect_predicateS = predicate_79X;
  start_hp_81X = s48_ShpS;
  *((long *) (s48_ShpS)) = (long) (0);
  s48_ShpS = ((s48_ShpS) + 8);
  v_82X = (*for_each_object_80X)(pD1);
  if (v_82X) {
    *((long *) start_hp_81X) = (long) ((10 + (((((s48_ShpS) - (start_hp_81X + 8)))<<8))));
    return (3 + (((long) (start_hp_81X + 8))));}
  else {
    s48_ShpS = start_hp_81X;
    return 1;}}
}
static char pD1(long obj_83X)
{
  char x_84X;
 {  x_84X = (*(Scollect_predicateS))(obj_83X);
  if (x_84X) {
    if ((((s48_ShpS) + 64) < (s48_SlimitS))) {
      *((long *) (s48_ShpS)) = (long) (obj_83X);
      s48_ShpS = ((s48_ShpS) + 8);
      return 1;}
    else {
      return 0;}}
  else {
    return 1;}}
}
char s48_check_heap(long error_count_85X)
{
  char * arg1K0;
  long arg0K0;
  char * merged_arg1K1;
  char * merged_arg1K0;

  int check_area_return_tag;
  char check_area0_return_value;
  char * start_86X;
  char * end_87X;
  char v_104X;
  long x_103X;
  char * addr_102X;
  char * next_101X;
  long d_100X;
  char * addr_99X;
  char v_98X;
  long i_97X;
  long count_96X;
  long *sizes_95X;
  char * *areas_94X;
  char v_93X;
  long i_92X;
  long count_91X;
  long *sizes_90X;
  char * *areas_89X;
  char v_88X;
 {  Sheap_errors_leftS = error_count_85X;
  merged_arg1K0 = (Snewspace_beginS);
  merged_arg1K1 = (s48_ShpS);
  check_area_return_tag = 0;
  goto check_area;
 check_area_return_0:
  v_88X = check_area0_return_value;
  if (v_88X) {
    if ((0 < (Simpure_area_countS))) {
      areas_89X = Simpure_areasS;
      sizes_90X = Simpure_sizesS;
      count_91X = Simpure_area_countS;
      arg0K0 = 0;
      goto L11296;}
    else {
      goto L11280;}}
  else {
    return 0;}}
 L11296: {
  i_92X = arg0K0;
  if ((i_92X < count_91X)) {
    merged_arg1K0 = (*(areas_89X + i_92X));
    merged_arg1K1 = ((*(areas_89X + i_92X)) + (*(sizes_90X + i_92X)));
    check_area_return_tag = 1;
    goto check_area;
   check_area_return_1:
    v_93X = check_area0_return_value;
    if (v_93X) {
      arg0K0 = (1 + i_92X);
      goto L11296;}
    else {
      return 0;}}
  else {
    goto L11280;}}
 L11280: {
  if ((0 < (Spure_area_countS))) {
    areas_94X = Spure_areasS;
    sizes_95X = Spure_sizesS;
    count_96X = Spure_area_countS;
    arg0K0 = 0;
    goto L11317;}
  else {
    return 1;}}
 L11317: {
  i_97X = arg0K0;
  if ((i_97X < count_96X)) {
    merged_arg1K0 = (*(areas_94X + i_97X));
    merged_arg1K1 = ((*(areas_94X + i_97X)) + (*(sizes_95X + i_97X)));
    check_area_return_tag = 2;
    goto check_area;
   check_area_return_2:
    v_98X = check_area0_return_value;
    if (v_98X) {
      arg0K0 = (1 + i_97X);
      goto L11317;}
    else {
      return 0;}}
  else {
    return 1;}}
 check_area: {
  start_86X = merged_arg1K0;
  end_87X = merged_arg1K1;{
  arg1K0 = start_86X;
  goto L10208;}
 L10208: {
  addr_99X = arg1K0;
  if ((addr_99X < end_87X)) {
    d_100X = *((long *) addr_99X);
    next_101X = addr_99X + (8 + (-8 & (7 + ((long)(((unsigned long)d_100X)>>8)))));
    if ((2 == (3 & d_100X))) {
      if ((end_87X < next_101X)) {
        ps_write_string("Heap-check: header too large.", (stderr));
        { long ignoreXX;
        PS_WRITE_CHAR(10, (stderr), ignoreXX) }
        Sheap_errors_leftS = (-1 + (Sheap_errors_leftS));
        check_area0_return_value = ((Sheap_errors_leftS) < 1);
        goto check_area_return;}
      else {
        if ((2 == (3 & d_100X))) {
          if (((31 & (((d_100X)>>2))) < 16)) {
            goto L10234;}
          else {
            arg1K0 = next_101X;
            goto L10208;}}
        else {
          goto L10234;}}}
    else {
      ps_write_string("Heap-check: unexpected non-header.", (stderr));
      { long ignoreXX;
      PS_WRITE_CHAR(10, (stderr), ignoreXX) }
      Sheap_errors_leftS = (-1 + (Sheap_errors_leftS));
      check_area0_return_value = ((Sheap_errors_leftS) < 1);
      goto check_area_return;}}
  else {
    check_area0_return_value = 1;
    goto check_area_return;}}
 L10234: {
  arg1K0 = (addr_99X + 8);
  goto L8968;}
 L8968: {
  addr_102X = arg1K0;
  if ((addr_102X == next_101X)) {
    arg1K0 = next_101X;
    goto L10208;}
  else {
    x_103X = *((long *) addr_102X);
    if ((2 == (3 & x_103X))) {
      ps_write_string("Heap-check: unexpected header.", (stderr));
      { long ignoreXX;
      PS_WRITE_CHAR(10, (stderr), ignoreXX) }
      Sheap_errors_leftS = (-1 + (Sheap_errors_leftS));
      if (((Sheap_errors_leftS) < 1)) {
        arg1K0 = next_101X;
        goto L10208;}
      else {
        check_area0_return_value = 0;
        goto check_area_return;}}
    else {
      if ((3 == (3 & x_103X))) {
        v_104X = s48_stob_in_heapP(x_103X);
        if (v_104X) {
          goto L8993;}
        else {
          check_area0_return_value = 0;
          goto check_area_return;}}
      else {
        goto L8993;}}}}
 L8993: {
  arg1K0 = (addr_102X + 8);
  goto L8968;}
 check_area_return:
  switch (check_area_return_tag) {
  case 0: goto check_area_return_0;
  case 1: goto check_area_return_1;
  default: goto check_area_return_2;
  }}

}
long s48_find_all(long type_105X)
{
  char * arg1K0;
  long arg0K0;
  char * merged_arg1K1;
  char * merged_arg1K0;

  int Hproc25106_return_tag;
  char Hproc251060_return_value;
  char * start_107X;
  char * end_108X;
  char * next_125X;
  long d_124X;
  char * addr_123X;
  long type_122X;
  char v_121X;
  long i_120X;
  long count_119X;
  long *sizes_118X;
  char * *areas_117X;
  char v_116X;
  long i_115X;
  long count_114X;
  long *sizes_113X;
  char * *areas_112X;
  char v_111X;
  char * start_hp_110X;
  char * start_hp_109X;
 {  Sfinding_typeS = type_105X;
  start_hp_109X = s48_ShpS;
  start_hp_110X = s48_ShpS;
  *((long *) (s48_ShpS)) = (long) (0);
  s48_ShpS = ((s48_ShpS) + 8);
  merged_arg1K0 = (Snewspace_beginS);
  merged_arg1K1 = start_hp_109X;
  Hproc25106_return_tag = 0;
  goto Hproc25106;
 Hproc25106_return_0:
  v_111X = Hproc251060_return_value;
  if (v_111X) {
    if ((0 < (Simpure_area_countS))) {
      areas_112X = Simpure_areasS;
      sizes_113X = Simpure_sizesS;
      count_114X = Simpure_area_countS;
      arg0K0 = 0;
      goto L11431;}
    else {
      goto L11400;}}
  else {
    goto L11413;}}
 L11431: {
  i_115X = arg0K0;
  if ((i_115X < count_114X)) {
    merged_arg1K0 = (*(areas_112X + i_115X));
    merged_arg1K1 = ((*(areas_112X + i_115X)) + (*(sizes_113X + i_115X)));
    Hproc25106_return_tag = 1;
    goto Hproc25106;
   Hproc25106_return_1:
    v_116X = Hproc251060_return_value;
    if (v_116X) {
      arg0K0 = (1 + i_115X);
      goto L11431;}
    else {
      goto L11413;}}
  else {
    goto L11400;}}
 L11400: {
  if ((0 < (Spure_area_countS))) {
    areas_117X = Spure_areasS;
    sizes_118X = Spure_sizesS;
    count_119X = Spure_area_countS;
    arg0K0 = 0;
    goto L11452;}
  else {
    goto L11415;}}
 L11413: {
  s48_ShpS = start_hp_110X;
  return 1;}
 L11452: {
  i_120X = arg0K0;
  if ((i_120X < count_119X)) {
    merged_arg1K0 = (*(areas_117X + i_120X));
    merged_arg1K1 = ((*(areas_117X + i_120X)) + (*(sizes_118X + i_120X)));
    Hproc25106_return_tag = 2;
    goto Hproc25106;
   Hproc25106_return_2:
    v_121X = Hproc251060_return_value;
    if (v_121X) {
      arg0K0 = (1 + i_120X);
      goto L11452;}
    else {
      goto L11413;}}
  else {
    goto L11415;}}
 L11415: {
  *((long *) start_hp_110X) = (long) ((10 + (((((s48_ShpS) - (start_hp_110X + 8)))<<8))));
  return (3 + (((long) (start_hp_110X + 8))));}
 Hproc25106: {
  start_107X = merged_arg1K0;
  end_108X = merged_arg1K1;{
  type_122X = Sfinding_typeS;
  arg1K0 = start_107X;
  goto L10726;}
 L10726: {
  addr_123X = arg1K0;
  if ((addr_123X < end_108X)) {
    d_124X = *((long *) addr_123X);
    next_125X = addr_123X + (8 + (-8 & (7 + ((long)(((unsigned long)d_124X)>>8)))));
    if ((2 == (3 & d_124X))) {
      if ((type_122X == (31 & (((d_124X)>>2))))) {
        if ((((s48_ShpS) + 64) < (s48_SlimitS))) {
          *((long *) (s48_ShpS)) = (long) ((3 + (((long) (addr_123X + 8)))));
          s48_ShpS = ((s48_ShpS) + 8);
          arg1K0 = next_125X;
          goto L10726;}
        else {
          Hproc251060_return_value = 0;
          goto Hproc25106_return;}}
      else {
        arg1K0 = next_125X;
        goto L10726;}}
    else {
      ps_write_string("heap is in an inconsistent state.", (stderr));
      Hproc251060_return_value = 0;
      goto Hproc25106_return;}}
  else {
    Hproc251060_return_value = 1;
    goto Hproc25106_return;}}
 Hproc25106_return:
  switch (Hproc25106_return_tag) {
  case 0: goto Hproc25106_return_0;
  case 1: goto Hproc25106_return_1;
  default: goto Hproc25106_return_2;
  }}

}
long s48_trace_value(long stob_126X)
{
  char * new_hp_129X;
  long new_thing_128X;
  char * a_127X;
 {  if ((3 == (3 & stob_126X))) {
    a_127X = ((char *) (-3 + stob_126X));
    if ((a_127X < (Sfrom_beginS))) {
      return stob_126X;}
    else {
      if ((a_127X < (Sfrom_endS))) {
        new_thing_128X = real_copy_object(stob_126X, (s48_ShpS), &new_hp_129X);
        s48_ShpS = new_hp_129X;
        return new_thing_128X;}
      else {
        return stob_126X;}}}
  else {
    return stob_126X;}}
}
long s48_find_all_records(long record_type_130X)
{
  char * arg1K0;
  long arg0K0;
  char * merged_arg1K1;
  char * merged_arg1K0;

  int Hproc85131_return_tag;
  char Hproc851310_return_value;
  char * start_132X;
  char * end_133X;
  long obj_151X;
  char * next_150X;
  long d_149X;
  char * addr_148X;
  long type_147X;
  char v_146X;
  long i_145X;
  long count_144X;
  long *sizes_143X;
  char * *areas_142X;
  char v_141X;
  long i_140X;
  long count_139X;
  long *sizes_138X;
  char * *areas_137X;
  char v_136X;
  char * start_hp_135X;
  char * start_hp_134X;
 {  Hthe_record_type280 = record_type_130X;
  Sfinding_typeS = 9;
  start_hp_134X = s48_ShpS;
  start_hp_135X = s48_ShpS;
  *((long *) (s48_ShpS)) = (long) (0);
  s48_ShpS = ((s48_ShpS) + 8);
  merged_arg1K0 = (Snewspace_beginS);
  merged_arg1K1 = start_hp_134X;
  Hproc85131_return_tag = 0;
  goto Hproc85131;
 Hproc85131_return_0:
  v_136X = Hproc851310_return_value;
  if (v_136X) {
    if ((0 < (Simpure_area_countS))) {
      areas_137X = Simpure_areasS;
      sizes_138X = Simpure_sizesS;
      count_139X = Simpure_area_countS;
      arg0K0 = 0;
      goto L11561;}
    else {
      goto L11530;}}
  else {
    goto L11543;}}
 L11561: {
  i_140X = arg0K0;
  if ((i_140X < count_139X)) {
    merged_arg1K0 = (*(areas_137X + i_140X));
    merged_arg1K1 = ((*(areas_137X + i_140X)) + (*(sizes_138X + i_140X)));
    Hproc85131_return_tag = 1;
    goto Hproc85131;
   Hproc85131_return_1:
    v_141X = Hproc851310_return_value;
    if (v_141X) {
      arg0K0 = (1 + i_140X);
      goto L11561;}
    else {
      goto L11543;}}
  else {
    goto L11530;}}
 L11530: {
  if ((0 < (Spure_area_countS))) {
    areas_142X = Spure_areasS;
    sizes_143X = Spure_sizesS;
    count_144X = Spure_area_countS;
    arg0K0 = 0;
    goto L11582;}
  else {
    goto L11545;}}
 L11543: {
  s48_ShpS = start_hp_135X;
  return 1;}
 L11582: {
  i_145X = arg0K0;
  if ((i_145X < count_144X)) {
    merged_arg1K0 = (*(areas_142X + i_145X));
    merged_arg1K1 = ((*(areas_142X + i_145X)) + (*(sizes_143X + i_145X)));
    Hproc85131_return_tag = 2;
    goto Hproc85131;
   Hproc85131_return_2:
    v_146X = Hproc851310_return_value;
    if (v_146X) {
      arg0K0 = (1 + i_145X);
      goto L11582;}
    else {
      goto L11543;}}
  else {
    goto L11545;}}
 L11545: {
  *((long *) start_hp_135X) = (long) ((10 + (((((s48_ShpS) - (start_hp_135X + 8)))<<8))));
  return (3 + (((long) (start_hp_135X + 8))));}
 Hproc85131: {
  start_132X = merged_arg1K0;
  end_133X = merged_arg1K1;{
  type_147X = Sfinding_typeS;
  arg1K0 = start_132X;
  goto L10893;}
 L10893: {
  addr_148X = arg1K0;
  if ((addr_148X < end_133X)) {
    d_149X = *((long *) addr_148X);
    next_150X = addr_148X + (8 + (-8 & (7 + ((long)(((unsigned long)d_149X)>>8)))));
    if ((2 == (3 & d_149X))) {
      if ((type_147X == (31 & (((d_149X)>>2))))) {
        obj_151X = 3 + (((long) (addr_148X + 8)));
        if (((*((long *) (((char *) (-3 + obj_151X))))) == (Hthe_record_type280))) {
          if ((((s48_ShpS) + 64) < (s48_SlimitS))) {
            *((long *) (s48_ShpS)) = (long) (obj_151X);
            s48_ShpS = ((s48_ShpS) + 8);
            arg1K0 = next_150X;
            goto L10893;}
          else {
            Hproc851310_return_value = 0;
            goto Hproc85131_return;}}
        else {
          arg1K0 = next_150X;
          goto L10893;}}
      else {
        arg1K0 = next_150X;
        goto L10893;}}
    else {
      ps_write_string("heap is in an inconsistent state.", (stderr));
      Hproc851310_return_value = 0;
      goto Hproc85131_return;}}
  else {
    Hproc851310_return_value = 1;
    goto Hproc85131_return;}}
 Hproc85131_return:
  switch (Hproc85131_return_tag) {
  case 0: goto Hproc85131_return_0;
  case 1: goto Hproc85131_return_1;
  default: goto Hproc85131_return_2;
  }}

}
void s48_trace_continuation_contentsB(char * contents_pointer_152X, char * code_pointer_153X, long mask_size_154X)
{
  char * arg1K0;
  char * arg1K1;
  long arg0K0;
  long x2_164X;
  char * new_hp_163X;
  long new_thing_162X;
  char * a_161X;
  long stob_160X;
  char * ptr_159X;
  long mask_158X;
  char * trace_ptr_157X;
  char * mask_ptr_156X;
  char * mask_pointer_155X;
 {  mask_pointer_155X = code_pointer_153X + -7;
  arg1K0 = (mask_pointer_155X + (0 - mask_size_154X));
  arg1K1 = contents_pointer_152X;
  goto L13308;}
 L13308: {
  mask_ptr_156X = arg1K0;
  trace_ptr_157X = arg1K1;
  if ((mask_ptr_156X == mask_pointer_155X)) {
    return;}
  else {
    arg0K0 = (*((unsigned char *) mask_ptr_156X));
    arg1K1 = trace_ptr_157X;
    goto L13316;}}
 L13316: {
  mask_158X = arg0K0;
  ptr_159X = arg1K1;
  if ((0 == mask_158X)) {
    arg1K0 = (mask_ptr_156X + 1);
    arg1K1 = (trace_ptr_157X + 64);
    goto L13308;}
  else {
    if ((1 == (1 & mask_158X))) {
      stob_160X = *((long *) ptr_159X);
      if ((3 == (3 & stob_160X))) {
        a_161X = ((char *) (-3 + stob_160X));
        if ((a_161X < (Sfrom_beginS))) {
          arg0K0 = stob_160X;
          goto L13329;}
        else {
          if ((a_161X < (Sfrom_endS))) {
            new_thing_162X = real_copy_object(stob_160X, (s48_ShpS), &new_hp_163X);
            s48_ShpS = new_hp_163X;
            arg0K0 = new_thing_162X;
            goto L13329;}
          else {
            arg0K0 = stob_160X;
            goto L13329;}}}
      else {
        arg0K0 = stob_160X;
        goto L13329;}}
    else {
      goto L13334;}}}
 L13329: {
  x2_164X = arg0K0;
  *((long *) ptr_159X) = (long) (x2_164X);
  goto L13334;}
 L13334: {
  arg0K0 = (((mask_158X)>>1));
  arg1K1 = (ptr_159X + 8);
  goto L13316;}
}
void s48_initializing_gc_root(void)
{
  long arg0K0;
  long expr_189X;
  char * new_hp_188X;
  long new_thing_187X;
  char * a_186X;
  long stob_185X;
  long expr_184X;
  char * new_hp_183X;
  long new_thing_182X;
  char * a_181X;
  long stob_180X;
  long expr_179X;
  char * new_hp_178X;
  long new_thing_177X;
  char * a_176X;
  long stob_175X;
  long expr_174X;
  char * new_hp_173X;
  long new_thing_172X;
  char * a_171X;
  long stob_170X;
  long expr_169X;
  char * new_hp_168X;
  long new_thing_167X;
  char * a_166X;
  long stob_165X;
 {  if ((SinitializingPS)) {
    stob_165X = Sstartup_procedureS;
    if ((3 == (3 & stob_165X))) {
      a_166X = ((char *) (-3 + stob_165X));
      if ((a_166X < (Sfrom_beginS))) {
        arg0K0 = stob_165X;
        goto L13422;}
      else {
        if ((a_166X < (Sfrom_endS))) {
          new_thing_167X = real_copy_object(stob_165X, (s48_ShpS), &new_hp_168X);
          s48_ShpS = new_hp_168X;
          arg0K0 = new_thing_167X;
          goto L13422;}
        else {
          arg0K0 = stob_165X;
          goto L13422;}}}
    else {
      arg0K0 = stob_165X;
      goto L13422;}}
  else {
    return;}}
 L13422: {
  expr_169X = arg0K0;
  Sstartup_procedureS = expr_169X;
  stob_170X = SsymbolsS;
  if ((3 == (3 & stob_170X))) {
    a_171X = ((char *) (-3 + stob_170X));
    if ((a_171X < (Sfrom_beginS))) {
      arg0K0 = stob_170X;
      goto L13428;}
    else {
      if ((a_171X < (Sfrom_endS))) {
        new_thing_172X = real_copy_object(stob_170X, (s48_ShpS), &new_hp_173X);
        s48_ShpS = new_hp_173X;
        arg0K0 = new_thing_172X;
        goto L13428;}
      else {
        arg0K0 = stob_170X;
        goto L13428;}}}
  else {
    arg0K0 = stob_170X;
    goto L13428;}}
 L13428: {
  expr_174X = arg0K0;
  SsymbolsS = expr_174X;
  stob_175X = Simported_bindingsS;
  if ((3 == (3 & stob_175X))) {
    a_176X = ((char *) (-3 + stob_175X));
    if ((a_176X < (Sfrom_beginS))) {
      arg0K0 = stob_175X;
      goto L13434;}
    else {
      if ((a_176X < (Sfrom_endS))) {
        new_thing_177X = real_copy_object(stob_175X, (s48_ShpS), &new_hp_178X);
        s48_ShpS = new_hp_178X;
        arg0K0 = new_thing_177X;
        goto L13434;}
      else {
        arg0K0 = stob_175X;
        goto L13434;}}}
  else {
    arg0K0 = stob_175X;
    goto L13434;}}
 L13434: {
  expr_179X = arg0K0;
  Simported_bindingsS = expr_179X;
  stob_180X = Sexported_bindingsS;
  if ((3 == (3 & stob_180X))) {
    a_181X = ((char *) (-3 + stob_180X));
    if ((a_181X < (Sfrom_beginS))) {
      arg0K0 = stob_180X;
      goto L13440;}
    else {
      if ((a_181X < (Sfrom_endS))) {
        new_thing_182X = real_copy_object(stob_180X, (s48_ShpS), &new_hp_183X);
        s48_ShpS = new_hp_183X;
        arg0K0 = new_thing_182X;
        goto L13440;}
      else {
        arg0K0 = stob_180X;
        goto L13440;}}}
  else {
    arg0K0 = stob_180X;
    goto L13440;}}
 L13440: {
  expr_184X = arg0K0;
  Sexported_bindingsS = expr_184X;
  stob_185X = Sresumer_recordsS;
  if ((3 == (3 & stob_185X))) {
    a_186X = ((char *) (-3 + stob_185X));
    if ((a_186X < (Sfrom_beginS))) {
      arg0K0 = stob_185X;
      goto L13446;}
    else {
      if ((a_186X < (Sfrom_endS))) {
        new_thing_187X = real_copy_object(stob_185X, (s48_ShpS), &new_hp_188X);
        s48_ShpS = new_hp_188X;
        arg0K0 = new_thing_187X;
        goto L13446;}
      else {
        arg0K0 = stob_185X;
        goto L13446;}}}
  else {
    arg0K0 = stob_185X;
    goto L13446;}}
 L13446: {
  expr_189X = arg0K0;
  Sresumer_recordsS = expr_189X;
  return;}
}
long s48_write_image(long resume_proc_190X, long undumpables_191X, FILE * port_192X)
{
  struct table *arg3K0;
  long arg0K0;
  char * arg1K0;
  long merged_arg0K0;
  long merged_arg0K1;
  char * merged_arg1K0;

  int copy_image_data_return_tag;
  int write_descriptor_return_tag;
  int write_shared_table_return_tag;
  char write_shared_table0_return_value;
  char * start_193X;
  long size_194X;
  long descriptor_195X;
  long table_196X;
  long have_338X;
  long have_337X;
  long v_336X;
  long value_335X;
  struct image_location *have_334X;
  long thing_333X;
  long link_332X;
  struct image_location *v_331X;
  long next_330X;
  long shared_329X;
  long link_328X;
  char temp_327X;
  long i_326X;
  long value_325X;
  long v_324X;
  struct image_location *have_323X;
  long v_322X;
  long v_321X;
  struct image_location *have_320X;
  long thing_319X;
  struct image_location *have_318X;
  long thing_317X;
  long x_316X;
  char * addr_315X;
  long v_314X;
  long value_313X;
  struct image_location *have_312X;
  long thing_311X;
  char * addr_310X;
  char * start_309X;
  long header_308X;
  long next_307X;
  struct image_location *have_306X;
  long thing_305X;
  struct image_location *have_304X;
  char * addr_303X;
  long v_302X;
  long link_301X;
  struct image_location *v_300X;
  long next_299X;
  char * start_298X;
  long header_297X;
  long next_296X;
  long value_295X;
  long have_294X;
  long available_293X;
  long size_292X;
  char * start_291X;
  long header_290X;
  long shared_289X;
  long link_288X;
  struct image_location *v_287X;
  long next_286X;
  struct image_location *have_285X;
  long thing_284X;
  long i_283X;
  long link_282X;
  long symbol_281X;
  long v_280X;
  long link_279X;
  struct image_location *v_278X;
  long next_277X;
  struct image_location **values_276X;
  long *keys_275X;
  struct table *table_274X;
  long link_273X;
  struct image_location *have_272X;
  long thing_271X;
  long id_270X;
  char * addr_269X;
  long symbol_268X;
  long have_267X;
  char v_266X;
  struct image_location *location_265X;
  long stob_264X;
  char * start_263X;
  long header_262X;
  struct image_location *have_261X;
  long thing_260X;
  long link_259X;
  long v_258X;
  long v_257X;
  long i_256X;
  struct image_location *v_255X;
  long thing_254X;
  long table_253X;
  struct image_location *location_252X;
  long stob_251X;
  struct table *stob_table_250X;
  long first_stob_249X;
  long v_248X;
  long v_247X;
  long v_246X;
  long v_245X;
  long n_244X;
  struct image_location *have_243X;
  long thing_242X;
  long v_241X;
  long n_240X;
  struct image_location *have_239X;
  long thing_238X;
  long v_237X;
  long n_236X;
  struct image_location *have_235X;
  long thing_234X;
  long v_233X;
  long cells_232X;
  long v_231X;
  long cells_230X;
  long v_229X;
  long v_228X;
  long v_227X;
  long v_226X;
  long i_225X;
  long v_224X;
  struct image_location **values_223X;
  long *keys_222X;
  struct table *table_221X;
  long v_220X;
  long resumer_records_219X;
  char * data_addr_218X;
  long cells_217X;
  long v_216X;
  long v_215X;
  long v_214X;
  struct image_location *last_213X;
  char * addr_212X;
  long next_211X;
  struct image_location *image_location_210X;
  char * start_209X;
  long link_208X;
  long entry_207X;
  long header_206X;
  long stob_205X;
  long link_204X;
  long i_203X;
  long table_202X;
  long resume_proc_201X;
  struct table *v_200X;
  struct table *table_199X;
  long i_198X;
  long *keys_197X;
 {  keys_197X = (long*)malloc(sizeof(long) * 4097);
  arg0K0 = 0;
  goto L7028;}
 L7028: {
  i_198X = arg0K0;
  if ((i_198X < 4097)) {
    *(keys_197X + i_198X) = 0;
    arg0K0 = (1 + i_198X);
    goto L7028;}
  else {
    table_199X = (struct table*)malloc(sizeof(struct table));
    if ((NULL == table_199X)) {
      arg3K0 = table_199X;
      goto L7001;}
    else {
      table_199X->keys = keys_197X;
      table_199X->values = ((struct image_location**)malloc(sizeof(struct image_location*) * 4096));
      table_199X->count = 0;
      table_199X->size = 4096;
      arg3K0 = table_199X;
      goto L7001;}}}
 L7001: {
  v_200X = arg3K0;
  Sstob_tableS = v_200X;
  Sfirst_stobS = 1;
  Slast_stobS = (NULL);
  Sundumpable_recordsS = undumpables_191X;
  Sundumpable_countS = 0;
  Sresumer_countS = 0;
  image_start_address = (((long) (Snew_heap_start_addrS)));
  Simage_beginS = (((char *) (image_start_address)));
  Simage_hpS = (((char *) (image_start_address)));
  Simage_portS = port_192X;
  Simage_bufferS = ((char *)malloc(4096));
  Simage_buffer_pointerS = (Simage_bufferS);
  SstatusS = NO_ERRORS;
  if (((Simage_bufferS) == NULL)) {
    return ENOMEM;}
  else {
    resume_proc_201X = trace_image_value(resume_proc_190X);
    table_202X = s48_exported_bindings();
    arg0K0 = 0;
    goto L11719;}}
 L11719: {
  i_203X = arg0K0;
  if ((1024 == i_203X)) {
    arg0K0 = (Sfirst_stobS);
    goto L14036;}
  else {
    link_204X = *((long *) ((((char *) (-3 + table_202X))) + (((i_203X)<<3))));
    if ((0 == (3 & link_204X))) {
      arg0K0 = (3 + (-4 & link_204X));
      goto L11693;}
    else {
      arg0K0 = link_204X;
      goto L11693;}}}
 L14036: {
  stob_205X = arg0K0;
  header_206X = *((long *) ((((char *) (-3 + stob_205X))) + -8));
  if ((2 == (3 & header_206X))) {
    if (((31 & (((header_206X)>>2))) < 16)) {
      goto L13900;}
    else {
      goto L14038;}}
  else {
    goto L13900;}}
 L11693: {
  entry_207X = arg0K0;
  if ((1 == entry_207X)) {
    arg0K0 = (1 + i_203X);
    goto L11719;}
  else {trace_image_value(entry_207X);
    link_208X = *((long *) ((((char *) (-3 + entry_207X))) + 24));
    if ((0 == (3 & link_208X))) {
      arg0K0 = (3 + (-4 & link_208X));
      goto L11693;}
    else {
      arg0K0 = link_208X;
      goto L11693;}}}
 L13900: {
  if ((2102 == header_206X)) {
    goto L14038;}
  else {
    start_209X = ((char *) (-3 + stob_205X));
    arg1K0 = start_209X;
    goto L13919;}}
 L14038: {
  if ((0 < ((Sstob_tableS)->size))) {
    image_location_210X = table_ref((Sstob_tableS), stob_205X);
    next_211X = image_location_210X->next;
    if ((3 == (3 & next_211X))) {
      arg0K0 = next_211X;
      goto L14036;}
    else {
      goto L14117;}}
  else {
    goto L14117;}}
 L13919: {
  addr_212X = arg1K0;
  if ((addr_212X == (start_209X + (-8 & (7 + ((long)(((unsigned long)header_206X)>>8))))))) {
    goto L14038;}
  else {trace_image_value((*((long *) addr_212X)));
    arg1K0 = (addr_212X + 8);
    goto L13919;}}
 L14117: {
  last_213X = Slast_stobS;
  v_214X = s48_symbol_table();trace_image_value(v_214X);
  v_215X = s48_imported_bindings();trace_image_value(v_215X);
  v_216X = s48_exported_bindings();trace_image_value(v_216X);
  last_213X->next = 1;
  cells_217X = Sresumer_countS;
  data_addr_218X = (Simage_hpS) + 8;
  Simage_hpS = (data_addr_218X + (((cells_217X)<<3)));
  Sresumer_recordsS = (3 + (((long) data_addr_218X)));
  if ((0 < ((Sstob_tableS)->size))) {
    resumer_records_219X = Sresumer_recordsS;
    if (((SstatusS) == NO_ERRORS)) {
      PS_WRITE_CHAR(10, port_192X, v_220X)
      SstatusS = v_220X;
      goto L5899;}
    else {
      goto L5899;}}
  else {
    table_221X = Sstob_tableS;
    keys_222X = table_221X->keys;
    values_223X = table_221X->values;
    arg0K0 = 0;
    goto L14433;}}
 L5899: {
  if (((SstatusS) == NO_ERRORS)) {
    PS_WRITE_CHAR(12, (Simage_portS), v_224X)
    SstatusS = v_224X;
    goto L5901;}
  else {
    goto L5901;}}
 L14433: {
  i_225X = arg0K0;
  if ((i_225X == (table_221X->size))) {
    free(keys_222X);
    free(values_223X);
    free(table_221X);
    free((Simage_bufferS));
    return ENOMEM;}
  else {
    if ((0 == (*(keys_222X + i_225X)))) {
      goto L14435;}
    else {
      free((*(values_223X + i_225X)));
      goto L14435;}}}
 L5901: {
  if (((SstatusS) == NO_ERRORS)) {
    PS_WRITE_CHAR(10, port_192X, v_226X)
    SstatusS = v_226X;
    goto L5910;}
  else {
    goto L5910;}}
 L14435: {
  arg0K0 = (1 + i_225X);
  goto L14433;}
 L5910: {
  if (((SstatusS) == NO_ERRORS)) {
    SstatusS = (ps_write_string("Vanilla 34", port_192X));
    goto L5917;}
  else {
    goto L5917;}}
 L5917: {
  if (((SstatusS) == NO_ERRORS)) {
    PS_WRITE_CHAR(10, port_192X, v_227X)
    SstatusS = v_227X;
    goto L5926;}
  else {
    goto L5926;}}
 L5926: {
  if (((SstatusS) == NO_ERRORS)) {
    SstatusS = (ps_write_integer(0, port_192X));
    goto L5933;}
  else {
    goto L5933;}}
 L5933: {
  if (((SstatusS) == NO_ERRORS)) {
    PS_WRITE_CHAR(10, port_192X, v_228X)
    SstatusS = v_228X;
    goto L5942;}
  else {
    goto L5942;}}
 L5942: {
  if (((SstatusS) == NO_ERRORS)) {
    SstatusS = (ps_write_integer(8, (Simage_portS)));
    goto L5987;}
  else {
    goto L5987;}}
 L5987: {
  if (((SstatusS) == NO_ERRORS)) {
    PS_WRITE_CHAR(10, (Simage_portS), v_229X)
    SstatusS = v_229X;
    goto L5944;}
  else {
    goto L5944;}}
 L5944: {
  cells_230X = image_start_address;
  if (((SstatusS) == NO_ERRORS)) {
    SstatusS = (ps_write_integer((((cells_230X)>>3)), (Simage_portS)));
    goto L6004;}
  else {
    goto L6004;}}
 L6004: {
  if (((SstatusS) == NO_ERRORS)) {
    PS_WRITE_CHAR(10, (Simage_portS), v_231X)
    SstatusS = v_231X;
    goto L5948;}
  else {
    goto L5948;}}
 L5948: {
  cells_232X = (image_start_address) + ((Simage_hpS) - (Simage_beginS));
  if (((SstatusS) == NO_ERRORS)) {
    SstatusS = (ps_write_integer((((cells_232X)>>3)), (Simage_portS)));
    goto L6023;}
  else {
    goto L6023;}}
 L6023: {
  if (((SstatusS) == NO_ERRORS)) {
    PS_WRITE_CHAR(10, (Simage_portS), v_233X)
    SstatusS = v_233X;
    goto L5954;}
  else {
    goto L5954;}}
 L5954: {
  thing_234X = s48_symbol_table();
  if ((3 == (3 & thing_234X))) {
    have_235X = table_ref((Sstob_tableS), thing_234X);
    if ((NULL == have_235X)) {
      ps_error("traced object has no descriptor in image", 0);
      goto L17239;}
    else {
      goto L17239;}}
  else {
    arg0K0 = thing_234X;
    goto L5958;}}
 L17239: {
  arg0K0 = (have_235X->new_descriptor);
  goto L5958;}
 L5958: {
  n_236X = arg0K0;
  if (((SstatusS) == NO_ERRORS)) {
    SstatusS = (ps_write_integer(n_236X, (Simage_portS)));
    goto L6037;}
  else {
    goto L6037;}}
 L6037: {
  if (((SstatusS) == NO_ERRORS)) {
    PS_WRITE_CHAR(10, (Simage_portS), v_237X)
    SstatusS = v_237X;
    goto L5960;}
  else {
    goto L5960;}}
 L5960: {
  thing_238X = s48_imported_bindings();
  if ((3 == (3 & thing_238X))) {
    have_239X = table_ref((Sstob_tableS), thing_238X);
    if ((NULL == have_239X)) {
      ps_error("traced object has no descriptor in image", 0);
      goto L17253;}
    else {
      goto L17253;}}
  else {
    arg0K0 = thing_238X;
    goto L5964;}}
 L17253: {
  arg0K0 = (have_239X->new_descriptor);
  goto L5964;}
 L5964: {
  n_240X = arg0K0;
  if (((SstatusS) == NO_ERRORS)) {
    SstatusS = (ps_write_integer(n_240X, (Simage_portS)));
    goto L6051;}
  else {
    goto L6051;}}
 L6051: {
  if (((SstatusS) == NO_ERRORS)) {
    PS_WRITE_CHAR(10, (Simage_portS), v_241X)
    SstatusS = v_241X;
    goto L5966;}
  else {
    goto L5966;}}
 L5966: {
  thing_242X = s48_exported_bindings();
  if ((3 == (3 & thing_242X))) {
    have_243X = table_ref((Sstob_tableS), thing_242X);
    if ((NULL == have_243X)) {
      ps_error("traced object has no descriptor in image", 0);
      goto L17267;}
    else {
      goto L17267;}}
  else {
    arg0K0 = thing_242X;
    goto L5970;}}
 L17267: {
  arg0K0 = (have_243X->new_descriptor);
  goto L5970;}
 L5970: {
  n_244X = arg0K0;
  if (((SstatusS) == NO_ERRORS)) {
    SstatusS = (ps_write_integer(n_244X, (Simage_portS)));
    goto L6065;}
  else {
    goto L6065;}}
 L6065: {
  if (((SstatusS) == NO_ERRORS)) {
    PS_WRITE_CHAR(10, (Simage_portS), v_245X)
    SstatusS = v_245X;
    goto L5972;}
  else {
    goto L5972;}}
 L5972: {
  if (((SstatusS) == NO_ERRORS)) {
    SstatusS = (ps_write_integer(resumer_records_219X, (Simage_portS)));
    goto L6079;}
  else {
    goto L6079;}}
 L6079: {
  if (((SstatusS) == NO_ERRORS)) {
    PS_WRITE_CHAR(10, (Simage_portS), v_246X)
    SstatusS = v_246X;
    goto L5974;}
  else {
    goto L5974;}}
 L5974: {
  if (((SstatusS) == NO_ERRORS)) {
    SstatusS = (ps_write_integer(resume_proc_201X, (Simage_portS)));
    goto L6093;}
  else {
    goto L6093;}}
 L6093: {
  if (((SstatusS) == NO_ERRORS)) {
    PS_WRITE_CHAR(10, (Simage_portS), v_247X)
    SstatusS = v_247X;
    goto L5976;}
  else {
    goto L5976;}}
 L5976: {
  if (((SstatusS) == NO_ERRORS)) {
    PS_WRITE_CHAR(12, (Simage_portS), v_248X)
    SstatusS = v_248X;
    goto L14334;}
  else {
    goto L14334;}}
 L14334: {
  merged_arg0K0 = 1;
  write_descriptor_return_tag = 0;
  goto write_descriptor;
 write_descriptor_return_0:
  first_stob_249X = Sfirst_stobS;
  stob_table_250X = Sstob_tableS;
  arg0K0 = first_stob_249X;
  goto L13840;}
 L13840: {
  stob_251X = arg0K0;
  if ((3 == (3 & stob_251X))) {
    location_252X = table_ref(stob_table_250X, stob_251X);
    if ((NULL == location_252X)) {
      ps_error("traced stob has no image-table entry", 0);
      goto L13845;}
    else {
      goto L13845;}}
  else {
    table_253X = s48_symbol_table();
    merged_arg0K0 = (*((long *) ((((char *) (-3 + table_253X))) + -8)));
    write_descriptor_return_tag = 1;
    goto write_descriptor;
   write_descriptor_return_1:
    arg0K0 = 0;
    goto L11892;}}
 L13845: {
  if ((3 == (3 & stob_251X))) {
    if ((13 == (31 & ((((*((long *) ((((char *) (-3 + stob_251X))) + -8))))>>2))))) {
      merged_arg0K0 = 2102;
      write_descriptor_return_tag = 2;
      goto write_descriptor;
     write_descriptor_return_2:
      thing_254X = *((long *) (((char *) (-3 + stob_251X))));
      if ((3 == (3 & thing_254X))) {
        v_255X = table_ref((Sstob_tableS), thing_254X);
        if ((NULL == v_255X)) {
          merged_arg0K0 = 1;
          write_descriptor_return_tag = 3;
          goto write_descriptor;
         write_descriptor_return_3:
          goto L13847;}
        else {
          goto L13566;}}
      else {
        goto L13566;}}
    else {
      goto L13572;}}
  else {
    goto L13572;}}
 L11892: {
  i_256X = arg0K0;
  if ((i_256X == ((((7 + ((long)(((unsigned long)(*((long *) ((((char *) (-3 + table_253X))) + -8))))>>8))))>>3)))) {
    v_257X = s48_imported_bindings();
    merged_arg0K0 = v_257X;
    write_shared_table_return_tag = 0;
    goto write_shared_table;
   write_shared_table_return_0:
    v_258X = s48_exported_bindings();
    merged_arg0K0 = v_258X;
    write_shared_table_return_tag = 1;
    goto write_shared_table;
   write_shared_table_return_1:
    merged_arg0K0 = (10 + ((((Sresumer_countS))<<11)));
    write_descriptor_return_tag = 4;
    goto write_descriptor;
   write_descriptor_return_4:
    arg0K0 = (Sfirst_stobS);
    goto L13863;}
  else {
    link_259X = *((long *) ((((char *) (-3 + table_253X))) + (((i_256X)<<3))));
    if ((0 == (3 & link_259X))) {
      arg0K0 = (3 + (-4 & link_259X));
      goto L11902;}
    else {
      arg0K0 = link_259X;
      goto L11902;}}}
 L13847: {
  arg0K0 = (location_252X->next);
  goto L13840;}
 L13566: {
  thing_260X = *((long *) (((char *) (-3 + stob_251X))));
  if ((3 == (3 & thing_260X))) {
    have_261X = table_ref((Sstob_tableS), thing_260X);
    if ((NULL == have_261X)) {
      ps_error("traced object has no descriptor in image", 0);
      goto L13630;}
    else {
      goto L13630;}}
  else {
    merged_arg0K0 = thing_260X;
    write_descriptor_return_tag = 5;
    goto write_descriptor;
   write_descriptor_return_5:
    goto L13847;}}
 L13572: {
  if ((3 == (3 & stob_251X))) {
    if ((6 == (31 & ((((*((long *) ((((char *) (-3 + stob_251X))) + -8))))>>2))))) {
      header_262X = *((long *) ((((char *) (-3 + stob_251X))) + -8));
      merged_arg0K0 = header_262X;
      write_descriptor_return_tag = 6;
      goto write_descriptor;
     write_descriptor_return_6:
      merged_arg0K0 = 0;
      write_descriptor_return_tag = 7;
      goto write_descriptor;
     write_descriptor_return_7:
      start_263X = (((char *) (-3 + stob_251X))) + 8;
      arg1K0 = start_263X;
      goto L10148;}
    else {
      goto L13576;}}
  else {
    goto L13576;}}
 L13863: {
  stob_264X = arg0K0;
  if ((3 == (3 & stob_264X))) {
    location_265X = table_ref((Sstob_tableS), stob_264X);
    v_266X = resumer_recordP(stob_264X);
    if (v_266X) {
      merged_arg0K0 = (location_265X->new_descriptor);
      write_descriptor_return_tag = 8;
      goto write_descriptor;
     write_descriptor_return_8:
      goto L13870;}
    else {
      goto L13870;}}
  else {
    have_267X = (Simage_buffer_pointerS) - (Simage_bufferS);
    if ((0 < have_267X)) {
      if (((SstatusS) == NO_ERRORS)) {
        SstatusS = (ps_write_block((Simage_portS), ((char *) (Simage_bufferS)), have_267X));
        goto L14379;}
      else {
        goto L14379;}}
    else {
      goto L14340;}}}
 L11902: {
  symbol_268X = arg0K0;
  arg0K0 = symbol_268X;
  goto L11936;}
 L13630: {
  merged_arg0K0 = (have_261X->new_descriptor);
  write_descriptor_return_tag = 9;
  goto write_descriptor;
 write_descriptor_return_9:
  goto L13847;}
 L10148: {
  addr_269X = arg1K0;
  if ((addr_269X == (start_263X + (-8 + (-8 & (7 + ((long)(((unsigned long)header_262X)>>8)))))))) {
    ps_write_string("Channel closed in dumped image: ", (stderr));
    id_270X = *((long *) ((((char *) (-3 + stob_251X))) + 8));
    if ((0 == (3 & id_270X))) {
      ps_write_integer((((id_270X)>>2)), (stderr));
      goto L10125;}
    else {
      ps_write_string((((char *)(((char *) (-3 + id_270X))))), (stderr));
      goto L10125;}}
  else {
    thing_271X = *((long *) addr_269X);
    if ((3 == (3 & thing_271X))) {
      have_272X = table_ref((Sstob_tableS), thing_271X);
      if ((NULL == have_272X)) {
        ps_error("traced object has no descriptor in image", 0);
        goto L10162;}
      else {
        goto L10162;}}
    else {
      arg0K0 = thing_271X;
      goto L10153;}}}
 L13576: {
  if ((3 == (3 & stob_251X))) {
    if ((1 == (31 & ((((*((long *) ((((char *) (-3 + stob_251X))) + -8))))>>2))))) {
      link_273X = *((long *) ((((char *) (-3 + stob_251X))) + 8));
      if ((0 == (3 & link_273X))) {
        arg0K0 = (3 + (-4 & link_273X));
        goto L12582;}
      else {
        arg0K0 = link_273X;
        goto L12582;}}
    else {
      goto L13580;}}
  else {
    goto L13580;}}
 L13870: {
  arg0K0 = (location_265X->next);
  goto L13863;}
 L14379: {
  Simage_buffer_pointerS = (Simage_bufferS);
  goto L14340;}
 L14340: {
  table_274X = Sstob_tableS;
  keys_275X = table_274X->keys;
  values_276X = table_274X->values;
  arg0K0 = 0;
  goto L14399;}
 L11936: {
  next_277X = arg0K0;
  if ((3 == (3 & next_277X))) {
    v_278X = table_ref((Sstob_tableS), next_277X);
    if ((NULL == v_278X)) {
      link_279X = *((long *) ((((char *) (-3 + next_277X))) + 8));
      if ((0 == (3 & link_279X))) {
        arg0K0 = (3 + (-4 & link_279X));
        goto L11936;}
      else {
        arg0K0 = link_279X;
        goto L11936;}}
    else {
      arg0K0 = next_277X;
      goto L11904;}}
  else {
    arg0K0 = next_277X;
    goto L11904;}}
 L10125: {
  { long ignoreXX;
  PS_WRITE_CHAR(10, (stderr), ignoreXX) }
  goto L13847;}
 L10162: {
  arg0K0 = (have_272X->new_descriptor);
  goto L10153;}
 L10153: {
  v_280X = arg0K0;
  merged_arg0K0 = v_280X;
  write_descriptor_return_tag = 10;
  goto write_descriptor;
 write_descriptor_return_10:
  arg1K0 = (addr_269X + 8);
  goto L10148;}
 L12582: {
  symbol_281X = arg0K0;
  arg0K0 = symbol_281X;
  goto L12615;}
 L13580: {
  if ((3 == (3 & stob_251X))) {
    if ((14 == (31 & ((((*((long *) ((((char *) (-3 + stob_251X))) + -8))))>>2))))) {
      link_282X = *((long *) ((((char *) (-3 + stob_251X))) + 24));
      if ((0 == (3 & link_282X))) {
        arg0K0 = (3 + (-4 & link_282X));
        goto L12425;}
      else {
        arg0K0 = link_282X;
        goto L12425;}}
    else {
      goto L13584;}}
  else {
    goto L13584;}}
 L14399: {
  i_283X = arg0K0;
  if ((i_283X == (table_274X->size))) {
    free(keys_275X);
    free(values_276X);
    free(table_274X);
    free((Simage_bufferS));
    return (SstatusS);}
  else {
    if ((0 == (*(keys_275X + i_283X)))) {
      goto L14401;}
    else {
      free((*(values_276X + i_283X)));
      goto L14401;}}}
 L11904: {
  thing_284X = arg0K0;
  if ((3 == (3 & thing_284X))) {
    have_285X = table_ref((Sstob_tableS), thing_284X);
    if ((NULL == have_285X)) {
      ps_error("traced object has no descriptor in image", 0);
      goto L11955;}
    else {
      goto L11955;}}
  else {
    arg0K0 = thing_284X;
    goto L11906;}}
 L12615: {
  next_286X = arg0K0;
  if ((3 == (3 & next_286X))) {
    v_287X = table_ref((Sstob_tableS), next_286X);
    if ((NULL == v_287X)) {
      link_288X = *((long *) ((((char *) (-3 + next_286X))) + 8));
      if ((0 == (3 & link_288X))) {
        arg0K0 = (3 + (-4 & link_288X));
        goto L12615;}
      else {
        arg0K0 = link_288X;
        goto L12615;}}
    else {
      arg0K0 = next_286X;
      goto L12584;}}
  else {
    arg0K0 = next_286X;
    goto L12584;}}
 L12425: {
  shared_289X = arg0K0;
  arg0K0 = shared_289X;
  goto L12474;}
 L13584: {
  header_290X = *((long *) ((((char *) (-3 + stob_251X))) + -8));
  start_291X = ((char *) (-3 + stob_251X));
  merged_arg0K0 = header_290X;
  write_descriptor_return_tag = 11;
  goto write_descriptor;
 write_descriptor_return_11:
  if ((2 == (3 & header_290X))) {
    if (((31 & (((header_290X)>>2))) < 16)) {
      goto L13600;}
    else {
      size_292X = -8 & (7 + ((long)(((unsigned long)header_290X)>>8)));
      available_293X = 4096 - ((Simage_buffer_pointerS) - (Simage_bufferS));
      if ((available_293X < size_292X)) {
        if ((4096 < size_292X)) {
          have_294X = (Simage_buffer_pointerS) - (Simage_bufferS);
          if ((0 < have_294X)) {
            if (((SstatusS) == NO_ERRORS)) {
              SstatusS = (ps_write_block((Simage_portS), ((char *) (Simage_bufferS)), have_294X));
              goto L9174;}
            else {
              goto L9174;}}
          else {
            goto L9148;}}
        else {
          merged_arg1K0 = start_291X;
          merged_arg0K1 = available_293X;
          copy_image_data_return_tag = 0;
          goto copy_image_data;
         copy_image_data_return_0:
          merged_arg1K0 = (start_291X + available_293X);
          merged_arg0K1 = (size_292X - available_293X);
          copy_image_data_return_tag = 1;
          goto copy_image_data;
         copy_image_data_return_1:
          goto L13847;}}
      else {
        merged_arg1K0 = start_291X;
        merged_arg0K1 = size_292X;
        copy_image_data_return_tag = 2;
        goto copy_image_data;
       copy_image_data_return_2:
        goto L13847;}}}
  else {
    goto L13600;}}
 L14401: {
  arg0K0 = (1 + i_283X);
  goto L14399;}
 L11955: {
  arg0K0 = (have_285X->new_descriptor);
  goto L11906;}
 L11906: {
  value_295X = arg0K0;
  if ((3 == (3 & value_295X))) {
    arg0K0 = (-4 & value_295X);
    goto L11908;}
  else {
    arg0K0 = value_295X;
    goto L11908;}}
 L12584: {
  next_296X = arg0K0;
  header_297X = *((long *) ((((char *) (-3 + stob_251X))) + -8));
  merged_arg0K0 = header_297X;
  write_descriptor_return_tag = 12;
  goto write_descriptor;
 write_descriptor_return_12:
  start_298X = ((char *) (-3 + stob_251X));
  arg1K0 = start_298X;
  goto L12644;}
 L12474: {
  next_299X = arg0K0;
  if ((3 == (3 & next_299X))) {
    v_300X = table_ref((Sstob_tableS), next_299X);
    if ((NULL == v_300X)) {
      link_301X = *((long *) ((((char *) (-3 + next_299X))) + 24));
      if ((0 == (3 & link_301X))) {
        arg0K0 = (3 + (-4 & link_301X));
        goto L12474;}
      else {
        arg0K0 = link_301X;
        goto L12474;}}
    else {
      arg0K0 = next_299X;
      goto L12427;}}
  else {
    arg0K0 = next_299X;
    goto L12427;}}
 L13600: {
  arg1K0 = start_291X;
  goto L13702;}
 L9174: {
  Simage_buffer_pointerS = (Simage_bufferS);
  goto L9148;}
 L9148: {
  if (((SstatusS) == NO_ERRORS)) {
    SstatusS = (ps_write_block((Simage_portS), ((char *) start_291X), size_292X));
    goto L13847;}
  else {
    goto L13847;}}
 L11908: {
  v_302X = arg0K0;
  merged_arg0K0 = v_302X;
  write_descriptor_return_tag = 13;
  goto write_descriptor;
 write_descriptor_return_13:
  arg0K0 = (1 + i_256X);
  goto L11892;}
 L12644: {
  addr_303X = arg1K0;
  if ((addr_303X == (start_298X + (-8 + (-8 & (7 + ((long)(((unsigned long)header_297X)>>8)))))))) {
    if ((3 == (3 & next_296X))) {
      have_304X = table_ref((Sstob_tableS), next_296X);
      if ((NULL == have_304X)) {
        ps_error("traced object has no descriptor in image", 0);
        goto L12674;}
      else {
        goto L12674;}}
    else {
      arg0K0 = next_296X;
      goto L12597;}}
  else {
    thing_305X = *((long *) addr_303X);
    if ((3 == (3 & thing_305X))) {
      have_306X = table_ref((Sstob_tableS), thing_305X);
      if ((NULL == have_306X)) {
        ps_error("traced object has no descriptor in image", 0);
        goto L12658;}
      else {
        goto L12658;}}
    else {
      arg0K0 = thing_305X;
      goto L12649;}}}
 L12427: {
  next_307X = arg0K0;
  header_308X = *((long *) ((((char *) (-3 + stob_251X))) + -8));
  merged_arg0K0 = header_308X;
  write_descriptor_return_tag = 14;
  goto write_descriptor;
 write_descriptor_return_14:
  start_309X = ((char *) (-3 + stob_251X));
  arg1K0 = start_309X;
  goto L12503;}
 L13702: {
  addr_310X = arg1K0;
  if ((addr_310X == (start_291X + (-8 & (7 + ((long)(((unsigned long)header_290X)>>8))))))) {
    goto L13847;}
  else {
    thing_311X = *((long *) addr_310X);
    if ((3 == (3 & thing_311X))) {
      have_312X = table_ref((Sstob_tableS), thing_311X);
      if ((NULL == have_312X)) {
        ps_error("traced object has no descriptor in image", 0);
        goto L13716;}
      else {
        goto L13716;}}
    else {
      arg0K0 = thing_311X;
      goto L13707;}}}
 L12674: {
  arg0K0 = (have_304X->new_descriptor);
  goto L12597;}
 L12597: {
  value_313X = arg0K0;
  if ((3 == (3 & value_313X))) {
    merged_arg0K0 = (-4 & value_313X);
    write_descriptor_return_tag = 15;
    goto write_descriptor;
   write_descriptor_return_15:
    goto L13847;}
  else {
    merged_arg0K0 = value_313X;
    write_descriptor_return_tag = 16;
    goto write_descriptor;
   write_descriptor_return_16:
    goto L13847;}}
 L12658: {
  arg0K0 = (have_306X->new_descriptor);
  goto L12649;}
 L12649: {
  v_314X = arg0K0;
  merged_arg0K0 = v_314X;
  write_descriptor_return_tag = 17;
  goto write_descriptor;
 write_descriptor_return_17:
  arg1K0 = (addr_303X + 8);
  goto L12644;}
 L12503: {
  addr_315X = arg1K0;
  if ((addr_315X == (start_309X + (-16 + (-8 & (7 + ((long)(((unsigned long)header_308X)>>8)))))))) {
    x_316X = *((long *) ((((char *) (-3 + stob_251X))) + 8));
    if ((5 == x_316X)) {
      arg0K0 = 529;
      goto L12452;}
    else {
      thing_317X = *((long *) ((((char *) (-3 + stob_251X))) + 16));
      if ((3 == (3 & thing_317X))) {
        have_318X = table_ref((Sstob_tableS), thing_317X);
        if ((NULL == have_318X)) {
          ps_error("traced object has no descriptor in image", 0);
          goto L12564;}
        else {
          goto L12564;}}
      else {
        arg0K0 = thing_317X;
        goto L12452;}}}
  else {
    thing_319X = *((long *) addr_315X);
    if ((3 == (3 & thing_319X))) {
      have_320X = table_ref((Sstob_tableS), thing_319X);
      if ((NULL == have_320X)) {
        ps_error("traced object has no descriptor in image", 0);
        goto L12517;}
      else {
        goto L12517;}}
    else {
      arg0K0 = thing_319X;
      goto L12508;}}}
 L13716: {
  arg0K0 = (have_312X->new_descriptor);
  goto L13707;}
 L13707: {
  v_321X = arg0K0;
  merged_arg0K0 = v_321X;
  write_descriptor_return_tag = 18;
  goto write_descriptor;
 write_descriptor_return_18:
  arg1K0 = (addr_310X + 8);
  goto L13702;}
 L12452: {
  v_322X = arg0K0;
  merged_arg0K0 = v_322X;
  write_descriptor_return_tag = 19;
  goto write_descriptor;
 write_descriptor_return_19:
  if ((3 == (3 & next_307X))) {
    have_323X = table_ref((Sstob_tableS), next_307X);
    if ((NULL == have_323X)) {
      ps_error("traced object has no descriptor in image", 0);
      goto L12540;}
    else {
      goto L12540;}}
  else {
    arg0K0 = next_307X;
    goto L12456;}}
 L12564: {
  arg0K0 = (have_318X->new_descriptor);
  goto L12452;}
 L12517: {
  arg0K0 = (have_320X->new_descriptor);
  goto L12508;}
 L12508: {
  v_324X = arg0K0;
  merged_arg0K0 = v_324X;
  write_descriptor_return_tag = 20;
  goto write_descriptor;
 write_descriptor_return_20:
  arg1K0 = (addr_315X + 8);
  goto L12503;}
 L12540: {
  arg0K0 = (have_323X->new_descriptor);
  goto L12456;}
 L12456: {
  value_325X = arg0K0;
  if ((3 == (3 & value_325X))) {
    merged_arg0K0 = (-4 & value_325X);
    write_descriptor_return_tag = 21;
    goto write_descriptor;
   write_descriptor_return_21:
    goto L13847;}
  else {
    merged_arg0K0 = value_325X;
    write_descriptor_return_tag = 22;
    goto write_descriptor;
   write_descriptor_return_22:
    goto L13847;}}
 write_shared_table: {
  table_196X = merged_arg0K0;{
  merged_arg0K0 = (*((long *) ((((char *) (-3 + table_196X))) + -8)));
  write_descriptor_return_tag = 23;
  goto write_descriptor;
 write_descriptor_return_23:
  arg0K0 = 0;
  goto L11802;}
 L11802: {
  i_326X = arg0K0;
  temp_327X = i_326X == ((((7 + ((long)(((unsigned long)(*((long *) ((((char *) (-3 + table_196X))) + -8))))>>8))))>>3));
  if (temp_327X) {
    write_shared_table0_return_value = temp_327X;
    goto write_shared_table_return;}
  else {
    link_328X = *((long *) ((((char *) (-3 + table_196X))) + (((i_326X)<<3))));
    if ((0 == (3 & link_328X))) {
      arg0K0 = (3 + (-4 & link_328X));
      goto L11812;}
    else {
      arg0K0 = link_328X;
      goto L11812;}}}
 L11812: {
  shared_329X = arg0K0;
  arg0K0 = shared_329X;
  goto L11846;}
 L11846: {
  next_330X = arg0K0;
  if ((3 == (3 & next_330X))) {
    v_331X = table_ref((Sstob_tableS), next_330X);
    if ((NULL == v_331X)) {
      link_332X = *((long *) ((((char *) (-3 + next_330X))) + 24));
      if ((0 == (3 & link_332X))) {
        arg0K0 = (3 + (-4 & link_332X));
        goto L11846;}
      else {
        arg0K0 = link_332X;
        goto L11846;}}
    else {
      arg0K0 = next_330X;
      goto L11814;}}
  else {
    arg0K0 = next_330X;
    goto L11814;}}
 L11814: {
  thing_333X = arg0K0;
  if ((3 == (3 & thing_333X))) {
    have_334X = table_ref((Sstob_tableS), thing_333X);
    if ((NULL == have_334X)) {
      ps_error("traced object has no descriptor in image", 0);
      goto L11865;}
    else {
      goto L11865;}}
  else {
    arg0K0 = thing_333X;
    goto L11816;}}
 L11865: {
  arg0K0 = (have_334X->new_descriptor);
  goto L11816;}
 L11816: {
  value_335X = arg0K0;
  if ((3 == (3 & value_335X))) {
    arg0K0 = (-4 & value_335X);
    goto L11818;}
  else {
    arg0K0 = value_335X;
    goto L11818;}}
 L11818: {
  v_336X = arg0K0;
  merged_arg0K0 = v_336X;
  write_descriptor_return_tag = 24;
  goto write_descriptor;
 write_descriptor_return_24:
  arg0K0 = (1 + i_326X);
  goto L11802;}
 write_shared_table_return:
  switch (write_shared_table_return_tag) {
  case 0: goto write_shared_table_return_0;
  default: goto write_shared_table_return_1;
  }}

 write_descriptor: {
  descriptor_195X = merged_arg0K0;{
  *((long *) (Simage_buffer_pointerS)) = (long) (descriptor_195X);
  Simage_buffer_pointerS = ((Simage_buffer_pointerS) + 8);
  if ((4096 == ((Simage_buffer_pointerS) - (Simage_bufferS)))) {
    have_337X = (Simage_buffer_pointerS) - (Simage_bufferS);
    if ((0 < have_337X)) {
      if (((SstatusS) == NO_ERRORS)) {
        SstatusS = (ps_write_block((Simage_portS), ((char *) (Simage_bufferS)), have_337X));
        goto L6621;}
      else {
        goto L6621;}}
    else {
      goto write_descriptor_return;}}
  else {
    goto write_descriptor_return;}}
 L6621: {
  Simage_buffer_pointerS = (Simage_bufferS);
  goto write_descriptor_return;}
 write_descriptor_return:
  switch (write_descriptor_return_tag) {
  case 0: goto write_descriptor_return_0;
  case 1: goto write_descriptor_return_1;
  case 2: goto write_descriptor_return_2;
  case 3: goto write_descriptor_return_3;
  case 4: goto write_descriptor_return_4;
  case 5: goto write_descriptor_return_5;
  case 6: goto write_descriptor_return_6;
  case 7: goto write_descriptor_return_7;
  case 8: goto write_descriptor_return_8;
  case 9: goto write_descriptor_return_9;
  case 10: goto write_descriptor_return_10;
  case 11: goto write_descriptor_return_11;
  case 12: goto write_descriptor_return_12;
  case 13: goto write_descriptor_return_13;
  case 14: goto write_descriptor_return_14;
  case 15: goto write_descriptor_return_15;
  case 16: goto write_descriptor_return_16;
  case 17: goto write_descriptor_return_17;
  case 18: goto write_descriptor_return_18;
  case 19: goto write_descriptor_return_19;
  case 20: goto write_descriptor_return_20;
  case 21: goto write_descriptor_return_21;
  case 22: goto write_descriptor_return_22;
  case 23: goto write_descriptor_return_23;
  default: goto write_descriptor_return_24;
  }}

 copy_image_data: {
  start_193X = merged_arg1K0;
  size_194X = merged_arg0K1;{
  memmove((void *)(Simage_buffer_pointerS), (void *)start_193X,size_194X);
  Simage_buffer_pointerS = ((Simage_buffer_pointerS) + size_194X);
  if ((4096 == ((Simage_buffer_pointerS) - (Simage_bufferS)))) {
    have_338X = (Simage_buffer_pointerS) - (Simage_bufferS);
    if ((0 < have_338X)) {
      if (((SstatusS) == NO_ERRORS)) {
        SstatusS = (ps_write_block((Simage_portS), ((char *) (Simage_bufferS)), have_338X));
        goto L6646;}
      else {
        goto L6646;}}
    else {
      goto copy_image_data_return;}}
  else {
    goto copy_image_data_return;}}
 L6646: {
  Simage_buffer_pointerS = (Simage_bufferS);
  goto copy_image_data_return;}
 copy_image_data_return:
  switch (copy_image_data_return_tag) {
  case 0: goto copy_image_data_return_0;
  case 1: goto copy_image_data_return_1;
  default: goto copy_image_data_return_2;
  }}

}
void s48_trace_locationsB(char * start_339X, char * end_340X)
{
  char * arg1K0;
  char * arg1K1;
  long arg0K0;
  long new_358X;
  char * data_addr_357X;
  char * frontier_356X;
  long new_thing_355X;
  char * data_pointer_354X;
  long mask_size_353X;
  char * code_pointer_352X;
  long size_351X;
  char * frontier_350X;
  long new_thing_349X;
  char * a_348X;
  long descriptor_347X;
  long h_346X;
  char * a_345X;
  char * next_344X;
  long thing_343X;
  char * frontier_342X;
  char * addr_341X;
 {  arg1K0 = start_339X;
  arg1K1 = (s48_ShpS);
  goto L14531;}
 L14531: {
  addr_341X = arg1K0;
  frontier_342X = arg1K1;
  if ((addr_341X < end_340X)) {
    thing_343X = *((long *) addr_341X);
    next_344X = addr_341X + 8;
    if ((2 == (3 & thing_343X))) {
      if ((2 == (3 & thing_343X))) {
        if (((31 & (((thing_343X)>>2))) < 16)) {
          goto L14548;}
        else {
          arg1K0 = (next_344X + (-8 & (7 + ((long)(((unsigned long)thing_343X)>>8)))));
          arg1K1 = frontier_342X;
          goto L14531;}}
      else {
        goto L14548;}}
    else {
      if ((3 == (3 & thing_343X))) {
        a_345X = ((char *) (-3 + thing_343X));
        if ((a_345X < (Sfrom_beginS))) {
          arg1K0 = next_344X;
          arg1K1 = frontier_342X;
          goto L14531;}
        else {
          if ((a_345X < (Sfrom_endS))) {
            h_346X = *((long *) ((((char *) (-3 + thing_343X))) + -8));
            if ((3 == (3 & h_346X))) {
              arg0K0 = h_346X;
              arg1K1 = frontier_342X;
              goto L14570;}
            else {
              if ((2102 == h_346X)) {
                descriptor_347X = *((long *) (((char *) (-3 + thing_343X))));
                if ((3 == (3 & descriptor_347X))) {
                  a_348X = ((char *) (-3 + descriptor_347X));
                  if ((a_348X < (Sfrom_beginS))) {
                    goto L17038;}
                  else {
                    if ((a_348X < (Sfrom_endS))) {
                      new_thing_349X = copy_weak_pointer(thing_343X, frontier_342X, &frontier_350X);
                      arg0K0 = new_thing_349X;
                      arg1K1 = frontier_350X;
                      goto L14570;}
                    else {
                      goto L17038;}}}
                else {
                  goto L17038;}}
              else {
                goto L17038;}}}
          else {
            arg1K0 = next_344X;
            arg1K1 = frontier_342X;
            goto L14531;}}}
      else {
        arg1K0 = next_344X;
        arg1K1 = frontier_342X;
        goto L14531;}}}
  else {
    s48_ShpS = frontier_342X;
    return;}}
 L14548: {
  if ((10 == (31 & (((thing_343X)>>2))))) {
    size_351X = -8 & (7 + ((long)(((unsigned long)thing_343X)>>8)));
    s48_ShpS = frontier_342X;
    code_pointer_352X = (((char *) (-3 + (*((long *) (next_344X + 8)))))) + ((((*((long *) next_344X)))>>2));
    mask_size_353X = *((unsigned char *) (code_pointer_352X + -3));
    if ((0 == mask_size_353X)) {s48_trace_locationsB(next_344X, (next_344X + size_351X));
      goto L14559;}
    else {
      data_pointer_354X = next_344X + 24;s48_trace_locationsB(next_344X, data_pointer_354X);s48_trace_continuation_contentsB(data_pointer_354X, code_pointer_352X, mask_size_353X);
      goto L14559;}}
  else {
    arg1K0 = next_344X;
    arg1K1 = frontier_342X;
    goto L14531;}}
 L14570: {
  new_thing_355X = arg0K0;
  frontier_356X = arg1K1;
  *((long *) addr_341X) = (long) (new_thing_355X);
  arg1K0 = next_344X;
  arg1K1 = frontier_356X;
  goto L14531;}
 L17038: {
  *((long *) frontier_342X) = (long) (h_346X);
  data_addr_357X = frontier_342X + 8;
  new_358X = 3 + (((long) data_addr_357X));
  *((long *) ((((char *) (-3 + thing_343X))) + -8)) = (long) (new_358X);
  memmove((void *)data_addr_357X, (void *)(((char *) (-3 + thing_343X))),((long)(((unsigned long)h_346X)>>8)));
  arg0K0 = new_358X;
  arg1K1 = (data_addr_357X + (-8 & (7 + ((long)(((unsigned long)h_346X)>>8)))));
  goto L14570;}
 L14559: {
  arg1K0 = (next_344X + size_351X);
  arg1K1 = (s48_ShpS);
  goto L14531;}
}
void s48_trace_stob_contentsB(long stob_359X)
{
  char * start_361X;
  long h_360X;
 {  h_360X = *((long *) ((((char *) (-3 + stob_359X))) + -8));
  start_361X = ((char *) (-3 + stob_359X));
  s48_trace_locationsB(start_361X, (start_361X + (-8 & (7 + ((long)(((unsigned long)h_360X)>>8))))));
  return;}
}
void s48_collect(char force_majorP_362X)
{
  char * arg1K1;
  char * arg1K0;
  long arg0K0;
  long x2_383X;
  long h_382X;
  char * a_381X;
  long value_380X;
  char * scan_379X;
  char * next_378X;
  char * end_377X;
  char * start_376X;
  long end_mseconds_375X;
  long end_seconds_374X;
  char v_373X;
  char * end_372X;
  char * x_371X;
  char * end_370X;
  char * start_369X;
  char * temp_368X;
  char * temp_367X;
  char * temp_366X;
  char * temp_365X;
  long start_mseconds_364X;
  long start_seconds_363X;
 {  start_seconds_363X = s48_run_time(&start_mseconds_364X);
  Sfrom_beginS = (Snewspace_beginS);
  Sfrom_endS = (Snewspace_endS);
  temp_365X = s48_SlimitS;
  s48_SlimitS = (Soldspace_limitS);
  Soldspace_limitS = temp_365X;
  temp_366X = s48_ShpS;
  s48_ShpS = (Soldspace_hpS);
  Soldspace_hpS = temp_366X;
  temp_367X = Snewspace_beginS;
  Snewspace_beginS = (Soldspace_beginS);
  Soldspace_beginS = temp_367X;
  temp_368X = Snewspace_endS;
  Snewspace_endS = (Soldspace_endS);
  Soldspace_endS = temp_368X;
  s48_ShpS = (Snewspace_beginS);
  Sweak_pointer_hpS = NULL;s48_gc_root();
  arg1K0 = (Snewspace_beginS);
  goto L14871;}
 L14871: {
  start_369X = arg1K0;
  end_370X = s48_ShpS;s48_trace_locationsB(start_369X, end_370X);
  if (((((((s48_SlimitS) - (s48_ShpS)))>>3)) < 0)) {
    ps_error("GC error: ran out of space in new heap", 0);
    goto L14807;}
  else {
    if ((end_370X < (s48_ShpS))) {
      arg1K0 = end_370X;
      goto L14871;}
    else {
      goto L14807;}}}
 L14807: {
  if (((Sweak_pointer_hpS) == NULL)) {
    goto L14809;}
  else {
    x_371X = Sweak_pointer_limitS;
    end_372X = Sweak_pointer_hpS;
    arg1K0 = (x_371X + -2048);
    arg1K1 = end_372X;
    goto L10001;}}
 L14809: {
  v_373X = (((((s48_SlimitS) - (s48_ShpS)))>>3)) < (((((7 + ((Snewspace_endS) - (Snewspace_beginS))))>>3)) / 10);s48_post_gc_cleanup(1, v_373X);
  Sgc_countS = (1 + (Sgc_countS));
  end_seconds_374X = s48_run_time(&end_mseconds_375X);
  if ((end_mseconds_375X < start_mseconds_364X)) {
    Sgc_secondsS = (-1 + ((Sgc_secondsS) + (end_seconds_374X - start_seconds_363X)));
    Sgc_msecondsS = ((Sgc_msecondsS) + ((1000 + end_mseconds_375X) - start_mseconds_364X));
    return;}
  else {
    Sgc_secondsS = ((Sgc_secondsS) + (end_seconds_374X - start_seconds_363X));
    Sgc_msecondsS = ((Sgc_msecondsS) + (end_mseconds_375X - start_mseconds_364X));
    return;}}
 L10001: {
  start_376X = arg1K0;
  end_377X = arg1K1;
  next_378X = ((char *) (*((long *) (start_376X + 16))));
  arg1K0 = start_376X;
  goto L6313;}
 L6313: {
  scan_379X = arg1K0;
  if ((scan_379X < end_377X)) {
    *((long *) scan_379X) = (long) (2102);
    value_380X = *((long *) (scan_379X + 8));
    if ((3 == (3 & value_380X))) {
      a_381X = ((char *) (-3 + value_380X));
      if ((a_381X < (Sfrom_beginS))) {
        goto L6359;}
      else {
        if ((a_381X < (Sfrom_endS))) {
          if ((3 == (3 & value_380X))) {
            h_382X = *((long *) ((((char *) (-3 + value_380X))) + -8));
            if ((3 == (3 & h_382X))) {
              arg0K0 = h_382X;
              goto L6354;}
            else {
              arg0K0 = 1;
              goto L6354;}}
          else {
            goto L6359;}}
        else {
          goto L6359;}}}
    else {
      goto L6359;}}
  else {
    if ((next_378X == NULL)) {
      if ((end_372X < (Sweak_pointer_limitS))) {
        *((long *) end_372X) = (long) ((70 + ((((-8 & ((Sweak_pointer_limitS) - (end_372X + 8))))<<8))));
        goto L14809;}
      else {
        goto L14809;}}
    else {
      arg1K0 = (next_378X + -2048);
      arg1K1 = next_378X;
      goto L10001;}}}
 L6359: {
  arg1K0 = (scan_379X + 16);
  goto L6313;}
 L6354: {
  x2_383X = arg0K0;
  *((long *) (scan_379X + 8)) = (long) (x2_383X);
  goto L6359;}
}
void s48_make_availableAgc(long len_384X)
{
  char x_385X;
 {  x_385X = ((s48_ShpS) + (-8 & (7 + len_384X))) < (s48_SlimitS);
  if (x_385X) {
    goto L14925;}
  else {s48_collect(0);
    goto L14925;}}
 L14925: {
  if ((((s48_ShpS) + (-8 & (7 + len_384X))) < (s48_SlimitS))) {
    return;}
  else {
    ps_error("Scheme 48 heap overflow", 0);
    return;}}
}
char * s48_allocate_tracedAgc(long len_386X)
{
  char * new_388X;
  char x_387X;
 {  x_387X = ((s48_ShpS) + (-8 & (7 + len_386X))) < (s48_SlimitS);
  if (x_387X) {
    goto L14999;}
  else {s48_collect(0);
    goto L14999;}}
 L14999: {
  if ((((s48_ShpS) + (-8 & (7 + len_386X))) < (s48_SlimitS))) {
    new_388X = s48_ShpS;
    s48_ShpS = ((s48_ShpS) + (-8 & (7 + len_386X)));
    return new_388X;}
  else {
    return NULL;}}
}
char * s48_allocate_weakAgc(long len_389X)
{
  char * new_391X;
  char x_390X;
 {  x_390X = ((s48_ShpS) + (-8 & (7 + len_389X))) < (s48_SlimitS);
  if (x_390X) {
    goto L15071;}
  else {s48_collect(0);
    goto L15071;}}
 L15071: {
  if ((((s48_ShpS) + (-8 & (7 + len_389X))) < (s48_SlimitS))) {
    new_391X = s48_ShpS;
    s48_ShpS = ((s48_ShpS) + (-8 & (7 + len_389X)));
    return new_391X;}
  else {
    return NULL;}}
}
char * s48_allocate_untracedAgc(long len_392X)
{
  char * new_394X;
  char x_393X;
 {  x_393X = ((s48_ShpS) + (-8 & (7 + len_392X))) < (s48_SlimitS);
  if (x_393X) {
    goto L15092;}
  else {s48_collect(0);
    goto L15092;}}
 L15092: {
  if ((((s48_ShpS) + (-8 & (7 + len_392X))) < (s48_SlimitS))) {
    new_394X = s48_ShpS;
    s48_ShpS = ((s48_ShpS) + (-8 & (7 + len_392X)));
    return new_394X;}
  else {
    return NULL;}}
}
long s48_allocate_stob(long type_395X, long size_396X)
{
  long arg0K0;
  char * arg1K0;
  char * thing_404X;
  char * new_403X;
  char * new_402X;
  char x_401X;
  char x_400X;
  long needed_399X;
  long length_in_bytes_398X;
  char tracedP_397X;
 {  tracedP_397X = type_395X < 16;
  if (tracedP_397X) {
    arg0K0 = (((size_396X)<<3));
    goto L15139;}
  else {
    arg0K0 = size_396X;
    goto L15139;}}
 L15139: {
  length_in_bytes_398X = arg0K0;
  needed_399X = 8 + length_in_bytes_398X;
  if (tracedP_397X) {
    x_400X = ((s48_ShpS) + (-8 & (7 + needed_399X))) < (s48_SlimitS);
    if (x_400X) {
      goto L15205;}
    else {s48_collect(0);
      goto L15205;}}
  else {
    x_401X = ((s48_ShpS) + (-8 & (7 + needed_399X))) < (s48_SlimitS);
    if (x_401X) {
      goto L15224;}
    else {s48_collect(0);
      goto L15224;}}}
 L15205: {
  if ((((s48_ShpS) + (-8 & (7 + needed_399X))) < (s48_SlimitS))) {
    new_402X = s48_ShpS;
    s48_ShpS = ((s48_ShpS) + (-8 & (7 + needed_399X)));
    arg1K0 = new_402X;
    goto L15155;}
  else {
    arg1K0 = NULL;
    goto L15155;}}
 L15224: {
  if ((((s48_ShpS) + (-8 & (7 + needed_399X))) < (s48_SlimitS))) {
    new_403X = s48_ShpS;
    s48_ShpS = ((s48_ShpS) + (-8 & (7 + needed_399X)));
    arg1K0 = new_403X;
    goto L15155;}
  else {
    arg1K0 = NULL;
    goto L15155;}}
 L15155: {
  thing_404X = arg1K0;
  if ((thing_404X == NULL)) {
    ps_error("insufficient heap space for external allocation", 0);
    goto L15167;}
  else {
    goto L15167;}}
 L15167: {
  *((long *) thing_404X) = (long) ((2 + (((((((length_in_bytes_398X)<<6)) + type_395X))<<2))));
  return (3 + (((long) (thing_404X + 8))));}
}
long s48_read_image(char *image_filename_405X, long max_heap_size_406X)
{
  struct image_location *arg2K0;
  struct table *arg3K0;
  char *arg5K1;
  char arg4K1;
  char arg4K0;
  char * arg1K0;
  long arg0K2;
  long arg0K1;
  long arg0K0;
  struct table *merged_arg3K1;
  FILE * merged_arg6K2;
  long merged_arg0K2;
  long merged_arg0K0;
  long merged_arg0K1;
  char * merged_arg1K1;
  char * merged_arg1K0;

  int really_read_image_area_return_tag;
  long really_read_image_area0_return_value;
  int reverse_byte_orderB_return_tag;
  int relocate_binding_table_two_spaceB_return_tag;
  int relocate_binding_table_bibopB_return_tag;
  int relocateD0_return_tag;
  long relocateD00_return_value;
  int old_Gnew_addr_return_tag;
  char * old_Gnew_addr0_return_value;
  int allocate_table_return_tag;
  long allocate_table0_return_value;
  int parse_reachable_objects_return_tag;
  long parse_reachable_objects0_return_value;
  int alloc_object_return_tag;
  char * alloc_object0_return_value;
  int relocateD2_return_tag;
  long relocateD20_return_value;
  char * new_start_addr_407X;
  long img_heap_size_408X;
  FILE * port_409X;
  char * start_410X;
  char * end_411X;
  long table_412X;
  long delta_413X;
  long table_414X;
  struct table *stob_table_415X;
  long address_416X;
  char * addr_417X;
  long format_418X;
  long tab_419X;
  long image_format_420X;
  char * from_addr_421X;
  char * to_addr_422X;
  long image_format_423X;
  char * current_address_424X;
  long size_in_bytes_425X;
  long address_426X;
  long status_782X;
  long status_781X;
  char *string_780X;
  char okayP_779X;
  long status_778X;
  char eofP_777X;
  long got_776X;
  long need_775X;
  char * next_774X;
  long value_773X;
  long byte_a_772X;
  char * addr_b_771X;
  char * addr_a_770X;
  long j_769X;
  long i_768X;
  char * ptr_767X;
  long val_766X;
  long next_765X;
  long next_764X;
  long link_763X;
  long entry_762X;
  long value_761X;
  long bucket_760X;
  long bucket_759X;
  long link_758X;
  long i_757X;
  long val_756X;
  long next_755X;
  long next_754X;
  long link_753X;
  long entry_752X;
  long value_751X;
  long bucket_750X;
  long bucket_749X;
  long link_748X;
  long i_747X;
  struct image_location *image_location_746X;
  long v_745X;
  char * address_744X;
  char * y_743X;
  char * y_742X;
  char * v_741X;
  char * y_740X;
  char * pointer_739X;
  char * new_738X;
  long v_737X;
  char x_736X;
  long size_in_byte_735X;
  long size_734X;
  long cell_733X;
  char * addr_732X;
  char * new_address_731X;
  struct image_location *image_location_730X;
  long v_729X;
  struct image_location *image_location_728X;
  long v_727X;
  char * index_726X;
  char * new_address_725X;
  struct image_location *v_724X;
  long v_723X;
  char * address_722X;
  char * new_address_721X;
  char * v_720X;
  char * new_address_719X;
  long size_in_cells_718X;
  struct image_location *v_717X;
  long v_716X;
  char * v_715X;
  char * new_address_714X;
  long size_in_bytes_713X;
  long size_in_cells_712X;
  long header_cell_711X;
  char * x1_710X;
  char * current_addr_709X;
  struct image_location *v_708X;
  long v_707X;
  char * current_addr_706X;
  long size_in_cells_705X;
  long cell_704X;
  char * x1_703X;
  char * current_addr_702X;
  long v_701X;
  struct image_location *val_700X;
  struct image_location *image_location_699X;
  char * new_address_698X;
  char * new_697X;
  char x_696X;
  struct image_location *image_location_695X;
  long v_694X;
  char * address_693X;
  long val_692X;
  long val_691X;
  long next_690X;
  long next_689X;
  long next_688X;
  long next_687X;
  struct image_location *image_location_686X;
  long v_685X;
  long i_684X;
  long link_683X;
  long entry_682X;
  long link_681X;
  long entry_680X;
  char * address_679X;
  long cell_678X;
  long size_677X;
  char * address_676X;
  struct image_location **values_675X;
  long *keys_674X;
  struct table *table_673X;
  long d_672X;
  long value_671X;
  long value_670X;
  long cell_669X;
  long resumer_records_668X;
  long expr_667X;
  long descriptor_666X;
  char * ptr_665X;
  long bucket_664X;
  long bucket_663X;
  long bucket_662X;
  long bucket_661X;
  long expr_660X;
  long v_659X;
  char * start_658X;
  long link_657X;
  long i_656X;
  long link_655X;
  long i_654X;
  long expr_653X;
  long v_652X;
  long table_651X;
  long expr_650X;
  struct table *stob_table_649X;
  long table_648X;
  long expr_647X;
  long v_646X;
  struct image_location *image_location_645X;
  long v_644X;
  long descriptor_643X;
  long expr_642X;
  char * address_641X;
  long descriptor_640X;
  long expr_639X;
  long descriptor_638X;
  long expr_637X;
  long status_636X;
  long status_635X;
  long status_634X;
  char * v_633X;
  char * v_632X;
  long expr_631X;
  long status_630X;
  long descriptor_629X;
  long expr_628X;
  long status_627X;
  long status_626X;
  long status_625X;
  long status_624X;
  long status_623X;
  long status_622X;
  char eofP_621X;
  char v_620X;
  long expr_619X;
  long status_618X;
  char *string_617X;
  char okayP_616X;
  long status_615X;
  long status_614X;
  long status_613X;
  long status_612X;
  long descriptor_611X;
  long status_610X;
  long expr_609X;
  long expr_608X;
  long expr_607X;
  long status_606X;
  char eofP_605X;
  long got_604X;
  long need_603X;
  struct table *v_602X;
  long status_601X;
  long status_600X;
  long status_599X;
  long status_598X;
  long status_597X;
  long status_596X;
  char eofP_595X;
  char v_594X;
  char *string_593X;
  char okayP_592X;
  long status_591X;
  char eofP_590X;
  long expr_589X;
  struct table *table_588X;
  long i_587X;
  long status_586X;
  char eofP_585X;
  long got_584X;
  long need_583X;
  char * address_582X;
  long cells_581X;
  long status_580X;
  char eofP_579X;
  char ch_578X;
  long we_577X;
  long cells_576X;
  long status_575X;
  long *keys_574X;
  char * v_573X;
  long expr_572X;
  long status_571X;
  char eofP_570X;
  long thing_569X;
  long status_568X;
  long wh_567X;
  long cells_566X;
  long v_565X;
  long byte_a_564X;
  char * addr_b_563X;
  char * addr_a_562X;
  long j_561X;
  long i_560X;
  long status_559X;
  long v_558X;
  char x_557X;
  long size_in_byte_556X;
  char * new_hp_555X;
  long delta_554X;
  char reverse_byte_orderP_553X;
  long status_552X;
  char eofP_551X;
  long thing_550X;
  long status_549X;
  long expr_548X;
  long status_547X;
  char eofP_546X;
  long thing_545X;
  long status_544X;
  long le_543X;
  long cells_542X;
  long status_541X;
  char eofP_540X;
  long thing_539X;
  long status_538X;
  long expr_537X;
  long status_536X;
  char eofP_535X;
  long thing_534X;
  long status_533X;
  long lh_532X;
  long cells_531X;
  long status_530X;
  char eofP_529X;
  long got_528X;
  char * new_addr_527X;
  long status_526X;
  char eofP_525X;
  long thing_524X;
  long status_523X;
  long expr_522X;
  long status_521X;
  char eofP_520X;
  long thing_519X;
  long status_518X;
  long se_517X;
  long cells_516X;
  char * temp_515X;
  char * temp_514X;
  char * temp_513X;
  char * temp_512X;
  long semisize_511X;
  long status_510X;
  char eofP_509X;
  long thing_508X;
  long status_507X;
  long expr_506X;
  long status_505X;
  char eofP_504X;
  long thing_503X;
  long status_502X;
  long sh_501X;
  long cells_500X;
  long cells_499X;
  char * heap_498X;
  long heap_size_497X;
  long status_496X;
  long status_495X;
  char eofP_494X;
  long thing_493X;
  long status_492X;
  long status_491X;
  char eofP_490X;
  long thing_489X;
  long status_488X;
  long sb_487X;
  long cells_486X;
  long status_485X;
  char eofP_484X;
  long thing_483X;
  long status_482X;
  long cells_481X;
  long minimum_size_480X;
  char * image_start_address_479X;
  long format_478X;
  long status_477X;
  long status_476X;
  long status_475X;
  long status_474X;
  long status_473X;
  long status_472X;
  char eofP_471X;
  long thing_470X;
  long status_469X;
  long status_468X;
  char eofP_467X;
  long thing_466X;
  long status_465X;
  long status_464X;
  long status_463X;
  long status_462X;
  long status_461X;
  long status_460X;
  long old_bytes_per_cell_459X;
  long status_458X;
  char eofP_457X;
  char thing_456X;
  long status_455X;
  char eofP_454X;
  long thing_453X;
  long status_452X;
  long format_451X;
  long status_450X;
  char eofP_449X;
  long status_448X;
  char eofP_447X;
  char ch_446X;
  long i_445X;
  long status_444X;
  char eofP_443X;
  long n_442X;
  long status_441X;
  char same_versionP_440X;
  long status_439X;
  char eofP_438X;
  long status_437X;
  char eofP_436X;
  char ch_435X;
  long status_434X;
  long status_433X;
  char eofP_432X;
  char ch_431X;
  long status_430X;
  long status_429X;
  long status_428X;
  FILE * port_427X;
 {  SstatusS = NO_ERRORS;
  SeofPS = 0;
  port_427X = ps_open_input_file(image_filename_405X, &status_428X);
  if ((status_428X == NO_ERRORS)) {
    status_429X = SstatusS;
    if ((status_429X == NO_ERRORS)) {
      if ((SeofPS)) {
        goto L7228;}
      else {
        goto L8751;}}
    else {
      goto L7228;}}
  else {
    ps_write_string("Can't open heap image file", (stderr));
    { long ignoreXX;
    PS_WRITE_CHAR(10, (stderr), ignoreXX) }
    ps_write_string((ps_error_string(status_428X)), (stderr));
    { long ignoreXX;
    PS_WRITE_CHAR(10, (stderr), ignoreXX) }
    return -1;}}
 L7228: {
  status_430X = SstatusS;
  if ((status_430X == NO_ERRORS)) {
    if ((SeofPS)) {
      goto L7279;}
    else {
      goto L8671;}}
  else {
    goto L7279;}}
 L8751: {
  PS_READ_CHAR(port_427X, ch_431X, eofP_432X, status_433X)
  if (eofP_432X) {
    arg4K0 = eofP_432X;
    arg0K1 = status_433X;
    goto L7202;}
  else {
    if ((status_433X == NO_ERRORS)) {
      if ((12 == ch_431X)) {
        arg4K0 = 0;
        arg0K1 = status_433X;
        goto L7202;}
      else {
        goto L8751;}}
    else {
      arg4K0 = eofP_432X;
      arg0K1 = status_433X;
      goto L7202;}}}
 L7279: {
  status_434X = SstatusS;
  if ((status_434X == NO_ERRORS)) {
    if ((SeofPS)) {
      arg4K0 = 0;
      goto L7330;}
    else {
      arg0K0 = 0;
      goto L8605;}}
  else {
    arg4K0 = 0;
    goto L7330;}}
 L8671: {
  PS_READ_CHAR(port_427X, ch_435X, eofP_436X, status_437X)
  if (eofP_436X) {
    arg4K0 = eofP_436X;
    arg0K1 = status_437X;
    goto L7253;}
  else {
    if ((status_437X == NO_ERRORS)) {
      if ((10 == ch_435X)) {
        arg4K0 = 0;
        arg0K1 = status_437X;
        goto L7253;}
      else {
        goto L8671;}}
    else {
      arg4K0 = eofP_436X;
      arg0K1 = status_437X;
      goto L7253;}}}
 L7202: {
  eofP_438X = arg4K0;
  status_439X = arg0K1;
  if (eofP_438X) {
    SeofPS = 1;
    goto L7228;}
  else {
    if ((status_439X == NO_ERRORS)) {
      goto L7228;}
    else {
      SeofPS = 1;
      if (((SstatusS) == NO_ERRORS)) {
        SstatusS = status_439X;
        goto L7228;}
      else {
        goto L7228;}}}}
 L7330: {
  same_versionP_440X = arg4K0;
  status_441X = SstatusS;
  if ((status_441X == NO_ERRORS)) {
    if ((SeofPS)) {
      arg0K0 = -1;
      goto L7383;}
    else {
      PS_READ_INTEGER(port_427X, n_442X, eofP_443X, status_444X)
      if (eofP_443X) {
        SeofPS = 1;
        arg0K0 = -1;
        goto L7383;}
      else {
        if ((status_444X == NO_ERRORS)) {
          arg0K0 = n_442X;
          goto L7383;}
        else {
          SeofPS = 1;
          if (((SstatusS) == NO_ERRORS)) {
            SstatusS = status_444X;
            arg0K0 = -1;
            goto L7383;}
          else {
            arg0K0 = -1;
            goto L7383;}}}}}
  else {
    arg0K0 = -1;
    goto L7383;}}
 L8605: {
  i_445X = arg0K0;
  PS_READ_CHAR(port_427X, ch_446X, eofP_447X, status_448X)
  if (eofP_447X) {
    arg4K0 = 0;
    arg4K1 = eofP_447X;
    arg0K2 = status_448X;
    goto L7304;}
  else {
    if ((status_448X == NO_ERRORS)) {
      if ((i_445X == (strlen((char *) "Vanilla 34")))) {
        arg4K0 = (10 == ch_446X);
        arg4K1 = 0;
        arg0K2 = status_448X;
        goto L7304;}
      else {
        if ((ch_446X == (*("Vanilla 34" + i_445X)))) {
          arg0K0 = (1 + i_445X);
          goto L8605;}
        else {
          arg4K0 = 0;
          arg4K1 = 0;
          arg0K2 = status_448X;
          goto L7304;}}}
    else {
      arg4K0 = 0;
      arg4K1 = eofP_447X;
      arg0K2 = status_448X;
      goto L7304;}}}
 L7253: {
  eofP_449X = arg4K0;
  status_450X = arg0K1;
  if (eofP_449X) {
    SeofPS = 1;
    goto L7279;}
  else {
    if ((status_450X == NO_ERRORS)) {
      goto L7279;}
    else {
      SeofPS = 1;
      if (((SstatusS) == NO_ERRORS)) {
        SstatusS = status_450X;
        goto L7279;}
      else {
        goto L7279;}}}}
 L7383: {
  format_451X = arg0K0;
  status_452X = SstatusS;
  if ((status_452X == NO_ERRORS)) {
    if ((SeofPS)) {
      arg0K0 = -1;
      goto L7436;}
    else {
      PS_READ_INTEGER(port_427X, thing_453X, eofP_454X, status_455X)
      if (eofP_454X) {
        SeofPS = 1;
        arg0K0 = -1;
        goto L7436;}
      else {
        if ((status_455X == NO_ERRORS)) {
          arg0K0 = thing_453X;
          goto L7436;}
        else {
          SeofPS = 1;
          if (((SstatusS) == NO_ERRORS)) {
            SstatusS = status_455X;
            arg0K0 = -1;
            goto L7436;}
          else {
            arg0K0 = -1;
            goto L7436;}}}}}
  else {
    arg0K0 = -1;
    goto L7436;}}
 L7304: {
  thing_456X = arg4K0;
  eofP_457X = arg4K1;
  status_458X = arg0K2;
  if (eofP_457X) {
    SeofPS = 1;
    arg4K0 = 0;
    goto L7330;}
  else {
    if ((status_458X == NO_ERRORS)) {
      arg4K0 = thing_456X;
      goto L7330;}
    else {
      SeofPS = 1;
      if (((SstatusS) == NO_ERRORS)) {
        SstatusS = status_458X;
        arg4K0 = 0;
        goto L7330;}
      else {
        arg4K0 = 0;
        goto L7330;}}}}
 L7436: {
  old_bytes_per_cell_459X = arg0K0;
  if (((SstatusS) == NO_ERRORS)) {
    if ((SeofPS)) {
      SstatusS = EDOM;
      ps_write_string("Premature EOF when reading image file", (stderr));
      { long ignoreXX;
      PS_WRITE_CHAR(10, (stderr), ignoreXX) }
      status_460X = SstatusS;
      if ((status_460X == NO_ERRORS)) {
        goto L7884;}
      else {
        ps_write_string((ps_error_string((SstatusS))), (stderr));
        { long ignoreXX;
        PS_WRITE_CHAR(10, (stderr), ignoreXX) }
        goto L7884;}}
    else {
      if (same_versionP_440X) {
        if ((0 == format_451X)) {
          goto L7948;}
        else {
          if ((1 == format_451X)) {
            goto L7948;}
          else {
            ps_write_string("Unknown image format", (stderr));
            { long ignoreXX;
            PS_WRITE_CHAR(10, (stderr), ignoreXX) }
            status_461X = SstatusS;
            if ((status_461X == NO_ERRORS)) {
              goto L7959;}
            else {
              ps_write_string((ps_error_string((SstatusS))), (stderr));
              { long ignoreXX;
              PS_WRITE_CHAR(10, (stderr), ignoreXX) }
              goto L7959;}}}}
      else {
        ps_write_string("Format of image is incompatible with this version of system", (stderr));
        { long ignoreXX;
        PS_WRITE_CHAR(10, (stderr), ignoreXX) }
        status_462X = SstatusS;
        if ((status_462X == NO_ERRORS)) {
          goto L7918;}
        else {
          ps_write_string((ps_error_string((SstatusS))), (stderr));
          { long ignoreXX;
          PS_WRITE_CHAR(10, (stderr), ignoreXX) }
          goto L7918;}}}}
  else {
    ps_write_string("Error reading from image file", (stderr));
    { long ignoreXX;
    PS_WRITE_CHAR(10, (stderr), ignoreXX) }
    status_463X = SstatusS;
    if ((status_463X == NO_ERRORS)) {
      goto L7849;}
    else {
      ps_write_string((ps_error_string((SstatusS))), (stderr));
      { long ignoreXX;
      PS_WRITE_CHAR(10, (stderr), ignoreXX) }
      goto L7849;}}}
 L7884: {
  status_464X = ps_close(port_427X);
  if ((status_464X == NO_ERRORS)) {
    arg0K0 = -1;
    arg0K1 = format_451X;
    goto L16863;}
  else {
    ps_write_string("Error closing image file", (stderr));
    { long ignoreXX;
    PS_WRITE_CHAR(10, (stderr), ignoreXX) }
    arg0K0 = -1;
    arg0K1 = format_451X;
    goto L16863;}}
 L7948: {
  if ((8 == old_bytes_per_cell_459X)) {
    if ((0 == format_451X)) {
      status_465X = SstatusS;
      if ((status_465X == NO_ERRORS)) {
        if ((SeofPS)) {
          arg0K0 = -1;
          goto L4783;}
        else {
          PS_READ_INTEGER(port_427X, thing_466X, eofP_467X, status_468X)
          if (eofP_467X) {
            SeofPS = 1;
            arg0K0 = -1;
            goto L4783;}
          else {
            if ((status_468X == NO_ERRORS)) {
              arg0K0 = thing_466X;
              goto L4783;}
            else {
              SeofPS = 1;
              if (((SstatusS) == NO_ERRORS)) {
                SstatusS = status_468X;
                arg0K0 = -1;
                goto L4783;}
              else {
                arg0K0 = -1;
                goto L4783;}}}}}
      else {
        arg0K0 = -1;
        goto L4783;}}
    else {
      if ((1 == format_451X)) {
        status_469X = SstatusS;
        if ((status_469X == NO_ERRORS)) {
          if ((SeofPS)) {
            arg0K0 = -1;
            goto L4901;}
          else {
            PS_READ_INTEGER(port_427X, thing_470X, eofP_471X, status_472X)
            if (eofP_471X) {
              SeofPS = 1;
              arg0K0 = -1;
              goto L4901;}
            else {
              if ((status_472X == NO_ERRORS)) {
                arg0K0 = thing_470X;
                goto L4901;}
              else {
                SeofPS = 1;
                if (((SstatusS) == NO_ERRORS)) {
                  SstatusS = status_472X;
                  arg0K0 = -1;
                  goto L4901;}
                else {
                  arg0K0 = -1;
                  goto L4901;}}}}}
        else {
          arg0K0 = -1;
          goto L4901;}}
      else {
        ps_error("check-all-data!: Unknown image format (this can't happen)", 0);
        goto L7478;}}}
  else {
    ps_write_string("Incompatible bytes-per-cell in image", (stderr));
    { long ignoreXX;
    PS_WRITE_CHAR(10, (stderr), ignoreXX) }
    status_473X = SstatusS;
    if ((status_473X == NO_ERRORS)) {
      goto L7993;}
    else {
      ps_write_string((ps_error_string((SstatusS))), (stderr));
      { long ignoreXX;
      PS_WRITE_CHAR(10, (stderr), ignoreXX) }
      goto L7993;}}}
 L7959: {
  status_474X = ps_close(port_427X);
  if ((status_474X == NO_ERRORS)) {
    arg0K0 = -1;
    arg0K1 = format_451X;
    goto L16863;}
  else {
    ps_write_string("Error closing image file", (stderr));
    { long ignoreXX;
    PS_WRITE_CHAR(10, (stderr), ignoreXX) }
    arg0K0 = -1;
    arg0K1 = format_451X;
    goto L16863;}}
 L7918: {
  status_475X = ps_close(port_427X);
  if ((status_475X == NO_ERRORS)) {
    arg0K0 = -1;
    arg0K1 = format_451X;
    goto L16863;}
  else {
    ps_write_string("Error closing image file", (stderr));
    { long ignoreXX;
    PS_WRITE_CHAR(10, (stderr), ignoreXX) }
    arg0K0 = -1;
    arg0K1 = format_451X;
    goto L16863;}}
 L7849: {
  status_476X = ps_close(port_427X);
  if ((status_476X == NO_ERRORS)) {
    arg0K0 = -1;
    arg0K1 = format_451X;
    goto L16863;}
  else {
    ps_write_string("Error closing image file", (stderr));
    { long ignoreXX;
    PS_WRITE_CHAR(10, (stderr), ignoreXX) }
    arg0K0 = -1;
    arg0K1 = format_451X;
    goto L16863;}}
 L16863: {
  status_477X = arg0K0;
  format_478X = arg0K1;
  if ((0 == status_477X)) {
    if (((SstatusS) == NO_ERRORS)) {
      image_start_address_479X = Simg_start_addrS;
      minimum_size_480X = (((Simg_heap_sizeS))<<2);
      if ((max_heap_size_406X < minimum_size_480X)) {
        ps_write_string("Heap size ", (stderr));
        ps_write_integer(max_heap_size_406X, (stderr));
        ps_write_string(" is too small, using ", (stderr));
        ps_write_integer(minimum_size_480X, (stderr));
        ps_write_string(" cells", (stderr));
        { long ignoreXX;
        PS_WRITE_CHAR(10, (stderr), ignoreXX) }
        arg0K0 = minimum_size_480X;
        goto L2231;}
      else {
        arg0K0 = max_heap_size_406X;
        goto L2231;}}
    else {
      return -1;}}
  else {
    return -1;}}
 L4783: {
  cells_481X = arg0K0;
  Simg_start_addrS = (((char *) (((cells_481X)<<3))));
  status_482X = SstatusS;
  if ((status_482X == NO_ERRORS)) {
    if ((SeofPS)) {
      arg0K0 = -1;
      goto L4838;}
    else {
      PS_READ_INTEGER(port_427X, thing_483X, eofP_484X, status_485X)
      if (eofP_484X) {
        SeofPS = 1;
        arg0K0 = -1;
        goto L4838;}
      else {
        if ((status_485X == NO_ERRORS)) {
          arg0K0 = thing_483X;
          goto L4838;}
        else {
          SeofPS = 1;
          if (((SstatusS) == NO_ERRORS)) {
            SstatusS = status_485X;
            arg0K0 = -1;
            goto L4838;}
          else {
            arg0K0 = -1;
            goto L4838;}}}}}
  else {
    arg0K0 = -1;
    goto L4838;}}
 L4901: {
  cells_486X = arg0K0;
  sb_487X = ((cells_486X)<<3);
  status_488X = SstatusS;
  if ((status_488X == NO_ERRORS)) {
    if ((SeofPS)) {
      arg0K0 = -1;
      goto L4956;}
    else {
      PS_READ_INTEGER(port_427X, thing_489X, eofP_490X, status_491X)
      if (eofP_490X) {
        SeofPS = 1;
        arg0K0 = -1;
        goto L4956;}
      else {
        if ((status_491X == NO_ERRORS)) {
          arg0K0 = thing_489X;
          goto L4956;}
        else {
          SeofPS = 1;
          if (((SstatusS) == NO_ERRORS)) {
            SstatusS = status_491X;
            arg0K0 = -1;
            goto L4956;}
          else {
            arg0K0 = -1;
            goto L4956;}}}}}
  else {
    arg0K0 = -1;
    goto L4956;}}
 L7478: {
  status_492X = SstatusS;
  if ((status_492X == NO_ERRORS)) {
    if ((SeofPS)) {
      arg0K0 = -1;
      goto L7529;}
    else {
      PS_READ_INTEGER(port_427X, thing_493X, eofP_494X, status_495X)
      if (eofP_494X) {
        SeofPS = 1;
        arg0K0 = -1;
        goto L7529;}
      else {
        if ((status_495X == NO_ERRORS)) {
          arg0K0 = thing_493X;
          goto L7529;}
        else {
          SeofPS = 1;
          if (((SstatusS) == NO_ERRORS)) {
            SstatusS = status_495X;
            arg0K0 = -1;
            goto L7529;}
          else {
            arg0K0 = -1;
            goto L7529;}}}}}
  else {
    arg0K0 = -1;
    goto L7529;}}
 L7993: {
  status_496X = ps_close(port_427X);
  if ((status_496X == NO_ERRORS)) {
    arg0K0 = -1;
    arg0K1 = format_451X;
    goto L16863;}
  else {
    ps_write_string("Error closing image file", (stderr));
    { long ignoreXX;
    PS_WRITE_CHAR(10, (stderr), ignoreXX) }
    arg0K0 = -1;
    arg0K1 = format_451X;
    goto L16863;}}
 L2231: {
  heap_size_497X = arg0K0;
  heap_498X = (char *)malloc((((heap_size_497X)<<4)));
  if ((heap_498X == NULL)) {
    ps_error("unable to allocate heap space", 0);
    goto L2247;}
  else {
    goto L2247;}}
 L4838: {
  cells_499X = arg0K0;
  Simg_end_addrS = (((char *) (((cells_499X)<<3))));
  Simg_heap_sizeS = ((((7 + ((Simg_end_addrS) - (Simg_start_addrS))))>>3));
  goto L7478;}
 L4956: {
  cells_500X = arg0K0;
  sh_501X = ((cells_500X)<<3);
  status_502X = SstatusS;
  if ((status_502X == NO_ERRORS)) {
    if ((SeofPS)) {
      arg0K0 = -1;
      goto L5011;}
    else {
      PS_READ_INTEGER(port_427X, thing_503X, eofP_504X, status_505X)
      if (eofP_504X) {
        SeofPS = 1;
        arg0K0 = -1;
        goto L5011;}
      else {
        if ((status_505X == NO_ERRORS)) {
          arg0K0 = thing_503X;
          goto L5011;}
        else {
          SeofPS = 1;
          if (((SstatusS) == NO_ERRORS)) {
            SstatusS = status_505X;
            arg0K0 = -1;
            goto L5011;}
          else {
            arg0K0 = -1;
            goto L5011;}}}}}
  else {
    arg0K0 = -1;
    goto L5011;}}
 L7529: {
  expr_506X = arg0K0;
  SsymbolsS = expr_506X;
  status_507X = SstatusS;
  if ((status_507X == NO_ERRORS)) {
    if ((SeofPS)) {
      arg0K0 = -1;
      goto L7582;}
    else {
      PS_READ_INTEGER(port_427X, thing_508X, eofP_509X, status_510X)
      if (eofP_509X) {
        SeofPS = 1;
        arg0K0 = -1;
        goto L7582;}
      else {
        if ((status_510X == NO_ERRORS)) {
          arg0K0 = thing_508X;
          goto L7582;}
        else {
          SeofPS = 1;
          if (((SstatusS) == NO_ERRORS)) {
            SstatusS = status_510X;
            arg0K0 = -1;
            goto L7582;}
          else {
            arg0K0 = -1;
            goto L7582;}}}}}
  else {
    arg0K0 = -1;
    goto L7582;}}
 L2247: {
  semisize_511X = ((heap_size_497X)<<3);
  Snewspace_beginS = heap_498X;
  Snewspace_endS = ((Snewspace_beginS) + semisize_511X);
  Soldspace_beginS = (Snewspace_endS);
  Soldspace_endS = ((Soldspace_beginS) + semisize_511X);
  if (((Soldspace_beginS) == image_start_address_479X)) {
    temp_512X = s48_SlimitS;
    s48_SlimitS = (Soldspace_limitS);
    Soldspace_limitS = temp_512X;
    temp_513X = s48_ShpS;
    s48_ShpS = (Soldspace_hpS);
    Soldspace_hpS = temp_513X;
    temp_514X = Snewspace_beginS;
    Snewspace_beginS = (Soldspace_beginS);
    Soldspace_beginS = temp_514X;
    temp_515X = Snewspace_endS;
    Snewspace_endS = (Soldspace_endS);
    Soldspace_endS = temp_515X;
    goto L2271;}
  else {
    goto L2271;}}
 L5011: {
  cells_516X = arg0K0;
  se_517X = ((cells_516X)<<3);
  status_518X = SstatusS;
  if ((status_518X == NO_ERRORS)) {
    if ((SeofPS)) {
      arg0K0 = -1;
      goto L5068;}
    else {
      PS_READ_INTEGER(port_427X, thing_519X, eofP_520X, status_521X)
      if (eofP_520X) {
        SeofPS = 1;
        arg0K0 = -1;
        goto L5068;}
      else {
        if ((status_521X == NO_ERRORS)) {
          arg0K0 = thing_519X;
          goto L5068;}
        else {
          SeofPS = 1;
          if (((SstatusS) == NO_ERRORS)) {
            SstatusS = status_521X;
            arg0K0 = -1;
            goto L5068;}
          else {
            arg0K0 = -1;
            goto L5068;}}}}}
  else {
    arg0K0 = -1;
    goto L5068;}}
 L7582: {
  expr_522X = arg0K0;
  Simported_bindingsS = expr_522X;
  status_523X = SstatusS;
  if ((status_523X == NO_ERRORS)) {
    if ((SeofPS)) {
      arg0K0 = -1;
      goto L7635;}
    else {
      PS_READ_INTEGER(port_427X, thing_524X, eofP_525X, status_526X)
      if (eofP_525X) {
        SeofPS = 1;
        arg0K0 = -1;
        goto L7635;}
      else {
        if ((status_526X == NO_ERRORS)) {
          arg0K0 = thing_524X;
          goto L7635;}
        else {
          SeofPS = 1;
          if (((SstatusS) == NO_ERRORS)) {
            SstatusS = status_526X;
            arg0K0 = -1;
            goto L7635;}
          else {
            arg0K0 = -1;
            goto L7635;}}}}}
  else {
    arg0K0 = -1;
    goto L7635;}}
 L2271: {
  Soldspace_hpS = (Soldspace_beginS);
  Soldspace_limitS = (Soldspace_endS);
  s48_ShpS = (Snewspace_beginS);
  s48_SlimitS = (Snewspace_endS);
  Snew_heap_start_addrS = (Snewspace_beginS);
  if (((SstatusS) == NO_ERRORS)) {
    new_addr_527X = (char *)malloc(8);
    got_528X = ps_read_block(port_427X, ((char *) new_addr_527X), 8, &eofP_529X, &status_530X);
    if ((status_530X == NO_ERRORS)) {
      if (eofP_529X) {
        goto L4600;}
      else {
        if ((got_528X < 8)) {
          goto L4600;}
        else {
          goto L4552;}}}
    else {
      SstatusS = status_530X;
      goto L4600;}}
  else {
    return -1;}}
 L5068: {
  cells_531X = arg0K0;
  lh_532X = ((cells_531X)<<3);
  status_533X = SstatusS;
  if ((status_533X == NO_ERRORS)) {
    if ((SeofPS)) {
      arg0K0 = -1;
      goto L5123;}
    else {
      PS_READ_INTEGER(port_427X, thing_534X, eofP_535X, status_536X)
      if (eofP_535X) {
        SeofPS = 1;
        arg0K0 = -1;
        goto L5123;}
      else {
        if ((status_536X == NO_ERRORS)) {
          arg0K0 = thing_534X;
          goto L5123;}
        else {
          SeofPS = 1;
          if (((SstatusS) == NO_ERRORS)) {
            SstatusS = status_536X;
            arg0K0 = -1;
            goto L5123;}
          else {
            arg0K0 = -1;
            goto L5123;}}}}}
  else {
    arg0K0 = -1;
    goto L5123;}}
 L7635: {
  expr_537X = arg0K0;
  Sexported_bindingsS = expr_537X;
  status_538X = SstatusS;
  if ((status_538X == NO_ERRORS)) {
    if ((SeofPS)) {
      arg0K0 = -1;
      goto L7688;}
    else {
      PS_READ_INTEGER(port_427X, thing_539X, eofP_540X, status_541X)
      if (eofP_540X) {
        SeofPS = 1;
        arg0K0 = -1;
        goto L7688;}
      else {
        if ((status_541X == NO_ERRORS)) {
          arg0K0 = thing_539X;
          goto L7688;}
        else {
          SeofPS = 1;
          if (((SstatusS) == NO_ERRORS)) {
            SstatusS = status_541X;
            arg0K0 = -1;
            goto L7688;}
          else {
            arg0K0 = -1;
            goto L7688;}}}}}
  else {
    arg0K0 = -1;
    goto L7688;}}
 L4600: {
  ps_error("byte order check failed", 0);
  goto L4552;}
 L4552: {
  if ((1 == (*((long *) new_addr_527X)))) {
    free(new_addr_527X);
    arg4K0 = 0;
    goto L16931;}
  else {
    arg0K0 = 0;
    arg0K1 = 7;
    goto L4613;}}
 L5123: {
  cells_542X = arg0K0;
  le_543X = ((cells_542X)<<3);
  status_544X = SstatusS;
  if ((status_544X == NO_ERRORS)) {
    if ((SeofPS)) {
      arg0K0 = -1;
      goto L5180;}
    else {
      PS_READ_INTEGER(port_427X, thing_545X, eofP_546X, status_547X)
      if (eofP_546X) {
        SeofPS = 1;
        arg0K0 = -1;
        goto L5180;}
      else {
        if ((status_547X == NO_ERRORS)) {
          arg0K0 = thing_545X;
          goto L5180;}
        else {
          SeofPS = 1;
          if (((SstatusS) == NO_ERRORS)) {
            SstatusS = status_547X;
            arg0K0 = -1;
            goto L5180;}
          else {
            arg0K0 = -1;
            goto L5180;}}}}}
  else {
    arg0K0 = -1;
    goto L5180;}}
 L7688: {
  expr_548X = arg0K0;
  Sresumer_recordsS = expr_548X;
  status_549X = SstatusS;
  if ((status_549X == NO_ERRORS)) {
    if ((SeofPS)) {
      arg0K0 = -1;
      goto L7741;}
    else {
      PS_READ_INTEGER(port_427X, thing_550X, eofP_551X, status_552X)
      if (eofP_551X) {
        SeofPS = 1;
        arg0K0 = -1;
        goto L7741;}
      else {
        if ((status_552X == NO_ERRORS)) {
          arg0K0 = thing_550X;
          goto L7741;}
        else {
          SeofPS = 1;
          if (((SstatusS) == NO_ERRORS)) {
            SstatusS = status_552X;
            arg0K0 = -1;
            goto L7741;}
          else {
            arg0K0 = -1;
            goto L7741;}}}}}
  else {
    arg0K0 = -1;
    goto L7741;}}
 L16931: {
  reverse_byte_orderP_553X = arg4K0;
  if ((0 == format_478X)) {
    delta_554X = (Snew_heap_start_addrS) - (Simg_start_addrS);
    new_hp_555X = (Simg_end_addrS) + delta_554X;
    size_in_byte_556X = (((Simg_heap_sizeS))<<3);
    x_557X = ((s48_ShpS) + (-8 & (7 + size_in_byte_556X))) < (s48_SlimitS);
    if (x_557X) {
      goto L15512;}
    else {s48_collect(0);
      goto L15512;}}
  else {
    if ((1 == format_478X)) {
      Sheap_image_pointerS = NULL;
      Ssymbol_addressS = NULL;
      v_558X = SsymbolsS;
      if ((1 == v_558X)) {
        arg1K0 = (Simg_end_addrS);
        goto L6948;}
      else {
        arg1K0 = ((((char *) (-3 + (SsymbolsS)))) + -8);
        goto L6948;}}
    else {
      ps_write_string("unknown image format", (stderr));
      { long ignoreXX;
      PS_WRITE_CHAR(10, (stderr), ignoreXX) }
      status_559X = SstatusS;
      if ((status_559X == NO_ERRORS)) {
        goto L16808;}
      else {
        ps_write_string((ps_error_string((SstatusS))), (stderr));
        { long ignoreXX;
        PS_WRITE_CHAR(10, (stderr), ignoreXX) }
        goto L16808;}}}}
 L4613: {
  i_560X = arg0K0;
  j_561X = arg0K1;
  if ((i_560X < j_561X)) {
    addr_a_562X = new_addr_527X + i_560X;
    addr_b_563X = new_addr_527X + j_561X;
    byte_a_564X = *((unsigned char *) addr_a_562X);
    *((unsigned char *) addr_a_562X) = (unsigned char) ((*((unsigned char *) addr_b_563X)));
    *((unsigned char *) addr_b_563X) = (unsigned char) (byte_a_564X);
    arg0K0 = (1 + i_560X);
    arg0K1 = (-1 + j_561X);
    goto L4613;}
  else {
    v_565X = *((long *) new_addr_527X);
    if ((1 == v_565X)) {
      goto L4572;}
    else {
      ps_error("Unable to correct byte order", 0);
      goto L4572;}}}
 L5180: {
  cells_566X = arg0K0;
  wh_567X = ((cells_566X)<<3);
  status_568X = SstatusS;
  if ((status_568X == NO_ERRORS)) {
    if ((SeofPS)) {
      arg0K0 = -1;
      goto L5235;}
    else {
      PS_READ_INTEGER(port_427X, thing_569X, eofP_570X, status_571X)
      if (eofP_570X) {
        SeofPS = 1;
        arg0K0 = -1;
        goto L5235;}
      else {
        if ((status_571X == NO_ERRORS)) {
          arg0K0 = thing_569X;
          goto L5235;}
        else {
          SeofPS = 1;
          if (((SstatusS) == NO_ERRORS)) {
            SstatusS = status_571X;
            arg0K0 = -1;
            goto L5235;}
          else {
            arg0K0 = -1;
            goto L5235;}}}}}
  else {
    arg0K0 = -1;
    goto L5235;}}
 L7741: {
  expr_572X = arg0K0;
  Sstartup_procedureS = expr_572X;
  if (((SstatusS) == NO_ERRORS)) {
    if ((SeofPS)) {
      arg0K0 = 0;
      arg0K1 = format_451X;
      goto L16863;}
    else {
      goto L8080;}}
  else {
    arg0K0 = 0;
    arg0K1 = format_451X;
    goto L16863;}}
 L15512: {
  if ((((s48_ShpS) + (-8 & (7 + size_in_byte_556X))) < (s48_SlimitS))) {
    s48_ShpS = ((s48_ShpS) + (-8 & (7 + size_in_byte_556X)));
    goto L15391;}
  else {
    goto L15391;}}
 L6948: {
  v_573X = arg1K0;
  Ssymbol_addressS = v_573X;
  Sheap_object_remaining_cellsS = 0;
  Sheap_object_pointerS = NULL;
  keys_574X = (long*)malloc(sizeof(long) * 4097);
  arg0K0 = 0;
  goto L6971;}
 L16808: {
  status_575X = ps_close(port_427X);
  if ((status_575X == NO_ERRORS)) {
    arg0K0 = -1;
    goto L16933;}
  else {
    ps_write_string("Error closing image file", (stderr));
    { long ignoreXX;
    PS_WRITE_CHAR(10, (stderr), ignoreXX) }
    arg0K0 = -1;
    goto L16933;}}
 L4572: {
  free(new_addr_527X);
  arg4K0 = 1;
  goto L16931;}
 L5235: {
  cells_576X = arg0K0;
  we_577X = ((cells_576X)<<3);
  Ssmall_img_start_addrS = (((char *) sb_487X));
  Ssmall_img_hp_addrS = (((char *) sh_501X));
  Ssmall_img_end_addrS = (((char *) se_517X));
  Slarge_img_start_addrS = (((char *) se_517X));
  Slarge_img_hp_addrS = (((char *) lh_532X));
  Slarge_img_end_addrS = (((char *) le_543X));
  Sweaks_img_start_addrS = (((char *) le_543X));
  Sweaks_img_hp_addrS = (((char *) wh_567X));
  Sweaks_img_end_addrS = (((char *) we_577X));
  Ssmall_img_heap_sizeS = ((((sh_501X - sb_487X))>>3));
  Slarge_img_heap_sizeS = ((((lh_532X - se_517X))>>3));
  Sweaks_img_heap_sizeS = ((((wh_567X - le_543X))>>3));
  Simg_start_addrS = (((char *) le_543X));
  Simg_end_addrS = (((char *) sh_501X));
  Simg_heap_sizeS = ((((((se_517X - sb_487X))>>3)) + ((((le_543X - se_517X))>>3))) + ((((we_577X - le_543X))>>3)));
  goto L7478;}
 L8080: {
  PS_READ_CHAR(port_427X, ch_578X, eofP_579X, status_580X)
  if (eofP_579X) {
    arg4K0 = eofP_579X;
    arg0K1 = status_580X;
    goto L7768;}
  else {
    if ((status_580X == NO_ERRORS)) {
      if ((12 == ch_578X)) {
        arg4K0 = 0;
        arg0K1 = status_580X;
        goto L7768;}
      else {
        goto L8080;}}
    else {
      arg4K0 = eofP_579X;
      arg0K1 = status_580X;
      goto L7768;}}}
 L15391: {
  cells_581X = Simg_heap_sizeS;
  address_582X = Snew_heap_start_addrS;
  need_583X = ((cells_581X)<<3);
  got_584X = ps_read_block(port_427X, ((char *) address_582X), need_583X, &eofP_585X, &status_586X);
  if ((status_586X == NO_ERRORS)) {
    if (eofP_585X) {
      arg4K0 = 0;
      arg5K1 = "Premature EOF when reading image file";
      goto L15401;}
    else {
      if ((got_584X < need_583X)) {
        arg4K0 = 0;
        arg5K1 = "Read returned too few bytes";
        goto L15401;}
      else {
        arg4K0 = 1;
        arg5K1 = "";
        goto L15401;}}}
  else {
    SstatusS = status_586X;
    arg4K0 = 0;
    arg5K1 = "Error reading from image file";
    goto L15401;}}
 L6971: {
  i_587X = arg0K0;
  if ((i_587X < 4097)) {
    *(keys_574X + i_587X) = 0;
    arg0K0 = (1 + i_587X);
    goto L6971;}
  else {
    table_588X = (struct table*)malloc(sizeof(struct table));
    if ((NULL == table_588X)) {
      arg3K0 = table_588X;
      goto L6959;}
    else {
      table_588X->keys = keys_574X;
      table_588X->values = ((struct image_location**)malloc(sizeof(struct image_location*) * 4096));
      table_588X->count = 0;
      table_588X->size = 4096;
      arg3K0 = table_588X;
      goto L6959;}}}
 L16933: {
  expr_589X = arg0K0;
  if ((0 == expr_589X)) {
    if (((SstatusS) == NO_ERRORS)) {
      return 0;}
    else {
      return -1;}}
  else {
    return -1;}}
 L7768: {
  eofP_590X = arg4K0;
  status_591X = arg0K1;
  if (eofP_590X) {
    SeofPS = 1;
    arg0K0 = 0;
    arg0K1 = format_451X;
    goto L16863;}
  else {
    if ((status_591X == NO_ERRORS)) {
      arg0K0 = 0;
      arg0K1 = format_451X;
      goto L16863;}
    else {
      SeofPS = 1;
      if (((SstatusS) == NO_ERRORS)) {
        SstatusS = status_591X;
        arg0K0 = 0;
        arg0K1 = format_451X;
        goto L16863;}
      else {
        arg0K0 = 0;
        arg0K1 = format_451X;
        goto L16863;}}}}
 L15401: {
  okayP_592X = arg4K0;
  string_593X = arg5K1;
  PS_READ_CHAR(port_427X, v_594X, eofP_595X, status_596X)
  if (okayP_592X) {
    if ((status_596X == NO_ERRORS)) {
      if (eofP_595X) {
        status_597X = ps_close(port_427X);
        if ((status_597X == NO_ERRORS)) {
          if (reverse_byte_orderP_553X) {
            merged_arg1K0 = (Snew_heap_start_addrS);
            merged_arg1K1 = new_hp_555X;
            reverse_byte_orderB_return_tag = 0;
            goto reverse_byte_orderB;
           reverse_byte_orderB_return_0:
            goto L15441;}
          else {
            goto L15441;}}
        else {
          ps_write_string("Error closing image file", (stderr));
          { long ignoreXX;
          PS_WRITE_CHAR(10, (stderr), ignoreXX) }
          status_598X = SstatusS;
          if ((status_598X == NO_ERRORS)) {
            goto L15658;}
          else {
            ps_write_string((ps_error_string((SstatusS))), (stderr));
            { long ignoreXX;
            PS_WRITE_CHAR(10, (stderr), ignoreXX) }
            goto L15658;}}}
      else {
        ps_write_string("Image file has extraneous data after image", (stderr));
        { long ignoreXX;
        PS_WRITE_CHAR(10, (stderr), ignoreXX) }
        status_599X = SstatusS;
        if ((status_599X == NO_ERRORS)) {
          goto L15626;}
        else {
          ps_write_string((ps_error_string((SstatusS))), (stderr));
          { long ignoreXX;
          PS_WRITE_CHAR(10, (stderr), ignoreXX) }
          goto L15626;}}}
    else {
      ps_write_string("Error reading from image file", (stderr));
      { long ignoreXX;
      PS_WRITE_CHAR(10, (stderr), ignoreXX) }
      status_600X = SstatusS;
      if ((status_600X == NO_ERRORS)) {
        goto L15594;}
      else {
        ps_write_string((ps_error_string((SstatusS))), (stderr));
        { long ignoreXX;
        PS_WRITE_CHAR(10, (stderr), ignoreXX) }
        goto L15594;}}}
  else {
    ps_write_string(string_593X, (stderr));
    { long ignoreXX;
    PS_WRITE_CHAR(10, (stderr), ignoreXX) }
    status_601X = SstatusS;
    if ((status_601X == NO_ERRORS)) {
      goto L15562;}
    else {
      ps_write_string((ps_error_string((SstatusS))), (stderr));
      { long ignoreXX;
      PS_WRITE_CHAR(10, (stderr), ignoreXX) }
      goto L15562;}}}
 L6959: {
  v_602X = arg3K0;
  Sstob_tableS = v_602X;
  Sheap_image_pointerS = ((char *)malloc(((((Simg_heap_sizeS))<<3))));
  if ((0 == format_478X)) {
    need_603X = (((Simg_heap_sizeS))<<3);
    got_604X = ps_read_block(port_427X, ((char *) (Sheap_image_pointerS)), need_603X, &eofP_605X, &status_606X);
    if ((status_606X == NO_ERRORS)) {
      if (eofP_605X) {
        arg4K0 = 0;
        arg5K1 = "Premature EOF when reading image file";
        goto L9255;}
      else {
        if ((got_604X < need_603X)) {
          arg4K0 = 0;
          arg5K1 = "Read returned too few bytes";
          goto L9255;}
        else {
          arg4K0 = 1;
          arg5K1 = "";
          goto L9255;}}}
    else {
      SstatusS = status_606X;
      arg4K0 = 0;
      arg5K1 = "Error reading from image file";
      goto L9255;}}
  else {
    if ((1 == format_478X)) {
      merged_arg1K0 = (Sheap_image_pointerS);
      merged_arg0K1 = (Sweaks_img_heap_sizeS);
      merged_arg6K2 = port_427X;
      really_read_image_area_return_tag = 0;
      goto really_read_image_area;
     really_read_image_area_return_0:
      expr_607X = really_read_image_area0_return_value;
      if ((0 == expr_607X)) {
        if (((SstatusS) == NO_ERRORS)) {
          merged_arg1K0 = ((Sheap_image_pointerS) + ((Sweaks_img_end_addrS) - (Sweaks_img_start_addrS)));
          merged_arg0K1 = (Slarge_img_heap_sizeS);
          merged_arg6K2 = port_427X;
          really_read_image_area_return_tag = 1;
          goto really_read_image_area;
         really_read_image_area_return_1:
          expr_608X = really_read_image_area0_return_value;
          if ((0 == expr_608X)) {
            if (((SstatusS) == NO_ERRORS)) {
              merged_arg1K0 = ((Sheap_image_pointerS) + ((Sweaks_img_end_addrS) - (Slarge_img_start_addrS)));
              merged_arg0K1 = (Ssmall_img_heap_sizeS);
              merged_arg6K2 = port_427X;
              really_read_image_area_return_tag = 2;
              goto really_read_image_area;
             really_read_image_area_return_2:
              expr_609X = really_read_image_area0_return_value;
              if ((0 == expr_609X)) {
                if (((SstatusS) == NO_ERRORS)) {
                  arg0K0 = 0;
                  goto L9288;}
                else {
                  arg0K0 = -1;
                  goto L9288;}}
              else {
                arg0K0 = -1;
                goto L9288;}}
            else {
              arg0K0 = -1;
              goto L9288;}}
          else {
            arg0K0 = -1;
            goto L9288;}}
        else {
          arg0K0 = -1;
          goto L9288;}}
      else {
        arg0K0 = -1;
        goto L9288;}}
    else {
      ps_write_string("this can't happen: invalid image format", (stderr));
      { long ignoreXX;
      PS_WRITE_CHAR(10, (stderr), ignoreXX) }
      status_610X = SstatusS;
      if ((status_610X == NO_ERRORS)) {
        goto L9658;}
      else {
        ps_write_string((ps_error_string((SstatusS))), (stderr));
        { long ignoreXX;
        PS_WRITE_CHAR(10, (stderr), ignoreXX) }
        goto L9658;}}}}
 L15441: {
  if ((0 == delta_554X)) {
    arg0K0 = 0;
    goto L16933;}
  else {
    descriptor_611X = Sstartup_procedureS;
    if ((3 == (3 & descriptor_611X))) {
      arg0K0 = (3 + (((long) ((((char *) (-3 + descriptor_611X))) + delta_554X))));
      goto L15450;}
    else {
      arg0K0 = descriptor_611X;
      goto L15450;}}}
 L15658: {
  status_612X = ps_close(port_427X);
  if ((status_612X == NO_ERRORS)) {
    arg0K0 = -1;
    goto L16933;}
  else {
    ps_write_string("Error closing image file", (stderr));
    { long ignoreXX;
    PS_WRITE_CHAR(10, (stderr), ignoreXX) }
    arg0K0 = -1;
    goto L16933;}}
 L15626: {
  status_613X = ps_close(port_427X);
  if ((status_613X == NO_ERRORS)) {
    arg0K0 = -1;
    goto L16933;}
  else {
    ps_write_string("Error closing image file", (stderr));
    { long ignoreXX;
    PS_WRITE_CHAR(10, (stderr), ignoreXX) }
    arg0K0 = -1;
    goto L16933;}}
 L15594: {
  status_614X = ps_close(port_427X);
  if ((status_614X == NO_ERRORS)) {
    arg0K0 = -1;
    goto L16933;}
  else {
    ps_write_string("Error closing image file", (stderr));
    { long ignoreXX;
    PS_WRITE_CHAR(10, (stderr), ignoreXX) }
    arg0K0 = -1;
    goto L16933;}}
 L15562: {
  status_615X = ps_close(port_427X);
  if ((status_615X == NO_ERRORS)) {
    arg0K0 = -1;
    goto L16933;}
  else {
    ps_write_string("Error closing image file", (stderr));
    { long ignoreXX;
    PS_WRITE_CHAR(10, (stderr), ignoreXX) }
    arg0K0 = -1;
    goto L16933;}}
 L9255: {
  okayP_616X = arg4K0;
  string_617X = arg5K1;
  if (okayP_616X) {
    arg0K0 = 0;
    goto L9288;}
  else {
    ps_write_string(string_617X, (stderr));
    { long ignoreXX;
    PS_WRITE_CHAR(10, (stderr), ignoreXX) }
    status_618X = SstatusS;
    if ((status_618X == NO_ERRORS)) {
      goto L9523;}
    else {
      ps_write_string((ps_error_string((SstatusS))), (stderr));
      { long ignoreXX;
      PS_WRITE_CHAR(10, (stderr), ignoreXX) }
      goto L9523;}}}
 L9288: {
  expr_619X = arg0K0;
  if ((0 == expr_619X)) {
    if (((SstatusS) == NO_ERRORS)) {
      PS_READ_CHAR(port_427X, v_620X, eofP_621X, status_622X)
      if ((status_622X == NO_ERRORS)) {
        if (eofP_621X) {
          status_623X = ps_close(port_427X);
          if ((status_623X == NO_ERRORS)) {
            arg0K0 = 0;
            goto L16702;}
          else {
            ps_write_string("Error closing image file", (stderr));
            { long ignoreXX;
            PS_WRITE_CHAR(10, (stderr), ignoreXX) }
            status_624X = SstatusS;
            if ((status_624X == NO_ERRORS)) {
              goto L9406;}
            else {
              ps_write_string((ps_error_string((SstatusS))), (stderr));
              { long ignoreXX;
              PS_WRITE_CHAR(10, (stderr), ignoreXX) }
              goto L9406;}}}
        else {
          ps_write_string("Image file has extraneous data after image", (stderr));
          { long ignoreXX;
          PS_WRITE_CHAR(10, (stderr), ignoreXX) }
          status_625X = SstatusS;
          if ((status_625X == NO_ERRORS)) {
            goto L9374;}
          else {
            ps_write_string((ps_error_string((SstatusS))), (stderr));
            { long ignoreXX;
            PS_WRITE_CHAR(10, (stderr), ignoreXX) }
            goto L9374;}}}
      else {
        ps_write_string("Error reading from image file", (stderr));
        { long ignoreXX;
        PS_WRITE_CHAR(10, (stderr), ignoreXX) }
        status_626X = SstatusS;
        if ((status_626X == NO_ERRORS)) {
          goto L9342;}
        else {
          ps_write_string((ps_error_string((SstatusS))), (stderr));
          { long ignoreXX;
          PS_WRITE_CHAR(10, (stderr), ignoreXX) }
          goto L9342;}}}
    else {
      arg0K0 = -1;
      goto L16702;}}
  else {
    arg0K0 = -1;
    goto L16702;}}
 L9658: {
  status_627X = ps_close(port_427X);
  if ((status_627X == NO_ERRORS)) {
    arg0K0 = -1;
    goto L9288;}
  else {
    ps_write_string("Error closing image file", (stderr));
    { long ignoreXX;
    PS_WRITE_CHAR(10, (stderr), ignoreXX) }
    arg0K0 = -1;
    goto L9288;}}
 L15450: {
  expr_628X = arg0K0;
  Sstartup_procedureS = expr_628X;
  descriptor_629X = SsymbolsS;
  if ((3 == (3 & descriptor_629X))) {
    arg0K0 = (3 + (((long) ((((char *) (-3 + descriptor_629X))) + delta_554X))));
    goto L15456;}
  else {
    arg0K0 = descriptor_629X;
    goto L15456;}}
 L9523: {
  status_630X = ps_close(port_427X);
  if ((status_630X == NO_ERRORS)) {
    arg0K0 = -1;
    goto L9288;}
  else {
    ps_write_string("Error closing image file", (stderr));
    { long ignoreXX;
    PS_WRITE_CHAR(10, (stderr), ignoreXX) }
    arg0K0 = -1;
    goto L9288;}}
 L16702: {
  expr_631X = arg0K0;
  if ((0 == expr_631X)) {
    if (((SstatusS) == NO_ERRORS)) {
      if (reverse_byte_orderP_553X) {
        merged_arg1K0 = (Simg_start_addrS);
        merged_arg0K1 = format_478X;
        old_Gnew_addr_return_tag = 0;
        goto old_Gnew_addr;
       old_Gnew_addr_return_0:
        v_632X = old_Gnew_addr0_return_value;
        merged_arg1K0 = (Simg_end_addrS);
        merged_arg0K1 = format_478X;
        old_Gnew_addr_return_tag = 1;
        goto old_Gnew_addr;
       old_Gnew_addr_return_1:
        v_633X = old_Gnew_addr0_return_value;
        merged_arg1K0 = v_632X;
        merged_arg1K1 = v_633X;
        reverse_byte_orderB_return_tag = 1;
        goto reverse_byte_orderB;
       reverse_byte_orderB_return_1:
        goto L16714;}
      else {
        goto L16714;}}
    else {
      arg0K0 = -1;
      goto L16933;}}
  else {
    arg0K0 = -1;
    goto L16933;}}
 L9406: {
  status_634X = ps_close(port_427X);
  if ((status_634X == NO_ERRORS)) {
    arg0K0 = -1;
    goto L16702;}
  else {
    ps_write_string("Error closing image file", (stderr));
    { long ignoreXX;
    PS_WRITE_CHAR(10, (stderr), ignoreXX) }
    arg0K0 = -1;
    goto L16702;}}
 L9374: {
  status_635X = ps_close(port_427X);
  if ((status_635X == NO_ERRORS)) {
    arg0K0 = -1;
    goto L16702;}
  else {
    ps_write_string("Error closing image file", (stderr));
    { long ignoreXX;
    PS_WRITE_CHAR(10, (stderr), ignoreXX) }
    arg0K0 = -1;
    goto L16702;}}
 L9342: {
  status_636X = ps_close(port_427X);
  if ((status_636X == NO_ERRORS)) {
    arg0K0 = -1;
    goto L16702;}
  else {
    ps_write_string("Error closing image file", (stderr));
    { long ignoreXX;
    PS_WRITE_CHAR(10, (stderr), ignoreXX) }
    arg0K0 = -1;
    goto L16702;}}
 L15456: {
  expr_637X = arg0K0;
  SsymbolsS = expr_637X;
  descriptor_638X = Simported_bindingsS;
  if ((3 == (3 & descriptor_638X))) {
    arg0K0 = (3 + (((long) ((((char *) (-3 + descriptor_638X))) + delta_554X))));
    goto L15462;}
  else {
    arg0K0 = descriptor_638X;
    goto L15462;}}
 L16714: {
  if ((0 == format_478X)) {
    merged_arg1K0 = (Simg_start_addrS);
    merged_arg1K1 = (Ssymbol_addressS);
    merged_arg0K2 = format_478X;
    parse_reachable_objects_return_tag = 0;
    goto parse_reachable_objects;
   parse_reachable_objects_return_0:
    goto L16716;}
  else {
    if ((1 == format_478X)) {
      merged_arg1K0 = (Ssmall_img_start_addrS);
      merged_arg1K1 = (Ssymbol_addressS);
      merged_arg0K2 = format_478X;
      parse_reachable_objects_return_tag = 1;
      goto parse_reachable_objects;
     parse_reachable_objects_return_1:
      merged_arg1K0 = (Slarge_img_start_addrS);
      merged_arg1K1 = ((Slarge_img_start_addrS) + ((((Slarge_img_heap_sizeS))<<3)));
      merged_arg0K2 = format_478X;
      parse_reachable_objects_return_tag = 2;
      goto parse_reachable_objects;
     parse_reachable_objects_return_2:
      merged_arg1K0 = (Sweaks_img_start_addrS);
      merged_arg1K1 = ((Sweaks_img_start_addrS) + ((((Sweaks_img_heap_sizeS))<<3)));
      merged_arg0K2 = format_478X;
      parse_reachable_objects_return_tag = 3;
      goto parse_reachable_objects;
     parse_reachable_objects_return_3:
      goto L16716;}
    else {
      ps_error("allocate+parse+copy-objects!: Unknown image format", 0);
      goto L16716;}}}
 L15462: {
  expr_639X = arg0K0;
  Simported_bindingsS = expr_639X;
  descriptor_640X = Sexported_bindingsS;
  if ((3 == (3 & descriptor_640X))) {
    arg0K0 = (3 + (((long) ((((char *) (-3 + descriptor_640X))) + delta_554X))));
    goto L15468;}
  else {
    arg0K0 = descriptor_640X;
    goto L15468;}}
 L16716: {
  address_641X = (((char *) (-3 + (Sstartup_procedureS)))) + -8;
  if ((0 == (((long) address_641X)))) {
    arg0K0 = -1;
    goto L16043;}
  else {
    arg0K0 = (((long) address_641X));
    goto L16043;}}
 L15468: {
  expr_642X = arg0K0;
  Sexported_bindingsS = expr_642X;
  descriptor_643X = Sresumer_recordsS;
  if ((3 == (3 & descriptor_643X))) {
    arg0K0 = (3 + (((long) ((((char *) (-3 + descriptor_643X))) + delta_554X))));
    goto L15474;}
  else {
    arg0K0 = descriptor_643X;
    goto L15474;}}
 L16043: {
  v_644X = arg0K0;
  image_location_645X = table_ref((Sstob_tableS), v_644X);
  Sstartup_procedureS = (3 + (((long) ((((char *) (image_location_645X->new_descriptor))) + 8))));
  v_646X = SsymbolsS;
  if ((1 == v_646X)) {
    goto L15973;}
  else {
    merged_arg0K0 = (SsymbolsS);
    merged_arg0K1 = format_478X;
    allocate_table_return_tag = 0;
    goto allocate_table;
   allocate_table_return_0:
    expr_647X = allocate_table0_return_value;
    SsymbolsS = expr_647X;
    table_648X = SsymbolsS;
    stob_table_649X = Sstob_tableS;
    if ((3 == (3 & table_648X))) {
      if ((2 == (31 & ((((*((long *) ((((char *) (-3 + table_648X))) + -8))))>>2))))) {
        arg0K0 = 0;
        goto L12908;}
      else {
        goto L15973;}}
    else {
      goto L15973;}}}
 L15474: {
  expr_650X = arg0K0;
  Sresumer_recordsS = expr_650X;
  table_651X = SsymbolsS;
  if ((3 == (3 & table_651X))) {
    if ((2 == (31 & ((((*((long *) ((((char *) (-3 + table_651X))) + -8))))>>2))))) {
      arg0K0 = 0;
      goto L12710;}
    else {
      goto L15480;}}
  else {
    goto L15480;}}
 L15973: {
  v_652X = Simported_bindingsS;
  if ((1 == v_652X)) {
    goto L15993;}
  else {
    merged_arg0K0 = (Simported_bindingsS);
    merged_arg0K1 = format_478X;
    allocate_table_return_tag = 1;
    goto allocate_table;
   allocate_table_return_1:
    expr_653X = allocate_table0_return_value;
    Simported_bindingsS = expr_653X;
    merged_arg0K0 = (Simported_bindingsS);
    merged_arg3K1 = (Sstob_tableS);
    relocate_binding_table_bibopB_return_tag = 0;
    goto relocate_binding_table_bibopB;
   relocate_binding_table_bibopB_return_0:
    goto L15993;}}
 L12908: {
  i_654X = arg0K0;
  if ((1024 == i_654X)) {
    goto L15973;}
  else {
    link_655X = *((long *) ((((char *) (-3 + table_648X))) + (((i_654X)<<3))));
    if ((0 == (3 & link_655X))) {
      arg0K0 = (3 + (-4 & link_655X));
      goto L12914;}
    else {
      arg0K0 = link_655X;
      goto L12914;}}}
 L12710: {
  i_656X = arg0K0;
  if ((1024 == i_656X)) {
    goto L15480;}
  else {
    link_657X = *((long *) ((((char *) (-3 + table_651X))) + (((i_656X)<<3))));
    if ((0 == (3 & link_657X))) {
      arg0K0 = (3 + (-4 & link_657X));
      goto L12716;}
    else {
      arg0K0 = link_657X;
      goto L12716;}}}
 L15480: {
  merged_arg0K0 = (Simported_bindingsS);
  merged_arg0K1 = delta_554X;
  relocate_binding_table_two_spaceB_return_tag = 0;
  goto relocate_binding_table_two_spaceB;
 relocate_binding_table_two_spaceB_return_0:
  merged_arg0K0 = (Sexported_bindingsS);
  merged_arg0K1 = delta_554X;
  relocate_binding_table_two_spaceB_return_tag = 1;
  goto relocate_binding_table_two_spaceB;
 relocate_binding_table_two_spaceB_return_1:
  start_658X = Snew_heap_start_addrS;
  arg1K0 = start_658X;
  goto L10597;}
 L15993: {
  v_659X = Sexported_bindingsS;
  if ((1 == v_659X)) {
    goto L16013;}
  else {
    merged_arg0K0 = (Sexported_bindingsS);
    merged_arg0K1 = format_478X;
    allocate_table_return_tag = 2;
    goto allocate_table;
   allocate_table_return_2:
    expr_660X = allocate_table0_return_value;
    Sexported_bindingsS = expr_660X;
    merged_arg0K0 = (Sexported_bindingsS);
    merged_arg3K1 = (Sstob_tableS);
    relocate_binding_table_bibopB_return_tag = 1;
    goto relocate_binding_table_bibopB;
   relocate_binding_table_bibopB_return_1:
    goto L16013;}}
 L12914: {
  bucket_661X = arg0K0;
  if ((1 == bucket_661X)) {
    goto L12910;}
  else {
    merged_arg0K0 = bucket_661X;
    relocateD2_return_tag = 0;
    goto relocateD2;
   relocateD2_return_0:
    bucket_662X = relocateD20_return_value;
    if ((3 == (3 & bucket_662X))) {
      arg0K0 = (-4 & bucket_662X);
      goto L12919;}
    else {
      arg0K0 = bucket_662X;
      goto L12919;}}}
 L12716: {
  bucket_663X = arg0K0;
  if ((1 == bucket_663X)) {
    goto L12712;}
  else {
    bucket_664X = bucket_663X + delta_554X;
    if ((3 == (3 & bucket_664X))) {
      arg0K0 = (-4 & bucket_664X);
      goto L12721;}
    else {
      arg0K0 = bucket_664X;
      goto L12721;}}}
 L10597: {
  ptr_665X = arg1K0;
  if ((ptr_665X < new_hp_555X)) {
    descriptor_666X = *((long *) ptr_665X);
    if ((3 == (3 & descriptor_666X))) {
      arg0K0 = (3 + (((long) ((((char *) (-3 + descriptor_666X))) + delta_554X))));
      goto L10602;}
    else {
      arg0K0 = descriptor_666X;
      goto L10602;}}
  else {
    arg0K0 = 0;
    goto L16933;}}
 L16013: {
  if ((1 == (Sresumer_recordsS))) {
    goto L16718;}
  else {
    merged_arg0K0 = (Sresumer_recordsS);
    merged_arg0K1 = format_478X;
    allocate_table_return_tag = 3;
    goto allocate_table;
   allocate_table_return_3:
    expr_667X = allocate_table0_return_value;
    Sresumer_recordsS = expr_667X;
    resumer_records_668X = Sresumer_recordsS;
    cell_669X = *((long *) ((((char *) (-3 + resumer_records_668X))) + -8));
    if ((2 == (3 & cell_669X))) {
      arg1K0 = (((char *) (-3 + resumer_records_668X)));
      arg0K1 = ((((7 + ((long)(((unsigned long)cell_669X)>>8))))>>3));
      goto L9745;}
    else {
      ps_error("relocate-resumer-record! - no header", 0);
      goto L16718;}}}
 L12910: {
  arg0K0 = (1 + i_654X);
  goto L12908;}
 L12919: {
  value_670X = arg0K0;
  *((long *) ((((char *) (-3 + table_648X))) + (((i_654X)<<3)))) = (long) (value_670X);
  arg0K0 = bucket_662X;
  goto L12926;}
 L12712: {
  arg0K0 = (1 + i_656X);
  goto L12710;}
 L12721: {
  value_671X = arg0K0;
  *((long *) ((((char *) (-3 + table_651X))) + (((i_656X)<<3)))) = (long) (value_671X);
  arg0K0 = bucket_664X;
  goto L12728;}
 L10602: {
  d_672X = arg0K0;
  *((long *) ptr_665X) = (long) (d_672X);
  if ((2 == (3 & d_672X))) {
    if (((31 & (((d_672X)>>2))) < 16)) {
      goto L10614;}
    else {
      arg1K0 = (ptr_665X + (8 + (-8 & (7 + ((long)(((unsigned long)d_672X)>>8))))));
      goto L10597;}}
  else {
    goto L10614;}}
 L16718: {
  table_673X = Sstob_tableS;
  keys_674X = table_673X->keys;
  values_675X = table_673X->values;
  arg0K0 = 0;
  goto L2973;}
 L9745: {
  address_676X = arg1K0;
  size_677X = arg0K1;
  if ((0 == size_677X)) {
    goto L16718;}
  else {
    cell_678X = *((long *) address_676X);
    if ((3 == (3 & cell_678X))) {
      address_679X = (((char *) (-3 + cell_678X))) + -8;
      if ((0 == (((long) address_679X)))) {
        arg0K0 = -1;
        goto L9810;}
      else {
        arg0K0 = (((long) address_679X));
        goto L9810;}}
    else {
      ps_error("Could this happen?", 0);
      goto L16718;}}}
 L12926: {
  entry_680X = arg0K0;
  link_681X = *((long *) ((((char *) (-3 + entry_680X))) + 8));
  if ((0 == (3 & link_681X))) {
    arg0K0 = (3 + (-4 & link_681X));
    goto L12930;}
  else {
    arg0K0 = link_681X;
    goto L12930;}}
 L12728: {
  entry_682X = arg0K0;
  link_683X = *((long *) ((((char *) (-3 + entry_682X))) + 8));
  if ((0 == (3 & link_683X))) {
    arg0K0 = (3 + (-4 & link_683X));
    goto L12732;}
  else {
    arg0K0 = link_683X;
    goto L12732;}}
 L10614: {
  arg1K0 = (ptr_665X + 8);
  goto L10597;}
 L2973: {
  i_684X = arg0K0;
  if ((i_684X == (table_673X->size))) {
    free(keys_674X);
    free(values_675X);
    free(table_673X);
    free((Sheap_image_pointerS));
    arg0K0 = 0;
    goto L16933;}
  else {
    if ((0 == (*(keys_674X + i_684X)))) {
      goto L2975;}
    else {
      free((*(values_675X + i_684X)));
      goto L2975;}}}
 L9810: {
  v_685X = arg0K0;
  image_location_686X = table_ref((Sstob_tableS), v_685X);
  *((long *) address_676X) = (long) ((3 + (((long) ((((char *) (image_location_686X->new_descriptor))) + 8)))));
  arg1K0 = (address_676X + 8);
  arg0K1 = (-1 + size_677X);
  goto L9745;}
 L12930: {
  next_687X = arg0K0;
  if ((1 == next_687X)) {
    goto L12910;}
  else {
    merged_arg0K0 = next_687X;
    relocateD2_return_tag = 1;
    goto relocateD2;
   relocateD2_return_1:
    next_688X = relocateD20_return_value;
    if ((3 == (3 & next_688X))) {
      arg0K0 = (-4 & next_688X);
      goto L12935;}
    else {
      arg0K0 = next_688X;
      goto L12935;}}}
 L12732: {
  next_689X = arg0K0;
  if ((1 == next_689X)) {
    goto L12712;}
  else {
    next_690X = next_689X + delta_554X;
    if ((3 == (3 & next_690X))) {
      arg0K0 = (-4 & next_690X);
      goto L12737;}
    else {
      arg0K0 = next_690X;
      goto L12737;}}}
 L2975: {
  arg0K0 = (1 + i_684X);
  goto L2973;}
 L12935: {
  val_691X = arg0K0;
  *((long *) ((((char *) (-3 + entry_680X))) + 8)) = (long) (val_691X);
  arg0K0 = next_688X;
  goto L12926;}
 L12737: {
  val_692X = arg0K0;
  *((long *) ((((char *) (-3 + entry_682X))) + 8)) = (long) (val_692X);
  arg0K0 = next_690X;
  goto L12728;}
 relocateD2: {
  address_426X = merged_arg0K0;{
  address_693X = (((char *) (-3 + address_426X))) + -8;
  if ((0 == (((long) address_693X)))) {
    arg0K0 = -1;
    goto L12878;}
  else {
    arg0K0 = (((long) address_693X));
    goto L12878;}}
 L12878: {
  v_694X = arg0K0;
  image_location_695X = table_ref(stob_table_649X, v_694X);
  relocateD20_return_value = (3 + (((long) ((((char *) (image_location_695X->new_descriptor))) + 8))));
  goto relocateD2_return;}
 relocateD2_return:
  switch (relocateD2_return_tag) {
  case 0: goto relocateD2_return_0;
  default: goto relocateD2_return_1;
  }}

 alloc_object: {
  current_address_424X = merged_arg1K0;
  size_in_bytes_425X = merged_arg0K1;{
  x_696X = ((s48_ShpS) + (-8 & (7 + size_in_bytes_425X))) < (s48_SlimitS);
  if (x_696X) {
    goto L15257;}
  else {s48_collect(0);
    goto L15257;}}
 L15257: {
  if ((((s48_ShpS) + (-8 & (7 + size_in_bytes_425X))) < (s48_SlimitS))) {
    new_697X = s48_ShpS;
    s48_ShpS = ((s48_ShpS) + (-8 & (7 + size_in_bytes_425X)));
    arg1K0 = new_697X;
    goto L15247;}
  else {
    arg1K0 = NULL;
    goto L15247;}}
 L15247: {
  new_address_698X = arg1K0;
  image_location_699X = (struct image_location*)malloc(sizeof(struct image_location));
  if ((NULL == image_location_699X)) {
    arg2K0 = image_location_699X;
    goto L15274;}
  else {
    image_location_699X->new_descriptor = (((long) new_address_698X));
    image_location_699X->next = 0;
    arg2K0 = image_location_699X;
    goto L15274;}}
 L15274: {
  val_700X = arg2K0;
  if ((0 == (((long) current_address_424X)))) {
    arg0K0 = -1;
    goto L15276;}
  else {
    arg0K0 = (((long) current_address_424X));
    goto L15276;}}
 L15276: {
  v_701X = arg0K0;table_setB((Sstob_tableS), v_701X, val_700X);
  alloc_object0_return_value = new_address_698X;
  goto alloc_object_return;}
 alloc_object_return:
  switch (alloc_object_return_tag) {
  case 0: goto alloc_object_return_0;
  case 1: goto alloc_object_return_1;
  case 2: goto alloc_object_return_2;
  default: goto alloc_object_return_3;
  }}

 parse_reachable_objects: {
  from_addr_421X = merged_arg1K0;
  to_addr_422X = merged_arg1K1;
  image_format_423X = merged_arg0K2;{
  arg1K0 = from_addr_421X;
  goto L16364;}
 L16364: {
  current_addr_702X = arg1K0;
  if ((current_addr_702X == to_addr_422X)) {
    parse_reachable_objects0_return_value = 0;
    goto parse_reachable_objects_return;}
  else {
    merged_arg1K0 = current_addr_702X;
    merged_arg0K1 = image_format_423X;
    old_Gnew_addr_return_tag = 2;
    goto old_Gnew_addr;
   old_Gnew_addr_return_2:
    x1_703X = old_Gnew_addr0_return_value;
    cell_704X = *((long *) x1_703X);
    if ((2 == (3 & cell_704X))) {
      size_in_cells_705X = (((7 + ((long)(((unsigned long)cell_704X)>>8))))>>3);
      if ((0 == (Sheap_object_remaining_cellsS))) {
        goto L16389;}
      else {
        ps_error("Encountered an header within an d-vector.", 0);
        goto L16389;}}
    else {
      if ((3 == (3 & cell_704X))) {
        current_addr_706X = (((char *) (-3 + cell_704X))) + -8;
        if ((0 == (((long) current_addr_706X)))) {
          arg0K0 = -1;
          goto L16591;}
        else {
          arg0K0 = (((long) current_addr_706X));
          goto L16591;}}
      else {
        *((long *) (Sheap_object_pointerS)) = (long) (cell_704X);
        Sheap_object_remaining_cellsS = (-1 + (Sheap_object_remaining_cellsS));
        Sheap_object_pointerS = ((Sheap_object_pointerS) + 8);
        goto L16446;}}}}
 L16389: {
  if ((2 == (3 & cell_704X))) {
    if (((31 & (((cell_704X)>>2))) < 16)) {
      goto L16405;}
    else {
      if ((0 == (((long) current_addr_702X)))) {
        arg0K0 = -1;
        goto L16477;}
      else {
        arg0K0 = (((long) current_addr_702X));
        goto L16477;}}}
  else {
    goto L16405;}}
 L16591: {
  v_707X = arg0K0;
  v_708X = table_ref((Sstob_tableS), v_707X);
  if ((NULL == v_708X)) {
    current_addr_709X = (((char *) (-3 + cell_704X))) + -8;
    merged_arg1K0 = current_addr_709X;
    merged_arg0K1 = image_format_423X;
    old_Gnew_addr_return_tag = 3;
    goto old_Gnew_addr;
   old_Gnew_addr_return_3:
    x1_710X = old_Gnew_addr0_return_value;
    header_cell_711X = *((long *) x1_710X);
    size_in_cells_712X = 1 + ((((7 + ((long)(((unsigned long)header_cell_711X)>>8))))>>3));
    size_in_bytes_713X = ((size_in_cells_712X)<<3);
    if ((2 == (3 & header_cell_711X))) {
      if (((31 & (((header_cell_711X)>>2))) < 16)) {
        goto L16223;}
      else {
        merged_arg1K0 = current_addr_709X;
        merged_arg0K1 = (((size_in_cells_712X)<<3));
        alloc_object_return_tag = 0;
        goto alloc_object;
       alloc_object_return_0:
        new_address_714X = alloc_object0_return_value;
        merged_arg1K0 = current_addr_709X;
        merged_arg0K1 = image_format_423X;
        old_Gnew_addr_return_tag = 4;
        goto old_Gnew_addr;
       old_Gnew_addr_return_4:
        v_715X = old_Gnew_addr0_return_value;
        memmove((void *)new_address_714X, (void *)v_715X,(((size_in_cells_712X)<<3)));
        goto L16437;}}
    else {
      goto L16223;}}
  else {
    goto L16437;}}
 L16446: {
  arg1K0 = (current_addr_702X + 8);
  goto L16364;}
 L16405: {
  if ((0 == (((long) current_addr_702X)))) {
    arg0K0 = -1;
    goto L16504;}
  else {
    arg0K0 = (((long) current_addr_702X));
    goto L16504;}}
 L16477: {
  v_716X = arg0K0;
  v_717X = table_ref((Sstob_tableS), v_716X);
  if ((NULL == v_717X)) {
    size_in_cells_718X = 1 + size_in_cells_705X;
    merged_arg1K0 = current_addr_702X;
    merged_arg0K1 = (((size_in_cells_718X)<<3));
    alloc_object_return_tag = 1;
    goto alloc_object;
   alloc_object_return_1:
    new_address_719X = alloc_object0_return_value;
    merged_arg1K0 = current_addr_702X;
    merged_arg0K1 = image_format_423X;
    old_Gnew_addr_return_tag = 5;
    goto old_Gnew_addr;
   old_Gnew_addr_return_5:
    v_720X = old_Gnew_addr0_return_value;
    memmove((void *)new_address_719X, (void *)v_720X,(((size_in_cells_718X)<<3)));
    goto L16402;}
  else {
    goto L16402;}}
 L16223: {
  merged_arg1K0 = current_addr_709X;
  merged_arg0K1 = size_in_bytes_713X;
  alloc_object_return_tag = 2;
  goto alloc_object;
 alloc_object_return_2:
  new_address_721X = alloc_object0_return_value;
  *((long *) new_address_721X) = (long) ((-1978 + (((size_in_bytes_713X)<<8))));
  arg1K0 = (new_address_721X + 8);
  goto L16241;}
 L16437: {
  address_722X = (((char *) (-3 + cell_704X))) + -8;
  if ((0 == (((long) address_722X)))) {
    arg0K0 = -1;
    goto L16605;}
  else {
    arg0K0 = (((long) address_722X));
    goto L16605;}}
 L16504: {
  v_723X = arg0K0;
  v_724X = table_ref((Sstob_tableS), v_723X);
  if ((NULL == v_724X)) {
    merged_arg1K0 = current_addr_702X;
    merged_arg0K1 = (8 + (((size_in_cells_705X)<<3)));
    alloc_object_return_tag = 3;
    goto alloc_object;
   alloc_object_return_3:
    new_address_725X = alloc_object0_return_value;
    if ((2 == (3 & cell_704X))) {
      goto L16521;}
    else {
      ps_error("cell was not a header", 0);
      goto L16521;}}
  else {
    if ((0 == (((long) current_addr_702X)))) {
      arg0K0 = -1;
      goto L9870;}
    else {
      arg0K0 = (((long) current_addr_702X));
      goto L9870;}}}
 L16402: {
  arg1K0 = (current_addr_702X + (8 + (((size_in_cells_705X)<<3))));
  goto L16364;}
 L16241: {
  index_726X = arg1K0;
  if ((index_726X == (new_address_721X + (-8 & (7 + size_in_bytes_713X))))) {
    goto L16437;}
  else {
    *((long *) index_726X) = (long) (0);
    arg1K0 = (index_726X + 8);
    goto L16241;}}
 L16605: {
  v_727X = arg0K0;
  image_location_728X = table_ref((Sstob_tableS), v_727X);
  *((long *) (Sheap_object_pointerS)) = (long) ((3 + (((long) ((((char *) (image_location_728X->new_descriptor))) + 8)))));
  Sheap_object_remaining_cellsS = (-1 + (Sheap_object_remaining_cellsS));
  Sheap_object_pointerS = ((Sheap_object_pointerS) + 8);
  goto L16446;}
 L16521: {
  *((long *) new_address_725X) = (long) (cell_704X);
  Sheap_object_pointerS = new_address_725X;
  Sheap_object_remaining_cellsS = (1 + ((((7 + ((long)(((unsigned long)cell_704X)>>8))))>>3)));
  Sheap_object_remaining_cellsS = (-1 + (Sheap_object_remaining_cellsS));
  Sheap_object_pointerS = ((Sheap_object_pointerS) + 8);
  goto L16417;}
 L9870: {
  v_729X = arg0K0;
  image_location_730X = table_ref((Sstob_tableS), v_729X);
  new_address_731X = ((char *) (image_location_730X->new_descriptor));
  if ((2 == (3 & cell_704X))) {
    goto L9855;}
  else {
    ps_error("cell was not a header", 0);
    goto L9855;}}
 L16417: {
  arg1K0 = (current_addr_702X + 8);
  goto L16364;}
 L9855: {
  *((long *) new_address_731X) = (long) (cell_704X);
  Sheap_object_pointerS = new_address_731X;
  Sheap_object_remaining_cellsS = (1 + ((((7 + ((long)(((unsigned long)cell_704X)>>8))))>>3)));
  Sheap_object_remaining_cellsS = (-1 + (Sheap_object_remaining_cellsS));
  Sheap_object_pointerS = ((Sheap_object_pointerS) + 8);
  goto L16417;}
 parse_reachable_objects_return:
  switch (parse_reachable_objects_return_tag) {
  case 0: goto parse_reachable_objects_return_0;
  case 1: goto parse_reachable_objects_return_1;
  case 2: goto parse_reachable_objects_return_2;
  default: goto parse_reachable_objects_return_3;
  }}

 allocate_table: {
  tab_419X = merged_arg0K0;
  image_format_420X = merged_arg0K1;{
  merged_arg1K0 = ((((char *) (-3 + tab_419X))) + -8);
  merged_arg0K1 = image_format_420X;
  old_Gnew_addr_return_tag = 6;
  goto old_Gnew_addr;
 old_Gnew_addr_return_6:
  addr_732X = old_Gnew_addr0_return_value;
  cell_733X = *((long *) addr_732X);
  if ((2 == (3 & cell_733X))) {
    size_734X = (((7 + ((long)(((unsigned long)cell_733X)>>8))))>>3);
    size_in_byte_735X = 8 + (((size_734X)<<3));
    x_736X = ((s48_ShpS) + (-8 & (7 + size_in_byte_735X))) < (s48_SlimitS);
    if (x_736X) {
      goto L15350;}
    else {s48_collect(0);
      goto L15350;}}
  else {
    ps_error("read-tables! no header", 0);
    allocate_table0_return_value = v_737X;
    goto allocate_table_return;}}
 L15350: {
  if ((((s48_ShpS) + (-8 & (7 + size_in_byte_735X))) < (s48_SlimitS))) {
    new_738X = s48_ShpS;
    s48_ShpS = ((s48_ShpS) + (-8 & (7 + size_in_byte_735X)));
    arg1K0 = new_738X;
    goto L15318;}
  else {
    arg1K0 = NULL;
    goto L15318;}}
 L15318: {
  pointer_739X = arg1K0;
  memmove((void *)pointer_739X, (void *)addr_732X,(8 + (((size_734X)<<3))));
  allocate_table0_return_value = (3 + (((long) (pointer_739X + 8))));
  goto allocate_table_return;}
 allocate_table_return:
  switch (allocate_table_return_tag) {
  case 0: goto allocate_table_return_0;
  case 1: goto allocate_table_return_1;
  case 2: goto allocate_table_return_2;
  default: goto allocate_table_return_3;
  }}

 old_Gnew_addr: {
  addr_417X = merged_arg1K0;
  format_418X = merged_arg0K1;{
  if ((0 == format_418X)) {
    old_Gnew_addr0_return_value = ((Sheap_image_pointerS) + (addr_417X - (Simg_start_addrS)));
    goto old_Gnew_addr_return;}
  else {
    if ((1 == format_418X)) {
      y_740X = Ssmall_img_start_addrS;
      if ((addr_417X < y_740X)) {
        goto L3076;}
      else {
        if (((Ssmall_img_hp_addrS) < addr_417X)) {
          goto L3076;}
        else {
          SoffsetS = (((Sweaks_img_end_addrS) - (Sweaks_img_start_addrS)) + ((Slarge_img_end_addrS) - (Slarge_img_start_addrS)));
          Sarea_startS = (Ssmall_img_start_addrS);
          goto L3128;}}}
    else {
      ps_error("old->new-addr: Unknown image format", 0);
      old_Gnew_addr0_return_value = v_741X;
      goto old_Gnew_addr_return;}}}
 L3076: {
  y_742X = Slarge_img_start_addrS;
  if ((addr_417X < y_742X)) {
    goto L3102;}
  else {
    if (((Slarge_img_hp_addrS) < addr_417X)) {
      goto L3102;}
    else {
      SoffsetS = ((Sweaks_img_end_addrS) - (Sweaks_img_start_addrS));
      Sarea_startS = (Slarge_img_start_addrS);
      goto L3128;}}}
 L3128: {
  old_Gnew_addr0_return_value = ((Sheap_image_pointerS) + ((SoffsetS) + (addr_417X - (Sarea_startS))));
  goto old_Gnew_addr_return;}
 L3102: {
  y_743X = Sweaks_img_start_addrS;
  if ((addr_417X < y_743X)) {
    goto L3124;}
  else {
    if (((Sweaks_img_hp_addrS) < addr_417X)) {
      goto L3124;}
    else {
      SoffsetS = 0;
      Sarea_startS = (Sweaks_img_start_addrS);
      goto L3128;}}}
 L3124: {
  ps_error("Unknown address area!", 0);
  goto L3128;}
 old_Gnew_addr_return:
  switch (old_Gnew_addr_return_tag) {
  case 0: goto old_Gnew_addr_return_0;
  case 1: goto old_Gnew_addr_return_1;
  case 2: goto old_Gnew_addr_return_2;
  case 3: goto old_Gnew_addr_return_3;
  case 4: goto old_Gnew_addr_return_4;
  case 5: goto old_Gnew_addr_return_5;
  default: goto old_Gnew_addr_return_6;
  }}

 relocateD0: {
  address_416X = merged_arg0K0;{
  address_744X = (((char *) (-3 + address_416X))) + -8;
  if ((0 == (((long) address_744X)))) {
    arg0K0 = -1;
    goto L12998;}
  else {
    arg0K0 = (((long) address_744X));
    goto L12998;}}
 L12998: {
  v_745X = arg0K0;
  image_location_746X = table_ref(stob_table_415X, v_745X);
  relocateD00_return_value = (3 + (((long) ((((char *) (image_location_746X->new_descriptor))) + 8))));
  goto relocateD0_return;}
 relocateD0_return:
  switch (relocateD0_return_tag) {
  case 0: goto relocateD0_return_0;
  default: goto relocateD0_return_1;
  }}

 relocate_binding_table_bibopB: {
  table_414X = merged_arg0K0;
  stob_table_415X = merged_arg3K1;{
  if ((3 == (3 & table_414X))) {
    if ((2 == (31 & ((((*((long *) ((((char *) (-3 + table_414X))) + -8))))>>2))))) {
      arg0K0 = 0;
      goto L13028;}
    else {
      goto relocate_binding_table_bibopB_return;}}
  else {
    goto relocate_binding_table_bibopB_return;}}
 L13028: {
  i_747X = arg0K0;
  if ((1024 == i_747X)) {
    goto relocate_binding_table_bibopB_return;}
  else {
    link_748X = *((long *) ((((char *) (-3 + table_414X))) + (((i_747X)<<3))));
    if ((0 == (3 & link_748X))) {
      arg0K0 = (3 + (-4 & link_748X));
      goto L13034;}
    else {
      arg0K0 = link_748X;
      goto L13034;}}}
 L13034: {
  bucket_749X = arg0K0;
  if ((1 == bucket_749X)) {
    goto L13030;}
  else {
    merged_arg0K0 = bucket_749X;
    relocateD0_return_tag = 0;
    goto relocateD0;
   relocateD0_return_0:
    bucket_750X = relocateD00_return_value;
    if ((3 == (3 & bucket_750X))) {
      arg0K0 = (-4 & bucket_750X);
      goto L13039;}
    else {
      arg0K0 = bucket_750X;
      goto L13039;}}}
 L13030: {
  arg0K0 = (1 + i_747X);
  goto L13028;}
 L13039: {
  value_751X = arg0K0;
  *((long *) ((((char *) (-3 + table_414X))) + (((i_747X)<<3)))) = (long) (value_751X);
  arg0K0 = bucket_750X;
  goto L13046;}
 L13046: {
  entry_752X = arg0K0;
  link_753X = *((long *) ((((char *) (-3 + entry_752X))) + 24));
  if ((0 == (3 & link_753X))) {
    arg0K0 = (3 + (-4 & link_753X));
    goto L13050;}
  else {
    arg0K0 = link_753X;
    goto L13050;}}
 L13050: {
  next_754X = arg0K0;
  if ((1 == next_754X)) {
    goto L13030;}
  else {
    merged_arg0K0 = next_754X;
    relocateD0_return_tag = 1;
    goto relocateD0;
   relocateD0_return_1:
    next_755X = relocateD00_return_value;
    if ((3 == (3 & next_755X))) {
      arg0K0 = (-4 & next_755X);
      goto L13055;}
    else {
      arg0K0 = next_755X;
      goto L13055;}}}
 L13055: {
  val_756X = arg0K0;
  *((long *) ((((char *) (-3 + entry_752X))) + 24)) = (long) (val_756X);
  arg0K0 = next_755X;
  goto L13046;}
 relocate_binding_table_bibopB_return:
  switch (relocate_binding_table_bibopB_return_tag) {
  case 0: goto relocate_binding_table_bibopB_return_0;
  default: goto relocate_binding_table_bibopB_return_1;
  }}

 relocate_binding_table_two_spaceB: {
  table_412X = merged_arg0K0;
  delta_413X = merged_arg0K1;{
  if ((3 == (3 & table_412X))) {
    if ((2 == (31 & ((((*((long *) ((((char *) (-3 + table_412X))) + -8))))>>2))))) {
      arg0K0 = 0;
      goto L12797;}
    else {
      goto relocate_binding_table_two_spaceB_return;}}
  else {
    goto relocate_binding_table_two_spaceB_return;}}
 L12797: {
  i_757X = arg0K0;
  if ((1024 == i_757X)) {
    goto relocate_binding_table_two_spaceB_return;}
  else {
    link_758X = *((long *) ((((char *) (-3 + table_412X))) + (((i_757X)<<3))));
    if ((0 == (3 & link_758X))) {
      arg0K0 = (3 + (-4 & link_758X));
      goto L12803;}
    else {
      arg0K0 = link_758X;
      goto L12803;}}}
 L12803: {
  bucket_759X = arg0K0;
  if ((1 == bucket_759X)) {
    goto L12799;}
  else {
    bucket_760X = bucket_759X + delta_413X;
    if ((3 == (3 & bucket_760X))) {
      arg0K0 = (-4 & bucket_760X);
      goto L12808;}
    else {
      arg0K0 = bucket_760X;
      goto L12808;}}}
 L12799: {
  arg0K0 = (1 + i_757X);
  goto L12797;}
 L12808: {
  value_761X = arg0K0;
  *((long *) ((((char *) (-3 + table_412X))) + (((i_757X)<<3)))) = (long) (value_761X);
  arg0K0 = bucket_760X;
  goto L12815;}
 L12815: {
  entry_762X = arg0K0;
  link_763X = *((long *) ((((char *) (-3 + entry_762X))) + 24));
  if ((0 == (3 & link_763X))) {
    arg0K0 = (3 + (-4 & link_763X));
    goto L12819;}
  else {
    arg0K0 = link_763X;
    goto L12819;}}
 L12819: {
  next_764X = arg0K0;
  if ((1 == next_764X)) {
    goto L12799;}
  else {
    next_765X = next_764X + delta_413X;
    if ((3 == (3 & next_765X))) {
      arg0K0 = (-4 & next_765X);
      goto L12824;}
    else {
      arg0K0 = next_765X;
      goto L12824;}}}
 L12824: {
  val_766X = arg0K0;
  *((long *) ((((char *) (-3 + entry_762X))) + 24)) = (long) (val_766X);
  arg0K0 = next_765X;
  goto L12815;}
 relocate_binding_table_two_spaceB_return:
  switch (relocate_binding_table_two_spaceB_return_tag) {
  case 0: goto relocate_binding_table_two_spaceB_return_0;
  default: goto relocate_binding_table_two_spaceB_return_1;
  }}

 reverse_byte_orderB: {
  start_410X = merged_arg1K0;
  end_411X = merged_arg1K1;{
  ps_write_string("Correcting byte order of resumed image.", (stderr));
  { long ignoreXX;
  PS_WRITE_CHAR(10, (stderr), ignoreXX) }
  arg1K0 = start_410X;
  goto L10491;}
 L10491: {
  ptr_767X = arg1K0;
  if ((ptr_767X < end_411X)) {
    arg0K0 = 0;
    arg0K1 = 7;
    goto L10531;}
  else {
    goto reverse_byte_orderB_return;}}
 L10531: {
  i_768X = arg0K0;
  j_769X = arg0K1;
  if ((i_768X < j_769X)) {
    addr_a_770X = ptr_767X + i_768X;
    addr_b_771X = ptr_767X + j_769X;
    byte_a_772X = *((unsigned char *) addr_a_770X);
    *((unsigned char *) addr_a_770X) = (unsigned char) ((*((unsigned char *) addr_b_771X)));
    *((unsigned char *) addr_b_771X) = (unsigned char) (byte_a_772X);
    arg0K0 = (1 + i_768X);
    arg0K1 = (-1 + j_769X);
    goto L10531;}
  else {
    value_773X = *((long *) ptr_767X);
    next_774X = ptr_767X + 8;
    if ((2 == (3 & value_773X))) {
      if (((31 & (((value_773X)>>2))) < 16)) {
        arg1K0 = next_774X;
        goto L10491;}
      else {
        arg1K0 = (next_774X + (-8 & (7 + ((long)(((unsigned long)value_773X)>>8)))));
        goto L10491;}}
    else {
      arg1K0 = next_774X;
      goto L10491;}}}
 reverse_byte_orderB_return:
  switch (reverse_byte_orderB_return_tag) {
  case 0: goto reverse_byte_orderB_return_0;
  default: goto reverse_byte_orderB_return_1;
  }}

 really_read_image_area: {
  new_start_addr_407X = merged_arg1K0;
  img_heap_size_408X = merged_arg0K1;
  port_409X = merged_arg6K2;{
  need_775X = ((img_heap_size_408X)<<3);
  got_776X = ps_read_block(port_409X, ((char *) new_start_addr_407X), need_775X, &eofP_777X, &status_778X);
  if ((status_778X == NO_ERRORS)) {
    if (eofP_777X) {
      arg4K0 = 0;
      arg5K1 = "Premature EOF when reading image file";
      goto L3909;}
    else {
      if ((got_776X < need_775X)) {
        arg4K0 = 0;
        arg5K1 = "Read returned too few bytes";
        goto L3909;}
      else {
        arg4K0 = 1;
        arg5K1 = "";
        goto L3909;}}}
  else {
    SstatusS = status_778X;
    arg4K0 = 0;
    arg5K1 = "Error reading from image file";
    goto L3909;}}
 L3909: {
  okayP_779X = arg4K0;
  string_780X = arg5K1;
  if (okayP_779X) {
    really_read_image_area0_return_value = 0;
    goto really_read_image_area_return;}
  else {
    ps_write_string(string_780X, (stderr));
    { long ignoreXX;
    PS_WRITE_CHAR(10, (stderr), ignoreXX) }
    status_781X = SstatusS;
    if ((status_781X == NO_ERRORS)) {
      goto L3952;}
    else {
      ps_write_string((ps_error_string((SstatusS))), (stderr));
      { long ignoreXX;
      PS_WRITE_CHAR(10, (stderr), ignoreXX) }
      goto L3952;}}}
 L3952: {
  status_782X = ps_close(port_409X);
  if ((status_782X == NO_ERRORS)) {
    really_read_image_area0_return_value = -1;
    goto really_read_image_area_return;}
  else {
    ps_write_string("Error closing image file", (stderr));
    { long ignoreXX;
    PS_WRITE_CHAR(10, (stderr), ignoreXX) }
    really_read_image_area0_return_value = -1;
    goto really_read_image_area_return;}}
 really_read_image_area_return:
  switch (really_read_image_area_return_tag) {
  case 0: goto really_read_image_area_return_0;
  case 1: goto really_read_image_area_return_1;
  default: goto really_read_image_area_return_2;
  }}

}void
s48_heap_init(void)
{
Snew_heap_start_addrS = NULL;
Spure_area_countS = 0;
Simpure_area_countS = 0;
Sfinding_typeS = 1;
Sheap_errors_leftS = 0;
Sgc_countS = 0;
Sgc_secondsS = 0;
Sgc_msecondsS = 0;
SstatusS = NO_ERRORS;
SeofPS = 0;
Sstartup_procedureS = 0;
SsymbolsS = 0;
Simported_bindingsS = 0;
Sexported_bindingsS = 0;
Sresumer_recordsS = 0;
Simg_start_addrS = NULL;
Simg_end_addrS = NULL;
Simg_heap_sizeS = 0;
Ssmall_img_start_addrS = NULL;
Ssmall_img_hp_addrS = NULL;
Ssmall_img_end_addrS = NULL;
Ssmall_img_heap_sizeS = 0;
Slarge_img_start_addrS = NULL;
Slarge_img_hp_addrS = NULL;
Slarge_img_end_addrS = NULL;
Slarge_img_heap_sizeS = 0;
Sweaks_img_start_addrS = NULL;
Sweaks_img_hp_addrS = NULL;
Sweaks_img_end_addrS = NULL;
Sweaks_img_heap_sizeS = 0;
SoffsetS = 0;
SinitializingPS = 1;
SstatusS = NO_ERRORS;
image_start_address = 0;
Hthe_record_type280 = 1;
}
