
#ifndef GR_STUFF_H
#define GR_STUFF_H


#ifndef BB_STUFF_H
#include "bb_stuff.h"
#endif


#define gr_maxpnt       100


/* Positioned based on origin point?? */

typedef enum {
  TUL, TUC, TUR, TCL, TCC, TCR, TLL, TLC, TLR
} centerType;

typedef long gr_intArray[gr_maxpnt];

typedef enum {
  gr_m, gr_pl, gr_ps, gr_cm
} gr_outKind;


/* Font/color configuration stuff */

#define maxFonts        40
#define maxColors       32
    /* Not really 32 colors, just 32 tries at plotting */


typedef struct fontArrRec {
  Char dispName[20];
  Char psName[60];
} fontArrRec;

typedef fontArrRec fontArr[maxFonts];

typedef struct colorArrRec {
  long cval;
  Char action[151];
} colorArrRec;

typedef colorArrRec colorArr[maxColors + 1];

typedef struct headInfoRec {
  Char fnm[256];
  Char fignm[81], whowhn[81];
  long bbxl, bbyl, bbxh, bbyh;
} headInfoRec;


extern gr_outKind gr_outDev;
extern boolean gr_show_seg;   /* Show arc control segments */
extern boolean gr_show_control;   /* Show bezier control segments */

extern long gr_numpt;
extern long *gr_xs, *gr_ys;
extern _PROCEDURE ps_out;
extern _PROCEDURE lbl_out;
extern fontArrRec *fonts;
extern char numFonts;
extern headInfoRec headinfo;
extern char symbolFontNum;   /* used for displaying characters on screen */
extern char musicFontNum;   /* used for displaying notes on screen */
extern char psColorVersion;
extern boolean hasAlpha;
extern colorArrRec *colors;
extern bbrec psBoundingBox;


extern void gr_init(void);
extern void gr_reInit(gr_outKind kind);
extern void gr_finish(void);
extern void gr_bright(void);

extern void gr_dim(void);
extern void readPSColors(Char *where);
extern void setPSColor(long c);

/* Some graphics routines that use the matrix stuff */
extern long nameToColor(Char *name);
extern void move_(long x, long y);
extern void draw(long x, long y);
extern void drawDot(long x, long y);
extern void showPoint(long x, long y);
extern void circle(long px, long py, long pr);
extern void ellipse(long x, long y, long a, long b);
extern void drawbox(long x1, long y1, long x2, long y2);
extern void chooseFont(long font, long scale, long rot, long slant);
extern void newpath(boolean canFill);
extern void finpath(void);

extern void drawText(long x, long y, centerType orig, Char *s);
extern void drawPoly(long n, long *x, long *y);
extern void bezier(long x1, long y1, long x2, long y2, long x3, long y3,
		   long x4, long y4);
extern void ellipseSegs(long numSegs);
extern void makeEllipseArc(long cx, long cy, long rx, long ry, long start,
			   long length, long rotate);
extern void ellipseArc(long cx, long cy, long rx, long ry, long start,
		       long length, long rotate, boolean pie);

extern void ellipseArcBB(long cx, long cy, long rx, long ry, long start,
			 long length, long rotate, boolean pie, bbrec *bb);


#endif /*GR_STUFF_H*/
